/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.protocol.actions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.committee.impl.meeting.CommitteeScheduleMinuteBase;
import org.kuali.coeus.common.framework.auth.task.TaskAuthorizationService;
import org.kuali.coeus.common.notification.impl.service.KcNotificationService;
import org.kuali.coeus.common.questionnaire.framework.answer.AnswerHeader;
import org.kuali.coeus.common.questionnaire.framework.answer.ModuleQuestionnaireBean;
import org.kuali.coeus.common.questionnaire.framework.answer.QuestionnaireAnswerService;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.protocol.ProtocolDocumentBase;
import org.kuali.kra.protocol.ProtocolFormBase;
import org.kuali.kra.protocol.actions.ProtocolActionBean;
import org.kuali.kra.protocol.actions.ProtocolActionRequestService;
import org.kuali.kra.protocol.actions.ProtocolActionTypeBase;
import org.kuali.kra.protocol.actions.correspondence.ProtocolActionCorrespondenceGenerationService;
import org.kuali.kra.protocol.actions.correspondence.ProtocolActionsCorrespondenceBase;
import org.kuali.kra.protocol.actions.reviewcomments.ReviewCommentsBeanBase;
import org.kuali.kra.protocol.actions.reviewcomments.ReviewCommentsService;
import org.kuali.kra.protocol.auth.ProtocolTaskBase;
import org.kuali.kra.protocol.correspondence.ProtocolCorrespondence;
import org.kuali.kra.protocol.notification.ProtocolNotification;
import org.kuali.kra.protocol.notification.ProtocolNotificationContextBase;
import org.kuali.kra.protocol.notification.ProtocolNotificationRequestBeanBase;
import org.kuali.kra.protocol.onlinereview.ProtocolReviewAttachmentBase;
import org.kuali.kra.protocol.questionnaire.ProtocolQuestionnaireAuditRuleBase;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.identity.PersonService;
import org.kuali.rice.kns.util.KNSGlobalVariables;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.document.authorization.PessimisticLock;
import org.kuali.rice.krad.rules.rule.event.DocumentEvent;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.service.KualiRuleService;
import org.kuali.rice.krad.util.GlobalVariables;

public abstract class ProtocolActionRequestServiceImpl
implements ProtocolActionRequestService {
    private KualiRuleService kualiRuleService;
    private TaskAuthorizationService taskAuthorizationService;
    private BusinessObjectService businessObjectService;
    private ProtocolActionCorrespondenceGenerationService protocolActionCorrespondenceGenerationService;
    private KcNotificationService notificationService;
    private PersonService personService;
    private ReviewCommentsService<? extends ProtocolReviewAttachmentBase> reviewCommentsService;
    private QuestionnaireAnswerService questionnaireAnswerService;
    private static final String FORWARD_TO_CORRESPONDENCE = "correspondence";
    protected static final String RETURN_TO_HOLDING_PAGE = "holdingPage";
    protected static final String ACTION_NAME_AMENDMENT = "Create Amendment";
    protected static final String ACTION_NAME_RENEWAL_WITHOUT_AMENDMENT = "Create Renewal without Amendment";
    protected static final String ACTION_NAME_RENEWAL_WITH_AMENDMENT = "Create Renewal with Amendment";
    protected static final String ACTION_NAME_FYI = "Create FYI";
    protected static final String ACTION_NAME_ASSIGN_TO_AGENDA = "Assign to Agenda";
    protected static final String ACTION_NAME_REVIEW_NOT_REQUIRED = "Review Not Required";
    protected static final String ACTION_NAME_DISAPPROVE = "Disapprove";
    protected static final String ACTION_NAME_EXPIRE = "Expire";
    protected static final String ACTION_NAME_TERMINATE = "Terminate";
    protected static final String ACTION_NAME_SUSPEND = "Suspend";
    protected static final String ACTION_NAME_SMR = "Return for Specific Minor Revisions";
    protected static final String ACTION_NAME_SRR = "Return for Substantive Revisions Required";
    protected static final String ACTION_NAME_RETURN_TO_PI = "Return To PI";
    protected static final String ACTION_NAME_MANAGE_ADMINISTRATIVE_CORRECTION = "Make Administrative Correction";
    protected static final String ACTION_NAME_RECORD_ABANDON = "Abandon";
    protected static final String ACTION_NAME_WITHDRAW = "Withdraw";
    protected static final String ACTION_NAME_RECORD_COMMITTEE_DECISION = "Record Committee Decision";

    protected final boolean applyRules(DocumentEvent event) {
        return this.getKualiRuleService().applyRules(event);
    }

    public KualiRuleService getKualiRuleService() {
        return this.kualiRuleService;
    }

    public void setKualiRuleService(KualiRuleService kualiRuleService) {
        this.kualiRuleService = kualiRuleService;
    }

    public TaskAuthorizationService getTaskAuthorizationService() {
        return this.taskAuthorizationService;
    }

    public void setTaskAuthorizationService(TaskAuthorizationService taskAuthorizationService) {
        this.taskAuthorizationService = taskAuthorizationService;
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    protected boolean hasPermission(String taskName, ProtocolBase protocol) {
        ProtocolTaskBase task = this.getProtocolTaskInstanceHook(taskName, protocol);
        return this.getTaskAuthorizationService().isAuthorized(GlobalVariables.getUserSession().getPrincipalId(), task);
    }

    protected boolean hasGenericPermission(String genericActionName, ProtocolBase protocol) {
        ProtocolTaskBase task = this.getProtocolGenericActionTaskInstanceHook(genericActionName, protocol);
        return this.getTaskAuthorizationService().isAuthorized(GlobalVariables.getUserSession().getPrincipalId(), task);
    }

    protected void generateActionCorrespondence(String protocolActionTypeCode, ProtocolBase protocol) throws Exception {
        if (this.isCorrespondenceRequired(protocolActionTypeCode)) {
            ProtocolActionsCorrespondenceBase correspondence = this.getNewProtocolActionsCorrespondence(protocolActionTypeCode);
            correspondence.setPrintableBusinessObject(protocol);
            correspondence.setProtocol(protocol);
            this.getProtocolActionCorrespondenceGenerationService().generateCorrespondenceDocumentAndAttach(correspondence);
        }
    }

    protected void updateDocumentStatusChangedMessage() {
        GlobalVariables.getMessageMap().clearErrorMessages();
        GlobalVariables.getMessageMap().putError("documentstatechanged", "error.protocol.document.state.changed", new String[0]);
    }

    private boolean isCorrespondenceRequired(String protocolActionTypeCode) {
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("protocolActionTypeCode", protocolActionTypeCode);
        ProtocolActionTypeBase protocolActionType = (ProtocolActionTypeBase)this.getBusinessObjectService().findByPrimaryKey(this.getProtocolActionTypeBOClassHook(), fieldValues);
        return protocolActionType.getTriggerCorrespondence();
    }

    @Override
    public void createProtocol(ProtocolFormBase protocolForm) throws Exception {
        this.generateActionCorrespondence(this.getProtocolCreatedActionTypeHook(), protocolForm.getProtocolDocument().getProtocol());
    }

    @Override
    public void rejectedInRouting(ProtocolBase protocol) throws Exception {
        this.generateActionCorrespondence(this.getProtocolRejectedInRoutingActionTypeHook(), protocol);
    }

    @Override
    public void recalledInRouting(ProtocolBase protocol) throws Exception {
        this.generateActionCorrespondence(this.getProtocolRecalledInRoutingActionTypeHook(), protocol);
    }

    protected void recordProtocolActionSuccess(String protocolActionName) {
        KNSGlobalVariables.getMessageList().add("message.protocol.action.successfully.completed", new String[]{protocolActionName});
    }

    protected void saveReviewComments(ProtocolFormBase protocolForm, ReviewCommentsBeanBase actionBean) throws Exception {
        this.getReviewCommentsService().updateScheduleForReviewComments(protocolForm.getProtocolDocument().getProtocol(), actionBean.getReviewComments());
        this.getReviewCommentsService().saveReviewComments(actionBean.getReviewComments(), actionBean.getDeletedReviewComments());
        actionBean.setDeletedReviewComments(new ArrayList<CommitteeScheduleMinuteBase>());
        protocolForm.getActionHelper().prepareCommentsView();
    }

    @Override
    public boolean hasDocumentStateChanged(ProtocolFormBase protocolForm) {
        boolean result = false;
        HashMap<String, Long> primaryKeys = new HashMap<String, Long>();
        primaryKeys.put("protocolId", protocolForm.getProtocolDocument().getProtocol().getProtocolId());
        ProtocolBase dbProtocol = (ProtocolBase)this.getBusinessObjectService().findByPrimaryKey(this.getProtocolBOClassHook(), primaryKeys);
        if (dbProtocol != null) {
            if (!StringUtils.equals((CharSequence)dbProtocol.getProtocolStatusCode(), (CharSequence)protocolForm.getProtocolDocument().getProtocol().getProtocolStatusCode())) {
                result = true;
            }
            if (dbProtocol.getProtocolSubmission() != null && protocolForm.getProtocolDocument().getProtocol().getProtocolSubmission().getSubmissionStatusCode() != null && !StringUtils.equals((CharSequence)dbProtocol.getProtocolSubmission().getSubmissionStatusCode(), (CharSequence)protocolForm.getProtocolDocument().getProtocol().getProtocolSubmission().getSubmissionStatusCode())) {
                result = true;
            }
        }
        if (!result) {
            result = !this.isDocumentPostprocessingComplete(protocolForm.getProtocolDocument());
        }
        return result;
    }

    private boolean isDocumentPostprocessingComplete(ProtocolDocumentBase document) {
        return document.getDocumentHeader().hasWorkflowDocument() && !this.isPessimisticallyLocked((Document)document);
    }

    private boolean isPessimisticallyLocked(Document document) {
        boolean isPessimisticallyLocked = false;
        Person pessimisticLockHolder = this.getPersonService().getPersonByPrincipalName("kr");
        for (PessimisticLock pessimisticLock : document.getPessimisticLocks()) {
            if (!pessimisticLock.isOwnedByUser(pessimisticLockHolder)) continue;
            isPessimisticallyLocked = true;
            break;
        }
        return isPessimisticallyLocked;
    }

    protected void refreshAfterProtocolAction(ProtocolFormBase protocolForm, String newDocId, String protocolActionName, boolean resetCurrentSubmission) {
        protocolForm.setDocId(newDocId);
        if (resetCurrentSubmission) {
            protocolForm.getActionHelper().setCurrentSubmissionNumber(-1);
        }
        this.recordProtocolActionSuccess(protocolActionName);
    }

    protected String getRedirectPathAfterProtocolAction(ProtocolFormBase protocolForm, ProtocolNotificationRequestBeanBase notificationBean, String promptAfterNotification) {
        if (protocolForm.getActionHelper().getProtocolCorrespondence() != null) {
            return FORWARD_TO_CORRESPONDENCE;
        }
        boolean sendNotification = this.checkToSendNotification(protocolForm, notificationBean, promptAfterNotification);
        return sendNotification ? this.getNotificationEditorHook() : promptAfterNotification;
    }

    @Override
    public boolean checkToSendNotification(ProtocolFormBase protocolForm, ProtocolNotificationRequestBeanBase notificationRequestBean, String promptAfterNotification) {
        ProtocolBase protocol = protocolForm.getProtocolDocument().getProtocol();
        ProtocolNotificationContextBase context = this.getProtocolNotificationContextHook(notificationRequestBean, protocolForm);
        if (protocolForm.getNotificationHelper().getPromptUserForNotificationEditor(context)) {
            context.setForwardName(promptAfterNotification);
            protocolForm.getNotificationHelper().initializeDefaultValues(context);
            return true;
        }
        this.getNotificationService().sendNotificationAndPersist(context, this.getProtocolNotificationInstanceHook(), protocol);
        return false;
    }

    @Override
    public ProtocolCorrespondence getProtocolCorrespondence(ProtocolFormBase protocolForm, String forwardName, ProtocolNotificationRequestBeanBase notificationRequestBean, boolean holdingPage) {
        return this.getProtocolCorrespondence(protocolForm.getProtocolDocument().getProtocol(), forwardName, notificationRequestBean, holdingPage);
    }

    public ProtocolCorrespondence getProtocolCorrespondence(ProtocolBase protocol, String forwardName, ProtocolNotificationRequestBeanBase notificationRequestBean, boolean holdingPage) {
        HashMap<String, Long> keyValues = new HashMap<String, Long>();
        keyValues.put("actionIdFk", protocol.getLastProtocolAction().getProtocolActionId());
        List correspondences = (List)this.getBusinessObjectService().findMatching(this.getProtocolCorrespondenceBOClassHook(), keyValues);
        if (correspondences.isEmpty()) {
            return null;
        }
        ProtocolCorrespondence correspondence = (ProtocolCorrespondence)correspondences.get(0);
        correspondence.setForwardName(forwardName);
        correspondence.setNotificationRequestBean(notificationRequestBean);
        correspondence.setHoldingPage(holdingPage);
        return correspondence;
    }

    protected ProtocolActionBean getActionBean(ProtocolFormBase protocolForm, String taskName) {
        ProtocolActionBean protocolActionBean = null;
        if (StringUtils.isNotBlank((CharSequence)taskName)) {
            protocolActionBean = protocolForm.getActionHelper().getActionBean(taskName);
        }
        return protocolActionBean;
    }

    protected List<AnswerHeader> getAnswerHeaders(ProtocolFormBase protocolForm, String actionTypeCode) {
        ModuleQuestionnaireBean moduleQuestionnaireBean = this.getProtocolModuleQuestionnaireBeanInstanceHook(protocolForm, actionTypeCode);
        return this.getQuestionnaireAnswerService().getQuestionnaireAnswer(moduleQuestionnaireBean);
    }

    protected boolean isMandatoryQuestionnaireComplete(List<AnswerHeader> answerHeaders, String errorKey) {
        boolean valid = true;
        ProtocolQuestionnaireAuditRuleBase auditRule = this.getProtocolQuestionnaireAuditRuleInstanceHook();
        if (!auditRule.isMandatorySubmissionQuestionnaireComplete(answerHeaders)) {
            GlobalVariables.getMessageMap().clearErrorMessages();
            GlobalVariables.getMessageMap().putError(errorKey, "error.mandatory.questionnaire", new String[0]);
            valid = false;
        }
        return valid;
    }

    protected String sendRequestNotification(ProtocolFormBase protocolForm, String requestProtocolActionTypeCode, String reason, String protocolActionTab) throws Exception {
        ProtocolActionTypeBase protocolActionType = (ProtocolActionTypeBase)this.getBusinessObjectService().findBySinglePrimaryKey(this.getProtocolActionTypeBOClassHook(), (Object)requestProtocolActionTypeCode);
        String protocolActionTypeCode = protocolActionType.getProtocolActionTypeCode();
        String description = protocolActionType.getDescription();
        ProtocolNotificationRequestBeanBase notificationBean = this.getRequestActionNotificationBeanInstanceHook(protocolForm.getProtocolDocument().getProtocol(), protocolActionTypeCode, description, reason);
        return this.getRedirectPathAfterProtocolAction(protocolForm, notificationBean, protocolActionTab);
    }

    protected abstract ProtocolNotificationRequestBeanBase getRequestActionNotificationBeanInstanceHook(ProtocolBase var1, String var2, String var3, String var4);

    protected abstract ProtocolQuestionnaireAuditRuleBase getProtocolQuestionnaireAuditRuleInstanceHook();

    protected abstract ModuleQuestionnaireBean getProtocolModuleQuestionnaireBeanInstanceHook(ProtocolFormBase var1, String var2);

    protected abstract Class<? extends ProtocolCorrespondence> getProtocolCorrespondenceBOClassHook();

    protected abstract String getNotificationEditorHook();

    protected abstract ProtocolNotification getProtocolNotificationInstanceHook();

    protected abstract ProtocolNotificationContextBase getProtocolNotificationContextHook(ProtocolNotificationRequestBeanBase var1, ProtocolFormBase var2);

    protected abstract ProtocolTaskBase getProtocolTaskInstanceHook(String var1, ProtocolBase var2);

    protected abstract ProtocolTaskBase getProtocolGenericActionTaskInstanceHook(String var1, ProtocolBase var2);

    protected abstract ProtocolActionsCorrespondenceBase getNewProtocolActionsCorrespondence(String var1);

    protected abstract Class<? extends ProtocolActionTypeBase> getProtocolActionTypeBOClassHook();

    protected abstract String getProtocolCreatedActionTypeHook();

    protected abstract Class<? extends ProtocolBase> getProtocolBOClassHook();

    protected abstract String getProtocolRejectedInRoutingActionTypeHook();

    protected abstract String getProtocolRecalledInRoutingActionTypeHook();

    public ProtocolActionCorrespondenceGenerationService getProtocolActionCorrespondenceGenerationService() {
        return this.protocolActionCorrespondenceGenerationService;
    }

    public void setProtocolActionCorrespondenceGenerationService(ProtocolActionCorrespondenceGenerationService protocolActionCorrespondenceGenerationService) {
        this.protocolActionCorrespondenceGenerationService = protocolActionCorrespondenceGenerationService;
    }

    public KcNotificationService getNotificationService() {
        return this.notificationService;
    }

    public void setNotificationService(KcNotificationService notificationService) {
        this.notificationService = notificationService;
    }

    public ReviewCommentsService<? extends ProtocolReviewAttachmentBase> getReviewCommentsService() {
        return this.reviewCommentsService;
    }

    public void setReviewCommentsService(ReviewCommentsService<? extends ProtocolReviewAttachmentBase> reviewCommentsService) {
        this.reviewCommentsService = reviewCommentsService;
    }

    public PersonService getPersonService() {
        return this.personService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    public QuestionnaireAnswerService getQuestionnaireAnswerService() {
        return this.questionnaireAnswerService;
    }

    public void setQuestionnaireAnswerService(QuestionnaireAnswerService questionnaireAnswerService) {
        this.questionnaireAnswerService = questionnaireAnswerService;
    }
}

