/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.committee.impl.document;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.committee.impl.bo.CommitteeBase;
import org.kuali.coeus.common.committee.impl.bo.CommitteeScheduleBase;
import org.kuali.coeus.common.committee.impl.service.CommitteeServiceBase;
import org.kuali.coeus.sys.framework.model.KcTransactionalDocumentBase;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.bo.RolePersons;
import org.kuali.rice.kew.framework.postprocessor.DocumentRouteStatusChange;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.document.Copyable;
import org.kuali.rice.krad.document.SessionDocument;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.util.ObjectUtils;

public abstract class CommitteeDocumentBase<CD extends CommitteeDocumentBase<CD, CMT, CS>, CMT extends CommitteeBase<CMT, CD, CS>, CS extends CommitteeScheduleBase<CS, CMT, ?, ?>>
extends KcTransactionalDocumentBase
implements Copyable,
SessionDocument {
    private static final long serialVersionUID = 1L;
    private static final String DOCUMENT_TYPE_CODE = "COMT";
    private String committeeId;
    private String docStatusCode;
    private List<CMT> committeeList = new ArrayList<CMT>();

    public CommitteeDocumentBase() {
        CMT committee = this.getNewCommitteeInstanceHook();
        this.committeeList.add(committee);
        ((CommitteeBase)committee).setCommitteeDocument(this.getThisHook());
    }

    protected abstract CD getThisHook();

    protected abstract CMT getNewCommitteeInstanceHook();

    @Override
    public void initialize() {
    }

    public CMT getCommittee() {
        return (CMT)((CommitteeBase)this.committeeList.get(0));
    }

    public void setCommittee(CMT committee) {
        this.committeeList.set(0, committee);
    }

    public List<CMT> getCommitteeList() {
        return this.committeeList;
    }

    public void setCommitteeList(List<CMT> committeeList) {
        this.committeeList = committeeList;
    }

    public List buildListOfDeletionAwareLists() {
        List managedLists = super.buildListOfDeletionAwareLists();
        managedLists.add(((CommitteeBase)this.getCommittee()).getCommitteeMemberships());
        managedLists.add(((CommitteeBase)this.getCommittee()).getCommitteeMemberships().stream().flatMap(membership -> membership.getMembershipRoles().stream()).collect(Collectors.toList()));
        managedLists.add(((CommitteeBase)this.getCommittee()).getCommitteeMemberships().stream().flatMap(membership -> membership.getMembershipExpertise().stream()).collect(Collectors.toList()));
        return managedLists;
    }

    @Override
    protected List<RolePersons> getAllRolePersons() {
        return new ArrayList<RolePersons>();
    }

    @Override
    public String getDocumentTypeCode() {
        return DOCUMENT_TYPE_CODE;
    }

    public void prepareForSave() {
        String routeStatusCode;
        super.prepareForSave();
        if (ObjectUtils.isNull((Object)this.getVersionNumber())) {
            this.setVersionNumber(0L);
        }
        if (this.getCommittee() != null) {
            this.setCommitteeId(((CommitteeBase)this.getCommittee()).getCommitteeId());
        }
        if (StringUtils.isNotBlank((CharSequence)(routeStatusCode = this.getDocumentHeader().getWorkflowDocument().getStatus().getCode())) && routeStatusCode.equals("I")) {
            this.setDocStatusCode("S");
        } else {
            this.setDocStatusCode(routeStatusCode);
        }
    }

    public void doRouteStatusChange(DocumentRouteStatusChange statusChangeEvent) {
        this.executeAsLastActionUser(() -> {
            super.doRouteStatusChange(statusChangeEvent);
            this.setDocStatusCode(statusChangeEvent.getNewRouteStatus());
            if (this.isFinal(statusChangeEvent) && ((CommitteeBase)this.getCommittee()).getSequenceNumber() > 1) {
                List<CS> newMasterSchedules = this.getCommitteeService().mergeCommitteeSchedule(this.getCommittee());
                ((CommitteeBase)this.getCommittee()).setCommitteeSchedules(newMasterSchedules);
                this.getCommitteeService().updateCommitteeForProtocolSubmissions(this.getCommittee());
            }
            this.getBusinessObjectService().save((PersistableBusinessObject)this);
            return null;
        });
    }

    protected abstract CommitteeServiceBase<CMT, CS> getCommitteeService();

    private BusinessObjectService getBusinessObjectService() {
        return KcServiceLocator.getService(BusinessObjectService.class);
    }

    private boolean isFinal(DocumentRouteStatusChange statusChangeEvent) {
        return StringUtils.equals((CharSequence)"F", (CharSequence)statusChangeEvent.getNewRouteStatus());
    }

    public String getCommitteeId() {
        return this.committeeId;
    }

    public void setCommitteeId(String committeeId) {
        this.committeeId = committeeId;
    }

    public String getDocStatusCode() {
        return this.docStatusCode;
    }

    public void setDocStatusCode(String docStatusCode) {
        this.docStatusCode = docStatusCode;
    }

    @Override
    public boolean isProcessComplete() {
        String docRouteStatus;
        boolean isComplete = false;
        if (this.getDocumentHeader().hasWorkflowDocument() && "F".equals(docRouteStatus = this.getDocumentHeader().getWorkflowDocument().getStatus().getCode())) {
            isComplete = true;
        }
        return isComplete;
    }

    @Override
    public String getDocumentBoNumber() {
        return this.getCommitteeId();
    }
}

