/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.budget.subaward;

import java.util.Objects;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.kuali.coeus.common.budget.framework.period.BudgetPeriod;
import org.kuali.coeus.propdev.api.budget.subaward.BudgetSubAwardPeriodDetailContract;
import org.kuali.coeus.propdev.impl.budget.subaward.BudgetSubAwards;
import org.kuali.coeus.sys.api.model.AbstractDecimal;
import org.kuali.coeus.sys.api.model.ScaleTwoDecimal;
import org.kuali.coeus.sys.framework.model.KcPersistableBusinessObjectBase;
import org.kuali.coeus.sys.framework.persistence.ScaleTwoDecimalConverter;
import org.kuali.rice.krad.data.jpa.PortableSequenceGenerator;

@Entity
@Table(name="BUDGET_SUB_AWARD_PERIOD_DETAIL")
public class BudgetSubAwardPeriodDetail
extends KcPersistableBusinessObjectBase
implements BudgetSubAwardPeriodDetailContract {
    private static final long serialVersionUID = 2327612798304765405L;
    @PortableSequenceGenerator(name="SEQ_BUDGET_SUBAWARD_PER_DET")
    @GeneratedValue(generator="SEQ_BUDGET_SUBAWARD_PER_DET")
    @Id
    @Column(name="SUBAWARD_PERIOD_DETAIL_ID")
    private Long id;
    @ManyToOne(cascade={CascadeType.REFRESH})
    @JoinColumns(value={@JoinColumn(name="BUDGET_ID", referencedColumnName="BUDGET_ID"), @JoinColumn(name="SUBAWARD_NUMBER", referencedColumnName="SUB_AWARD_NUMBER")})
    private BudgetSubAwards budgetSubAward;
    @Column(name="BUDGET_PERIOD")
    private Integer budgetPeriod;
    @Column(name="DIRECT_COST")
    @Convert(converter=ScaleTwoDecimalConverter.class)
    private ScaleTwoDecimal directCost = ScaleTwoDecimal.ZERO;
    @Column(name="INDIRECT_COST")
    @Convert(converter=ScaleTwoDecimalConverter.class)
    private ScaleTwoDecimal indirectCost = ScaleTwoDecimal.ZERO;
    @Column(name="COST_SHARING_AMOUNT")
    @Convert(converter=ScaleTwoDecimalConverter.class)
    private ScaleTwoDecimal costShare = ScaleTwoDecimal.ZERO;
    @Column(name="TOTAL_COST")
    @Convert(converter=ScaleTwoDecimalConverter.class)
    private ScaleTwoDecimal totalCost = ScaleTwoDecimal.ZERO;
    @Column(name="SUBAWARD_NUMBER", insertable=false, updatable=false)
    private Integer subAwardNumber;
    @Transient
    private transient boolean amountsModified = false;

    public BudgetSubAwardPeriodDetail() {
    }

    public BudgetSubAwardPeriodDetail(BudgetSubAwards subAward, BudgetPeriod period) {
        this.budgetSubAward = subAward;
        this.subAwardNumber = subAward.getSubAwardNumber();
        this.budgetPeriod = period.getBudgetPeriod();
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Integer getBudgetPeriod() {
        return this.budgetPeriod;
    }

    public void setBudgetPeriod(Integer budgetPeriod) {
        this.budgetPeriod = budgetPeriod;
    }

    public ScaleTwoDecimal getDirectCost() {
        return this.directCost;
    }

    public void setDirectCost(ScaleTwoDecimal directCost) {
        if (!Objects.equals(this.directCost, directCost)) {
            this.amountsModified = true;
        }
        this.directCost = directCost;
        this.computeTotal();
    }

    public ScaleTwoDecimal getIndirectCost() {
        return this.indirectCost;
    }

    public void setIndirectCost(ScaleTwoDecimal indirectCost) {
        if (!Objects.equals(this.indirectCost, indirectCost)) {
            this.amountsModified = true;
        }
        this.indirectCost = indirectCost;
        this.computeTotal();
    }

    public ScaleTwoDecimal getCostShare() {
        return this.costShare;
    }

    public void setCostShare(ScaleTwoDecimal costShare) {
        if (!Objects.equals(this.costShare, costShare)) {
            this.amountsModified = true;
        }
        this.costShare = costShare;
    }

    public ScaleTwoDecimal getTotalCost() {
        return this.totalCost;
    }

    public void setTotalCost(ScaleTwoDecimal totalCost) {
        this.totalCost = totalCost;
    }

    public void computeTotal() {
        ScaleTwoDecimal total = this.getDirectCost() == null ? ScaleTwoDecimal.ZERO : this.getDirectCost();
        total = (ScaleTwoDecimal)total.add((AbstractDecimal)(this.getIndirectCost() == null ? ScaleTwoDecimal.ZERO : this.getIndirectCost()));
        total = (ScaleTwoDecimal)total.add((AbstractDecimal)(this.getCostShare() == null ? ScaleTwoDecimal.ZERO : this.getCostShare()));
        this.setTotalCost(total);
    }

    public boolean isAmountsModified() {
        return this.amountsModified;
    }

    public void setAmountsModified(boolean amountsModified) {
        this.amountsModified = amountsModified;
    }

    public BudgetSubAwards getBudgetSubAward() {
        return this.budgetSubAward;
    }

    public void setBudgetSubAward(BudgetSubAwards budgetSubAward) {
        this.budgetSubAward = budgetSubAward;
    }

    public Integer getSubAwardNumber() {
        return this.subAwardNumber;
    }

    public void setSubAwardNumber(Integer subAwardNumber) {
        this.subAwardNumber = subAwardNumber;
    }

    public Long getBudgetId() {
        if (this.budgetSubAward != null) {
            return this.budgetSubAward.getBudgetId();
        }
        return null;
    }

    public BudgetPeriod getBudgetPeriodBO() {
        for (BudgetPeriod period : this.getBudgetSubAward().getBudget().getBudgetPeriods()) {
            if (!Objects.equals(this.budgetPeriod, period.getBudgetPeriod())) continue;
            return period;
        }
        return null;
    }
}

