/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.institutionalproposal.specialreview;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.BooleanUtils;
import org.kuali.coeus.common.framework.compliance.core.SpecialReviewHelperBase;
import org.kuali.kra.institutionalproposal.specialreview.InstitutionalProposalSpecialReview;
import org.kuali.kra.institutionalproposal.web.struts.form.InstitutionalProposalForm;

public class SpecialReviewHelper
extends SpecialReviewHelperBase<InstitutionalProposalSpecialReview> {
    private static final long serialVersionUID = 6509860722698432447L;
    private static final String PROTOCOL_INSTITUTIONAL_PROPOSAL_LINKING_ENABLED_PARAMETER = "irb.protocol.institute.proposal.linking.enabled";
    private static final String IACUC_PROTOCOL_INSTITUTIONAL_PROPOSAL_LINKING_ENABLED_PARAMETER = "iacuc.protocol.institute.proposal.linking.enabled";
    private InstitutionalProposalForm form;

    public SpecialReviewHelper(InstitutionalProposalForm form) {
        this.form = form;
        this.setNewSpecialReview(new InstitutionalProposalSpecialReview());
        this.setLinkedProtocolNumbers(new ArrayList<String>());
    }

    public void syncProtocolFundingSourcesWithSpecialReviews() {
        String fundingSourceNumber = this.form.getInstitutionalProposalDocument().getInstitutionalProposal().getProposalNumber();
        String fundingSourceTypeCode = "5";
        String fundingSourceName = this.form.getInstitutionalProposalDocument().getInstitutionalProposal().getSponsorName();
        String fundingSourceTitle = this.form.getInstitutionalProposalDocument().getInstitutionalProposal().getTitle();
        this.syncProtocolFundingSourcesWithSpecialReviews(fundingSourceNumber, fundingSourceTypeCode, fundingSourceName, fundingSourceTitle);
    }

    @Override
    protected boolean hasModifySpecialReviewPermission(String principalId) {
        return BooleanUtils.toBoolean((String)((String)this.form.getEditingMode().get("fullEntry")));
    }

    @Override
    protected boolean isIrbProtocolLinkingEnabledForModule() {
        return this.getParameterService().getParameterValueAsBoolean("KC-PROTOCOL", "Document", PROTOCOL_INSTITUTIONAL_PROPOSAL_LINKING_ENABLED_PARAMETER);
    }

    @Override
    protected boolean isIacucProtocolLinkingEnabledForModule() {
        return this.getParameterService().getParameterValueAsBoolean("KC-IACUC", "Document", IACUC_PROTOCOL_INSTITUTIONAL_PROPOSAL_LINKING_ENABLED_PARAMETER);
    }

    @Override
    protected List<InstitutionalProposalSpecialReview> getSpecialReviews() {
        return this.form.getInstitutionalProposalDocument().getInstitutionalProposal().getSpecialReviews();
    }

    @Override
    public boolean isCanCreateIrbProtocol() {
        return false;
    }

    @Override
    public boolean isCanCreateIacucProtocol() {
        return false;
    }
}

