/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.subaward.bo;

import java.io.IOException;
import java.lang.ref.SoftReference;
import java.sql.Timestamp;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.struts.upload.FormFile;
import org.kuali.coeus.common.framework.attachment.KcAttachmentDataDao;
import org.kuali.coeus.sys.api.model.KcFile;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.subaward.bo.SubAward;
import org.kuali.kra.subaward.bo.SubAwardAssociate;
import org.kuali.kra.subaward.bo.SubAwardAttachmentType;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.identity.PersonService;

public class SubAwardAttachments
extends SubAwardAssociate
implements Comparable<SubAwardAttachments>,
KcFile {
    private static final Logger LOG = LogManager.getLogger(SubAwardAttachments.class);
    private String subAwardCode;
    private Integer sequenceNumber;
    private Integer attachmentId;
    private SubAwardAttachmentType typeAttachment;
    private String description;
    private Long subAwardId;
    private transient FormFile newFile;
    private Integer subAwardAttachmentTypeCode;
    private Integer documentId;
    private String fileName;
    private String fileDataId;
    private String oldFileDataId;
    private transient SoftReference<byte[]> document;
    private String mimeType;
    private Boolean selectToPrint = false;
    private String documentStatusCode;
    private boolean modifyAttachment = false;
    private String lastUpdateUser;
    private Timestamp lastUpdateTimestamp;
    private transient KcAttachmentDataDao kcAttachmentDataDao;

    public final Boolean getSelectToPrint() {
        return this.selectToPrint;
    }

    public final void setSelectToPrint(Boolean selectToPrint) {
        this.selectToPrint = selectToPrint;
    }

    public String getName() {
        return this.getFileName();
    }

    public String getType() {
        return this.getMimeType();
    }

    public byte[] getData() {
        return this.getDocument();
    }

    public SubAwardAttachmentType getTypeAttachment() {
        return this.typeAttachment;
    }

    public void setTypeAttachment(SubAwardAttachmentType typeAttachment) {
        this.typeAttachment = typeAttachment;
    }

    public byte[] getAttachmentContent() {
        return this.getDocument();
    }

    public String getContentType() {
        return this.getMimeType();
    }

    public void setContentType(String contentType) {
        this.setMimeType(contentType);
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public byte[] getDocument() {
        byte[] existingData;
        if (this.document != null && (existingData = this.document.get()) != null) {
            return existingData;
        }
        byte[] newData = this.getKcAttachmentDataDao().getData(this.fileDataId);
        this.document = new SoftReference<byte[]>(newData);
        return newData;
    }

    public void setDocument(byte[] document) {
        if (document == null || document.length == 0) {
            this.setFileDataId(null);
        } else {
            this.setFileDataId(this.getKcAttachmentDataDao().saveData(document, null));
        }
        this.document = new SoftReference<byte[]>(document);
    }

    public SubAwardAttachments() {
    }

    public SubAwardAttachments(SubAward subaward) {
        this.setSubAward(subaward);
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    @Override
    public Long getSubAwardId() {
        return this.subAwardId;
    }

    @Override
    public void setSubAwardId(Long subAwardId) {
        this.subAwardId = subAwardId;
    }

    public Integer getSubAwardAttachmentTypeCode() {
        return this.subAwardAttachmentTypeCode;
    }

    public void setSubAwardAttachmentTypeCode(Integer subAwardAttachmentTypeCode) {
        this.subAwardAttachmentTypeCode = subAwardAttachmentTypeCode;
    }

    public String getAttachmentDescription() {
        return "Subaward Attachment";
    }

    public Integer getDocumentId() {
        return this.documentId;
    }

    public void setDocumentId(Integer documentId) {
        this.documentId = documentId;
    }

    public FormFile getNewFile() {
        return this.newFile;
    }

    public void setNewFile(FormFile newFile) {
        this.newFile = newFile;
    }

    @Override
    public String getSubAwardCode() {
        return this.subAwardCode;
    }

    @Override
    public void setSubAwardCode(String subAwardCode) {
        this.subAwardCode = subAwardCode;
    }

    @Override
    public Integer getSequenceNumber() {
        return this.sequenceNumber;
    }

    @Override
    public void setSequenceNumber(Integer sequenceNumber) {
        this.sequenceNumber = sequenceNumber;
    }

    public Integer getAttachmentId() {
        return this.attachmentId;
    }

    public void setAttachmentId(Integer attachmentId) {
        this.attachmentId = attachmentId;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean isNew() {
        return this.getAttachmentId() == null;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.documentId == null ? 0 : this.documentId.hashCode());
        result = 31 * result + (this.subAwardAttachmentTypeCode == null ? 0 : this.subAwardAttachmentTypeCode.hashCode());
        result = 31 * result + (this.fileDataId == null ? 0 : this.fileDataId.hashCode());
        result = 31 * result + (this.attachmentId == null ? 0 : this.attachmentId.hashCode());
        result = 31 * result + (this.mimeType == null ? 0 : this.mimeType.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SubAwardAttachments other = (SubAwardAttachments)obj;
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (this.documentId == null ? other.documentId != null : !this.documentId.equals(other.documentId)) {
            return false;
        }
        if (this.subAwardAttachmentTypeCode == null ? other.subAwardAttachmentTypeCode != null : !this.subAwardAttachmentTypeCode.equals(other.subAwardAttachmentTypeCode)) {
            return false;
        }
        if (this.fileDataId == null ? other.fileDataId != null : !this.fileDataId.equals(other.fileDataId)) {
            return false;
        }
        if (this.attachmentId == null ? other.attachmentId != null : !this.attachmentId.equals(other.attachmentId)) {
            return false;
        }
        return !(this.mimeType == null ? other.mimeType != null : !this.mimeType.equals(other.mimeType));
    }

    @Override
    protected void preUpdate() {
        super.preUpdate();
        if (this.getVersionNumber() == null) {
            this.setVersionNumber(new Long(0L));
        }
    }

    public String getLastUpdateUserName() {
        Person updateUser = KcServiceLocator.getService(PersonService.class).getPersonByPrincipalName(this.getLastUpdateUser());
        return updateUser != null ? updateUser.getName() : this.getUpdateUser();
    }

    public void populateAttachment() {
        FormFile newFile = this.getNewFile();
        if (newFile == null) {
            return;
        }
        try {
            byte[] newFileData = newFile.getFileData();
            this.setDocument(newFileData);
            if (newFileData.length > 0) {
                this.mimeType = newFile.getContentType();
                this.fileName = newFile.getFileName();
            }
        }
        catch (IOException e) {
            LOG.warn(e.getMessage(), (Throwable)e);
        }
    }

    public String getDocumentStatusCode() {
        return this.documentStatusCode;
    }

    public void setDocumentStatusCode(String documentStatusCode) {
        this.documentStatusCode = documentStatusCode;
    }

    public boolean isModifyAttachment() {
        return this.modifyAttachment;
    }

    public void setModifyAttachment(boolean modifyAttachment) {
        this.modifyAttachment = modifyAttachment;
    }

    @Override
    public void resetPersistenceState() {
        this.setAttachmentId(null);
    }

    @Override
    public int compareTo(SubAwardAttachments o) {
        return this.getAttachmentId().compareTo(o.getAttachmentId());
    }

    public String getLastUpdateUser() {
        return this.lastUpdateUser;
    }

    public void setLastUpdateUser(String lastUpdateUser) {
        this.lastUpdateUser = lastUpdateUser;
    }

    public Timestamp getLastUpdateTimestamp() {
        return this.lastUpdateTimestamp;
    }

    public void setLastUpdateTimestamp(Timestamp lastUpdateTimestamp) {
        this.lastUpdateTimestamp = lastUpdateTimestamp;
    }

    @Override
    public void prePersist() {
        super.prePersist();
        if (this.lastUpdateUser == null) {
            this.setLastUpdateUser(this.getUpdateUser());
        }
        if (this.lastUpdateTimestamp == null) {
            this.setLastUpdateTimestamp(this.getUpdateTimestamp());
        }
    }

    public String getFileDataId() {
        return this.fileDataId;
    }

    public void setFileDataId(String fileDataId) {
        if (!StringUtils.equals((CharSequence)this.fileDataId, (CharSequence)fileDataId)) {
            this.oldFileDataId = this.fileDataId;
        }
        this.fileDataId = fileDataId;
    }

    public void postRemove() {
        super.postRemove();
        if (this.getFileDataId() != null) {
            this.getKcAttachmentDataDao().removeData(this.getFileDataId());
        }
    }

    public void postUpdate() {
        super.postUpdate();
        if (this.oldFileDataId != null && !StringUtils.equals((CharSequence)this.fileDataId, (CharSequence)this.oldFileDataId)) {
            this.getKcAttachmentDataDao().removeData(this.oldFileDataId);
            this.oldFileDataId = null;
        }
    }

    public KcAttachmentDataDao getKcAttachmentDataDao() {
        if (this.kcAttachmentDataDao == null) {
            this.kcAttachmentDataDao = KcServiceLocator.getService(KcAttachmentDataDao.class);
        }
        return this.kcAttachmentDataDao;
    }

    public void setKcAttachmentDataDao(KcAttachmentDataDao kcAttachmentDao) {
        this.kcAttachmentDataDao = kcAttachmentDao;
    }

    public String getOldFileDataId() {
        return this.oldFileDataId;
    }

    public void setOldFileDataId(String oldFileDataId) {
        this.oldFileDataId = oldFileDataId;
    }
}

