/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.committee.impl.rules;

import java.sql.Date;
import java.util.List;
import org.kuali.coeus.common.committee.impl.bo.CommitteeScheduleBase;
import org.kuali.coeus.common.committee.impl.rule.event.CommitteeScheduleDeadlineEvent;
import org.kuali.coeus.sys.framework.rule.KcBusinessRule;
import org.kuali.coeus.sys.framework.rule.KcTransactionalDocumentRuleBase;

public class CommitteeScheduleDeadlineDateRule
extends KcTransactionalDocumentRuleBase
implements KcBusinessRule<CommitteeScheduleDeadlineEvent> {
    public static final String ID = "document.committeeList[0].committeeSchedules[%1$s].protocolSubDeadline";

    @Override
    public boolean processRules(CommitteeScheduleDeadlineEvent deadlineCommitteeScheduleEvent) {
        boolean rulePassed = true;
        List<CommitteeScheduleBase> committeeSchedules = deadlineCommitteeScheduleEvent.getCommitteeSchedules();
        int count = 0;
        for (CommitteeScheduleBase committeeSchedule : committeeSchedules) {
            Date deadline = committeeSchedule.getProtocolSubDeadline();
            Date schedule = committeeSchedule.getScheduledDate();
            if (schedule != null && deadline != null && schedule.before(deadline)) {
                this.reportError(String.format(ID, count), "error.committeeSchedule.dealine", deadline.toString(), schedule.toString());
                rulePassed = false;
            }
            ++count;
        }
        return rulePassed;
    }
}

