/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.impl.custom.attr;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.framework.custom.DocumentCustomData;
import org.kuali.coeus.common.framework.custom.arg.ArgValueLookup;
import org.kuali.coeus.common.framework.custom.attr.CustomAttribute;
import org.kuali.coeus.common.framework.custom.attr.CustomAttributeDataType;
import org.kuali.coeus.common.framework.custom.attr.CustomAttributeDocument;
import org.kuali.coeus.common.framework.custom.attr.CustomAttributeService;
import org.kuali.kra.infrastructure.PropertyConstants;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.WorkflowDocumentFactory;
import org.kuali.rice.kew.api.document.attribute.WorkflowAttributeDefinition;
import org.kuali.rice.kns.service.BusinessObjectDictionaryService;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.service.DataDictionaryService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component(value="customAttributeService")
public class CustomAttributeServiceImpl
implements CustomAttributeService {
    private static final String ARGVALUELOOKUP_CLASS = ArgValueLookup.class.getName();
    private static final String EQUAL_CHAR = "=";
    @Autowired
    @Qualifier(value="dataObjectService")
    private DataObjectService dataObjectService;
    @Autowired
    @Qualifier(value="businessObjectDictionaryService")
    private BusinessObjectDictionaryService businessDictionaryService;
    @Autowired
    @Qualifier(value="dataDictionaryService")
    private DataDictionaryService dataDictionaryService;
    @Autowired
    @Qualifier(value="businessObjectService")
    private BusinessObjectService businessObjectService;
    @Autowired
    @Qualifier(value="parameterService")
    private ParameterService parameterService;

    @Override
    public Map<String, CustomAttributeDocument> getDefaultCustomAttributeDocuments(String documentTypeCode, List<? extends DocumentCustomData> customDataList) {
        HashMap<String, CustomAttributeDocument> customAttributeDocuments = new HashMap<String, CustomAttributeDocument>();
        HashMap<String, String> queryMap = new HashMap<String, String>();
        queryMap.put(PropertyConstants.DOCUMENT.TYPE_NAME.toString(), documentTypeCode);
        List customAttributeDocumentList = (List)this.businessObjectService.findMatching(CustomAttributeDocument.class, queryMap);
        HashSet<Object> customIds = new HashSet();
        if (customDataList != null) {
            customIds = this.getCurrentCustomAttributeIds(customDataList);
        }
        for (CustomAttributeDocument customAttributeDocument : customAttributeDocumentList) {
            boolean customAttributeExists = false;
            if (!customIds.isEmpty() && customIds.contains((long)customAttributeDocument.getId())) {
                customAttributeExists = true;
            }
            if (!customAttributeDocument.isActive() && !customAttributeExists) continue;
            customAttributeDocuments.put(customAttributeDocument.getId().toString(), customAttributeDocument);
        }
        return customAttributeDocuments;
    }

    protected HashSet<Long> getCurrentCustomAttributeIds(List<? extends DocumentCustomData> customDataList) {
        HashSet<Long> customIds = new HashSet<Long>();
        for (DocumentCustomData documentCustomData : customDataList) {
            customIds.add(documentCustomData.getCustomAttributeId());
        }
        return customIds;
    }

    @Override
    public void setCustomAttributeKeyValue(String documentNumber, Map<String, CustomAttributeDocument> customAttributeDocuments, String attributeName, String networkId) {
        WorkflowDocument workflowDocument = WorkflowDocumentFactory.loadDocument((String)networkId, (String)documentNumber);
        workflowDocument.clearAttributeContent();
        WorkflowAttributeDefinition customDataDef = WorkflowAttributeDefinition.Builder.create((String)attributeName).build();
        WorkflowAttributeDefinition.Builder refToUpdate = WorkflowAttributeDefinition.Builder.create((WorkflowAttributeDefinition)customDataDef);
        if (customAttributeDocuments != null) {
            for (Map.Entry<String, CustomAttributeDocument> customAttributeDocumentEntry : customAttributeDocuments.entrySet()) {
                CustomAttributeDocument customAttributeDocument = customAttributeDocumentEntry.getValue();
                if (!StringUtils.isNotBlank((CharSequence)customAttributeDocument.getCustomAttribute().getValue())) continue;
                refToUpdate.addPropertyDefinition(customAttributeDocument.getCustomAttribute().getName(), StringEscapeUtils.escapeXml((String)customAttributeDocument.getCustomAttribute().getValue()));
            }
        }
        workflowDocument.addAttributeDefinition(refToUpdate.build());
        workflowDocument.saveDocumentData();
    }

    @Override
    public CustomAttributeDataType getCustomAttributeDataType(String dataTypeCode) {
        if (StringUtils.isNotEmpty((CharSequence)dataTypeCode)) {
            return (CustomAttributeDataType)this.dataObjectService.findUnique(CustomAttributeDataType.class, QueryByCriteria.Builder.forAttribute((String)"code", (Object)dataTypeCode).build());
        }
        return null;
    }

    @Override
    public List getLookupReturns(String lookupClass) throws Exception {
        List<String> lookupReturns = new ArrayList();
        if (ARGVALUELOOKUP_CLASS.equals(lookupClass)) {
            for (ArgValueLookup argValueLookup : this.businessObjectService.findAll(ArgValueLookup.class)) {
                if (lookupReturns.contains(argValueLookup.getArgumentName())) continue;
                lookupReturns.add(argValueLookup.getArgumentName());
            }
            Collections.sort(lookupReturns);
        } else {
            lookupReturns = this.businessDictionaryService.getLookupFieldNames(Class.forName(lookupClass));
        }
        return lookupReturns;
    }

    @Override
    public String getLookupReturnsForAjaxCall(String lookupClass) throws Exception {
        List lookupFieldNames = this.getLookupReturns(lookupClass);
        Object attributeNames = "";
        for (Object attributeName : lookupFieldNames) {
            attributeNames = (String)attributeNames + "," + attributeName + ";" + (ARGVALUELOOKUP_CLASS.equals(lookupClass) ? attributeName : this.dataDictionaryService.getAttributeLabel(lookupClass, attributeName.toString()));
        }
        return attributeNames;
    }

    public void setDataObjectService(DataObjectService dataObjectService) {
        this.dataObjectService = dataObjectService;
    }

    public DataObjectService getDataObjectService() {
        return this.dataObjectService;
    }

    public DataDictionaryService getDataDictionaryService() {
        return this.dataDictionaryService;
    }

    public void setDataDictionaryService(DataDictionaryService dataDictionaryService) {
        this.dataDictionaryService = dataDictionaryService;
    }

    public BusinessObjectDictionaryService getBusinessDictionaryService() {
        return this.businessDictionaryService;
    }

    public void setBusinessDictionaryService(BusinessObjectDictionaryService businessDictionaryService) {
        this.businessDictionaryService = businessDictionaryService;
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public ParameterService getParameterService() {
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    @Override
    public boolean isRequired(String dataTypeCode, CustomAttribute attr, List<? extends DocumentCustomData> customDataList) {
        Map<String, CustomAttributeDocument> map = this.getDefaultCustomAttributeDocuments(dataTypeCode, customDataList);
        for (Map.Entry<String, CustomAttributeDocument> document : map.entrySet()) {
            if (document.getValue() == null || document.getValue().getCustomAttribute() == null || !Objects.equals(document.getValue().getCustomAttribute().getId(), attr.getId())) continue;
            return document.getValue().isRequired();
        }
        return false;
    }

    @Override
    public Map<String, String> getDocumentTypeMap() {
        HashMap<String, String> documentTypes = new HashMap<String, String>();
        for (String documentType : this.getDocumentTypeParam()) {
            String[] params = documentType.split(EQUAL_CHAR);
            documentTypes.put(params[0], params[1]);
        }
        return documentTypes;
    }

    @Override
    public Map<String, String> getReverseDocumentTypeMap() {
        HashMap<String, String> documentTypes = new HashMap<String, String>();
        for (String documentType : this.getDocumentTypeParam()) {
            String[] params = documentType.split(EQUAL_CHAR);
            documentTypes.put(params[1].replace(" ", "+"), params[0]);
        }
        return documentTypes;
    }

    protected Collection<String> getDocumentTypeParam() {
        return this.getParameterService().getParameterValuesAsString("KC-GEN", "DocumentType", "customAttributeDocumentType");
    }
}

