/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.iacuc.protocol;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.coeus.common.notification.impl.service.KcNotificationService;
import org.kuali.coeus.propdev.impl.core.DevelopmentProposal;
import org.kuali.coeus.propdev.impl.core.ProposalDevelopmentDocument;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.iacuc.IacucProtocol;
import org.kuali.kra.iacuc.IacucProtocolAction;
import org.kuali.kra.iacuc.IacucProtocolDocument;
import org.kuali.kra.iacuc.IacucProtocolDocumentRule;
import org.kuali.kra.iacuc.IacucProtocolForm;
import org.kuali.kra.iacuc.IacucResearchArea;
import org.kuali.kra.iacuc.notification.IacucProtocolFundingSourceNotificationRenderer;
import org.kuali.kra.iacuc.notification.IacucProtocolNotification;
import org.kuali.kra.iacuc.notification.IacucProtocolNotificationContext;
import org.kuali.kra.iacuc.protocol.funding.AddIacucProtocolFundingSourceEvent;
import org.kuali.kra.iacuc.protocol.funding.IacucProtocolFundingSource;
import org.kuali.kra.iacuc.protocol.funding.IacucProtocolFundingSourceService;
import org.kuali.kra.iacuc.protocol.funding.IacucProtocolFundingSourceServiceImpl;
import org.kuali.kra.iacuc.protocol.funding.IacucProtocolProposalDevelopmentDocumentService;
import org.kuali.kra.iacuc.protocol.funding.LookupIacucProtocolFundingSourceEvent;
import org.kuali.kra.iacuc.protocol.funding.SaveIacucProtocolFundingSourceLinkEvent;
import org.kuali.kra.iacuc.protocol.location.AddIacucProtocolLocationEvent;
import org.kuali.kra.iacuc.protocol.location.IacucProtocolLocation;
import org.kuali.kra.iacuc.protocol.location.IacucProtocolLocationService;
import org.kuali.kra.iacuc.protocol.reference.AddIacucProtocolReferenceEvent;
import org.kuali.kra.iacuc.protocol.reference.IacucProtocolReference;
import org.kuali.kra.iacuc.protocol.reference.IacucProtocolReferenceBean;
import org.kuali.kra.iacuc.protocol.reference.IacucProtocolReferenceService;
import org.kuali.kra.iacuc.protocol.reference.IacucProtocolReferenceType;
import org.kuali.kra.iacuc.protocol.research.IacucProtocolResearchAreaService;
import org.kuali.kra.protocol.ProtocolDocumentBase;
import org.kuali.kra.protocol.ProtocolEventBase;
import org.kuali.kra.protocol.ProtocolFormBase;
import org.kuali.kra.protocol.protocol.funding.ProtocolFundingSourceBase;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.rules.rule.event.DocumentEvent;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.util.GlobalVariables;

public class IacucProtocolProtocolAction
extends IacucProtocolAction {
    private static final String CONFIRM_DELETE_PROTOCOL_FUNDING_SOURCE_KEY = "confirmDeleteProtocolFundingSource";

    @Override
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward actionForward = super.execute(mapping, form, request, response);
        ProtocolFormBase protocolForm = (ProtocolFormBase)form;
        if ("close".equals(protocolForm.getMethodToCall()) || protocolForm.getMethodToCall() == null) {
            return mapping.findForward("portal");
        }
        String correctionMode = request.getParameter("correctionMode");
        if (correctionMode != null && Boolean.parseBoolean(correctionMode)) {
            protocolForm.getProtocolDocument().getProtocol().setCorrectionMode(Boolean.TRUE);
        }
        protocolForm.getProtocolHelper().prepareView();
        return actionForward;
    }

    @Override
    public ActionForward headerTab(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolFormBase protocolform = (ProtocolFormBase)form;
        String command = request.getParameter("command");
        String docId = request.getParameter("docId");
        if (StringUtils.isNotEmpty((CharSequence)command) && command.equals("displayDocSearchView") && StringUtils.isNotEmpty((CharSequence)docId)) {
            Document retrievedDocument = KRADServiceLocatorWeb.getDocumentService().getByDocumentHeaderId(docId);
            protocolform.setDocument(retrievedDocument);
        }
        return super.headerTab(mapping, form, request, response);
    }

    @Override
    protected <T extends BusinessObject> void processMultipleLookupResults(ProtocolDocumentBase protocolDocument, Class<T> lookupResultsBOClass, Collection<T> selectedBOs) {
        if (lookupResultsBOClass.isAssignableFrom(IacucResearchArea.class)) {
            IacucProtocolResearchAreaService service = (IacucProtocolResearchAreaService)KcServiceLocator.getService("iacucProtocolResearchAreaService");
            service.addProtocolResearchArea(protocolDocument.getProtocol(), selectedBOs);
            new IacucProtocolDocumentRule().processProtocolResearchAreaBusinessRules(protocolDocument);
        }
    }

    public ActionForward addProtocolReferenceBean(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        IacucProtocolForm iacucProtocolForm = (IacucProtocolForm)form;
        IacucProtocolReferenceBean iacucProtocolReferenceBean = (IacucProtocolReferenceBean)iacucProtocolForm.getNewProtocolReferenceBean();
        IacucProtocolDocument iacucProtocolDoc = iacucProtocolForm.getIacucProtocolDocument();
        if (this.applyRules(new AddIacucProtocolReferenceEvent("", iacucProtocolDoc, iacucProtocolReferenceBean))) {
            IacucProtocolReferenceType type = (IacucProtocolReferenceType)this.getBusinessObjectService().findBySinglePrimaryKey(IacucProtocolReferenceType.class, (Object)iacucProtocolReferenceBean.getProtocolReferenceTypeCode());
            IacucProtocolReference ref = new IacucProtocolReference(iacucProtocolReferenceBean, iacucProtocolDoc.getIacucProtocol(), type);
            IacucProtocolReferenceService service = KcServiceLocator.getService(IacucProtocolReferenceService.class);
            service.addProtocolReference(iacucProtocolDoc.getIacucProtocol(), ref);
            iacucProtocolForm.setNewProtocolReferenceBean(new IacucProtocolReferenceBean());
        }
        return mapping.findForward("basic");
    }

    public ActionForward deleteProtocolReference(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolFormBase protocolForm = (ProtocolFormBase)form;
        protocolForm.getProtocolDocument().getProtocol().getProtocolReferences().remove(this.getLineToDelete(request));
        return mapping.findForward("basic");
    }

    public ActionForward deleteProtocolResearchArea(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolFormBase protocolForm = (ProtocolFormBase)form;
        protocolForm.getProtocolDocument().getProtocol().getProtocolResearchAreas().remove(this.getLineToDelete(request));
        new IacucProtocolDocumentRule().processProtocolResearchAreaBusinessRules(protocolForm.getProtocolDocument());
        return mapping.findForward("basic");
    }

    public ActionForward addProtocolLocation(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        IacucProtocolForm protocolForm = (IacucProtocolForm)form;
        IacucProtocolLocation newProtocolLocation = (IacucProtocolLocation)protocolForm.getProtocolHelper().getNewProtocolLocation();
        if (this.applyRules(new AddIacucProtocolLocationEvent("", protocolForm.getIacucProtocolDocument(), newProtocolLocation))) {
            this.getProtocolLocationService().addProtocolLocation(protocolForm.getProtocolDocument().getProtocol(), newProtocolLocation);
            protocolForm.getProtocolHelper().setNewProtocolLocation(new IacucProtocolLocation());
        }
        return mapping.findForward("basic");
    }

    public ActionForward deleteProtocolLocation(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolFormBase protocolForm = (ProtocolFormBase)form;
        protocolForm.getProtocolDocument().getProtocol().getProtocolLocations().remove(this.getLineToDelete(request));
        return mapping.findForward("basic");
    }

    public ActionForward clearProtocolLocationAddress(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolFormBase protocolForm = (ProtocolFormBase)form;
        this.getProtocolLocationService().clearProtocolLocationAddress(protocolForm.getProtocolDocument().getProtocol(), this.getSelectedLine(request));
        return mapping.findForward("basic");
    }

    private IacucProtocolLocationService getProtocolLocationService() {
        return (IacucProtocolLocationService)KcServiceLocator.getService("iacucProtocolLocationService");
    }

    public ActionForward addProtocolFundingSource(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolFormBase protocolForm = (ProtocolFormBase)form;
        IacucProtocolDocument protocolDocument = (IacucProtocolDocument)protocolForm.getProtocolDocument();
        IacucProtocolFundingSource fundingSource = (IacucProtocolFundingSource)protocolForm.getProtocolHelper().getNewFundingSource();
        List<ProtocolFundingSourceBase> protocolFundingSources = protocolDocument.getProtocol().getProtocolFundingSources();
        AddIacucProtocolFundingSourceEvent event = new AddIacucProtocolFundingSourceEvent("", (Document)protocolDocument, fundingSource, protocolFundingSources);
        protocolForm.getProtocolHelper().syncFundingSources(protocolDocument.getProtocol());
        if (this.applyRules((DocumentEvent)event)) {
            protocolDocument.getProtocol().getProtocolFundingSources().add(protocolForm.getProtocolHelper().getNewFundingSource());
            protocolForm.getProtocolHelper().setNewFundingSource(new IacucProtocolFundingSource());
        }
        return mapping.findForward("basic");
    }

    public ActionForward deleteProtocolFundingSource(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.confirm(this.buildParameterizedConfirmationQuestion(mapping, form, request, response, CONFIRM_DELETE_PROTOCOL_FUNDING_SOURCE_KEY, "question.protocol.fundingSource.delete.confirmation", new String[0]), CONFIRM_DELETE_PROTOCOL_FUNDING_SOURCE_KEY, "");
    }

    public ActionForward confirmDeleteProtocolFundingSource(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String question = request.getParameter("questionIndex");
        if (CONFIRM_DELETE_PROTOCOL_FUNDING_SOURCE_KEY.equals(question)) {
            ProtocolFormBase protocolForm = (ProtocolFormBase)form;
            ProtocolDocumentBase protocolDocument = protocolForm.getProtocolDocument();
            ProtocolFundingSourceBase protocolFundingSource = protocolDocument.getProtocol().getProtocolFundingSources().remove(this.getLineToDelete(request));
            protocolForm.getProtocolHelper().getDeletedProtocolFundingSources().add(protocolFundingSource);
        }
        return mapping.findForward("basic");
    }

    public ActionForward viewProtocolFundingSource(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        int lineNumber;
        ProtocolFormBase protocolForm = (ProtocolFormBase)form;
        String line = request.getParameter("line");
        try {
            lineNumber = Integer.parseInt(line);
        }
        catch (Exception e) {
            lineNumber = this.getLineToDelete(request);
        }
        ProtocolFundingSourceBase protocolFundingSource = protocolForm.getProtocolDocument().getProtocol().getProtocolFundingSources().get(lineNumber);
        String viewFundingSourceUrl = this.getProtocolFundingSourceService().getViewProtocolFundingSourceUrl(protocolFundingSource, this);
        if (StringUtils.isNotEmpty((CharSequence)viewFundingSourceUrl)) {
            return new ActionForward(viewFundingSourceUrl, true);
        }
        return mapping.findForward("basic");
    }

    @Override
    public String buildForwardUrl(String routeHeaderId) {
        return super.buildForwardUrl(routeHeaderId);
    }

    public ActionForward performFundingSourceLookup(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward returnAction = null;
        ProtocolFormBase protocolForm = (ProtocolFormBase)form;
        String fundingSourceTypeCode = protocolForm.getProtocolHelper().getNewFundingSource().getFundingSourceTypeCode();
        LookupIacucProtocolFundingSourceEvent event = new LookupIacucProtocolFundingSourceEvent("", (IacucProtocolDocument)protocolForm.getDocument(), fundingSourceTypeCode, ProtocolEventBase.ErrorType.HARDERROR);
        if (this.applyRules((DocumentEvent)event)) {
            Map.Entry<String, String> entry = this.getProtocolFundingSourceService().getLookupParameters(fundingSourceTypeCode);
            String boClassName = entry.getKey();
            String fieldConversions = entry.getValue();
            String fullParameter = (String)request.getAttribute("methodToCallAttribute");
            String updatedParameter = this.getProtocolFundingSourceService().updateLookupParameter(fullParameter, boClassName, fieldConversions);
            request.setAttribute("methodToCallAttribute", (Object)updatedParameter);
            returnAction = super.performLookup(mapping, form, request, response);
            protocolForm.getProtocolHelper().setEditProtocolFundingSourceName(false);
        } else {
            returnAction = mapping.findForward("basic");
        }
        return returnAction;
    }

    private IacucProtocolFundingSourceService getProtocolFundingSourceService() {
        return KcServiceLocator.getService(IacucProtocolFundingSourceService.class);
    }

    private IacucProtocolProposalDevelopmentDocumentService getProtocolProposalDevelopmentDocumentService() {
        return KcServiceLocator.getService(IacucProtocolProposalDevelopmentDocumentService.class);
    }

    public ActionForward createProposalDevelopment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        IacucProtocolProposalDevelopmentDocumentService service;
        ProposalDevelopmentDocument proposalDevelopmentDocument;
        ProtocolFormBase protocolForm = (ProtocolFormBase)form;
        ProtocolDocumentBase protocolDocument = protocolForm.getProtocolDocument();
        if (protocolForm.getProtocolHelper().isProtocolProposalDevelopmentLinkingEnabled() && (proposalDevelopmentDocument = (service = this.getProtocolProposalDevelopmentDocumentService()).createProposalDevelopmentDocument(protocolForm)) != null) {
            DevelopmentProposal developmentProposal = proposalDevelopmentDocument.getDevelopmentProposal();
            IacucProtocolFundingSourceServiceImpl protocolFundingSourceServiceImpl = (IacucProtocolFundingSourceServiceImpl)this.getProtocolFundingSourceService();
            IacucProtocolFundingSource proposalProtocolFundingSource = (IacucProtocolFundingSource)protocolFundingSourceServiceImpl.updateProtocolFundingSource("4", developmentProposal.getProposalNumber(), developmentProposal.getSponsorName());
            proposalProtocolFundingSource.setProtocol(protocolDocument.getProtocol());
            List<ProtocolFundingSourceBase> protocolFundingSources = protocolDocument.getProtocol().getProtocolFundingSources();
            AddIacucProtocolFundingSourceEvent event = new AddIacucProtocolFundingSourceEvent("", (Document)protocolDocument, proposalProtocolFundingSource, protocolFundingSources);
            if (this.applyRules((DocumentEvent)event)) {
                protocolDocument.getProtocol().getProtocolFundingSources().add(proposalProtocolFundingSource);
            }
        }
        return mapping.findForward("basic");
    }

    @Override
    public void preSave(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        super.preSave(mapping, form, request, response);
        this.preSaveProtocol(form);
    }

    private void preSaveProtocol(ActionForm form) throws Exception {
        ProtocolFormBase protocolForm = (ProtocolFormBase)form;
        ProtocolDocumentBase protocolDocument = protocolForm.getProtocolDocument();
        List<ProtocolFundingSourceBase> protocolFundingSources = protocolDocument.getProtocol().getProtocolFundingSources();
        List<ProtocolFundingSourceBase> deletedProtocolFundingSources = protocolForm.getProtocolHelper().getDeletedProtocolFundingSources();
        protocolForm.getProtocolHelper().setNewProtocolFundingSources(protocolForm.getProtocolHelper().findNewFundingSources());
        this.setDeletedFundingSource(form);
        protocolForm.getProtocolHelper().prepareRequiredFieldsForSave();
        protocolForm.getProtocolHelper().createInitialProtocolAction();
        if (protocolDocument.getProtocol().isNew() && this.applyRules((DocumentEvent)new SaveIacucProtocolFundingSourceLinkEvent((IacucProtocolDocument)protocolDocument, protocolFundingSources, deletedProtocolFundingSources))) {
            protocolForm.getProtocolHelper().syncSpecialReviewsWithFundingSources();
        }
    }

    private void setDeletedFundingSource(ActionForm form) {
        ProtocolFormBase protocolForm = (ProtocolFormBase)form;
        protocolForm.setDeletedProtocolFundingSources(new ArrayList<ProtocolFundingSourceBase>());
        for (ProtocolFundingSourceBase fundingSource : protocolForm.getProtocolHelper().getDeletedProtocolFundingSources()) {
            if (fundingSource.getProtocolFundingSourceId() == null) continue;
            protocolForm.getDeletedProtocolFundingSources().add(fundingSource);
        }
    }

    @Override
    protected ActionForward saveOnClose(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.preSaveProtocol(form);
        ActionForward forward = super.saveOnClose(mapping, form, request, response);
        if (GlobalVariables.getMessageMap().hasNoErrors()) {
            this.fundingSourceNotification(form);
        }
        return forward;
    }

    @Override
    public void postSave(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        super.postSave(mapping, form, request, response);
        this.fundingSourceNotification(form);
    }

    private void fundingSourceNotification(ActionForm form) {
        IacucProtocolNotificationContext context;
        IacucProtocolFundingSourceNotificationRenderer renderer;
        String fundingType;
        IacucProtocolForm protocolForm = (IacucProtocolForm)form;
        IacucProtocol protocol = (IacucProtocol)protocolForm.getProtocolDocument().getProtocol();
        for (ProtocolFundingSourceBase fundingSource : protocolForm.getProtocolHelper().getNewProtocolFundingSources()) {
            fundingType = "'" + fundingSource.getFundingSourceType().getDescription() + "': " + fundingSource.getFundingSourceNumber();
            renderer = new IacucProtocolFundingSourceNotificationRenderer(protocol, fundingType, "linked to");
            context = new IacucProtocolNotificationContext(protocol, "904", "Funding Source", renderer);
            this.getKcNotificationService().sendNotificationAndPersist(context, new IacucProtocolNotification(), protocol);
        }
        for (ProtocolFundingSourceBase fundingSource : protocolForm.getDeletedProtocolFundingSources()) {
            if (fundingSource.getProtocolFundingSourceId() == null) continue;
            fundingType = "'" + fundingSource.getFundingSourceType().getDescription() + "': " + fundingSource.getFundingSourceNumber();
            renderer = new IacucProtocolFundingSourceNotificationRenderer(protocol, fundingType, "removed from");
            context = new IacucProtocolNotificationContext(protocol, "904", "Funding Source", renderer);
            this.getKcNotificationService().sendNotificationAndPersist(context, new IacucProtocolNotification(), protocol);
        }
    }

    @Override
    public ActionForward customData(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        IacucProtocolForm protocolForm = (IacucProtocolForm)form;
        protocolForm.getCustomDataHelper().prepareCustomData();
        return mapping.findForward("iacucCustomData");
    }

    public ActionForward iacucSpecialReview(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        return super.specialReview(mapping, form, request, response);
    }

    @Override
    public ActionForward speciesAndGroups(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        ((IacucProtocolForm)form).getIacucProtocolSpeciesHelper().prepareView();
        return mapping.findForward("iacucSpeciesAndGroups");
    }

    @Override
    public ActionForward procedures(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        ((IacucProtocolForm)form).getIacucProtocolProceduresHelper().prepareView();
        return mapping.findForward("iacucProtocolProcedures");
    }

    private KcNotificationService getKcNotificationService() {
        return KcServiceLocator.getService(KcNotificationService.class);
    }
}

