/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.irb.actions;

import java.sql.Timestamp;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.committee.impl.service.CommitteeServiceBase;
import org.kuali.coeus.common.questionnaire.framework.answer.AnswerHeader;
import org.kuali.kra.committee.service.CommitteeService;
import org.kuali.kra.irb.Protocol;
import org.kuali.kra.irb.actions.ActionHelper;
import org.kuali.kra.irb.actions.submit.ProtocolSubmission;
import org.kuali.kra.irb.questionnaire.IrbSubmissionQuestionnaireHelper;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.protocol.actions.ProtocolActionBase;
import org.kuali.kra.protocol.questionnaire.ProtocolModuleQuestionnaireBeanBase;
import org.kuali.kra.protocol.questionnaire.ProtocolSubmissionQuestionnaireHelper;

public class ProtocolAction
extends ProtocolActionBase {
    private static final String COMMENT_SUBMITTED_TO_IRB = "Submitted to IRB";
    private static final long serialVersionUID = -2148599171919464303L;

    public ProtocolAction() {
    }

    public ProtocolAction(Protocol protocol, ProtocolSubmission protocolSubmission, String protocolActionTypeCode, Timestamp actionDate) {
        super(protocol, protocolSubmission, protocolActionTypeCode, actionDate);
    }

    public ProtocolAction(Protocol protocol, ProtocolSubmission protocolSubmission, String protocolActionTypeCode) {
        super(protocol, protocolSubmission, protocolActionTypeCode);
    }

    public ProtocolAction(Protocol protocol, String protocolActionTypeCode) {
        super(protocol, protocolActionTypeCode);
    }

    public void setQuestionnairePrintOptionFromHelper(ActionHelper actionHelper) {
        if (this.getSubmissionNumber() != null && !"101".equals(this.getProtocolActionTypeCode())) {
            if (this.getQuestionnaireHelper().getAnswerHeaders().isEmpty()) {
                this.setQuestionnairePrintOption(this.getQnPrintOptionForAction(this.getProtocolNumber(), this.getSubmissionNumber().toString(), "2"));
            }
        } else if ("101".equals(this.getProtocolActionTypeCode()) && COMMENT_SUBMITTED_TO_IRB.equals(this.getComments())) {
            if (this.getProtocol().isAmendment() || this.getProtocol().isRenewal()) {
                this.setQuestionnairePrintOption(this.getQnPrintOptionForAction(this.getProtocolNumber(), this.getSequenceNumber().toString(), "1"));
            } else {
                this.setQuestionnairePrintOption(this.getQnPrintOptionForAction(this.getProtocolNumber(), this.getInitialSequence(this, ""), "0"));
            }
        } else if ("101".equals(this.getProtocolActionTypeCode()) && StringUtils.isNotBlank((CharSequence)this.getComments()) && (this.getComments().startsWith(COMMENT_PREFIX_AMMENDMENT) || this.getComments().startsWith(COMMENT_PREFIX_RENEWAL) || this.getComments().startsWith(COMMENT_PREFIX_FYI))) {
            String amendmentRenewalNumber = this.getAmendmentRenewalNumber(this.getComments());
            this.setQuestionnairePrintOption(this.getQnPrintOptionForAction(this.getProtocolNumber() + amendmentRenewalNumber, this.getInitialSequence(this, amendmentRenewalNumber), "1"));
        }
    }

    private String getInitialSequence(ProtocolAction protocolAction, String amendmentRenewalNumber) {
        HashMap<String, Object> fieldValues = new HashMap<String, Object>();
        fieldValues.put("protocolNumber", protocolAction.getProtocolNumber() + amendmentRenewalNumber);
        if (StringUtils.isBlank((CharSequence)amendmentRenewalNumber)) {
            fieldValues.put("actionId", protocolAction.getActionId().toString());
        } else {
            fieldValues.put("submissionNumber", protocolAction.getSubmissionNumber().toString());
        }
        fieldValues.put("protocolActionTypeCode", "101");
        return ((ProtocolAction)((List)this.getBusinessObjectService().findMatchingOrderBy(ProtocolAction.class, fieldValues, "protocolActionId", true)).get(0)).getProtocol().getSequenceNumber().toString();
    }

    @Override
    protected Class<? extends CommitteeServiceBase> getCommitteeServiceClassHook() {
        return CommitteeService.class;
    }

    @Override
    protected String getCoeusModule() {
        return "7";
    }

    @Override
    protected ProtocolSubmissionQuestionnaireHelper getProtocolSubmissionQuestionnaireHelperHook(ProtocolBase protocol, String actionTypeCode, String submissionNumber) {
        return new IrbSubmissionQuestionnaireHelper(protocol, actionTypeCode, submissionNumber, true);
    }

    @Override
    public ProtocolSubmissionQuestionnaireHelper getQuestionnaireHelper() {
        IrbSubmissionQuestionnaireHelper questionnaireHelper = (IrbSubmissionQuestionnaireHelper)super.getQuestionnaireHelper();
        if (StringUtils.equals((CharSequence)this.getProtocolActionTypeCode(), (CharSequence)"101")) {
            ProtocolModuleQuestionnaireBeanBase protocolBaseQnBean = questionnaireHelper.getBaseProtocolModuleQuestionnaireBean(this.getSequenceNumber() == null ? null : this.getSequenceNumber().toString());
            List<AnswerHeader> protocolAnswerHeaders = questionnaireHelper.getQuestionnaireAnswerService().getQuestionnaireAnswer(protocolBaseQnBean);
            List<AnswerHeader> submissionAnswerHeaders = questionnaireHelper.getAnswerHeaders();
            submissionAnswerHeaders.addAll(protocolAnswerHeaders);
            questionnaireHelper.setAnswerHeaders(submissionAnswerHeaders);
            questionnaireHelper.resetHeaderLabels();
        }
        return questionnaireHelper;
    }
}

