/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.subaward.service.impl;

import java.util.Collection;
import org.kuali.coeus.common.impl.krms.KcKrmsJavaFunctionTermServiceBase;
import org.kuali.coeus.sys.api.model.AbstractDecimal;
import org.kuali.coeus.sys.api.model.ScaleTwoDecimal;
import org.kuali.kra.award.document.AwardDocument;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.subaward.bo.SubAward;
import org.kuali.kra.subaward.bo.SubAwardAmountInfo;
import org.kuali.kra.subaward.bo.SubAwardFundingSource;
import org.kuali.kra.subaward.service.SubAwardJavaFunctionKrmsTermService;

public class SubAwardJavaFunctionKrmsTermServiceImpl
extends KcKrmsJavaFunctionTermServiceBase
implements SubAwardJavaFunctionKrmsTermService {
    @Override
    public Boolean ffataCrosscheck(SubAward subAward, Double obligatedAmountGreaterThan) {
        Boolean foundFederalSponsorInFundingSources = subAward.getSubAwardFundingSourceList().stream().map(SubAwardFundingSource::getActiveAward).anyMatch(this::hasFederalSponsorCode);
        return subAward.getFfataRequired() == false && subAward.getTotalObligatedAmount().isGreaterThan((AbstractDecimal)new ScaleTwoDecimal(obligatedAmountGreaterThan.doubleValue())) && foundFederalSponsorInFundingSources != false;
    }

    private Boolean hasFederalSponsorCode(Award award) {
        Collection federalSponsorTypes = this.getParameterService().getParameterValuesAsString(AwardDocument.class, "FEDERAL_SPONSOR_TYPE_CODE");
        return federalSponsorTypes.contains(award.getSponsor().getSponsorTypeCode()) || award.getPrimeSponsor() != null && federalSponsorTypes.contains(award.getPrimeSponsor().getSponsorTypeCode());
    }

    @Override
    public Boolean purchaseOrderOnActiveEntryIsNotNull(SubAward subAward) {
        SubAwardAmountInfo latestSubAwardAmountInfo = subAward.getLatestSubAwardAmountInfo();
        return latestSubAwardAmountInfo != null && latestSubAwardAmountInfo.getPurchaseOrderNum() != null;
    }
}

