/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.budget.impl.distribution;

import java.util.Iterator;
import org.kuali.coeus.common.budget.framework.core.Budget;
import org.kuali.coeus.common.budget.framework.distribution.BudgetCostShare;
import org.kuali.coeus.common.budget.impl.distribution.AddBudgetCostShareEvent;
import org.kuali.coeus.common.framework.costshare.CostShareRuleResearchDocumentBase;
import org.kuali.coeus.common.framework.ruleengine.KcBusinessRule;
import org.kuali.coeus.common.framework.ruleengine.KcEventMethod;
import org.kuali.rice.krad.util.GlobalVariables;

@KcBusinessRule(value="budgetCostShareRule")
public class BudgetCostShareRule
extends CostShareRuleResearchDocumentBase {
    private static final String ADD_ERROR_KEY = "error.custom";

    @KcEventMethod
    public boolean processAddBudgetCostShareBusinessRules(AddBudgetCostShareEvent budgetCostShareEvent) {
        boolean retVal = !this.areDuplicatesPresent(budgetCostShareEvent.getBudget(), budgetCostShareEvent.getBudgetCostShare());
        retVal &= this.validateProjectPeriod(budgetCostShareEvent);
        return retVal &= this.validateUnit(budgetCostShareEvent.getBudgetCostShare().getUnitNumber(), "newBudgetCostShare.unitNumber");
    }

    protected boolean areDuplicatesPresent(Budget budget, BudgetCostShare testBudgetCostShare) {
        BudgetCostShare budgetCostShare;
        if (testBudgetCostShare == null) {
            return false;
        }
        boolean duplicate = false;
        Iterator<BudgetCostShare> iterator = budget.getBudgetCostShares().iterator();
        while (iterator.hasNext() && !(duplicate = this.checkForDuplicateFields(testBudgetCostShare, budgetCostShare = iterator.next()))) {
        }
        return duplicate;
    }

    private boolean checkForDuplicateFields(BudgetCostShare testBudgetCostShare, BudgetCostShare budgetCostShare) {
        boolean duplicate = testBudgetCostShare.equals(budgetCostShare);
        if (duplicate) {
            GlobalVariables.getMessageMap().putError("newCostShare.*", ADD_ERROR_KEY, new String[]{"A Cost Share with the same Fiscal Year, Source Account and Amount exists in the table"});
        }
        return duplicate;
    }

    private boolean validateProjectPeriod(AddBudgetCostShareEvent budgetCostShareEvent) {
        String projectPeriodField = "newBudgetCostShare.projectPeriod";
        int numberOfProjectPeriods = budgetCostShareEvent.getBudget().getBudgetPeriods().size();
        return this.validateProjectPeriod(budgetCostShareEvent.getBudgetCostShare().getProjectPeriod(), projectPeriodField, numberOfProjectPeriods);
    }
}

