/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.budget.impl.struts;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.coeus.common.budget.framework.core.Budget;
import org.kuali.coeus.common.budget.framework.core.BudgetForm;
import org.kuali.coeus.common.budget.framework.distribution.BudgetCostShare;
import org.kuali.coeus.common.budget.framework.distribution.BudgetDistributionService;
import org.kuali.coeus.common.budget.framework.distribution.BudgetUnrecoveredFandA;
import org.kuali.coeus.common.budget.framework.income.AddBudgetProjectIncomeEvent;
import org.kuali.coeus.common.budget.framework.income.BudgetProjectIncome;
import org.kuali.coeus.common.budget.impl.distribution.AddBudgetCostShareEvent;
import org.kuali.coeus.common.budget.impl.distribution.AddBudgetUnrecoveredFandAEvent;
import org.kuali.coeus.common.budget.impl.struts.BudgetAction;
import org.kuali.coeus.sys.api.model.ScaleTwoDecimal;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.award.budget.AwardBudgetExt;
import org.kuali.kra.award.budget.document.AwardBudgetDocument;
import org.kuali.rice.krad.service.KualiRuleService;

public class BudgetDistributionAndIncomeAction
extends BudgetAction {
    private static final Logger LOG = LogManager.getLogger(BudgetDistributionAndIncomeAction.class);
    private BudgetDistributionService bdiService = KcServiceLocator.getService(BudgetDistributionService.class);

    @Override
    public ActionForward reload(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = super.reload(mapping, form, request, response);
        AwardBudgetExt budget = ((BudgetForm)form).getBudgetDocument().getBudget();
        this.bdiService.initializeCollectionDefaults(budget);
        return forward;
    }

    public ActionForward addCostShare(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BudgetForm budgetForm = (BudgetForm)form;
        AwardBudgetExt budget = budgetForm.getBudgetDocument().getBudget();
        BudgetCostShare budgetCostShare = budgetForm.getNewBudgetCostShare();
        boolean passed = this.getKcBusinessRulesEngine().applyRules(new AddBudgetCostShareEvent(budget, budgetCostShare));
        if (passed) {
            this.setCostShareAddRowDefaults(budget, budgetCostShare);
            budget.add(budgetCostShare);
            budgetForm.setNewBudgetCostShare(new BudgetCostShare());
            LOG.debug("Added new BudgetCostShare: " + budgetCostShare);
        }
        return mapping.findForward("basic");
    }

    public ActionForward addProjectIncome(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BudgetForm budgetForm = (BudgetForm)form;
        BudgetProjectIncome budgetProjectIncome = budgetForm.getNewBudgetProjectIncome();
        boolean passed = this.getKcBusinessRulesEngine().applyRules(this.createRuleEvent(budgetForm, budgetProjectIncome));
        if (passed) {
            budgetForm.getBudgetDocument().getBudget().add(budgetProjectIncome);
            budgetForm.setNewBudgetProjectIncome(new BudgetProjectIncome());
            LOG.debug("Added new BudgetProjectIncome: " + budgetProjectIncome);
        }
        return mapping.findForward("basic");
    }

    public ActionForward addUnrecoveredFandA(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BudgetForm budgetForm = (BudgetForm)form;
        AwardBudgetDocument budgetDocument = budgetForm.getBudgetDocument();
        BudgetUnrecoveredFandA budgetUnrecoveredFandA = budgetForm.getNewBudgetUnrecoveredFandA();
        boolean passed = this.getKcBusinessRulesEngine().applyRules(this.createRuleEvent(budgetForm, budgetUnrecoveredFandA));
        if (passed) {
            this.setUnrecoveredFandAAddRowDefaults(budgetDocument, budgetUnrecoveredFandA);
            budgetForm.getBudgetDocument().getBudget().add(budgetUnrecoveredFandA);
            budgetForm.setNewBudgetUnrecoveredFandA(new BudgetUnrecoveredFandA());
            LOG.debug("Added new BudgetCostShare: " + budgetUnrecoveredFandA);
        }
        return mapping.findForward("basic");
    }

    public ActionForward deleteCostShare(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ((BudgetForm)form).getBudgetDocument().getBudget().removeBudgetCostShare(this.getLineToDelete(request));
        return mapping.findForward("basic");
    }

    public ActionForward deleteProjectIncome(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ((BudgetForm)form).getBudgetDocument().getBudget().removeBudgetProjectIncome(this.getLineToDelete(request));
        return mapping.findForward("basic");
    }

    public ActionForward deleteUnrecoveredFandA(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ((BudgetForm)form).getBudgetDocument().getBudget().removeBudgetUnrecoveredFandA(this.getLineToDelete(request));
        return mapping.findForward("basic");
    }

    public ActionForward refreshTotals(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return mapping.findForward("basic");
    }

    public ActionForward resetCostSharingToDefault(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AwardBudgetExt budget = this.getDocument(form).getBudget();
        budget.getBudgetCostShares().clear();
        this.bdiService.initializeCostSharingCollectionDefaults(budget);
        return mapping.findForward("basic");
    }

    public ActionForward resetUnrecoveredFandAToDefault(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AwardBudgetExt budget = this.getDocument(form).getBudget();
        budget.getBudgetUnrecoveredFandAs().clear();
        this.bdiService.initializeUnrecoveredFandACollectionDefaults(budget);
        return mapping.findForward("basic");
    }

    protected KualiRuleService getKualiRuleService() {
        return KcServiceLocator.getService(KualiRuleService.class);
    }

    private AddBudgetProjectIncomeEvent createRuleEvent(BudgetForm budgetForm, BudgetProjectIncome budgetProjectIncome) {
        return new AddBudgetProjectIncomeEvent(budgetForm.getBudget(), budgetProjectIncome);
    }

    private AddBudgetUnrecoveredFandAEvent createRuleEvent(BudgetForm budgetForm, BudgetUnrecoveredFandA budgetUnrecoveredFandA) {
        return new AddBudgetUnrecoveredFandAEvent(budgetForm.getBudget(), budgetUnrecoveredFandA);
    }

    private AwardBudgetDocument getDocument(ActionForm form) {
        BudgetForm budgetForm = (BudgetForm)form;
        AwardBudgetDocument budgetDocument = budgetForm.getBudgetDocument();
        return budgetDocument;
    }

    private void setCostShareAddRowDefaults(Budget budget, BudgetCostShare budgetCostShare) {
        ScaleTwoDecimal defaultValue = ScaleTwoDecimal.ZERO;
        if (budgetCostShare.getProjectPeriod() == null) {
            budgetCostShare.setProjectPeriod(0);
        }
        if (budgetCostShare.getShareAmount() == null) {
            ScaleTwoDecimal shareAmount = budgetCostShare.getProjectPeriod() == 0 ? defaultValue : budget.findCostSharingForFiscalYear(budgetCostShare.getProjectPeriod());
            budgetCostShare.setShareAmount(shareAmount);
        }
        if (budgetCostShare.getSharePercentage() == null) {
            budgetCostShare.setSharePercentage(defaultValue);
        }
    }

    private void setUnrecoveredFandAAddRowDefaults(AwardBudgetDocument budgetDocument, BudgetUnrecoveredFandA budgetUnrecoveredFandA) {
        if (budgetUnrecoveredFandA.getFiscalYear() == null) {
            budgetUnrecoveredFandA.setFiscalYear(0);
        }
        if (budgetUnrecoveredFandA.getAmount() == null) {
            ScaleTwoDecimal shareAmount = budgetUnrecoveredFandA.getFiscalYear() == 0 ? ScaleTwoDecimal.ZERO : budgetDocument.getBudget().findUnrecoveredFandAForFiscalYear(budgetUnrecoveredFandA.getFiscalYear());
            budgetUnrecoveredFandA.setAmount(shareAmount);
        }
        if (budgetUnrecoveredFandA.getApplicableRate() == null) {
            budgetUnrecoveredFandA.setApplicableRate(ScaleTwoDecimal.ZERO);
        }
    }
}

