/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.s2s.override;

import java.sql.Date;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.framework.person.KcPerson;
import org.kuali.coeus.common.framework.person.KcPersonService;
import org.kuali.coeus.propdev.api.s2s.override.S2sOverrideContract;
import org.kuali.coeus.propdev.impl.core.DevelopmentProposal;
import org.kuali.coeus.propdev.impl.s2s.override.S2sOverrideApplicationData;
import org.kuali.coeus.sys.framework.model.KcPersistableBusinessObjectBase;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.rice.core.api.mo.common.Identifiable;
import org.kuali.rice.core.api.mo.common.active.MutableInactivatable;
import org.kuali.rice.krad.data.jpa.PortableSequenceGenerator;
import org.kuali.rice.krad.data.jpa.converters.BooleanYNConverter;

@Entity
@Table(name="S2S_OVERRIDE")
public class S2sOverride
extends KcPersistableBusinessObjectBase
implements S2sOverrideContract,
Identifiable,
MutableInactivatable {
    @PortableSequenceGenerator(name="SEQ_S2S_OVERRIDE_ID")
    @GeneratedValue(generator="SEQ_S2S_OVERRIDE_ID")
    @Id
    @Column(name="ID")
    private String id;
    @Column(name="DESCRIPTION")
    private String description;
    @Column(name="SIGNED_BY")
    private String signedBy;
    @Column(name="SUBMITTED_DATE")
    private Date submittedDate;
    @Column(name="ACTIVE")
    @Convert(converter=BooleanYNConverter.class)
    private boolean active;
    @OneToOne(cascade={CascadeType.REFRESH})
    @JoinColumn(name="PROPOSAL_NUMBER")
    private DevelopmentProposal developmentProposal;
    @OneToOne(orphanRemoval=true, cascade={CascadeType.ALL})
    @JoinColumn(name="S2S_APPL_DATA_ID", referencedColumnName="ID")
    private S2sOverrideApplicationData application;
    @OneToOne(orphanRemoval=true, cascade={CascadeType.ALL})
    @JoinColumn(name="S2S_APPL_DATA_OVERRIDE_ID", referencedColumnName="ID")
    private S2sOverrideApplicationData applicationOverride;
    @Transient
    private transient KcPerson signedByPerson;
    @Transient
    private transient KcPersonService kcPersonService;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public DevelopmentProposal getDevelopmentProposal() {
        return this.developmentProposal;
    }

    public void setDevelopmentProposal(DevelopmentProposal developmentProposal) {
        this.developmentProposal = developmentProposal;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getSignedBy() {
        return this.signedBy;
    }

    public void setSignedBy(String signedBy) {
        this.signedBy = signedBy;
    }

    public KcPerson getSignedByPerson() {
        if (StringUtils.isNotBlank((CharSequence)this.signedBy) && (this.signedByPerson == null || !this.signedBy.equals(this.signedByPerson.getUserName()))) {
            this.setSignedByPerson(this.getKcPersonService().getKcPersonByUserName(this.signedBy));
        } else if (StringUtils.isBlank((CharSequence)this.signedBy) && this.signedByPerson != null) {
            this.setSignedByPerson(null);
        }
        return this.signedByPerson;
    }

    public void setSignedByPerson(KcPerson signedByPerson) {
        this.signedByPerson = signedByPerson;
    }

    public Date getSubmittedDate() {
        return this.submittedDate;
    }

    public void setSubmittedDate(Date submittedDate) {
        this.submittedDate = submittedDate;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public S2sOverrideApplicationData getApplication() {
        return this.application;
    }

    public void setApplication(S2sOverrideApplicationData application) {
        this.application = application;
    }

    public S2sOverrideApplicationData getApplicationOverride() {
        return this.applicationOverride;
    }

    public void setApplicationOverride(S2sOverrideApplicationData applicationOverride) {
        this.applicationOverride = applicationOverride;
    }

    public KcPersonService getKcPersonService() {
        if (this.kcPersonService == null) {
            this.kcPersonService = KcServiceLocator.getService(KcPersonService.class);
        }
        return this.kcPersonService;
    }

    public void setKcPersonService(KcPersonService kcPersonService) {
        this.kcPersonService = kcPersonService;
    }
}

