/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.sys.impl.mq;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import java.io.IOException;
import java.io.Serializable;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import org.apache.activemq.openwire.OpenWireFormat;
import org.apache.activemq.util.ByteSequence;
import org.apache.activemq.wireformat.WireFormat;
import org.kuali.rice.krad.bo.PersistableBusinessObjectBase;

public class ActiveMqMessage
extends PersistableBusinessObjectBase {
    private static final WireFormat WIRE_FORMAT = new OpenWireFormat();
    private Long id;
    private String container;
    private String messageIdProducer;
    private Long messageIdSequence;
    private Long expiration;
    private byte[] message;
    private Long priority;
    private String xid;
    private transient Class<? extends Serializable> type;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getContainer() {
        return this.container;
    }

    public String getCurrentQueueName() {
        return this.getContainer().replaceFirst("queue://", "");
    }

    public String getOriginalQueueName() {
        return this.getCurrentQueueName().replaceFirst("DLQ.", "");
    }

    public void setContainer(String container) {
        this.container = container;
    }

    public String getMessageIdProducer() {
        return this.messageIdProducer;
    }

    public void setMessageIdProducer(String messageIdProducer) {
        this.messageIdProducer = messageIdProducer;
    }

    public Long getMessageIdSequence() {
        return this.messageIdSequence;
    }

    public void setMessageIdSequence(Long messageIdSequence) {
        this.messageIdSequence = messageIdSequence;
    }

    public Long getExpiration() {
        return this.expiration;
    }

    public void setExpiration(Long expiration) {
        this.expiration = expiration;
    }

    public byte[] getMessage() {
        return this.message;
    }

    public void setMessage(byte[] message) {
        this.message = message;
    }

    public Message getJmsMessage() {
        byte[] msg = this.getMessage();
        if (msg != null) {
            try {
                return (Message)WIRE_FORMAT.unmarshal(new ByteSequence(msg));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    public String getMessageJson() {
        byte[] msg = this.getMessage();
        if (msg != null) {
            try {
                Object oMessage = WIRE_FORMAT.unmarshal(new ByteSequence(msg));
                if (oMessage instanceof ObjectMessage) {
                    Serializable o = ((ObjectMessage)oMessage).getObject();
                    ObjectWriter writer = new ObjectMapper().writerWithDefaultPrettyPrinter();
                    return writer.writeValueAsString((Object)o);
                }
            }
            catch (IOException | JMSException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    public void setMessageJson(String messageJson) {
        if (messageJson != null) {
            try {
                Serializable o = (Serializable)new ObjectMapper().readValue(messageJson, this.getType());
                byte[] msg = this.getMessage();
                Object oMessage = WIRE_FORMAT.unmarshal(new ByteSequence(msg));
                if (oMessage instanceof ObjectMessage) {
                    ((ObjectMessage)oMessage).setObject(o);
                }
                this.setMessage(WIRE_FORMAT.marshal(oMessage).getData());
            }
            catch (IOException | JMSException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private Class<? extends Serializable> getType() {
        byte[] msg = this.getMessage();
        if (msg != null && this.type == null) {
            try {
                Object oMessage = WIRE_FORMAT.unmarshal(new ByteSequence(msg));
                if (oMessage instanceof ObjectMessage) {
                    this.type = ((ObjectMessage)oMessage).getObject().getClass();
                }
            }
            catch (IOException | JMSException e) {
                throw new RuntimeException(e);
            }
        }
        return this.type;
    }

    public Long getPriority() {
        return this.priority;
    }

    public void setPriority(Long priority) {
        this.priority = priority;
    }

    public String getXid() {
        return this.xid;
    }

    public void setXid(String xid) {
        this.xid = xid;
    }
}

