/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.irb.actions.genericactions;

import org.kuali.kra.irb.Protocol;
import org.kuali.kra.irb.ProtocolDocument;
import org.kuali.kra.irb.actions.ProtocolAction;
import org.kuali.kra.irb.actions.genericactions.ProtocolGenericActionBean;
import org.kuali.kra.irb.actions.genericactions.ProtocolGenericActionService;
import org.kuali.kra.irb.actions.genericactions.ProtocolGenericCorrespondence;
import org.kuali.kra.irb.actions.submit.ProtocolSubmission;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.protocol.actions.ProtocolActionBase;
import org.kuali.kra.protocol.actions.correspondence.ProtocolActionsCorrespondenceBase;
import org.kuali.kra.protocol.actions.genericactions.ProtocolGenericActionServiceImplBase;
import org.kuali.kra.protocol.actions.submit.ProtocolSubmissionBase;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.krad.document.Document;

public class ProtocolGenericActionServiceImpl
extends ProtocolGenericActionServiceImplBase
implements ProtocolGenericActionService {
    @Override
    public void close(Protocol protocol, ProtocolGenericActionBean actionBean) throws Exception {
        if ("105".equals(protocol.getLastProtocolAction().getProtocolActionType().getProtocolActionTypeCode())) {
            this.performGenericAction(protocol, actionBean, "300", "301");
        } else {
            this.performGenericAction(protocol, actionBean, "300", "300");
        }
    }

    @Override
    public void closeEnrollment(Protocol protocol, ProtocolGenericActionBean actionBean) throws Exception {
        this.performGenericAction(protocol, actionBean, "207", "201");
    }

    @Override
    public void defer(Protocol protocol, ProtocolGenericActionBean actionBean) throws Exception {
        this.performGenericAction(protocol, actionBean, "201", "103");
    }

    @Override
    public void disapprove(ProtocolBase protocol, org.kuali.kra.protocol.actions.genericactions.ProtocolGenericActionBean actionBean) throws Exception {
        this.performGenericAction(protocol, actionBean, "304", "306");
        this.performDisapprove(protocol);
    }

    @Override
    public void expire(ProtocolBase protocol, org.kuali.kra.protocol.actions.genericactions.ProtocolGenericActionBean actionBean) throws Exception {
        this.performGenericAction(protocol, actionBean, "305", "305");
    }

    @Override
    public void irbAcknowledgement(Protocol protocol, ProtocolGenericActionBean actionBean) throws Exception {
        this.performGenericAction(protocol, actionBean, "209");
    }

    @Override
    public void permitDataAnalysis(Protocol protocol, ProtocolGenericActionBean actionBean) throws Exception {
        this.performGenericAction(protocol, actionBean, "211", "202");
    }

    @Override
    public void reopenEnrollment(Protocol protocol, ProtocolGenericActionBean actionBean) throws Exception {
        this.performGenericAction(protocol, actionBean, "212", "200");
    }

    @Override
    public ProtocolDocument returnForSMR(ProtocolBase protocol, org.kuali.kra.protocol.actions.genericactions.ProtocolGenericActionBean actionBean) throws Exception {
        this.performGenericAction(protocol, actionBean, "203", "102");
        return this.getReturnedVersionedDocument(protocol);
    }

    @Override
    public ProtocolDocument returnForSRR(ProtocolBase protocol, org.kuali.kra.protocol.actions.genericactions.ProtocolGenericActionBean actionBean) throws Exception {
        this.performGenericAction(protocol, actionBean, "202", "104");
        return this.getReturnedVersionedDocument(protocol);
    }

    @Override
    public ProtocolDocument returnToPI(ProtocolBase protocol, org.kuali.kra.protocol.actions.genericactions.ProtocolGenericActionBean actionBean) throws Exception {
        this.performGenericAction(protocol, actionBean, "213", "107");
        return this.getReturnedVersionedDocument(protocol);
    }

    @Override
    public void suspend(ProtocolBase protocol, org.kuali.kra.protocol.actions.genericactions.ProtocolGenericActionBean actionBean) throws Exception {
        if ("106".equals(protocol.getLastProtocolAction().getProtocolActionType().getProtocolActionTypeCode())) {
            this.performGenericAction(protocol, actionBean, "302", "302");
        } else {
            this.performGenericAction(protocol, actionBean, "302", "308");
        }
    }

    @Override
    public void suspendByDsmb(Protocol protocol, ProtocolGenericActionBean actionBean) throws Exception {
        this.performGenericAction(protocol, actionBean, "306", "311");
    }

    @Override
    public void terminate(ProtocolBase protocol, org.kuali.kra.protocol.actions.genericactions.ProtocolGenericActionBean actionBean) throws Exception {
        this.performGenericAction(protocol, actionBean, "301", "307");
    }

    private void performGenericAction(Protocol protocol, ProtocolGenericActionBean actionBean, String protocolActionType) throws Exception {
        ProtocolAction protocolAction = (ProtocolAction)this.createProtocolActionAndAttach(protocol, actionBean, protocolActionType);
        if (protocol.getNotifyIrbSubmissionId() == null) {
            this.getProtocolActionService().updateProtocolStatus(protocolAction, protocol);
        } else {
            for (ProtocolSubmissionBase submission : protocol.getProtocolSubmissions()) {
                if (!submission.getSubmissionId().equals(protocol.getNotifyIrbSubmissionId())) continue;
                submission.setSubmissionStatusCode("212");
            }
        }
        protocol.refreshReferenceObject("protocolStatus");
        protocol.refreshReferenceObject("protocolSubmission");
        this.getDocumentService().saveDocument((Document)protocol.getProtocolDocument());
    }

    @Override
    protected ProtocolActionBase getNewProtocolActionInstanceHook(ProtocolBase protocol, ProtocolSubmissionBase submission, String protocolActionType) {
        return new ProtocolAction((Protocol)protocol, (ProtocolSubmission)submission, protocolActionType);
    }

    @Override
    protected ProtocolActionsCorrespondenceBase getNewProtocolActionsCorrespondenceHook(String protocolActionType) {
        return new ProtocolGenericCorrespondence(protocolActionType);
    }

    @Override
    protected void performDisapprove(ProtocolBase protocol) throws Exception {
        WorkflowDocument currentWorkflowDocument;
        if (protocol.getProtocolDocument() != null && (currentWorkflowDocument = protocol.getProtocolDocument().getDocumentHeader().getWorkflowDocument()) != null) {
            currentWorkflowDocument.disapprove("Protocol document disapproved after committee decision");
        }
        this.getProtocolOnlineReviewService().cancelOnlineReviews(protocol.getProtocolSubmission(), "Protocol Review cancelled - protocol has been disapproved.");
    }

    @Override
    public ProtocolDocument getDeferredVersionedDocument(Protocol protocol) throws Exception {
        this.getDocumentService().cancelDocument((Document)protocol.getProtocolDocument(), "Protocol document cancelled - protocol has been deferred.");
        this.getProtocolOnlineReviewService().cancelOnlineReviews(protocol.getProtocolSubmission(), "Protocol Review cancelled - protocol has been deferred.");
        ProtocolDocument newDocument = (ProtocolDocument)this.getVersionedDocument(protocol);
        this.setReferencesForProtocolCorrespondence(newDocument);
        ProtocolAction assignToAgendaProtocolAction = (ProtocolAction)this.getProtocolAssignToAgendaService().getAssignedToAgendaProtocolAction(newDocument.getProtocol());
        if (assignToAgendaProtocolAction != null) {
            newDocument.getProtocol().getProtocolActions().remove(assignToAgendaProtocolAction);
            this.getBusinessObjectService().delete((Object)assignToAgendaProtocolAction);
        }
        newDocument.getProtocol().refreshReferenceObject("protocolStatus");
        this.getDocumentService().saveDocument((Document)newDocument);
        return newDocument;
    }

    protected void setReferencesForProtocolCorrespondence(ProtocolDocument newDocument) {
        Protocol newProtocol = newDocument.getProtocol();
        newProtocol.getProtocolActions().forEach(protocolAction -> {
            protocolAction.setSequenceNumber(newProtocol.getSequenceNumber());
            protocolAction.getProtocolCorrespondences().forEach(protocolCorrespondence -> {
                protocolCorrespondence.setProtocolId(newProtocol.getProtocolId());
                protocolCorrespondence.setSequenceNumber(newProtocol.getSequenceNumber());
            });
        });
    }

    @Override
    protected ProtocolDocument getReturnedVersionedDocument(ProtocolBase protocol) throws Exception {
        this.getDocumentService().cancelDocument((Document)protocol.getProtocolDocument(), "Protocol document cancelled - protocol has been returned for revisions.");
        this.getProtocolOnlineReviewService().finalizeOnlineReviews(protocol.getProtocolSubmission(), "Protocol Review finalized - protocol has been returned for revisions.");
        return (ProtocolDocument)this.getVersionedDocument(protocol);
    }

    @Override
    protected String getProtocolPendingInProgressStatusCodeHook() {
        return "100";
    }

    @Override
    protected String getProtocolSubmissionStatusRejectedInRoutingCodeHook() {
        return "405";
    }

    @Override
    protected ProtocolActionBase getNewDisapprovedInRoutingProtocolActionInstanceHook(ProtocolBase protocol) {
        return new ProtocolAction((Protocol)protocol, null, "404");
    }

    @Override
    protected String getDisapprovedProtocolStatusCodeHook() {
        return "306";
    }

    @Override
    protected String getRecallProtocolActionTypeCodeHook() {
        return "405";
    }
}

