/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.protocol.summary;

import java.io.Serializable;
import java.sql.Date;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kra.protocol.specialreview.ProtocolSpecialReviewExemption;
import org.kuali.kra.protocol.summary.ProtocolSummary;

public class SpecialReviewSummary
implements Serializable {
    private static final long serialVersionUID = -8047038042526446451L;
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("MM/dd/yyyy");
    private String type;
    private String approvalStatus;
    private String protocolNumber;
    private String applicationDate;
    private String approvalDate;
    private String expirationDate;
    private String exemptionNumbers;
    private String comment;
    private boolean typeChanged;
    private boolean approvalStatusChanged;
    private boolean protocolNumberChanged;
    private boolean applicationDateChanged;
    private boolean approvalDateChanged;
    private boolean expirationDateChanged;
    private boolean exemptionNumbersChanged;
    private boolean commentChanged;

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getApprovalStatus() {
        return this.approvalStatus;
    }

    public void setApprovalStatus(String approvalStatus) {
        this.approvalStatus = approvalStatus;
    }

    public String getProtocolNumber() {
        return this.protocolNumber;
    }

    public void setProtocolNumber(String protocolNumber) {
        this.protocolNumber = protocolNumber;
    }

    public String getApplicationDate() {
        return this.applicationDate;
    }

    public void setApplicationDate(Date applicationDate) {
        this.applicationDate = this.formatDate(applicationDate);
    }

    public String getApprovalDate() {
        return this.approvalDate;
    }

    public void setApprovalDate(Date approvalDate) {
        this.approvalDate = this.formatDate(approvalDate);
    }

    public String getExpirationDate() {
        return this.expirationDate;
    }

    public void setExpirationDate(Date expirationDate) {
        this.expirationDate = this.formatDate(expirationDate);
    }

    public String getExemptionNumbers() {
        return this.exemptionNumbers;
    }

    public void setExemptionNumbers(List<ProtocolSpecialReviewExemption> exemptions) {
        this.exemptionNumbers = "";
        Collections.sort(exemptions, new Comparator<ProtocolSpecialReviewExemption>(){

            @Override
            public int compare(ProtocolSpecialReviewExemption e1, ProtocolSpecialReviewExemption e2) {
                if (e1.getExemptionType() == null) {
                    e1.refreshReferenceObject("exemptionType");
                }
                if (e2.getExemptionType() == null) {
                    e2.refreshReferenceObject("exemptionType");
                }
                return e1.getExemptionType().getDescription().compareTo(e2.getExemptionType().getDescription());
            }
        });
        for (ProtocolSpecialReviewExemption exemption : exemptions) {
            if (!StringUtils.isBlank((CharSequence)this.exemptionNumbers)) {
                this.exemptionNumbers = this.exemptionNumbers + ", ";
            }
            if (exemption.getExemptionType() == null) {
                exemption.refreshReferenceObject("exemptionType");
            }
            this.exemptionNumbers = this.exemptionNumbers + exemption.getExemptionType().getDescription();
        }
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    private String formatDate(Date date) {
        return date == null ? "" : this.dateFormat.format(date);
    }

    public boolean isTypeChanged() {
        return this.typeChanged;
    }

    public boolean isApprovalStatusChanged() {
        return this.approvalStatusChanged;
    }

    public boolean isProtocolNumberChanged() {
        return this.protocolNumberChanged;
    }

    public boolean isApplicationDateChanged() {
        return this.applicationDateChanged;
    }

    public boolean isApprovalDateChanged() {
        return this.approvalDateChanged;
    }

    public boolean isExpirationDateChanged() {
        return this.expirationDateChanged;
    }

    public boolean isExemptionNumbersChanged() {
        return this.exemptionNumbersChanged;
    }

    public boolean isCommentChanged() {
        return this.commentChanged;
    }

    public void compare(ProtocolSummary other) {
        SpecialReviewSummary otherSpecialReview = other.findSpecialReview(this.type, this.approvalStatus);
        if (otherSpecialReview == null) {
            this.typeChanged = true;
            this.approvalStatusChanged = true;
            this.protocolNumberChanged = true;
            this.applicationDateChanged = true;
            this.approvalDateChanged = true;
            this.expirationDateChanged = true;
            this.exemptionNumbersChanged = true;
            this.commentChanged = true;
        } else {
            this.typeChanged = !StringUtils.equals((CharSequence)this.type, (CharSequence)otherSpecialReview.type);
            this.approvalStatusChanged = !StringUtils.equals((CharSequence)this.approvalStatus, (CharSequence)otherSpecialReview.approvalStatus);
            this.protocolNumberChanged = !StringUtils.equals((CharSequence)this.protocolNumber, (CharSequence)otherSpecialReview.protocolNumber);
            this.applicationDateChanged = !StringUtils.equals((CharSequence)this.applicationDate, (CharSequence)otherSpecialReview.applicationDate);
            this.approvalDateChanged = !StringUtils.equals((CharSequence)this.approvalDate, (CharSequence)otherSpecialReview.approvalDate);
            this.expirationDateChanged = !StringUtils.equals((CharSequence)this.expirationDate, (CharSequence)otherSpecialReview.expirationDate);
            this.exemptionNumbersChanged = !StringUtils.equals((CharSequence)this.exemptionNumbers, (CharSequence)otherSpecialReview.exemptionNumbers);
            this.commentChanged = !StringUtils.equals((CharSequence)this.comment, (CharSequence)otherSpecialReview.comment);
        }
    }
}

