/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.budget.impl.personnel;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.budget.framework.core.AwardBudgetSaveEvent;
import org.kuali.coeus.common.budget.framework.core.Budget;
import org.kuali.coeus.common.budget.framework.core.BudgetParent;
import org.kuali.coeus.common.budget.framework.core.BudgetSaveEvent;
import org.kuali.coeus.common.budget.framework.nonpersonnel.ApplyToPeriodsBudgetEvent;
import org.kuali.coeus.common.budget.framework.nonpersonnel.BudgetLineItem;
import org.kuali.coeus.common.budget.framework.period.BudgetPeriod;
import org.kuali.coeus.common.budget.framework.personnel.AddPersonnelBudgetEvent;
import org.kuali.coeus.common.budget.framework.personnel.BudgetPerson;
import org.kuali.coeus.common.budget.framework.personnel.BudgetPersonService;
import org.kuali.coeus.common.budget.framework.personnel.BudgetPersonnelDetails;
import org.kuali.coeus.common.budget.framework.personnel.BudgetSavePersonnelEvent;
import org.kuali.coeus.common.budget.framework.personnel.BudgetSaveProjectPersonnelEvent;
import org.kuali.coeus.common.budget.framework.personnel.DeleteBudgetPersonEvent;
import org.kuali.coeus.common.budget.framework.personnel.JobCode;
import org.kuali.coeus.common.budget.framework.personnel.JobCodeService;
import org.kuali.coeus.common.budget.framework.personnel.ValidCeJobCode;
import org.kuali.coeus.common.framework.ruleengine.KcBusinessRule;
import org.kuali.coeus.common.framework.ruleengine.KcEventMethod;
import org.kuali.coeus.common.framework.ruleengine.KcEventResult;
import org.kuali.coeus.propdev.impl.core.DevelopmentProposal;
import org.kuali.coeus.sys.api.model.AbstractDecimal;
import org.kuali.coeus.sys.api.model.ScaleTwoDecimal;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.krad.data.CompoundKey;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.service.DictionaryValidationService;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.MessageMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@KcBusinessRule(value="budgetPersonnelRule")
public class BudgetPersonnelRule {
    private static final String BUDGET_PERSONS_FIELD_NAME_START = "budgetPersons[";
    private static final String BUDGET_PERSONS_FIELD_NAME_JOBCODE = "].jobCode";
    private static final String BUDGET_PERSONS_FIELD_NAME_CALC_BASE = "].calculationBase";
    @Autowired
    @Qualifier(value="businessObjectService")
    private BusinessObjectService boService;
    @Autowired
    @Qualifier(value="parameterService")
    private ParameterService paramService;
    @Autowired
    @Qualifier(value="budgetPersonService")
    private BudgetPersonService budgetPersonService;
    @Autowired
    @Qualifier(value="dictionaryValidationService")
    private DictionaryValidationService dictionaryValidationService;
    @Autowired
    @Qualifier(value="dataObjectService")
    private DataObjectService dataObjectService;
    @Autowired
    @Qualifier(value="jobCodeService")
    private JobCodeService jobCodeService;

    @KcEventMethod
    public boolean processCheckExistBudgetPersonnelDetailsBusinessRules(DeleteBudgetPersonEvent event) {
        boolean valid = true;
        String errorPath = event.getErrorPath();
        if (this.isPersonDetailsFound(event.getBudget(), event.getBudgetPerson())) {
            MessageMap messageMap = GlobalVariables.getMessageMap();
            messageMap.putError(errorPath, "error.delete.person.with.personnelDetails", new String[]{event.getBudgetPerson().getPersonName()});
            valid = false;
        }
        return valid;
    }

    private boolean isPersonDetailsFound(Budget budget, BudgetPerson budgetPerson) {
        for (BudgetPeriod budgetPeriod : budget.getBudgetPeriods()) {
            for (BudgetLineItem lineItem : budgetPeriod.getBudgetLineItems()) {
                for (BudgetPersonnelDetails budgetPersonnelDetail : lineItem.getBudgetPersonnelDetailsList()) {
                    if (!budgetPersonnelDetail.getPersonSequenceNumber().equals(budgetPerson.getPersonSequenceNumber())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @KcEventMethod
    public boolean processCheckBaseSalaryFormat(BudgetSaveEvent event) {
        boolean valid = true;
        MessageMap messageMap = GlobalVariables.getMessageMap();
        int i = 0;
        List<BudgetPerson> budgetPersons = event.getBudget().getBudgetPersons();
        for (BudgetPerson budgetPerson : budgetPersons) {
            if (budgetPerson.getCalculationBase() == null) {
                messageMap.putError(BUDGET_PERSONS_FIELD_NAME_START + i + BUDGET_PERSONS_FIELD_NAME_CALC_BASE, "error.required", new String[]{"Base Salary"});
                valid = false;
            } else if (budgetPerson.getCalculationBase().isNegative()) {
                messageMap.putError(BUDGET_PERSONS_FIELD_NAME_START + i + BUDGET_PERSONS_FIELD_NAME_CALC_BASE, "error.negativeAmount", new String[]{"Base Salary"});
                valid = false;
            }
            ++i;
        }
        return valid;
    }

    private Collection<ValidCeJobCode> getMappedCostElements(BudgetPerson person) {
        return this.budgetPersonService.getApplicableCostElements(person.getBudget(), person.getPersonSequenceNumber().toString());
    }

    @KcEventMethod
    public boolean processBudgetPersonnelBusinessRules(BudgetSaveEvent event) {
        boolean valid = true;
        List<BudgetPerson> budgetPersons = event.getBudget().getBudgetPersons();
        BudgetParent budgetParent = event.getBudget().getBudgetParent().getDocument().getBudgetParent();
        if (budgetParent instanceof DevelopmentProposal && ((DevelopmentProposal)budgetParent).isParent()) {
            KcEventResult result = ((DevelopmentProposal)budgetParent).isParent() ? new KcEventResult() : this.isNotDuplicateBudgetPersons(budgetPersons);
            GlobalVariables.getMessageMap().merge(result.getMessageMap());
        }
        return valid;
    }

    protected KcEventResult isNotDuplicateBudgetPersons(List<BudgetPerson> budgetPersons) {
        KcEventResult result = new KcEventResult();
        MessageMap messages = new MessageMap();
        result.setSuccess(true);
        for (int i = 0; i < budgetPersons.size(); ++i) {
            BudgetPerson budgetPerson = budgetPersons.get(i);
            for (int j = i + 1; j < budgetPersons.size(); ++j) {
                BudgetPerson budgetPersonCompare = budgetPersons.get(j);
                if (!budgetPerson.isDuplicatePerson(budgetPersonCompare)) continue;
                messages.putError(BUDGET_PERSONS_FIELD_NAME_START + j + "].personName", "error.budgetPerson.duplicate", new String[]{budgetPerson.getPersonName()});
                result.setSuccess(false);
            }
        }
        result.setMessageMap(messages);
        return result;
    }

    @KcEventMethod
    public boolean processCheckForJobCodeChange(BudgetSavePersonnelEvent event) {
        if (event.getBudget() == null) {
            throw new NullPointerException("the budgetDocument is null");
        }
        if (event.getCurrentBudgetPeriod() == null) {
            throw new NullPointerException("the currentBudgetPeriod is invalid");
        }
        boolean valid = true;
        GlobalVariables.getMessageMap().addToErrorPath("document");
        BudgetPeriod selectedBudgetPeriod = event.getCurrentBudgetPeriod();
        Collection<Integer> budgetPersonSequences = this.getBudgetPersonSequencesFromPersonnelDetails(selectedBudgetPeriod.getBudgetLineItems());
        if (CollectionUtils.isNotEmpty(budgetPersonSequences)) {
            int personIndex = 0;
            List<BudgetPerson> budgetPersons = event.getBudget().getBudgetPersons();
            for (BudgetPerson person : budgetPersons) {
                String errorKey = BUDGET_PERSONS_FIELD_NAME_START + personIndex + BUDGET_PERSONS_FIELD_NAME_JOBCODE;
                if (budgetPersonSequences.contains(person.getPersonSequenceNumber())) {
                    if (CollectionUtils.isNotEmpty(this.getMappedCostElements(person))) {
                        valid &= this.validateJobCodeChange(person, errorKey);
                    } else {
                        valid &= this.validateJobCodeValue(person, errorKey);
                        this.updateJobCodeOnDetailsFromPerson(selectedBudgetPeriod.getBudgetLineItems(), person);
                    }
                }
                ++personIndex;
            }
        }
        GlobalVariables.getMessageMap().removeFromErrorPath("document");
        return valid;
    }

    @KcEventMethod
    public boolean addPersonnelCheck(AddPersonnelBudgetEvent event) {
        boolean result = true;
        Budget budget = event.getBudget();
        BudgetPeriod budgetPeriod = event.getBudgetPeriod();
        BudgetLineItem newBudgetLineItem = event.getBudgetLineItem();
        BudgetPersonnelDetails budgetPersonDetails = event.getBudgetPersonnelDetails();
        String errorKey = event.getErrorKey();
        GlobalVariables.getMessageMap().addToErrorPath(errorKey);
        if (this.dictionaryValidationService.validate((Object)newBudgetLineItem).getNumberOfErrors() > 0) {
            result = false;
        }
        GlobalVariables.getMessageMap().removeFromErrorPath(errorKey);
        if (budgetPeriod == null) {
            GlobalVariables.getMessageMap().putError("viewBudgetPeriod", "error.viewBudgetPeriod.notSelected", new String[0]);
            result = false;
        }
        if (newBudgetLineItem.getCostElement() == null || StringUtils.equalsIgnoreCase((CharSequence)newBudgetLineItem.getCostElement(), (CharSequence)"")) {
            GlobalVariables.getMessageMap().putError(errorKey, "error.costElement.notSelected", new String[0]);
            result = false;
        }
        if (budgetPersonDetails.getPersonSequenceNumber() == null) {
            GlobalVariables.getMessageMap().putError("newBudgetPersonnelDetails.personSequenceNumber", "error.budgetPersonnel.notSelected", new String[0]);
            result = false;
        }
        if (!this.processCheckJobCodeObjectCodeCombo(budget, budgetPersonDetails, false)) {
            GlobalVariables.getMessageMap().putError(errorKey, "error.jobCode.costElement.invalid", new String[0]);
            result = false;
        }
        return result;
    }

    private boolean validateJobCodeChange(BudgetPerson person, String errorKey) {
        boolean valid = true;
        BudgetPerson personCopy = this.getOriginalBudgetPerson(person);
        if (personCopy != null && !person.isDuplicatePerson(personCopy) && !StringUtils.equals((CharSequence)person.getJobCode(), (CharSequence)personCopy.getJobCode())) {
            MessageMap messageMap = GlobalVariables.getMessageMap();
            messageMap.putError(errorKey, "error.person.jobcodeChange", new String[]{person.getPersonName()});
            valid = false;
        }
        return valid;
    }

    protected BudgetPerson getOriginalBudgetPerson(BudgetPerson person) {
        HashMap<String, Number> queryMap = new HashMap<String, Number>();
        queryMap.put("budgetId", person.getBudgetId());
        queryMap.put("personSequenceNumber", person.getPersonSequenceNumber());
        return (BudgetPerson)this.getDataObjectService().find(BudgetPerson.class, (Object)new CompoundKey(queryMap));
    }

    private boolean validateJobCodeValue(BudgetPerson person, String errorKey) {
        assert (person != null) : "the person is null";
        boolean valid = true;
        if (person.getJobCode() == null) {
            MessageMap messageMap = GlobalVariables.getMessageMap();
            messageMap.putError(errorKey, "error.person.jobcodeValue", new String[]{person.getPersonName()});
            valid = false;
        }
        return valid;
    }

    private Collection<Integer> getBudgetPersonSequencesFromPersonnelDetails(Collection<BudgetLineItem> budgetLineItems) {
        assert (budgetLineItems != null) : "the budgetLineItems is null";
        ArrayList<Integer> budgetPersonSequences = new ArrayList<Integer>();
        for (BudgetLineItem budgetLineItem : budgetLineItems) {
            for (BudgetPersonnelDetails budgetPersonnelDetails : budgetLineItem.getBudgetPersonnelDetailsList()) {
                budgetPersonSequences.add(budgetPersonnelDetails.getPersonSequenceNumber());
            }
        }
        return budgetPersonSequences;
    }

    private void updateJobCodeOnDetailsFromPerson(Collection<BudgetLineItem> budgetLineItems, BudgetPerson person) {
        assert (budgetLineItems != null) : "the budgetLineItems is null";
        assert (person != null) : "the person is null";
        if (person.getJobCode() == null) {
            return;
        }
        for (BudgetLineItem budgetLineItem : budgetLineItems) {
            for (BudgetPersonnelDetails budgetPersonnelDetails : budgetLineItem.getBudgetPersonnelDetailsList()) {
                if (!person.getPersonSequenceNumber().equals(budgetPersonnelDetails.getPersonSequenceNumber())) continue;
                budgetPersonnelDetails.setJobCode(person.getJobCode());
            }
        }
    }

    private List<ValidCeJobCode> getApplicableCostElements(Budget budget, BudgetPersonnelDetails newBudgetPersonnelDetails, boolean save) {
        List validCostElements = null;
        if (save) {
            String jobCodeValidationEnabledInd = this.paramService.getParameterValueAsString(Budget.class, "JOBCODE_VALIDATION_ENABLED");
            HashMap<String, String> fieldValues = new HashMap<String, String>();
            BudgetPerson budgetPerson = null;
            if (StringUtils.isNotEmpty((CharSequence)jobCodeValidationEnabledInd) && jobCodeValidationEnabledInd.equals("Y")) {
                List<BudgetPerson> budgetPersons = budget.getBudgetPersons();
                for (BudgetPerson tmpBudgetPerson : budgetPersons) {
                    if (tmpBudgetPerson.getPersonSequenceNumber().intValue() != newBudgetPersonnelDetails.getPersonSequenceNumber().intValue()) continue;
                    budgetPerson = tmpBudgetPerson;
                    break;
                }
                if (budgetPerson != null && StringUtils.isNotEmpty((CharSequence)budgetPerson.getJobCode())) {
                    fieldValues.put("jobCode", budgetPerson.getJobCode().toUpperCase());
                    validCostElements = (List)this.boService.findMatching(ValidCeJobCode.class, fieldValues);
                }
            }
        } else {
            validCostElements = this.budgetPersonService.getApplicableCostElements(budget, newBudgetPersonnelDetails.getPersonSequenceNumber().toString());
        }
        return validCostElements;
    }

    protected boolean processCheckJobCodeObjectCodeCombo(Budget budget, BudgetPersonnelDetails newBudgetPersonnelDetails, boolean save) {
        boolean isValid = false;
        List<ValidCeJobCode> validCostElements = this.getApplicableCostElements(budget, newBudgetPersonnelDetails, save);
        if (CollectionUtils.isEmpty(validCostElements)) {
            isValid = true;
        } else {
            for (ValidCeJobCode validCeJobCode : validCostElements) {
                if (!validCeJobCode.getCostElement().equalsIgnoreCase(newBudgetPersonnelDetails.getCostElement())) continue;
                isValid = true;
                break;
            }
        }
        return isValid;
    }

    @KcEventMethod
    public boolean budgetPersonnelDetailsCheck(ApplyToPeriodsBudgetEvent event) {
        return this.budgetPersonnelDetailsCheck(event.getBudget(), event.getBudgetLineItem(), event.getErrorPath());
    }

    private boolean budgetPersonnelDetailsCheck(Budget budget, BudgetLineItem budgetLineItem, String errorPath) {
        boolean valid = true;
        int k = 0;
        for (BudgetPersonnelDetails budgetPersonnelDetails : budgetLineItem.getBudgetPersonnelDetailsList()) {
            String detailsErrorPath;
            valid &= !this.personnelDetailsCheck(budget, budgetLineItem, budgetPersonnelDetails, detailsErrorPath = errorPath + ".budgetPersonnelDetailsList[" + k + "]");
            boolean validJobCodeCECombo = this.processCheckJobCodeObjectCodeCombo(budget, budgetPersonnelDetails, true);
            if (!validJobCodeCECombo) {
                GlobalVariables.getMessageMap().putError(detailsErrorPath + ".personSequenceNumber", "error.save.jobCode.costElement.invalid", new String[0]);
            }
            valid &= validJobCodeCECombo;
            ++k;
        }
        return valid;
    }

    @KcEventMethod
    public boolean budgetPersonnelDetailsCheck(AwardBudgetSaveEvent event) {
        boolean valid = true;
        List<BudgetPeriod> budgetPeriods = event.getBudget().getBudgetPeriods();
        int i = 0;
        int j = 0;
        for (BudgetPeriod budgetPeriod : budgetPeriods) {
            j = 0;
            List<BudgetLineItem> budgetLineItems = budgetPeriod.getBudgetLineItems();
            for (BudgetLineItem budgetLineItem : budgetLineItems) {
                if (budgetLineItem.getBudgetCategory().getBudgetCategoryTypeCode().equals("P")) {
                    valid &= this.budgetPersonnelDetailsCheck(event.getBudget(), budgetLineItem, event.getErrorPath() + "budgetPeriod[" + i + "].budgetLineItems[" + j + "]");
                }
                ++j;
            }
            ++i;
        }
        return valid;
    }

    @Deprecated
    private boolean personnelDetailsCheck(Budget budget, BudgetLineItem budgetLineItem, BudgetPersonnelDetails budgetPersonnelDetails, String errorPath) {
        boolean errorFound = false;
        GlobalVariables.getMessageMap().addToErrorPath(errorPath);
        if (StringUtils.isEmpty((CharSequence)budgetPersonnelDetails.getPeriodTypeCode())) {
            GlobalVariables.getMessageMap().putError("periodTypeCode", "error.required.periodTypeCode", new String[0]);
            errorFound = true;
        }
        if (budgetPersonnelDetails.getPercentEffort().isGreaterThan((AbstractDecimal)new ScaleTwoDecimal(100))) {
            GlobalVariables.getMessageMap().putError("percentEffort", "error.percentage", new String[]{"Percent Effort"});
            errorFound = true;
        }
        if (budgetPersonnelDetails.getPercentCharged().isGreaterThan((AbstractDecimal)new ScaleTwoDecimal(100))) {
            GlobalVariables.getMessageMap().putError("percentCharged", "error.percentage", new String[]{"Percent Charged"});
            errorFound = true;
        }
        if (budgetPersonnelDetails.getPercentCharged().isGreaterThan((AbstractDecimal)budgetPersonnelDetails.getPercentEffort())) {
            GlobalVariables.getMessageMap().putError("percentCharged", "error.percentEffort.lessThan.percentCharged", new String[0]);
            errorFound = true;
        }
        errorFound = errorFound || this.personnelDatesCheck(budgetLineItem, budgetPersonnelDetails);
        GlobalVariables.getMessageMap().removeFromErrorPath(errorPath);
        return errorFound;
    }

    @Deprecated
    private boolean personnelDatesCheck(BudgetLineItem budgetLineItem, BudgetPersonnelDetails budgetPersonnelDetails) {
        boolean errorFound = false;
        if (budgetPersonnelDetails.getStartDate() == null) {
            GlobalVariables.getMessageMap().putError("startDate", "error.required", new String[]{"Start Date (Start Date)"});
            errorFound = true;
        }
        if (budgetPersonnelDetails.getEndDate() == null) {
            GlobalVariables.getMessageMap().putError("endDate", "error.required", new String[]{"End Date (End Date)"});
            errorFound = true;
        }
        if (!errorFound) {
            if (budgetPersonnelDetails.getEndDate().compareTo(budgetPersonnelDetails.getStartDate()) < 0) {
                GlobalVariables.getMessageMap().putError("endDate", "error.personnel.detail.dates", new String[0]);
                errorFound = true;
            }
            if (budgetLineItem.getEndDate().compareTo(budgetPersonnelDetails.getEndDate()) < 0) {
                GlobalVariables.getMessageMap().putError("endDate", "error.personnel.detail.end.date", new String[]{"can not be after", "end date"});
                errorFound = true;
            }
            if (budgetLineItem.getStartDate().compareTo(budgetPersonnelDetails.getEndDate()) > 0) {
                GlobalVariables.getMessageMap().putError("endDate", "error.personnel.detail.end.date", new String[]{"can not be before", "start date"});
                errorFound = true;
            }
            if (budgetLineItem.getStartDate().compareTo(budgetPersonnelDetails.getStartDate()) > 0) {
                GlobalVariables.getMessageMap().putError("startDate", "error.personnel.detail.start.date", new String[]{"can not be before", "start date"});
                errorFound = true;
            }
            if (budgetLineItem.getEndDate().compareTo(budgetPersonnelDetails.getStartDate()) < 0) {
                GlobalVariables.getMessageMap().putError("startDate", "error.personnel.detail.start.date", new String[]{"can not be after", "end date"});
                errorFound = true;
            }
        }
        return errorFound;
    }

    @KcEventMethod
    public KcEventResult validateProjectPersonnel(BudgetSaveProjectPersonnelEvent event) {
        KcEventResult result = new KcEventResult();
        result.getMessageMap().addToErrorPath(event.getErrorPath());
        this.verifyJobCode(event, result);
        result.getMessageMap().removeFromErrorPath(event.getErrorPath());
        return result;
    }

    protected void verifyJobCode(BudgetSaveProjectPersonnelEvent event, KcEventResult result) {
        List<BudgetLineItem> budgetLineItems = this.getBudgetLineItems(event);
        BudgetPerson budgetPerson = event.getBudgetPerson();
        if (this.isJobCodeChanged(budgetPerson) && this.isNewJobCodeValid(budgetPerson, result) && this.isBudgetPersonExistsInPersonnelDetails(budgetLineItems, budgetPerson)) {
            if (this.isJobCodeValid(budgetPerson)) {
                this.updateJobCodeOnDetailsFromPerson(budgetLineItems, budgetPerson);
            } else {
                result.setSuccess(false);
            }
        }
    }

    protected boolean isJobCodeValid(BudgetPerson budgetPerson) {
        if (CollectionUtils.isNotEmpty(this.getMappedCostElements(budgetPerson))) {
            return this.validateJobCodeChange(budgetPerson, "jobCode");
        }
        return this.validateJobCodeValue(budgetPerson, "jobCode");
    }

    protected boolean isNewJobCodeValid(BudgetPerson budgetPerson, KcEventResult result) {
        if (!this.getParamService().getParameterValueAsBoolean("KC-B", "Document", "JOBCODE_VALIDATION_ENABLED").booleanValue()) {
            return true;
        }
        JobCode jobCode = this.getJobCodeService().findJobCodeRef(budgetPerson.getJobCode());
        if (jobCode == null) {
            result.getMessageMap().putError("jobCode", "error.person.invalid.jobcodeValue", new String[0]);
            result.setSuccess(false);
            return false;
        }
        return true;
    }

    protected boolean isJobCodeChanged(BudgetPerson budgetPerson) {
        BudgetPerson originalBudgetPerson = this.getOriginalBudgetPerson(budgetPerson);
        return originalBudgetPerson != null && !StringUtils.equalsIgnoreCase((CharSequence)originalBudgetPerson.getJobCode(), (CharSequence)budgetPerson.getJobCode());
    }

    protected boolean isBudgetPersonExistsInPersonnelDetails(List<BudgetLineItem> budgetLineItems, BudgetPerson budgetPerson) {
        for (BudgetLineItem budgetLineItem : budgetLineItems) {
            for (BudgetPersonnelDetails budgetPersonnelDetails : budgetLineItem.getBudgetPersonnelDetailsList()) {
                if (!budgetPersonnelDetails.getPersonSequenceNumber().equals(budgetPerson.getPersonSequenceNumber())) continue;
                return true;
            }
        }
        return false;
    }

    protected List<BudgetLineItem> getBudgetLineItems(BudgetSaveProjectPersonnelEvent event) {
        ArrayList<BudgetLineItem> budgetLineItems = new ArrayList<BudgetLineItem>();
        for (BudgetPeriod budgetPeriod : event.getBudget().getBudgetPeriods()) {
            budgetLineItems.addAll(budgetPeriod.getBudgetLineItems());
        }
        return budgetLineItems;
    }

    protected BudgetPersonService getBudgetPersonService() {
        return this.budgetPersonService;
    }

    protected BusinessObjectService getBoService() {
        return this.boService;
    }

    protected ParameterService getParamService() {
        return this.paramService;
    }

    protected DictionaryValidationService getDictionaryValidationService() {
        return this.dictionaryValidationService;
    }

    public void setBoService(BusinessObjectService boService) {
        this.boService = boService;
    }

    public void setParamService(ParameterService paramService) {
        this.paramService = paramService;
    }

    public void setBudgetPersonService(BudgetPersonService budgetPersonService) {
        this.budgetPersonService = budgetPersonService;
    }

    public void setDictionaryValidationService(DictionaryValidationService dictionaryValidationService) {
        this.dictionaryValidationService = dictionaryValidationService;
    }

    public DataObjectService getDataObjectService() {
        return this.dataObjectService;
    }

    public void setDataObjectService(DataObjectService dataObjectService) {
        this.dataObjectService = dataObjectService;
    }

    public JobCodeService getJobCodeService() {
        return this.jobCodeService;
    }

    public void setJobCodeService(JobCodeService jobCodeService) {
        this.jobCodeService = jobCodeService;
    }
}

