/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.iacuc.rules;

import java.util.HashMap;
import org.kuali.coeus.common.framework.person.attr.PersonTraining;
import org.kuali.coeus.sys.framework.rule.KcMaintenanceDocumentRuleBase;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.iacuc.IacucPersonTraining;
import org.kuali.rice.kns.document.MaintenanceDocument;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.util.ObjectUtils;

public class IacucPersonTrainingMaintenanceDocumentRule
extends KcMaintenanceDocumentRuleBase {
    private static final String PERSON_TRAINING_FIELD_NAME = "personTrainingId";
    private transient BusinessObjectService businessObjectService;

    protected boolean processCustomRouteDocumentBusinessRules(MaintenanceDocument document) {
        return this.checkIacucPersonTraining(document);
    }

    protected boolean processCustomApproveDocumentBusinessRules(MaintenanceDocument document) {
        return this.checkIacucPersonTraining(document);
    }

    protected boolean processCustomSaveDocumentBusinessRules(MaintenanceDocument document) {
        return this.checkIacucPersonTraining(document);
    }

    public boolean isDocumentValidForSave(MaintenanceDocument document) {
        return this.checkIacucPersonTraining(document);
    }

    private boolean checkIacucPersonTraining(MaintenanceDocument document) {
        boolean isValid = true;
        IacucPersonTraining newIacucPersonTraining = (IacucPersonTraining)document.getNewMaintainableObject().getDataObject();
        return isValid &= this.isPersonTrainingValid(newIacucPersonTraining);
    }

    private boolean isPersonTrainingValid(IacucPersonTraining newIacucPersonTraining) {
        boolean isValid = true;
        Integer personTrainingId = newIacucPersonTraining.getPersonTrainingId();
        if (ObjectUtils.isNotNull((Object)personTrainingId)) {
            HashMap<String, Integer> fieldValues = new HashMap<String, Integer>();
            fieldValues.put(PERSON_TRAINING_FIELD_NAME, personTrainingId);
            PersonTraining personTraining = (PersonTraining)this.getBusinessObjectService().findByPrimaryKey(PersonTraining.class, fieldValues);
            if (ObjectUtils.isNull((Object)personTraining)) {
                isValid = false;
                this.putFieldError(PERSON_TRAINING_FIELD_NAME, "error.iacuc.validation.invalid.person.training");
            } else {
                newIacucPersonTraining.setPersonId(personTraining.getPersonId());
            }
        }
        return isValid;
    }

    public BusinessObjectService getBusinessObjectService() {
        if (this.businessObjectService == null) {
            this.businessObjectService = KcServiceLocator.getService(BusinessObjectService.class);
        }
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }
}

