/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.committee.impl.meeting;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.committee.impl.bo.CommitteeScheduleBase;
import org.kuali.coeus.common.committee.impl.meeting.MeetingSaveEvent;
import org.kuali.coeus.common.committee.impl.meeting.MemberPresentBean;
import org.kuali.coeus.common.committee.impl.rules.CommitteeScheduleTimeRule;
import org.kuali.coeus.common.committee.impl.web.struts.form.schedule.Time12HrFmt;
import org.kuali.coeus.sys.framework.rule.KcBusinessRule;
import org.kuali.coeus.sys.framework.rule.KcTransactionalDocumentRuleBase;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.coeus.sys.framework.validation.ErrorReporter;

public class MeetingSaveRule
extends KcTransactionalDocumentRuleBase
implements KcBusinessRule<MeetingSaveEvent> {
    private static final String MSG1 = "hh:mm";
    private static final String MSG2 = "hh as 1-12 & mm as 0-59";
    private static final String MSG3 = "hh as 1-12";
    private static final String MSG4 = "mm as 0-59";
    private static final String COLON = ":";
    private static final String ID1 = "meetingHelper.committeeSchedule.viewTime.time";
    private static final String VIEW_TIME = "viewTime";
    private static final String VIEW_START_TIME = "viewStartTime";
    private static final String VIEW_END_TIME = "viewEndTime";
    private ErrorReporter errorReporter;

    @Override
    public boolean processRules(MeetingSaveEvent event) {
        boolean rulePassed = true;
        rulePassed &= this.validateMeetingDetails(event.getMeetingHelper().getCommitteeSchedule());
        return rulePassed &= this.validateDuplicateAlternateFor(event.getMeetingHelper().getMemberPresentBeans());
    }

    private boolean validateMeetingDetails(CommitteeScheduleBase committeeSchedule) {
        boolean rulePassed = true;
        this.errorReporter = KcServiceLocator.getService(ErrorReporter.class);
        String time = committeeSchedule.getViewStartTime().getTime();
        rulePassed &= this.processTime(time, ID1.replace(VIEW_TIME, VIEW_START_TIME));
        time = committeeSchedule.getViewEndTime().getTime();
        if (rulePassed &= this.processTime(time, ID1.replace(VIEW_TIME, VIEW_END_TIME))) {
            rulePassed &= this.checkStartTimeBeforeEndTime(committeeSchedule.getViewStartTime(), committeeSchedule.getViewEndTime());
        }
        time = committeeSchedule.getViewTime().getTime();
        rulePassed &= new CommitteeScheduleTimeRule().processTime(time, ID1);
        return rulePassed &= this.checkDeadlineBeforeScheduleDate(committeeSchedule);
    }

    private boolean validateDuplicateAlternateFor(List<MemberPresentBean> memberPresentBeans) {
        boolean rulePassed = true;
        this.errorReporter = KcServiceLocator.getService(ErrorReporter.class);
        int i = 0;
        for (MemberPresentBean memberPresentBean : memberPresentBeans) {
            if (StringUtils.isNotBlank((CharSequence)memberPresentBean.getAttendance().getAlternateFor())) {
                int j = 0;
                for (MemberPresentBean memberPresentBean1 : memberPresentBeans) {
                    if (j > i && StringUtils.isNotBlank((CharSequence)memberPresentBean1.getAttendance().getAlternateFor()) && memberPresentBean.getAttendance().getAlternateFor().equals(memberPresentBean1.getAttendance().getAlternateFor())) {
                        this.errorReporter.reportError("meetingHelper.memberPresentBeans[" + i + "].attendance.alternateFor", "error.duplicate.alternateFor", new String[0]);
                        rulePassed = false;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return rulePassed;
    }

    private boolean processTime(String time, String id) {
        String prefix = "";
        if (id.contains(VIEW_START_TIME)) {
            prefix = "Start";
        } else if (id.contains(VIEW_END_TIME)) {
            prefix = "End";
        }
        boolean rulePassed = true;
        if (StringUtils.isBlank((CharSequence)time)) {
            rulePassed = this.createErrorReport(id, prefix, MSG1);
            return rulePassed;
        }
        String[] result = time.split(COLON);
        if (result.length != 2) {
            rulePassed = this.createErrorReport(id, prefix, MSG1);
            return rulePassed;
        }
        try {
            Integer hrs = new Integer(result[0]);
            Integer mins = new Integer(result[1]);
            if (hrs < 1 || hrs > 12) {
                rulePassed = this.createErrorReport(id, prefix, MSG3);
                return rulePassed;
            }
            if (mins < 0 || mins > 59) {
                rulePassed = this.createErrorReport(id, prefix, MSG4);
                return rulePassed;
            }
        }
        catch (NumberFormatException e) {
            rulePassed = this.createErrorReport(id, prefix, MSG2);
        }
        return rulePassed;
    }

    private boolean checkStartTimeBeforeEndTime(Time12HrFmt startTime, Time12HrFmt endTime) {
        boolean rulePassed = true;
        String[] startTimeSplit = startTime.getTime().split(COLON);
        String[] endTimeSplit = endTime.getTime().split(COLON);
        if ("PM".equals(startTime.getMeridiem()) && "AM".equals(endTime.getMeridiem())) {
            this.errorReporter.reportError(ID1.replace(VIEW_TIME, VIEW_END_TIME), "error.committeeSchedule.endTime.before.startTime", new String[0]);
            rulePassed = false;
        } else if (startTime.getMeridiem().equals(endTime.getMeridiem())) {
            Integer startHrs = new Integer(startTimeSplit[0]);
            Integer startMins = new Integer(startTimeSplit[1]);
            Integer endHrs = new Integer(endTimeSplit[0]);
            Integer endMins = new Integer(endTimeSplit[1]);
            if (startHrs != 12 && (startHrs > endHrs || endHrs == 12) || startHrs.equals(endHrs) && startMins > endMins) {
                this.errorReporter.reportError(ID1.replace(VIEW_TIME, VIEW_END_TIME), "error.committeeSchedule.endTime.before.startTime", new String[0]);
                rulePassed = false;
            }
        }
        return rulePassed;
    }

    private boolean checkDeadlineBeforeScheduleDate(CommitteeScheduleBase committeeSchedule) {
        boolean rulePassed = true;
        if (committeeSchedule.getProtocolSubDeadline() != null && committeeSchedule.getScheduledDate().before(committeeSchedule.getProtocolSubDeadline())) {
            this.reportError("meetingHelper.committeeSchedule.protocolSubDeadline", "error.committeeSchedule.dealine", committeeSchedule.getProtocolSubDeadline().toString(), committeeSchedule.getScheduledDate().toString());
            rulePassed = false;
        }
        return rulePassed;
    }

    private boolean createErrorReport(String id, String prefix, String msg) {
        this.errorReporter.reportError(id, "error.committeeSchedule.viewtime", prefix, msg);
        return false;
    }
}

