/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.committee.impl.service.impl;

import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.common.committee.impl.bo.CommitteeBatchCorrespondenceBase;
import org.kuali.coeus.common.committee.impl.bo.CommitteeBatchCorrespondenceDetailBase;
import org.kuali.coeus.common.committee.impl.print.CommitteeReportType;
import org.kuali.coeus.common.committee.impl.print.service.CommitteePrintingServiceBase;
import org.kuali.coeus.common.committee.impl.service.CommitteeBatchCorrespondenceServiceBase;
import org.kuali.coeus.common.framework.mail.EmailAttachment;
import org.kuali.coeus.common.framework.print.AbstractPrint;
import org.kuali.coeus.common.framework.print.Printable;
import org.kuali.coeus.common.framework.print.PrintingException;
import org.kuali.coeus.common.notification.impl.service.KcNotificationService;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.coeus.sys.framework.util.DateUtils;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.protocol.ProtocolDao;
import org.kuali.kra.protocol.actions.ProtocolActionBase;
import org.kuali.kra.protocol.actions.genericactions.ProtocolGenericActionService;
import org.kuali.kra.protocol.correspondence.BatchCorrespondenceBase;
import org.kuali.kra.protocol.correspondence.BatchCorrespondenceDetailBase;
import org.kuali.kra.protocol.correspondence.ProtocolCorrespondence;
import org.kuali.kra.protocol.correspondence.ProtocolCorrespondenceTemplateService;
import org.kuali.kra.protocol.correspondence.ProtocolCorrespondenceTypeBase;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.service.DocumentService;
import org.kuali.rice.krad.service.SequenceAccessorService;
import org.kuali.rice.krad.util.GlobalVariables;

public abstract class CommitteeBatchCorrespondenceServiceImplBase
implements CommitteeBatchCorrespondenceServiceBase {
    protected static final Logger LOG = LogManager.getLogger(CommitteeBatchCorrespondenceServiceImplBase.class);
    private static final String COMMITTEE_ID = "committeeId";
    private static final String PROTOCOL_NUMBER = "protocolNumber";
    private static final String SEQUENCE_NUMBER = "sequenceNumber";
    private static final String BATCH_CORRESPONDENCE_TYPE_CODE = "batchCorrespondenceTypeCode";
    protected BusinessObjectService businessObjectService;
    protected ProtocolDao<? extends ProtocolBase> protocolDao;
    protected ProtocolGenericActionService protocolGenericActionService;
    protected ProtocolCorrespondenceTemplateService protocolCorrespondenceTemplateService;
    protected DocumentService documentService;
    protected KcNotificationService kcNotificationService;
    private DateTimeService dateTimeService;
    protected int finalActionCounter;

    @Override
    public abstract CommitteeBatchCorrespondenceBase generateBatchCorrespondence(String var1, String var2, Date var3, Date var4) throws Exception;

    protected ProtocolCorrespondenceTypeBase getProtocolCorrespondenceTypeToGenerate(ProtocolBase protocol, BatchCorrespondenceBase batchCorrespondence) throws Exception {
        ProtocolCorrespondenceTypeBase protocolCorrespondenceType = null;
        protocolCorrespondenceType = StringUtils.equals((CharSequence)batchCorrespondence.getSendCorrespondence(), (CharSequence)"BEFORE") ? this.getBeforeProtocolCorrespondenceTypeToGenerate(protocol, batchCorrespondence) : this.getAfterProtocolCorrespondenceTypeToGenerate(protocol, batchCorrespondence);
        if (protocolCorrespondenceType != null && this.correspondencePreviouslyGenerated(protocol, protocolCorrespondenceType)) {
            return null;
        }
        return protocolCorrespondenceType;
    }

    protected ProtocolCorrespondenceTypeBase getBeforeProtocolCorrespondenceTypeToGenerate(ProtocolBase protocol, BatchCorrespondenceBase batchCorrespondence) throws Exception {
        ProtocolCorrespondenceTypeBase protocolCorrespondenceType = null;
        double diff = DateUtils.getDifferenceInDays(new Timestamp(System.currentTimeMillis()), new Timestamp(protocol.getExpirationDate().getTime()));
        for (BatchCorrespondenceDetailBase batchCorrespondenceDetail : batchCorrespondence.getBatchCorrespondenceDetails()) {
            if (!((double)batchCorrespondenceDetail.getDaysToEvent().intValue() >= diff)) continue;
            protocolCorrespondenceType = batchCorrespondenceDetail.getProtocolCorrespondenceType();
        }
        if ((double)batchCorrespondence.getFinalActionDay().intValue() >= diff) {
            protocolCorrespondenceType = batchCorrespondence.getProtocolCorrespondenceType();
            this.applyFinalAction(protocol, batchCorrespondence);
        }
        return protocolCorrespondenceType;
    }

    protected ProtocolCorrespondenceTypeBase getAfterProtocolCorrespondenceTypeToGenerate(ProtocolBase protocol, BatchCorrespondenceBase batchCorrespondence) throws Exception {
        ProtocolCorrespondenceTypeBase protocolCorrespondenceType = null;
        double diff = DateUtils.getDifferenceInDays(protocol.getLastProtocolAction().getActionDate(), new Timestamp(System.currentTimeMillis()));
        for (BatchCorrespondenceDetailBase batchCorrespondenceDetail : batchCorrespondence.getBatchCorrespondenceDetails()) {
            if (!((double)batchCorrespondenceDetail.getDaysToEvent().intValue() <= diff)) continue;
            protocolCorrespondenceType = batchCorrespondenceDetail.getProtocolCorrespondenceType();
        }
        if ((double)batchCorrespondence.getFinalActionDay().intValue() <= diff) {
            protocolCorrespondenceType = batchCorrespondence.getProtocolCorrespondenceType();
            this.applyFinalAction(protocol, batchCorrespondence);
        }
        return protocolCorrespondenceType;
    }

    protected abstract void applyFinalAction(ProtocolBase var1, BatchCorrespondenceBase var2) throws Exception;

    protected boolean correspondencePreviouslyGenerated(ProtocolBase protocol, ProtocolCorrespondenceTypeBase protocolCorrespondenceType) {
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put(PROTOCOL_NUMBER, protocol.getProtocolNumber());
        fieldValues.put(SEQUENCE_NUMBER, protocol.getSequenceNumber().toString());
        fieldValues.put("protoCorrespTypeCode", protocolCorrespondenceType.getProtoCorrespTypeCode());
        return !this.businessObjectService.findMatching(this.getProtocolCorrespondenceBOClassHook(), fieldValues).isEmpty();
    }

    protected abstract Class<? extends ProtocolCorrespondence> getProtocolCorrespondenceBOClassHook();

    protected CommitteeBatchCorrespondenceDetailBase createBatchCorrespondenceDetail(String committeeId, ProtocolBase protocol, ProtocolCorrespondenceTypeBase protocolCorrespondenceType, String committeeBatchCorrespondenceId, String protocolActionTypeCode) throws PrintingException {
        CommitteeBatchCorrespondenceDetailBase committeeBatchCorrespondenceDetail = this.getNewCommitteeBatchCorrespondenceDetailInstanceHook();
        committeeBatchCorrespondenceDetail.setCommitteeBatchCorrespondenceId(committeeBatchCorrespondenceId);
        committeeBatchCorrespondenceDetail.setProtocolAction(this.createAndSaveProtocolAction(protocol, protocolCorrespondenceType, protocolActionTypeCode));
        committeeBatchCorrespondenceDetail.setProtocolActionId(committeeBatchCorrespondenceDetail.getProtocolAction().getProtocolActionId());
        committeeBatchCorrespondenceDetail.setProtocolCorrespondence(this.createAndSaveProtocolCorrespondence(committeeId, protocol, protocolCorrespondenceType, committeeBatchCorrespondenceDetail.getProtocolAction()));
        committeeBatchCorrespondenceDetail.setProtocolCorrespondenceId(committeeBatchCorrespondenceDetail.getProtocolCorrespondence().getId());
        committeeBatchCorrespondenceDetail.setCommitteeBatchCorrespondenceDetailId(KcServiceLocator.getService(SequenceAccessorService.class).getNextAvailableSequenceNumber("SEQ_COMMITTEE_ID", committeeBatchCorrespondenceDetail.getClass()));
        return committeeBatchCorrespondenceDetail;
    }

    protected abstract CommitteeBatchCorrespondenceDetailBase getNewCommitteeBatchCorrespondenceDetailInstanceHook();

    protected ProtocolActionBase createAndSaveProtocolAction(ProtocolBase protocol, ProtocolCorrespondenceTypeBase protocolCorrespondenceType, String protocolActionTypeCode) {
        ProtocolActionBase protocolAction = this.getNewProtocolActionInstanceHook(protocol, null, protocolActionTypeCode);
        protocolAction.setComments(protocolCorrespondenceType.getDescription());
        this.businessObjectService.save((PersistableBusinessObject)protocolAction);
        return protocolAction;
    }

    protected abstract ProtocolActionBase getNewProtocolActionInstanceHook(ProtocolBase var1, Object var2, String var3);

    protected ProtocolCorrespondence createAndSaveProtocolCorrespondence(String committeeId, ProtocolBase protocol, ProtocolCorrespondenceTypeBase protocolCorrespondenceType, ProtocolActionBase protocolAction) throws PrintingException {
        ProtocolCorrespondence protocolCorrespondence = this.getNewProtocolCorrespondenceInstanceHook();
        protocolCorrespondence.setProtocolId(protocol.getProtocolId());
        protocolCorrespondence.setProtocolNumber(protocol.getProtocolNumber());
        protocolCorrespondence.setSequenceNumber(protocol.getSequenceNumber());
        protocolCorrespondence.setActionIdFk(protocolAction.getProtocolActionId());
        protocolCorrespondence.setActionId(protocolAction.getActionId());
        protocolCorrespondence.setProtoCorrespTypeCode(protocolCorrespondenceType.getProtoCorrespTypeCode());
        AbstractPrint printable = this.getCommitteePrintingService().getCommitteePrintable(CommitteeReportType.PROTOCOL_BATCH_CORRESPONDENCE, committeeId);
        printable.setPrintableBusinessObject(protocol);
        HashMap<String, Object> reportParameters = new HashMap<String, Object>();
        reportParameters.put(COMMITTEE_ID, committeeId);
        reportParameters.put("submissionNumber", protocolAction.getSubmissionNumber());
        reportParameters.put("protoCorrespTypeCode", protocolCorrespondenceType.getProtoCorrespTypeCode());
        printable.setReportParameters(reportParameters);
        ArrayList<Printable> printableArtifactList = new ArrayList<Printable>();
        printableArtifactList.add(printable);
        protocolCorrespondence.setCorrespondence(this.getCommitteePrintingService().print(printableArtifactList).getData());
        protocolCorrespondence.setFinalFlag(false);
        protocolCorrespondence.setCreateUser(GlobalVariables.getUserSession().getPrincipalName());
        protocolCorrespondence.setCreateTimestamp(this.dateTimeService.getCurrentTimestamp());
        protocolCorrespondence.setProtocol(protocol);
        protocolCorrespondence.setProtocolCorrespondenceType(protocolCorrespondenceType);
        this.businessObjectService.save((PersistableBusinessObject)protocolCorrespondence);
        return protocolCorrespondence;
    }

    protected abstract ProtocolCorrespondence getNewProtocolCorrespondenceInstanceHook();

    protected List<EmailAttachment> getEmailAttachments(ProtocolCorrespondence protocolCorrespondence) {
        ArrayList<EmailAttachment> attachments = null;
        try {
            byte[] attachmentContents = protocolCorrespondence.getCorrespondence();
            if (attachmentContents != null) {
                attachments = new ArrayList<EmailAttachment>();
                String attachmentName = "correspondence_" + protocolCorrespondence.getProtocolNumber() + ".pdf";
                EmailAttachment attachment = new EmailAttachment();
                attachment.setFileName(attachmentName);
                attachment.setMimeType("application/pdf");
                attachment.setContents(attachmentContents);
                attachments.add(attachment);
            }
        }
        catch (Exception e) {
            LOG.error("Failed to get email attachments for batch correspondence.", (Throwable)e);
        }
        return attachments;
    }

    protected BatchCorrespondenceBase lookupBatchCorrespondence(String batchCorrespondenceTypeCode) {
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put(BATCH_CORRESPONDENCE_TYPE_CODE, batchCorrespondenceTypeCode);
        return (BatchCorrespondenceBase)this.businessObjectService.findByPrimaryKey(this.getBatchCorrespondenceBOClassHook(), fieldValues);
    }

    protected abstract Class<? extends BatchCorrespondenceBase> getBatchCorrespondenceBOClassHook();

    protected abstract CommitteePrintingServiceBase getCommitteePrintingService();

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public void setProtocolCorrespondenceTemplateService(ProtocolCorrespondenceTemplateService protocolCorrespondenceTemplateService) {
        this.protocolCorrespondenceTemplateService = protocolCorrespondenceTemplateService;
    }

    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }

    public void setKcNotificationService(KcNotificationService kcNotificationService) {
        this.kcNotificationService = kcNotificationService;
    }

    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }

    public ProtocolDao<? extends ProtocolBase> getProtocolDao() {
        return this.protocolDao;
    }

    public void setProtocolDao(ProtocolDao<? extends ProtocolBase> protocolDao) {
        this.protocolDao = protocolDao;
    }
}

