/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.committee.impl.web.struts.action;

import java.util.Collection;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionRedirect;
import org.apache.struts.config.ForwardConfig;
import org.kuali.coeus.common.committee.impl.bo.CommitteeBase;
import org.kuali.coeus.common.committee.impl.document.CommitteeDocumentBase;
import org.kuali.coeus.common.committee.impl.document.authorization.CommitteeTaskBase;
import org.kuali.coeus.common.committee.impl.web.struts.form.CommitteeFormBase;
import org.kuali.coeus.sys.framework.controller.KcTransactionalDocumentActionBase;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kns.lookup.LookupResultsService;
import org.kuali.rice.kns.web.struts.form.KualiDocumentFormBase;
import org.kuali.rice.kns.web.struts.form.KualiForm;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.rules.rule.event.DocumentEvent;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.service.KualiRuleService;
import org.kuali.rice.krad.util.GlobalVariables;

public abstract class CommitteeActionBase
extends KcTransactionalDocumentActionBase {
    private static final Logger LOG = LogManager.getLogger(CommitteeActionBase.class);

    @Override
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward actionForward = super.execute(mapping, form, request, response);
        return actionForward;
    }

    @Override
    public ActionForward save(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward actionForward = mapping.findForward("basic");
        CommitteeFormBase committeeForm = (CommitteeFormBase)form;
        CommitteeDocumentBase doc = committeeForm.getCommitteeDocument();
        CommitteeTaskBase task = this.getNewCommitteeTaskInstanceHook("modifyCommittee", (CommitteeBase)doc.getCommittee());
        if (this.isAuthorized(task) && this.isValidSave(committeeForm)) {
            actionForward = super.save(mapping, form, request, response);
        }
        return actionForward;
    }

    protected abstract CommitteeTaskBase getNewCommitteeTaskInstanceHook(String var1, CommitteeBase var2);

    protected boolean isValidSave(CommitteeFormBase committeeForm) {
        return true;
    }

    @Override
    public ActionForward close(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        CommitteeFormBase committeeForm = (CommitteeFormBase)form;
        this.doProcessingAfterPost((KualiForm)committeeForm, request);
        return super.close(mapping, (ActionForm)committeeForm, request, response);
    }

    public ActionForward refresh(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String lookupResultsSequenceNumber;
        super.refresh(mapping, form, request, response);
        CommitteeFormBase committeeForm = (CommitteeFormBase)form;
        if ("multipleValues".equals(committeeForm.getRefreshCaller()) && StringUtils.isNotBlank((CharSequence)(lookupResultsSequenceNumber = committeeForm.getLookupResultsSequenceNumber()))) {
            Class<?> lookupResultsBOClass = Class.forName(committeeForm.getLookupResultsBOClassName());
            String principalId = GlobalVariables.getUserSession().getPerson().getPrincipalId();
            LookupResultsService service = KcServiceLocator.getService(LookupResultsService.class);
            Collection selectedBOs = service.retrieveSelectedResultBOs(lookupResultsSequenceNumber, lookupResultsBOClass, principalId);
            this.processMultipleLookupResults(committeeForm, lookupResultsBOClass, selectedBOs);
        }
        return mapping.findForward("basic");
    }

    protected void processMultipleLookupResults(CommitteeFormBase committeeForm, Class lookupResultsBOClass, Collection<PersistableBusinessObject> selectedBOs) {
    }

    @Override
    public ActionForward docHandler(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = null;
        CommitteeFormBase committeeForm = (CommitteeFormBase)form;
        String command = committeeForm.getCommand();
        if ("displayActionListInlineView".equals(command)) {
            String docIdRequestParameter = request.getParameter("docId");
            Document retrievedDocument = KRADServiceLocatorWeb.getDocumentService().getByDocumentHeaderId(docIdRequestParameter);
            committeeForm.setDocument(retrievedDocument);
            request.setAttribute("docId", (Object)docIdRequestParameter);
            forward = mapping.findForward("basic");
            forward = new ActionForward(forward.getPath() + "?docId=" + docIdRequestParameter);
        } else if ("committeeActions".equals(command)) {
            String docIdRequestParameter = request.getParameter("docId");
            Document retrievedDocument = KRADServiceLocatorWeb.getDocumentService().getByDocumentHeaderId(docIdRequestParameter);
            committeeForm.setDocument(retrievedDocument);
            this.loadDocument((KualiDocumentFormBase)committeeForm);
            request.setAttribute("docId", (Object)docIdRequestParameter);
        } else {
            forward = super.docHandler(mapping, form, request, response);
        }
        if ("initiate".equals(committeeForm.getCommand())) {
            committeeForm.getCommitteeDocument().initialize();
        } else {
            committeeForm.initialize();
        }
        if ("committeeActions".equals(command)) {
            forward = this.committeeActions(mapping, (ActionForm)committeeForm, request, response);
        }
        return forward;
    }

    public ActionForward committee(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        ((CommitteeFormBase)form).getCommitteeHelper().prepareView();
        return mapping.findForward("committee");
    }

    public ActionForward committeeMembership(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        ((CommitteeFormBase)form).getCommitteeHelper().prepareView();
        ((CommitteeFormBase)form).getCommitteeHelper().flagInactiveMembers();
        return mapping.findForward("committeeMembership");
    }

    public ActionForward committeeSchedule(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        WorkflowDocument workflowDocument = ((CommitteeFormBase)form).getCommitteeDocument().getDocumentHeader().getWorkflowDocument();
        if (workflowDocument.isEnroute() || workflowDocument.isFinal()) {
            ((CommitteeFormBase)form).getCommitteeDocument().getCommittee().refreshReferenceObject("committeeSchedules");
        }
        ((CommitteeFormBase)form).getCommitteeHelper().prepareView();
        return mapping.findForward("committeeSchedule");
    }

    public ActionForward committeeActions(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        ((CommitteeFormBase)form).getCommitteeHelper().prepareView();
        return mapping.findForward("committeeActions");
    }

    protected KualiRuleService getKualiRuleService() {
        return KcServiceLocator.getService(KualiRuleService.class);
    }

    protected final boolean applyRules(DocumentEvent event) {
        return this.getKualiRuleService().applyRules(event);
    }

    @Override
    public ActionForward route(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = super.route(mapping, form, request, response);
        String routeHeaderId = ((CommitteeFormBase)form).getCommitteeDocument().getDocumentNumber();
        String returnLocation = this.buildActionUrl(routeHeaderId, "committeeActions", this.getCommitteeDocumentTypeSimpleNameHook());
        ActionRedirect holdingPageForward = new ActionRedirect((ForwardConfig)mapping.findForward("kraHoldingPage"));
        holdingPageForward.addParameter("holdingPageDocumentId", (Object)routeHeaderId);
        return this.routeToHoldingPage(forward, forward, holdingPageForward, returnLocation, routeHeaderId);
    }

    protected abstract String getCommitteeDocumentTypeSimpleNameHook();

    public ActionForward blanketApprove(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = super.blanketApprove(mapping, form, request, response);
        String routeHeaderId = ((CommitteeFormBase)form).getCommitteeDocument().getDocumentNumber();
        String returnLocation = this.buildActionUrl(routeHeaderId, "committeeActions", this.getCommitteeDocumentTypeSimpleNameHook());
        ActionRedirect holdingPageForward = new ActionRedirect((ForwardConfig)mapping.findForward("kraHoldingPage"));
        holdingPageForward.addParameter("holdingPageDocumentId", (Object)routeHeaderId);
        return this.routeToHoldingPage(forward, forward, holdingPageForward, returnLocation, routeHeaderId);
    }

    @Override
    protected void populateAuthorizationFields(KualiDocumentFormBase formBase) {
        super.populateAuthorizationFields(formBase);
        CommitteeFormBase committeeForm = (CommitteeFormBase)formBase;
        String command = committeeForm.getCommand();
        Map documentActions = formBase.getDocumentActions();
        if ("displayDocSearchView".equals(command) && documentActions.containsKey("canReload")) {
            documentActions.remove("canReload");
        }
    }
}

