/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.impl.person.attr;

import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.framework.custom.attr.CustomAttributeDocument;
import org.kuali.coeus.common.framework.person.attr.KcPersonExtendedAttributes;
import org.kuali.coeus.common.framework.person.attr.PersonCustomData;
import org.kuali.coeus.common.impl.person.attr.PersonCustomDataRuleBase;
import org.kuali.rice.kns.document.MaintenanceDocument;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.rules.rule.DocumentAuditRule;

public class PersonCustomDataAuditRule
extends PersonCustomDataRuleBase
implements DocumentAuditRule {
    private static final String CUSTOM_DATA_ERROR_PREFIX = "document.newMaintainableObject.businessObject.personCustomDataList";

    public boolean processRunAuditBusinessRules(Document document) {
        boolean rulePassed = true;
        MaintenanceDocument maintenanceDocument = (MaintenanceDocument)document;
        KcPersonExtendedAttributes kcPersonExtendedAttributes = (KcPersonExtendedAttributes)maintenanceDocument.getNewMaintainableObject().getDataObject();
        Map<String, CustomAttributeDocument> customAttributeDocuments = this.getCustomAttributeDocuments();
        int i = 0;
        for (PersonCustomData personCustomData : kcPersonExtendedAttributes.getPersonCustomDataList()) {
            CustomAttributeDocument customAttributeDocument = customAttributeDocuments.get(String.valueOf(personCustomData.getCustomAttributeId()));
            String errorKey = "document.newMaintainableObject.businessObject.personCustomDataList[" + i++ + "].value";
            rulePassed &= this.validateRequired(personCustomData, customAttributeDocument, errorKey);
        }
        return rulePassed;
    }

    private boolean validateRequired(PersonCustomData personCustomData, CustomAttributeDocument customAttributeDocument, String errorKey) {
        boolean rulePassed = true;
        if (customAttributeDocument.isRequired() && StringUtils.isBlank((CharSequence)personCustomData.getValue())) {
            this.reportError(errorKey, "error.required", personCustomData.getCustomAttribute().getLabel());
            rulePassed = false;
        }
        return rulePassed;
    }
}

