/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.hr.impl;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.apache.commons.io.input.BOMInputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.common.framework.mail.EmailAttachment;
import org.kuali.coeus.common.notification.impl.service.KcNotificationService;
import org.kuali.coeus.hr.impl.DOMHRImport;
import org.kuali.coeus.hr.impl.HRImport;
import org.kuali.coeus.hr.impl.HRImportService;
import org.kuali.coeus.hr.impl.ImportError;
import org.kuali.coeus.hr.impl.ImportRunner;
import org.kuali.coeus.hr.impl.ImportStatus;
import org.kuali.coeus.hr.impl.ImportStatusService;
import org.kuali.coeus.sys.framework.gv.GlobalVariableService;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.krad.UserSession;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component(value="importRunner")
public class ImportRunnerImpl
implements ImportRunner,
InitializingBean {
    private static final Logger LOG = LogManager.getLogger(ImportRunnerImpl.class);
    private static final int DFT_POOL_SIZE = 5;
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss (z)");
    private static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("###.##");
    protected static final String FROM_ADDRESS_KEY = "hrimport.report.from";
    protected String fromAddress;
    protected int threadPoolSize = 5;
    @Autowired
    @Qualifier(value="hrImportService")
    protected HRImportService importService;
    @Autowired
    @Qualifier(value="importStatusService")
    protected ImportStatusService statusService;
    @Autowired
    @Qualifier(value="kcNotificationService")
    protected KcNotificationService kcNotificationService;
    @Autowired
    @Qualifier(value="globalVariableService")
    private GlobalVariableService globalVariableService;
    @Autowired
    @Qualifier(value="kualiConfigurationService")
    protected ConfigurationService configurationService;
    protected ExecutorService executorService;

    protected void setThreadPoolSize(int size) {
        this.threadPoolSize = size;
    }

    protected int getThreadPoolSize() {
        return this.threadPoolSize;
    }

    public HRImportService getImportService() {
        return this.importService;
    }

    public void setImportService(HRImportService importService) {
        this.importService = importService;
    }

    public ImportStatusService getStatusService() {
        return this.statusService;
    }

    public void setStatusService(ImportStatusService svc) {
        this.statusService = svc;
    }

    public KcNotificationService getKcNotificationService() {
        return this.kcNotificationService;
    }

    public void setKcNotificationService(KcNotificationService kcNotificationService) {
        this.kcNotificationService = kcNotificationService;
    }

    protected ExecutorService getExecutorService() {
        if (this.executorService == null) {
            this.executorService = Executors.newFixedThreadPool(this.getThreadPoolSize());
        }
        return this.executorService;
    }

    @Override
    public ImportStatus processImport(String importId, HRImport toImport) {
        ImportTask task = new ImportTask(importId, toImport, this.importService, this.statusService);
        ImportStatus status = task.getImportStatus();
        LOG.debug("scheduling import task with executor for import " + importId);
        this.getExecutorService().execute(task);
        return status;
    }

    @Override
    public ImportStatus processImport(String importId, String importFile) {
        ImportTask task = new ImportTask(importId, importFile, this.importService, this.statusService);
        ImportStatus status = task.getImportStatus();
        LOG.debug("scheduling import task with executor for import " + importId);
        this.getExecutorService().execute(task);
        return status;
    }

    @Override
    public ImportStatus getStatus(String id) {
        return this.statusService.getImportStatus(id);
    }

    @Override
    public void abort(String id) {
        LOG.debug("aborting import with id: " + id);
        this.importService.abort(id);
    }

    public GlobalVariableService getGlobalVariableService() {
        return this.globalVariableService;
    }

    public void setGlobalVariableService(GlobalVariableService globalVariableService) {
        this.globalVariableService = globalVariableService;
    }

    public ConfigurationService getConfigurationService() {
        return this.configurationService;
    }

    public void setConfigurationService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }

    public void afterPropertiesSet() {
        if (this.fromAddress == null) {
            this.fromAddress = this.getConfigurationService().getPropertyValueAsString(FROM_ADDRESS_KEY);
            if (this.fromAddress == null) {
                LOG.error("hrimport.report.from is not set. Report emails cannot be sent.");
            } else {
                LOG.debug("Report email from address set to: " + this.fromAddress);
            }
        }
    }

    private class ImportTask
    implements Runnable {
        protected String importId;
        protected HRImport hrImport;
        protected HRImportService importService;
        protected ImportStatusService statusService;
        protected ImportStatus importStatus;
        protected UserSession userSession;

        public ImportTask(String importId, HRImport hrImport, HRImportService service, ImportStatusService statusService) {
            this.importId = importId;
            this.hrImport = hrImport;
            this.importService = service;
            this.statusService = statusService;
            this.importStatus = statusService.initiateImport(importId, hrImport.getRecordCount());
            UserSession incomingUserSession = ImportRunnerImpl.this.getGlobalVariableService().getUserSession();
            if (incomingUserSession == null) {
                throw new IllegalStateException("No user logged in");
            }
            this.userSession = incomingUserSession;
        }

        public ImportTask(String importId, String importFile, HRImportService service, ImportStatusService statusService) {
            this.importId = importId;
            this.importService = service;
            this.statusService = statusService;
            BufferedReader br = null;
            try {
                File file = new File(importFile);
                BOMInputStream is = new BOMInputStream((InputStream)new FileInputStream(file));
                if (is.hasBOM()) {
                    LOG.info("FYI: importFile '" + importFile + "' has a BOM!");
                }
                br = new BufferedReader(new InputStreamReader((InputStream)is, Charset.forName("UTF-8")));
                JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{DOMHRImport.class});
                Unmarshaller um = context.createUnmarshaller();
                this.hrImport = (DOMHRImport)um.unmarshal((Reader)br);
            }
            catch (IOException | JAXBException e) {
                throw new Error(e.getMessage(), e);
            }
            finally {
                try {
                    if (br != null) {
                        br.close();
                    }
                }
                catch (IOException e) {
                    LOG.error(e.getMessage(), (Throwable)e);
                }
            }
            this.importStatus = statusService.initiateImport(importId, this.hrImport.getRecordCount());
            UserSession incomingUserSession = ImportRunnerImpl.this.getGlobalVariableService().getUserSession();
            if (incomingUserSession == null) {
                throw new IllegalStateException("No user logged in");
            }
            this.userSession = incomingUserSession;
        }

        public ImportStatus getImportStatus() {
            return this.importStatus;
        }

        protected final EmailAttachment generateExceptionReport(ImportStatus status) {
            EmailAttachment exceptionReport = new EmailAttachment();
            String reportFileName = "hrimport-" + status.getImportId() + ".txt";
            LOG.debug("generating exception report for " + reportFileName);
            exceptionReport.setFileName(reportFileName);
            exceptionReport.setMimeType("text/plain");
            StringBuilder buff = new StringBuilder();
            List<ImportError> errors = status.getErrors();
            for (ImportError error : errors) {
                buff.append("record ").append(error.getRecordNumber());
                buff.append(", principal name: ").append(error.getPrincipalName()).append(": ");
                buff.append(error.getException()).append('\n');
            }
            exceptionReport.setContents(buff.toString().getBytes());
            return exceptionReport;
        }

        protected final String formatStatusMessage(ImportStatus status) {
            StringBuilder buff = new StringBuilder();
            String BREAK = "<br/>\n";
            buff.append("HR Import Status Report").append("<br/>\n").append("-----------------------").append("<br/>\n").append("<br/>\n");
            buff.append("Unique Import ID: ").append(status.getImportId()).append("<br/>\n");
            buff.append("Import Status: ").append(status.getStatus().toString()).append("<br/>\n");
            long start = status.getStartTimeInMillis();
            long end = status.getEndTimeInMillis();
            long duration = end - start;
            Date startDate = new Date(start);
            Date endDate = new Date(end);
            buff.append("Start:\t").append(DATE_FORMAT.format(startDate)).append("<br/>\n");
            buff.append("End:\t").append(DATE_FORMAT.format(endDate)).append("<br/>\n");
            buff.append("Total Time: ").append(DECIMAL_FORMAT.format((float)duration / 1000.0f)).append(" seconds").append("<br/>\n");
            int errorCount = status.getErrorCount();
            buff.append("Records Sumbitted: ").append(status.getRecordTotal()).append("<br/>\n");
            buff.append("Records Processed: ").append(status.getProcessedRecordCount()).append("<br/>\n");
            buff.append("Errors Encountered: ").append(status.getErrorCount()).append("<br/>\n");
            if (errorCount > 0) {
                buff.append("\t*** Error report is attached to this email");
            }
            buff.append("<br/>\n").append("<br/>\n");
            String message = status.getMessage();
            if (message != null) {
                buff.append("Detailed Message:").append("<br/>\n").append("&nbsp;&nbsp;&nbsp;&nbsp;").append(message);
            }
            return buff.toString();
        }

        protected void notifyStatusEmailRecipient(String importId) {
            LOG.debug("formulating report email");
            if (ImportRunnerImpl.this.fromAddress == null) {
                LOG.error("status email not sent; hrimport.report.from is not set");
                return;
            }
            ImportStatus status = this.statusService.getImportStatus(importId);
            String recipient = this.hrImport.getStatusEmailRecipient();
            if (recipient != null) {
                LinkedList<EmailAttachment> attachments = new LinkedList<EmailAttachment>();
                if (status.getErrorCount() > 0) {
                    EmailAttachment exceptionReport = this.generateExceptionReport(status);
                    attachments.add(exceptionReport);
                }
                HashSet<String> toAddresses = new HashSet<String>();
                toAddresses.add(this.hrImport.getStatusEmailRecipient());
                String subject = "HR Import Results";
                String message = this.formatStatusMessage(status);
                try {
                    Method sendEmailMethod = ImportRunnerImpl.this.kcNotificationService.getClass().getDeclaredMethod("sendEmailNotification", String.class, Set.class, String.class, String.class, List.class);
                    sendEmailMethod.setAccessible(true);
                    sendEmailMethod.invoke((Object)ImportRunnerImpl.this.kcNotificationService, ImportRunnerImpl.this.fromAddress, toAddresses, "HR Import Results", message, attachments);
                }
                catch (Exception e) {
                    LOG.error("Email of results failed", (Throwable)e);
                }
            }
            LOG.debug("Email report finished");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            LOG.debug("initiating import of: " + this.importId);
            try {
                ImportRunnerImpl.this.getGlobalVariableService().setUserSession(this.userSession);
                this.importService.startImport(this.importId, this.hrImport);
                this.statusService.completeImport(this.importId);
            }
            catch (Exception e) {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                e.printStackTrace(pw);
                pw.flush();
                LOG.error("import stopped due to error: " + e.getMessage() + "\n" + sw.toString(), (Throwable)e);
                pw.close();
                StringBuilder sb = new StringBuilder();
                sb.append("Unexpected error: ").append(e.getMessage()).append(" [").append(e.getClass().getSimpleName()).append(']');
                this.statusService.abnormalTermination(this.importId, sb.toString());
            }
            finally {
                this.notifyStatusEmailRecipient(this.importId);
                ImportRunnerImpl.this.getGlobalVariableService().clear();
            }
            LOG.debug("ImportRunnerImpl.run() finished");
        }
    }
}

