/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kra.award.AwardTemplateSyncEvent;
import org.kuali.kra.award.AwardTemplateSyncScope;
import org.kuali.kra.award.AwardTemplateSyncService;
import org.kuali.kra.award.document.AwardDocument;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.award.home.AwardComment;
import org.kuali.kra.award.home.AwardSponsorTerm;
import org.kuali.kra.award.home.AwardSyncable;
import org.kuali.kra.award.home.AwardSyncableList;
import org.kuali.kra.award.home.AwardTemplate;
import org.kuali.kra.award.home.AwardTemplateComment;
import org.kuali.kra.award.home.AwardTemplateReportTermRecipient;
import org.kuali.kra.award.home.AwardTemplateTerm;
import org.kuali.kra.award.paymentreports.awardreports.AwardReportTermRecipient;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.rules.rule.event.DocumentEvent;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.service.KualiRuleService;
import org.kuali.rice.krad.util.ObjectUtils;

public class AwardTemplateSyncServiceImpl
implements AwardTemplateSyncService {
    private BusinessObjectService businessObjectService;
    private KualiRuleService kualiRuleService;
    private static final Logger LOG = LogManager.getLogger(AwardTemplateSyncService.class);

    @Override
    public boolean syncAwardToTemplate(AwardDocument awardDocument, AwardTemplateSyncScope[] scopes) {
        boolean success;
        Award award = awardDocument.getAward();
        AwardTemplateSyncEvent awardTemplateSyncEvent = new AwardTemplateSyncEvent("Award Sync", "document.award.awardTemplate", (Document)awardDocument);
        if (!this.getKualiRuleService().applyRules((DocumentEvent)awardTemplateSyncEvent)) {
            return false;
        }
        try {
            AwardTemplate awardTemplate = this.fetchAwardTemplate(award);
            this.sync(awardTemplate, award, scopes, this.createScopeStack(), award, awardTemplate);
            success = true;
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Exception thrown executing syncAwardToTemplate on document %s with scopes {%s}", awardDocument.getDocumentNumber(), AwardTemplateSyncServiceImpl.scopesArrayToDelimitedList(scopes)), e);
        }
        return success;
    }

    @Override
    public boolean syncWillAlterData(AwardDocument awardDocument, AwardTemplateSyncScope scope) {
        boolean result = false;
        AwardTemplateSyncScope[] scopes = this.getScopeArray(scope);
        Award award = awardDocument.getAward();
        try {
            result = this.syncTargetCheck(this.fetchAwardTemplate(award), award, scopes, this.createScopeStack(), award, this.fetchAwardTemplate(award));
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Exception thrown executing syncWillAlterData on document %s with scopes {%s}", awardDocument.getDocumentNumber(), AwardTemplateSyncServiceImpl.scopesArrayToDelimitedList(scopes)), e);
        }
        return result;
    }

    @Override
    public boolean templateContainsScopedData(AwardDocument awardDocument, AwardTemplateSyncScope scope) {
        boolean result = false;
        AwardTemplateSyncScope[] scopes = this.getScopeArray(scope);
        Award award = awardDocument.getAward();
        try {
            result = this.syncSourceCheck(this.fetchAwardTemplate(award), award, scopes, this.createScopeStack(), award, this.fetchAwardTemplate(award));
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Exception thrown executing syncSourceCheck on document %s with scopes {%s}", awardDocument.getDocumentNumber(), AwardTemplateSyncServiceImpl.scopesArrayToDelimitedList(scopes)), e);
        }
        return result;
    }

    protected AwardTemplateSyncScope[] getScopeArray(AwardTemplateSyncScope scope) {
        AwardTemplateSyncScope[] scopes = new AwardTemplateSyncScope[]{scope};
        if (scope.equals((Object)AwardTemplateSyncScope.FULL)) {
            scopes = AwardTemplateSyncScope.values();
        }
        return scopes;
    }

    protected Stack<AwardTemplateSyncScope[]> createScopeStack() {
        return new Stack<AwardTemplateSyncScope[]>();
    }

    protected boolean syncTargetCheck(Object awardTemplateObject, Object awardObject, AwardTemplateSyncScope[] scopes, Stack<AwardTemplateSyncScope[]> scopeStack, Award award, AwardTemplate awardTemplate) throws Exception {
        ArrayList<Field> allFields = new ArrayList<Field>();
        this.findAllFields(awardObject.getClass(), allFields);
        boolean result = false;
        for (Field field : allFields) {
            try {
                AwardTemplateSyncScope[] effectiveScopes;
                if (field.isAnnotationPresent(AwardSyncable.class)) {
                    scopeStack.push(field.getAnnotation(AwardSyncable.class).scopes());
                    effectiveScopes = this.getEffectiveScope(scopeStack);
                    if (AwardTemplateSyncScope.isInScope(effectiveScopes, scopes)) {
                        result = this.checkTargetField(awardTemplateObject, awardObject, field, scopeStack, award, awardTemplate);
                    }
                    scopeStack.pop();
                } else if (field.isAnnotationPresent(AwardSyncableList.class)) {
                    scopeStack.push(field.getAnnotation(AwardSyncableList.class).scopes());
                    effectiveScopes = this.getEffectiveScope(scopeStack);
                    if (AwardTemplateSyncScope.isInScope(effectiveScopes, scopes)) {
                        result = this.checkTargetList(awardTemplateObject, awardObject, field, scopes, scopeStack, award, awardTemplate);
                    } else if (LOG.isDebugEnabled()) {
                        LOG.debug(String.format("Skipped (not in scope(s) %s) list:%s.%s", ArrayUtils.toString((Object)scopes), awardObject.getClass().toString(), field.getName()));
                    }
                    scopeStack.pop();
                } else if (LOG.isTraceEnabled()) {
                    LOG.trace(String.format("Skipped (No Annotation):%s.%s", awardObject.getClass().toString(), field.getName()));
                }
                if (!result) continue;
                break;
            }
            catch (IllegalStateException ise) {
                throw new RuntimeException(String.format("IllegalStateException while processing %s.%s", field.getDeclaringClass(), field.getName()), ise);
            }
        }
        return result;
    }

    protected boolean checkTargetField(Object awardTemplateObject, Object awardObject, Field field, Stack<AwardTemplateSyncScope[]> scopeStack, Award award, AwardTemplate awardTemplate) throws Exception {
        boolean result = false;
        if (field.isAnnotationPresent(AwardSyncable.class)) {
            result = ObjectUtils.getPropertyValue((Object)awardObject, (String)field.getName()) != null;
        }
        return result;
    }

    protected boolean syncSourceCheck(Object awardTemplateObject, Object awardObject, AwardTemplateSyncScope[] scopes, Stack<AwardTemplateSyncScope[]> scopeStack, Award award, AwardTemplate awardTemplate) throws Exception {
        ArrayList<Field> allFields = new ArrayList<Field>();
        this.findAllFields(awardObject.getClass(), allFields);
        boolean result = false;
        for (Field field : allFields) {
            try {
                AwardTemplateSyncScope[] effectiveScopes;
                if (field.isAnnotationPresent(AwardSyncable.class)) {
                    scopeStack.push(field.getAnnotation(AwardSyncable.class).scopes());
                    effectiveScopes = this.getEffectiveScope(scopeStack);
                    if (AwardTemplateSyncScope.isInScope(effectiveScopes, scopes)) {
                        result = this.checkSourceField(awardTemplateObject, awardObject, field, scopeStack, award, awardTemplate);
                    }
                    scopeStack.pop();
                } else if (field.isAnnotationPresent(AwardSyncableList.class)) {
                    scopeStack.push(field.getAnnotation(AwardSyncableList.class).scopes());
                    effectiveScopes = this.getEffectiveScope(scopeStack);
                    if (AwardTemplateSyncScope.isInScope(effectiveScopes, scopes)) {
                        result = this.checkSourceList(awardTemplateObject, awardObject, field, scopes, scopeStack, award, awardTemplate);
                    } else if (LOG.isDebugEnabled()) {
                        LOG.debug(String.format("Skipped (not in scope(s) %s) list:%s.%s", ArrayUtils.toString((Object)scopes), awardObject.getClass().toString(), field.getName()));
                    }
                    scopeStack.pop();
                } else if (LOG.isTraceEnabled()) {
                    LOG.trace(String.format("Skipped (No Annotation):%s.%s", awardObject.getClass().toString(), field.getName()));
                }
                if (!result) continue;
                break;
            }
            catch (IllegalStateException ise) {
                throw new RuntimeException(String.format("IllegalStateException while processing %s.%s", field.getDeclaringClass(), field.getName()), ise);
            }
        }
        return result;
    }

    protected boolean checkSourceField(Object awardTemplateObject, Object awardObject, Field field, Stack<AwardTemplateSyncScope[]> scopeStack, Award award, AwardTemplate awardTemplate) {
        boolean result = false;
        if (ObjectUtils.isNotNull((Object)ObjectUtils.getPropertyValue((Object)awardTemplateObject, (String)field.getName())) && field.getAnnotation(AwardSyncable.class).impactSourceScopeEmpty()) {
            result = true;
        }
        return result;
    }

    protected boolean checkSourceList(Object awardTemplateObject, Object awardObject, Field field, AwardTemplateSyncScope[] scopes, Stack<AwardTemplateSyncScope[]> scopeStack, Award award, AwardTemplate awardTemplate) throws Exception {
        field.setAccessible(true);
        boolean result = false;
        List awardTemplateObjectList = (List)ObjectUtils.getPropertyValue((Object)awardTemplateObject, (String)field.getName());
        if (awardTemplateObjectList != null && awardTemplateObjectList.size() != 0) {
            Method templateIsInScopeMethod = this.findIsInScopeMethodForClass(field.getAnnotation(AwardSyncableList.class).syncSourceClass());
            for (Object awardListObject : awardTemplateObjectList) {
                if (!((Boolean)templateIsInScopeMethod.invoke(null, new Object[]{awardListObject, scopes})).booleanValue()) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    protected void extractListFromParentAndSync(Object awardTemplateObject, Object awardObject, Field field, AwardTemplateSyncScope[] scopes, Stack<AwardTemplateSyncScope[]> scopeStack, Award award, AwardTemplate awardTemplate) throws Exception {
        field.setAccessible(true);
        List awardTemplateObjectList = (List)ObjectUtils.getPropertyValue((Object)awardTemplateObject, (String)field.getName());
        AwardSyncableList awardSyncableList = field.getAnnotation(AwardSyncableList.class);
        scopeStack.push(awardSyncableList.scopes());
        AwardTemplateSyncScope[] effectiveScopes = this.getEffectiveScope(scopeStack);
        if (awardTemplateObjectList != null && AwardTemplateSyncScope.isInScope(scopes, effectiveScopes)) {
            if (awardSyncableList.syncMethodName().equalsIgnoreCase("defaultMethod")) {
                this.syncListObjects(awardObject, awardTemplateObjectList, field, scopes, scopeStack, award, awardTemplate);
            } else {
                this.invokeMethodToSync((Award)awardObject, awardTemplateObjectList, awardSyncableList.syncMethodName(), scopes, scopeStack, award, awardTemplate);
            }
        }
        scopeStack.pop();
    }

    protected AwardTemplateSyncScope[] getEffectiveScope(Stack<AwardTemplateSyncScope[]> scopeStack) throws IllegalStateException {
        AwardTemplateSyncScope[] effectiveScope = null;
        for (int i = scopeStack.size() - 1; i >= 0; --i) {
            if (ArrayUtils.contains((Object[])((Object[])scopeStack.get(i)), (Object)((Object)AwardTemplateSyncScope.CONTAINING_CLASS_INHERIT))) continue;
            effectiveScope = (AwardTemplateSyncScope[])scopeStack.get(i);
        }
        if (effectiveScope == null) {
            StringBuffer scopeStackString = new StringBuffer();
            for (int i = scopeStack.size() - 1; i >= 0; --i) {
                scopeStackString.append(String.format("{%s}", scopeStackString.append(AwardTemplateSyncServiceImpl.scopesArrayToDelimitedList((AwardTemplateSyncScope[])scopeStack.get(i)))));
                if (i <= 0) continue;
                scopeStackString.append("|");
            }
            throw new RuntimeException(String.format("No Effective Scope could  be calculated for the scopeStack [%s]", scopeStackString));
        }
        return effectiveScope;
    }

    protected void invokeMethodToSync(Award awardObject, List awardTemplateObjectList, String syncMethodName, AwardTemplateSyncScope[] scopes, Stack<AwardTemplateSyncScope[]> scopeStack, Award award, AwardTemplate awardTemplate) throws Exception {
        Method syncMethod = this.getClass().getMethod(syncMethodName, Award.class, List.class, Stack.class, Award.class, AwardTemplate.class);
        syncMethod.invoke((Object)this, awardObject, awardTemplateObjectList, scopeStack, award, awardTemplate);
    }

    protected void sync(Object awardTemplateObject, Object awardObject, AwardTemplateSyncScope[] scopes, Stack<AwardTemplateSyncScope[]> scopeStack, Award award, AwardTemplate awardTemplate) throws Exception {
        ArrayList<Field> allFields = new ArrayList<Field>();
        this.findAllFields(awardObject.getClass(), allFields);
        for (Field field : allFields) {
            AwardTemplateSyncScope[] effectiveScopes;
            if (field.isAnnotationPresent(AwardSyncable.class)) {
                scopeStack.push(field.getAnnotation(AwardSyncable.class).scopes());
                effectiveScopes = this.getEffectiveScope(scopeStack);
                if (AwardTemplateSyncScope.isInScope(effectiveScopes, scopes)) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(String.format("Copying field:%s.%s", awardObject.getClass().toString(), field.getName()));
                    }
                    this.copyField(awardTemplateObject, awardObject, field, scopeStack, award, awardTemplate);
                } else if (LOG.isDebugEnabled()) {
                    LOG.debug(String.format("Skiped (not in scope(s) %s):%s.%s", ArrayUtils.toString((Object)scopes), awardObject.getClass().toString(), field.getName()));
                }
                scopeStack.pop();
                continue;
            }
            if (field.isAnnotationPresent(AwardSyncableList.class)) {
                scopeStack.push(field.getAnnotation(AwardSyncableList.class).scopes());
                effectiveScopes = this.getEffectiveScope(scopeStack);
                if (AwardTemplateSyncScope.isInScope(effectiveScopes, scopes)) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(String.format("Sync list:%s.%s", awardObject.getClass().toString(), field.getName()));
                    }
                    this.extractListFromParentAndSync(awardTemplateObject, awardObject, field, scopes, scopeStack, award, awardTemplate);
                } else if (LOG.isDebugEnabled()) {
                    LOG.debug(String.format("Skipped (not in scope(s) %s) list:%s.%s", ArrayUtils.toString((Object)scopes), awardObject.getClass().toString(), field.getName()));
                }
                scopeStack.pop();
                continue;
            }
            if (!LOG.isTraceEnabled()) continue;
            LOG.trace(String.format("Skipped (No Annotation):%s.%s", awardObject.getClass().toString(), field.getName()));
        }
    }

    protected void findAllFields(Class klass, List<Field> allFields) {
        Field[] fields = klass.getDeclaredFields();
        allFields.addAll(Arrays.asList(fields));
        klass = klass.getSuperclass();
        if (klass != null) {
            this.findAllFields(klass, allFields);
        }
    }

    protected void copyField(Object awardTemplateObject, Object awardObject, Field field, Stack<AwardTemplateSyncScope[]> scopeStack, Award award, AwardTemplate awardTemplate) throws Exception {
        if (field.isAnnotationPresent(AwardSyncable.class)) {
            Object value = ObjectUtils.getPropertyValue((Object)awardTemplateObject, (String)field.getName());
            ObjectUtils.setObjectProperty((Object)awardObject, (String)field.getName(), (Object)value);
        }
    }

    protected boolean checkTargetList(Object awardTemplateObject, Object awardObject, Field field, AwardTemplateSyncScope[] scopes, Stack<AwardTemplateSyncScope[]> scopeStack, Award award, AwardTemplate awardTemplate) throws Exception {
        field.setAccessible(true);
        boolean result = false;
        List awardObjectList = (List)ObjectUtils.getPropertyValue((Object)awardObject, (String)field.getName());
        if (awardObjectList != null && awardObjectList.size() != 0) {
            Method templateIsInScopeMethod = this.findIsInScopeMethodForClass(field.getAnnotation(AwardSyncableList.class).syncClass());
            for (Object awardListObject : awardObjectList) {
                if (!((Boolean)templateIsInScopeMethod.invoke(null, new Object[]{awardListObject, scopes})).booleanValue()) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    protected void syncListObjects(Object awardObject, List<Object> listObject, Field field, AwardTemplateSyncScope[] scopes, Stack<AwardTemplateSyncScope[]> scopeStack, Award award, AwardTemplate awardTemplate) throws Exception {
        AwardSyncableList awardSyncableList = field.getAnnotation(AwardSyncableList.class);
        String parentPropertyName = awardSyncableList.parentPropertyName();
        Method templateIsInScopeMethod = this.findIsInScopeMethodForClass(awardSyncableList.syncSourceClass());
        Method awardIsInScopeMethod = this.findIsInScopeMethodForClass(awardSyncableList.syncClass());
        ArrayList<Object> newObjectList = new ArrayList<Object>(listObject.size());
        Method createNewListElementMethod = this.getCreateNewListElementMethod(awardSyncableList.syncSourceClass());
        HashMap<Object, Object> syncdMap = new HashMap<Object, Object>();
        for (Object awardTemplateObject : listObject) {
            if (!((Boolean)templateIsInScopeMethod.invoke(null, new Object[]{awardTemplateObject, scopes})).booleanValue()) continue;
            Object newObjectToSync = createNewListElementMethod.invoke((Object)this, awardTemplateObject, awardSyncableList.syncClass(), award, awardTemplate, true);
            this.sync(awardTemplateObject, newObjectToSync, scopes, scopeStack, award, awardTemplate);
            ObjectUtils.setObjectProperty((Object)newObjectToSync, (String)parentPropertyName, (Object)awardObject);
            newObjectList.add(newObjectToSync);
            syncdMap.put(awardTemplateObject, newObjectToSync);
        }
        ArrayList newAwardList = new ArrayList();
        List awardList = (List)ObjectUtils.getPropertyValue((Object)awardObject, (String)field.getName());
        for (Object aObject : awardList) {
            Boolean isInScope = (Boolean)awardIsInScopeMethod.invoke(null, new Object[]{aObject, scopes});
            if (!isInScope.booleanValue()) {
                newAwardList.add(aObject);
                continue;
            }
            if (!isInScope.booleanValue() || awardSyncableList.removeMissingListElementsFromTarget()) continue;
            if (aObject instanceof AwardComment) {
                if (this.findSourceListElementFromTarget((AwardComment)aObject, syncdMap, award, awardTemplate) != null) continue;
                newAwardList.add(this.clearListElement((AwardComment)aObject, awardSyncableList.syncClass(), award, awardTemplate));
                continue;
            }
            if (aObject == null) continue;
            throw new RuntimeException(aObject.getClass().getName() + " is not supported");
        }
        newObjectList.addAll(newAwardList);
        ObjectUtils.setObjectProperty((Object)awardObject, (String)field.getName(), newObjectList);
    }

    protected Method getCreateNewListElementMethod(Class syncSourceClass) {
        try {
            Method m = AwardTemplateSyncServiceImpl.class.getDeclaredMethod("getOrCreateNewListElementObject", syncSourceClass, Class.class, Award.class, AwardTemplate.class, Boolean.TYPE);
            m.setAccessible(true);
            return m;
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("Could not find specific getOrCreateNewListElementObject for class %s, using generic method.", syncSourceClass));
            }
            try {
                Method m = AwardTemplateSyncServiceImpl.class.getDeclaredMethod("getOrCreateNewListElementObject", Object.class, Class.class, Award.class, AwardTemplate.class, Boolean.TYPE);
                m.setAccessible(true);
                return m;
            }
            catch (Exception e2) {
                throw new IllegalStateException("Could not find generic getOrCreateNewListElementObject, this should never happen.", e2);
            }
        }
    }

    protected Object getOrCreateNewListElementObject(Object sourceObject, Class syncClass, Award award, AwardTemplate awardTemplate, boolean createNew) {
        return createNew ? ObjectUtils.createNewObjectFromClass((Class)syncClass) : null;
    }

    protected AwardComment getOrCreateNewListElementObject(AwardTemplateComment sourceComment, Class syncClass, Award award, AwardTemplate awardTemplate, boolean createNew) {
        AwardComment comment = award.getAwardCommentByType(sourceComment.getCommentTypeCode(), sourceComment.getChecklistPrintFlag(), createNew);
        return comment;
    }

    protected AwardComment clearListElement(AwardComment comment, Class syncClass, Award award, AwardTemplate awardTemplate) {
        comment.setComments(null);
        return comment;
    }

    protected AwardTemplateComment findSourceListElementFromTarget(AwardComment comment, Map<Object, Object> sourceToTargetMap, Award award, AwardTemplate awardTemplate) {
        AwardTemplateComment result = null;
        if (sourceToTargetMap != null && sourceToTargetMap.values() != null) {
            for (Object tc : sourceToTargetMap.keySet()) {
                AwardTemplateComment templateComment = (AwardTemplateComment)tc;
                if (!StringUtils.equals((CharSequence)templateComment.getCommentTypeCode(), (CharSequence)comment.getCommentTypeCode()) || templateComment.getCommentTypeCode() == null) continue;
                result = templateComment;
                break;
            }
        }
        return result;
    }

    protected AwardSponsorTerm getOrCreateNewListElementObject(AwardTemplateTerm sponsorTerm, Class syncClass, Award award, AwardTemplate awardTemplate, boolean createNew) {
        AwardSponsorTerm term = award.getAwardSponsorTermByTemplateTerm(sponsorTerm, createNew);
        return term;
    }

    protected AwardReportTermRecipient getOrCreateNewListElementObject(AwardTemplateReportTermRecipient recipient, Class syncClass, Award award, AwardTemplate awardTemplate, boolean createNew) {
        AwardReportTermRecipient newRecipient = new AwardReportTermRecipient();
        recipient.refreshReferenceObject("rolodex");
        recipient.refreshReferenceObject("contactType");
        newRecipient.setContactType(recipient.getContactType());
        newRecipient.setNumberOfCopies(recipient.getNumberOfCopies());
        newRecipient.setRolodex(recipient.getRolodex());
        newRecipient.setRolodexId(recipient.getRolodexId());
        newRecipient.setContactTypeCode(recipient.getContactTypeCode());
        return newRecipient;
    }

    protected Method findIsInScopeMethodForClass(Class clazz) {
        Class<AwardTemplateSyncScope> klass = AwardTemplateSyncScope.class;
        Method result = null;
        try {
            result = klass.getMethod("isInScope", Object.class, AwardTemplateSyncScope[].class);
        }
        catch (Exception e1) {
            throw new IllegalStateException("FATAL: Cannot find method isInScope( Object,AwardTemplateSyncScope[]) on the AwardTemplateSyncScope class.  This should never happen.");
        }
        try {
            result = klass.getMethod("isInScope", clazz, AwardTemplateSyncScope[].class);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    protected AwardTemplate fetchAwardTemplate(Award award) {
        award.refreshReferenceObject("awardTemplate");
        AwardTemplate awardTemplate = award.getAwardTemplate();
        if (awardTemplate == null && award.getTemplateCode() != null) {
            HashMap<String, Integer> primaryKeys = new HashMap<String, Integer>();
            primaryKeys.put("templateCode", award.getTemplateCode());
            awardTemplate = (AwardTemplate)this.businessObjectService.findByPrimaryKey(AwardTemplate.class, primaryKeys);
        }
        return awardTemplate;
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public KualiRuleService getKualiRuleService() {
        return this.kualiRuleService;
    }

    public void setKualiRuleService(KualiRuleService kualiRuleService) {
        this.kualiRuleService = kualiRuleService;
    }

    public static final String scopesArrayToDelimitedList(AwardTemplateSyncScope[] scopes) {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < scopes.length; ++i) {
            result.append(scopes[i].toString());
            if (i >= scopes.length - 1) continue;
            result.append(",");
        }
        return result.toString();
    }
}

