/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.version.service.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.ojb.broker.query.Criteria;
import org.apache.ojb.broker.query.Query;
import org.apache.ojb.broker.query.QueryByCriteria;
import org.apache.ojb.broker.query.QueryFactory;
import org.kuali.coeus.common.framework.version.VersionStatus;
import org.kuali.coeus.common.framework.version.history.VersionHistory;
import org.kuali.coeus.common.framework.version.history.VersionHistoryService;
import org.kuali.coeus.sys.framework.gv.GlobalVariableService;
import org.kuali.kra.award.document.AwardDocument;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.award.home.AwardService;
import org.kuali.kra.award.paymentreports.awardreports.reporting.ReportTracking;
import org.kuali.kra.award.version.service.AwardVersionService;
import org.kuali.rice.core.framework.persistence.ojb.dao.PlatformAwareDaoBaseOjb;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.service.DocumentService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class AwardVersionServiceImpl
extends PlatformAwareDaoBaseOjb
implements AwardVersionService {
    private static final String AWARD_AMOUNT_INFOS = "awardAmountInfos";
    private static final String AWARD_SEQUENCE_STATUS = "awardSequenceStatus";
    private static final String AWARD_NUMBER = "awardNumber";
    @Autowired
    @Qualifier(value="versionHistoryService")
    private VersionHistoryService versionHistoryService;
    @Autowired
    @Qualifier(value="businessObjectService")
    private BusinessObjectService businessObjectService;
    @Autowired
    @Qualifier(value="documentService")
    private DocumentService documentService;
    @Autowired
    @Qualifier(value="awardService")
    private AwardService awardService;
    @Autowired
    @Qualifier(value="globalVariableService")
    private GlobalVariableService globalVariableService;

    @Override
    public Award getWorkingAwardVersion(String awardNumber) {
        HashMap<String, String> values = new HashMap<String, String>();
        values.put(AWARD_NUMBER, awardNumber);
        values.put(AWARD_SEQUENCE_STATUS, VersionStatus.ACTIVE.toString());
        Award award = this.getBusinessObjectService().findMatching(Award.class, values).stream().findFirst().orElse(null);
        if (award == null) {
            values.put(AWARD_SEQUENCE_STATUS, VersionStatus.PENDING.toString());
            award = this.getBusinessObjectService().findMatching(Award.class, values).stream().findFirst().orElse(null);
        }
        return award;
    }

    @Override
    public List<Award> getAllActiveAwardsForHierarchy(String awardNumber) {
        QueryByCriteria queryCrit = this.getQueryForAwardHierarchyByStatus(awardNumber, VersionStatus.ACTIVE.toString());
        queryCrit.addPrefetchedRelationship(AWARD_AMOUNT_INFOS);
        return new ArrayList<Award>(this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)queryCrit));
    }

    QueryByCriteria getQueryForAwardHierarchyByStatus(String awardNumber, String status) {
        Criteria crit = new Criteria();
        crit.addLike((Object)AWARD_NUMBER, (Object)(awardNumber.substring(0, 6) + "%"));
        crit.addEqualTo(AWARD_SEQUENCE_STATUS, (Object)status);
        QueryByCriteria queryCrit = QueryFactory.newQuery(Award.class, (Criteria)crit);
        return queryCrit;
    }

    @Override
    public Award getActiveAwardVersion(String awardNumber) {
        List<VersionHistory> versions = this.versionHistoryService.findVersionHistory(Award.class, awardNumber);
        VersionHistory result = this.getActiveVersionHistory(versions);
        return result == null ? null : (Award)result.getSequenceOwner();
    }

    @Override
    public Award getPendingAwardVersion(String awardNumber) {
        List<VersionHistory> versions = this.versionHistoryService.findVersionHistory(Award.class, awardNumber);
        VersionHistory result = this.getPendingVersionHistory(versions);
        return result == null ? null : (Award)result.getSequenceOwner();
    }

    @Override
    public AwardDocument createAndSaveNewAwardVersion(AwardDocument awardDocument) throws Exception {
        awardDocument.getAward().setNewVersion(true);
        this.refreshAwardReportTrackingRelationships(awardDocument.getAward());
        AwardDocument newAwardDocument = this.awardService.createNewAwardVersion(awardDocument);
        this.documentService.saveDocument((Document)newAwardDocument);
        this.versionAwardReportTracking(newAwardDocument.getAward());
        this.awardService.updateAwardSequenceStatus(newAwardDocument.getAward(), VersionStatus.PENDING);
        this.getVersionHistoryService().updateVersionHistory(newAwardDocument.getAward(), VersionStatus.PENDING, this.globalVariableService.getUserSession().getPrincipalName());
        return newAwardDocument;
    }

    private void refreshAwardReportTrackingRelationships(Award award) {
        award.getAwardReportTermItems().forEach(item -> {
            Map<String, Long> params = Collections.singletonMap("awardReportTermId", item.getAwardReportTermId());
            item.setReportTrackings(new ArrayList<ReportTracking>(this.getBusinessObjectService().findMatching(ReportTracking.class, params)));
        });
    }

    private void versionAwardReportTracking(Award newAwardVersion) {
        newAwardVersion.getAwardReportTermItems().forEach(awardReportTerm -> {
            awardReportTerm.getReportTrackings().forEach(reportTracking -> {
                reportTracking.setAwardReportTrackingId(null);
                reportTracking.setAwardReportTermId(awardReportTerm.getAwardReportTermId());
                reportTracking.setAwardId(newAwardVersion.getAwardId());
            });
            this.getBusinessObjectService().save(awardReportTerm.getReportTrackings());
        });
    }

    private VersionHistory getPendingVersionHistory(List<VersionHistory> list) {
        VersionHistory returnVal = null;
        for (VersionHistory vh : list) {
            if (!vh.getStatus().equals((Object)VersionStatus.PENDING)) continue;
            returnVal = vh;
        }
        return returnVal;
    }

    private VersionHistory getActiveVersionHistory(List<VersionHistory> list) {
        VersionHistory returnVal = null;
        for (VersionHistory vh : list) {
            if (!vh.getStatus().equals((Object)VersionStatus.ACTIVE)) continue;
            returnVal = vh;
        }
        return returnVal;
    }

    @Override
    public boolean isPendingAwardInAwardHierarchy(String awardNumber) {
        return this.getPersistenceBrokerTemplate().getCount((Query)this.getQueryForAwardHierarchyByStatus(awardNumber, VersionStatus.PENDING.toString())) != 0;
    }

    @Override
    public boolean isActiveAwardInAwardHierarchy(String awardNumber) {
        return this.getPersistenceBrokerTemplate().getCount((Query)this.getQueryForAwardHierarchyByStatus(awardNumber, VersionStatus.ACTIVE.toString())) != 0;
    }

    public VersionHistoryService getVersionHistoryService() {
        return this.versionHistoryService;
    }

    public void setVersionHistoryService(VersionHistoryService versionHistoryService) {
        this.versionHistoryService = versionHistoryService;
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }
}

