/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.committee.print;

import edu.mit.irb.irbnamespace.InvestigatorDocument;
import edu.mit.irb.irbnamespace.PersonDocument;
import edu.mit.irb.irbnamespace.ProtocolMasterDataDocument;
import edu.mit.irb.irbnamespace.ProtocolReviewerDocument;
import edu.mit.irb.irbnamespace.ProtocolSubmissionDocument;
import edu.mit.irb.irbnamespace.ProtocolSummaryDocument;
import edu.mit.irb.irbnamespace.ScheduleDocument;
import edu.mit.irb.irbnamespace.ScheduleMasterDataDocument;
import edu.mit.irb.irbnamespace.SubmissionDetailsDocument;
import java.math.BigInteger;
import java.sql.Date;
import java.text.ParseException;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.common.committee.impl.bo.CommitteeMembershipBase;
import org.kuali.coeus.common.committee.impl.meeting.CommScheduleActItemBase;
import org.kuali.coeus.common.committee.impl.meeting.CommitteeScheduleAttendanceBase;
import org.kuali.coeus.common.framework.print.stream.xml.PrintBaseXmlStream;
import org.kuali.coeus.common.framework.rolodex.Rolodex;
import org.kuali.coeus.common.framework.sponsor.Sponsor;
import org.kuali.coeus.common.framework.unit.Unit;
import org.kuali.coeus.sys.framework.model.KcPersistableBusinessObjectBase;
import org.kuali.kra.committee.bo.CommitteeSchedule;
import org.kuali.kra.committee.print.IrbPrintXmlUtilService;
import org.kuali.kra.committee.service.CommitteeMembershipService;
import org.kuali.kra.irb.Protocol;
import org.kuali.kra.irb.actions.ProtocolAction;
import org.kuali.kra.irb.actions.risklevel.ProtocolRiskLevel;
import org.kuali.kra.irb.actions.submit.ProtocolExemptStudiesCheckListItem;
import org.kuali.kra.irb.actions.submit.ProtocolExpeditedReviewCheckListItem;
import org.kuali.kra.irb.actions.submit.ProtocolSubmissionLite;
import org.kuali.kra.irb.personnel.ProtocolPerson;
import org.kuali.kra.irb.personnel.ProtocolPersonRolodex;
import org.kuali.kra.protocol.actions.ProtocolActionBase;
import org.kuali.kra.protocol.actions.submit.ProtocolReviewer;
import org.kuali.kra.protocol.actions.submit.ProtocolSubmissionLiteBase;
import org.kuali.kra.protocol.personnel.ProtocolPersonBase;
import org.kuali.kra.protocol.protocol.funding.ProtocolFundingSourceBase;

public class ScheduleXmlStream
extends PrintBaseXmlStream<ScheduleDocument> {
    private static final Logger LOG = LogManager.getLogger(ScheduleXmlStream.class);
    private static final String SCHEDULE = "Schedule";
    private static final String PROTOCOL_SUBMISSIONS = "protocolSubmissions";
    private static final String SUBMISSION_ID_FK = "submissionIdFk";
    private static final String COMMITTEE_ID_FK = "committeeIdFk";
    private static final String SCHEDULED_DATE = "scheduledDate";
    private static final String PROTOCOL_ID = "protocolId";
    private CommitteeMembershipService committeeMembershipService;
    private IrbPrintXmlUtilService irbPrintXmlUtilService;

    @Override
    public Class<ScheduleDocument> type() {
        return ScheduleDocument.class;
    }

    @Override
    public Map<String, ScheduleDocument> generateXmlStream(KcPersistableBusinessObjectBase printableBusinessObject, Map<String, Object> reportParameters) {
        CommitteeSchedule committeeSchedule = (CommitteeSchedule)printableBusinessObject;
        LinkedHashMap<String, ScheduleDocument> xmlObjectList = new LinkedHashMap<String, ScheduleDocument>();
        ScheduleDocument scheduleDocument = ScheduleDocument.Factory.newInstance();
        scheduleDocument.setSchedule(this.getSchedule(committeeSchedule));
        xmlObjectList.put(SCHEDULE, scheduleDocument);
        return xmlObjectList;
    }

    public ScheduleDocument.Schedule getSchedule(CommitteeSchedule committeeSchedule) {
        ScheduleDocument.Schedule schedule = ScheduleDocument.Schedule.Factory.newInstance();
        this.setScheduleMasterData(committeeSchedule, schedule.addNewScheduleMasterData());
        ScheduleDocument.Schedule.PreviousSchedule prevSchedule = schedule.addNewPreviousSchedule();
        this.setPreviousSchedule(committeeSchedule, prevSchedule.addNewScheduleMasterData());
        ScheduleDocument.Schedule.NextSchedule nextScheduleType = schedule.addNewNextSchedule();
        this.setNextSchedule(committeeSchedule, nextScheduleType.addNewScheduleMasterData());
        this.getIrbPrintXmlUtilService().setMinutes(committeeSchedule, schedule);
        this.setAttendance(committeeSchedule, schedule);
        committeeSchedule.refreshReferenceObject(PROTOCOL_SUBMISSIONS);
        committeeSchedule.getLatestProtocolSubmissions().stream().sorted(Comparator.comparing(ProtocolSubmissionLiteBase::getProtocolReviewTypeCode).thenComparing(ProtocolSubmissionLiteBase::getSubmissionTypeCode).thenComparing(ProtocolSubmissionLiteBase::getProtocolNumber)).forEach(protocolSubmission -> {
            ProtocolSubmissionDocument.ProtocolSubmission protocolSubmissionType = schedule.addNewProtocolSubmission();
            SubmissionDetailsDocument.SubmissionDetails protocolSubmissionDetail = protocolSubmissionType.addNewSubmissionDetails();
            ProtocolSummaryDocument.ProtocolSummary protocolSummary = protocolSubmissionType.addNewProtocolSummary();
            ProtocolMasterDataDocument.ProtocolMasterData protocolMaster = protocolSummary.addNewProtocolMasterData();
            Protocol protocol = (Protocol)this.getBusinessObjectService().findByPrimaryKey(Protocol.class, Collections.singletonMap(PROTOCOL_ID, protocolSubmission.getProtocolId()));
            protocolMaster.setProtocolNumber(protocol.getProtocolNumber());
            protocolMaster.setSequenceNumber(new BigInteger(String.valueOf(protocol.getSequenceNumber())));
            protocolMaster.setProtocolTitle(protocol.getTitle());
            protocolMaster.setProtocolStatusCode(new BigInteger(String.valueOf(protocol.getProtocolStatusCode())));
            protocolMaster.setProtocolStatusDesc(protocol.getProtocolStatus().getDescription());
            protocolMaster.setProtocolTypeCode(new BigInteger(String.valueOf(protocol.getProtocolTypeCode())));
            protocolMaster.setProtocolTypeDesc(protocol.getProtocolType().getDescription());
            if (protocol.getDescription() != null) {
                protocolMaster.setProtocolDescription(protocol.getDescription());
            }
            if (protocol.getApprovalDate() != null) {
                protocolMaster.setApprovalDate(this.getDateTimeService().getCalendar((java.util.Date)protocol.getApprovalDate()));
            }
            if (protocol.getExpirationDate() != null) {
                protocolMaster.setExpirationDate(this.getDateTimeService().getCalendar((java.util.Date)protocol.getExpirationDate()));
            }
            if (protocol.getFdaApplicationNumber() != null) {
                protocolMaster.setFdaApplicationNumber(protocol.getFdaApplicationNumber());
            }
            if (protocol.getReferenceNumber1() != null) {
                protocolMaster.setRefNumber1(protocol.getReferenceNumber1());
            }
            if (protocol.getReferenceNumber2() != null) {
                protocolMaster.setRefNumber2(protocol.getReferenceNumber2());
            }
            protocolSubmissionDetail.setProtocolNumber(protocolSubmission.getProtocolNumber());
            if (protocolSubmission.getProtocolSubmissionType() != null) {
                protocolSubmissionDetail.setSubmissionTypeDesc(protocolSubmission.getProtocolSubmissionType().getDescription());
            }
            if (protocolSubmission.getProtocolReviewTypeCode() != null) {
                protocolSubmissionDetail.setProtocolReviewTypeCode(new BigInteger(protocolSubmission.getProtocolReviewTypeCode()));
            }
            if (protocolSubmission.getProtocolReviewType() != null) {
                protocolSubmissionDetail.setProtocolReviewTypeDesc(protocolSubmission.getProtocolReviewType().getDescription());
            }
            if (protocolSubmission.getSubmissionTypeCode() != null) {
                protocolSubmissionDetail.setSubmissionTypeCode(new BigInteger(protocolSubmission.getSubmissionTypeCode()));
            }
            if (protocolSubmission.getProtocolSubmissionType() != null) {
                protocolSubmissionDetail.setSubmissionTypeDesc(protocolSubmission.getProtocolSubmissionType().getDescription());
            }
            if (protocolSubmission.getSubmissionNumber() != null) {
                protocolSubmissionDetail.setSubmissionNumber(new BigInteger(String.valueOf(protocolSubmission.getSubmissionNumber())));
            }
            if (protocolSubmission.getSubmissionStatusCode() != null) {
                protocolSubmissionDetail.setSubmissionStatusCode(new BigInteger(protocolSubmission.getSubmissionStatusCode()));
            }
            if (protocolSubmission.getSubmissionStatus() != null) {
                protocolSubmissionDetail.setSubmissionStatusDesc(protocolSubmission.getSubmissionStatus().getDescription());
            }
            if (protocolSubmission.getSubmissionTypeQualifierCode() != null) {
                protocolSubmissionDetail.setSubmissionTypeQualifierCode(new BigInteger(protocolSubmission.getSubmissionTypeQualifierCode()));
            }
            if (protocolSubmission.getProtocolSubmissionQualifierType() != null) {
                protocolSubmissionDetail.setSubmissionTypeQualifierDesc(protocolSubmission.getProtocolSubmissionQualifierType().getDescription());
            }
            if (protocolSubmission.getYesVoteCount() != null) {
                protocolSubmissionDetail.setYesVote(BigInteger.valueOf(protocolSubmission.getYesVoteCount().intValue()));
            } else {
                protocolSubmissionDetail.setYesVote(BigInteger.ZERO);
            }
            if (protocolSubmission.getNoVoteCount() != null) {
                protocolSubmissionDetail.setNoVote(BigInteger.valueOf(protocolSubmission.getNoVoteCount().intValue()));
            } else {
                protocolSubmissionDetail.setNoVote(BigInteger.ZERO);
            }
            if (protocolSubmission.getAbstainerCount() != null) {
                protocolSubmissionDetail.setAbstainerCount(BigInteger.valueOf(protocolSubmission.getAbstainerCount().intValue()));
            } else {
                protocolSubmissionDetail.setAbstainerCount(BigInteger.ZERO);
            }
            protocolSubmissionDetail.setVotingComments(protocolSubmission.getVotingComments());
            this.setProtocolSubmissionAction((ProtocolSubmissionLite)protocolSubmission, protocol, protocolSubmissionDetail);
            if (protocolSubmission.getSubmissionDate() != null) {
                protocolSubmissionDetail.setSubmissionDate(this.getDateTimeService().getCalendar((java.util.Date)protocolSubmission.getSubmissionDate()));
            }
            this.setSubmissionCheckListinfo((ProtocolSubmissionLite)protocolSubmission, protocolSubmissionDetail);
            this.setProtocolSubmissionReviewers((ProtocolSubmissionLite)protocolSubmission, protocolSubmissionDetail);
            List<ProtocolPersonBase> protocolPersons = protocol.getProtocolPersons();
            for (ProtocolPersonBase protocolPersonBase : protocolPersons) {
                if (!protocolPersonBase.getProtocolPersonRoleId().equals("PI") && !protocolPersonBase.getProtocolPersonRoleId().equals("COI")) continue;
                InvestigatorDocument.Investigator investigator = protocolSummary.addNewInvestigator();
                this.getIrbPrintXmlUtilService().setPersonRolodexType((ProtocolPerson)protocolPersonBase, investigator.addNewPerson());
                if (!protocolPersonBase.getProtocolPersonRoleId().equals("PI")) continue;
                investigator.setPIFlag(true);
            }
            List<ProtocolRiskLevel> cvRiskLevels = protocol.getProtocolRiskLevels();
            for (ProtocolRiskLevel protocolRiskLevelBean : cvRiskLevels) {
                ProtocolSummaryDocument.ProtocolSummary.RiskLevels riskLevelType = protocolSummary.addNewRiskLevels();
                riskLevelType.setRiskLevelDescription(protocolRiskLevelBean.getRiskLevel().getDescription());
                riskLevelType.setComments(protocolRiskLevelBean.getComments());
            }
            List<ProtocolFundingSourceBase> list = protocol.getProtocolFundingSources();
            for (ProtocolFundingSourceBase protocolFundingSourceBean : list) {
                protocolFundingSourceBean.refreshNonUpdateableReferences();
                ProtocolSummaryDocument.ProtocolSummary.FundingSource fundingSource = protocolSummary.addNewFundingSource();
                String fundingSourceCode = protocolFundingSourceBean.getFundingSourceNumber();
                int fundingSourceTypeCode = Integer.valueOf(protocolFundingSourceBean.getFundingSourceTypeCode());
                String fundingSourceName = this.getFundingSourceNameForType(fundingSourceTypeCode, fundingSourceCode);
                fundingSource.setFundingSourceName(fundingSourceName);
                if (protocolFundingSourceBean.getFundingSourceType() == null) continue;
                fundingSource.setTypeOfFundingSource(protocolFundingSourceBean.getFundingSourceType().getDescription());
            }
            this.getIrbPrintXmlUtilService().setProcotolMinutes(committeeSchedule, (ProtocolSubmissionLite)protocolSubmission, protocolSubmissionType);
        });
        this.setOtherActionItems(committeeSchedule, schedule);
        return schedule;
    }

    private void setProtocolSubmissionAction(ProtocolSubmissionLite protocolSubmission, Protocol protocol, SubmissionDetailsDocument.SubmissionDetails protocolSubmissionDetail) {
        ProtocolAction protcolAction = this.findProtocolActionForSubmission(protocolSubmission, protocol);
        if (protcolAction != null) {
            protcolAction.refreshNonUpdateableReferences();
            SubmissionDetailsDocument.SubmissionDetails.ActionType actionTypeInfo = protocolSubmissionDetail.addNewActionType();
            actionTypeInfo.setActionId(BigInteger.valueOf(protcolAction.getActionId().intValue()));
            if (protcolAction.getProtocolActionTypeCode() != null) {
                actionTypeInfo.setActionTypeCode(new BigInteger(protcolAction.getProtocolActionTypeCode()));
                actionTypeInfo.setActionTypeDescription(protcolAction.getProtocolActionType().getDescription());
            }
            if (protcolAction.getActionDate() != null) {
                actionTypeInfo.setActionDate(this.getDateTimeService().getCalendar((java.util.Date)protcolAction.getActionDate()));
            }
            actionTypeInfo.setActionComments(protcolAction.getComments());
        }
    }

    private void setOtherActionItems(CommitteeSchedule committeeSchedule, ScheduleDocument.Schedule schedule) {
        List<CommScheduleActItemBase> otherActions = committeeSchedule.getCommScheduleActItems();
        for (CommScheduleActItemBase otherActionInfoBean : otherActions) {
            otherActionInfoBean.refreshNonUpdateableReferences();
            ScheduleDocument.Schedule.OtherBusiness otherBusinessType = schedule.addNewOtherBusiness();
            otherBusinessType.setActionItemNumber(BigInteger.valueOf(otherActionInfoBean.getActionItemNumber().intValue()));
            otherBusinessType.setActionItemDesc(otherActionInfoBean.getItemDescription());
            if (otherActionInfoBean.getScheduleActItemType() == null) continue;
            otherBusinessType.setActionItemCode(new BigInteger(otherActionInfoBean.getScheduleActItemTypeCode()));
            otherBusinessType.setActionItemCodeDesc(otherActionInfoBean.getScheduleActItemType().getDescription());
        }
    }

    private String getFundingSourceNameForType(int sourceType, String sourceCode) {
        String name = null;
        if (sourceType == 1) {
            Sponsor sponsor = (Sponsor)this.getBusinessObjectService().findBySinglePrimaryKey(Sponsor.class, (Object)sourceCode);
            if (sponsor != null) {
                name = sponsor.getSponsorName();
            }
        } else if (sourceType == 2) {
            Unit unit = (Unit)this.getBusinessObjectService().findBySinglePrimaryKey(Unit.class, (Object)sourceCode);
            if (unit != null) {
                name = unit.getUnitName();
            }
        } else {
            name = sourceCode;
        }
        return name;
    }

    private void setProtocolSubmissionReviewers(ProtocolSubmissionLite protocolSubmission, SubmissionDetailsDocument.SubmissionDetails protocolSubmissionDetail) {
        Collection vecReviewers = this.getBusinessObjectService().findMatching(org.kuali.kra.irb.actions.submit.ProtocolReviewer.class, Collections.singletonMap(SUBMISSION_ID_FK, protocolSubmission.getSubmissionId()));
        for (ProtocolReviewer protocolReviewer : vecReviewers) {
            protocolReviewer.refreshNonUpdateableReferences();
            ProtocolReviewerDocument.ProtocolReviewer protocolReviewerType = protocolSubmissionDetail.addNewProtocolReviewer();
            this.setPerson((org.kuali.kra.irb.actions.submit.ProtocolReviewer)protocolReviewer, protocolReviewerType);
            protocolReviewerType.setReviewerTypeDesc(protocolReviewer.getProtocolReviewerType().getDescription());
            protocolReviewerType.setReviewerTypeCode(new BigInteger(String.valueOf(protocolReviewer.getReviewerTypeCode())));
        }
    }

    private void setPerson(org.kuali.kra.irb.actions.submit.ProtocolReviewer protocolReviewer, ProtocolReviewerDocument.ProtocolReviewer protocolReviewerType) {
        PersonDocument.Person personType = protocolReviewerType.addNewPerson();
        boolean nonEmployeeFlag = protocolReviewer.getNonEmployeeFlag();
        if (!nonEmployeeFlag) {
            this.getIrbPrintXmlUtilService().setPersonXml(protocolReviewer.getPerson(), personType);
        } else {
            Rolodex rolodex = protocolReviewer.getRolodex();
            ProtocolPersonRolodex protocolRolodex = (ProtocolPersonRolodex)this.getBusinessObjectService().findBySinglePrimaryKey(ProtocolPersonRolodex.class, (Object)rolodex.getRolodexId());
            this.getIrbPrintXmlUtilService().setPersonXml(protocolRolodex, personType);
        }
    }

    private void setSubmissionCheckListinfo(ProtocolSubmissionLite protocolSubmission, SubmissionDetailsDocument.SubmissionDetails protocolSubmissionDetail) {
        SubmissionDetailsDocument.SubmissionDetails.SubmissionChecklistInfo submissionChecklistInfo = protocolSubmissionDetail.addNewSubmissionChecklistInfo();
        StringBuilder formattedCode = new StringBuilder();
        Collection protocolExemptCheckList = this.getBusinessObjectService().findMatching(ProtocolExemptStudiesCheckListItem.class, Collections.singletonMap(SUBMISSION_ID_FK, protocolSubmission.getSubmissionId()));
        for (ProtocolExemptStudiesCheckListItem protocolExemptStudiesCheckListBean : protocolExemptCheckList) {
            SubmissionDetailsDocument.SubmissionDetails.SubmissionChecklistInfo.Checklists checkListItem = submissionChecklistInfo.addNewChecklists();
            checkListItem.setChecklistCode(protocolExemptStudiesCheckListBean.getExemptStudiesCheckListCode());
            checkListItem.setChecklistDescription(protocolExemptStudiesCheckListBean.getExemptStudiesCheckListItem().getDescription());
            formattedCode.append("(").append(protocolExemptStudiesCheckListBean.getExemptStudiesCheckListCode()).append(") ");
        }
        if (formattedCode.length() > 0) {
            submissionChecklistInfo.setChecklistCodesFormatted(formattedCode.toString());
        }
        Collection vecExpeditedCheckList = this.getBusinessObjectService().findMatching(ProtocolExpeditedReviewCheckListItem.class, Collections.singletonMap(SUBMISSION_ID_FK, protocolSubmission.getSubmissionId()));
        for (ProtocolExpeditedReviewCheckListItem protocolReviewTypeCheckListBean : vecExpeditedCheckList) {
            SubmissionDetailsDocument.SubmissionDetails.SubmissionChecklistInfo.Checklists checkListItem = submissionChecklistInfo.addNewChecklists();
            checkListItem.setChecklistCode(protocolReviewTypeCheckListBean.getExpeditedReviewCheckListCode());
            checkListItem.setChecklistDescription(protocolReviewTypeCheckListBean.getExpeditedReviewCheckListItem().getDescription());
            formattedCode.append("(").append(protocolReviewTypeCheckListBean.getExpeditedReviewCheckListCode()).append(") ");
        }
        if (formattedCode.length() > 0) {
            submissionChecklistInfo.setChecklistCodesFormatted(formattedCode.toString());
        }
    }

    private ProtocolAction findProtocolActionForSubmission(ProtocolSubmissionLite protocolSubmission, Protocol protocol) {
        List<ProtocolActionBase> protocolActions = protocol.getProtocolActions();
        for (ProtocolActionBase protocolAction : protocolActions) {
            if (protocolAction.getSubmissionNumber() == null || !protocolAction.getSubmissionNumber().equals(protocolSubmission.getSubmissionNumber())) continue;
            return (ProtocolAction)protocolAction;
        }
        return null;
    }

    private void setAttendance(CommitteeSchedule committeeSchedule, ScheduleDocument.Schedule schedule) {
        List<CommitteeScheduleAttendanceBase> attendenceList = committeeSchedule.getCommitteeScheduleAttendances();
        for (CommitteeScheduleAttendanceBase attendanceInfoBean : attendenceList) {
            ScheduleDocument.Schedule.Attendents attendents = schedule.addNewAttendents();
            attendents.setAttendentName(attendanceInfoBean.getPersonName());
            attendents.setAlternateFlag(attendanceInfoBean.getAlternateFlag());
            attendents.setGuestFlag(attendanceInfoBean.getGuestFlag());
            attendents.setAlternateFor(attendanceInfoBean.getAlternateFor());
            attendents.setPresentFlag(true);
        }
        List<CommitteeMembershipBase> committeeMemberships = committeeSchedule.getParentCommittee().getCommitteeMemberships();
        committeeMemberships.stream().filter(committeeMembership -> this.isAbsent(attendenceList, (CommitteeMembershipBase)committeeMembership, committeeSchedule.getScheduledDate())).forEach(committeeMembership -> {
            ScheduleDocument.Schedule.Attendents attendents = schedule.addNewAttendents();
            attendents.setAttendentName(committeeMembership.getPersonName());
            attendents.setAlternateFlag(false);
            attendents.setGuestFlag(false);
            attendents.setPresentFlag(false);
        });
    }

    private boolean isAbsent(List<CommitteeScheduleAttendanceBase> attendenceList, CommitteeMembershipBase committeeMembership, Date scheduledDate) {
        return attendenceList.stream().noneMatch(committeeScheduleAttendanceBase -> committeeScheduleAttendanceBase.isCommitteeMember(committeeMembership)) && committeeMembership.isActive(scheduledDate);
    }

    public ScheduleMasterDataDocument.ScheduleMasterData setScheduleMasterData(CommitteeSchedule scheduleDetailsBean, ScheduleMasterDataDocument.ScheduleMasterData currentSchedule) {
        scheduleDetailsBean.refreshNonUpdateableReferences();
        String committeeId = scheduleDetailsBean.getParentCommittee().getCommitteeId();
        currentSchedule.setScheduleId(scheduleDetailsBean.getScheduleId());
        currentSchedule.setCommitteeId(committeeId);
        currentSchedule.setCommitteeName(scheduleDetailsBean.getParentCommittee().getCommitteeName());
        currentSchedule.setScheduleStatusCode(BigInteger.valueOf(scheduleDetailsBean.getScheduleStatusCode().intValue()));
        currentSchedule.setScheduleStatusDesc(scheduleDetailsBean.getScheduleStatus().getDescription());
        if (scheduleDetailsBean.getScheduledDate() != null) {
            currentSchedule.setScheduledDate(this.getDateTimeService().getCalendar((java.util.Date)scheduleDetailsBean.getScheduledDate()));
        } else {
            currentSchedule.setScheduledDate(this.getDateTimeService().getCurrentCalendar());
        }
        try {
            if (scheduleDetailsBean.getTime() != null) {
                Date date = this.getDateTimeService().convertToSqlDate(scheduleDetailsBean.getTime());
                currentSchedule.setScheduledTime(this.getDateTimeService().getCalendar((java.util.Date)date));
            }
            currentSchedule.setPlace(scheduleDetailsBean.getPlace());
            if (scheduleDetailsBean.getProtocolSubDeadline() != null) {
                currentSchedule.setProtocolSubDeadline(this.getDateTimeService().getCalendar((java.util.Date)scheduleDetailsBean.getProtocolSubDeadline()));
            }
            if (scheduleDetailsBean.getMeetingDate() != null) {
                currentSchedule.setMeetingDate(this.getDateTimeService().getCalendar((java.util.Date)scheduleDetailsBean.getMeetingDate()));
            }
            if (scheduleDetailsBean.getStartTime() != null) {
                currentSchedule.setStartTime(this.getDateTimeService().getCalendar((java.util.Date)this.getDateTimeService().convertToSqlDate(scheduleDetailsBean.getStartTime())));
            }
            if (scheduleDetailsBean.getEndTime() != null) {
                currentSchedule.setEndTime(this.getDateTimeService().getCalendar((java.util.Date)this.getDateTimeService().convertToSqlDate(scheduleDetailsBean.getEndTime())));
            }
            if (scheduleDetailsBean.getAgendaProdRevDate() != null) {
                currentSchedule.setAgendaProdRevDate(this.getDateTimeService().getCalendar((java.util.Date)scheduleDetailsBean.getAgendaProdRevDate()));
            }
        }
        catch (ParseException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        currentSchedule.setMaxProtocols(new BigInteger(String.valueOf(scheduleDetailsBean.getMaxProtocols())));
        if (scheduleDetailsBean.getComments() != null) {
            currentSchedule.setComments(scheduleDetailsBean.getComments());
        }
        return currentSchedule;
    }

    public void setNextSchedule(CommitteeSchedule scheduleDetailsBean, ScheduleMasterDataDocument.ScheduleMasterData scheduleMasterData) {
        CommitteeSchedule nextSchedule = this.getNextOrPreviousSchedule(scheduleDetailsBean, true);
        if (nextSchedule != null) {
            this.setScheduleMasterData(nextSchedule, scheduleMasterData);
        }
    }

    public void setPreviousSchedule(CommitteeSchedule scheduleDetailsBean, ScheduleMasterDataDocument.ScheduleMasterData scheduleMasterDataType) {
        CommitteeSchedule prevSchedule = this.getNextOrPreviousSchedule(scheduleDetailsBean, false);
        if (prevSchedule != null) {
            this.setScheduleMasterData(prevSchedule, scheduleMasterDataType);
        }
    }

    private CommitteeSchedule getNextOrPreviousSchedule(CommitteeSchedule scheduleDetailsBean, boolean nextFlag) {
        HashMap<String, String> scheduleParam = new HashMap<String, String>();
        scheduleParam.put(COMMITTEE_ID_FK, scheduleDetailsBean.getParentCommittee().getId().toString());
        List schedules = (List)this.getBusinessObjectService().findMatchingOrderBy(CommitteeSchedule.class, scheduleParam, SCHEDULED_DATE, true);
        if (!schedules.isEmpty()) {
            int size = schedules.size();
            for (int i = 0; i < size; ++i) {
                CommitteeSchedule schedule = (CommitteeSchedule)schedules.get(i);
                if (!schedule.getScheduleId().equals(scheduleDetailsBean.getScheduleId())) continue;
                if (nextFlag && i < size - 1) {
                    return (CommitteeSchedule)schedules.get(i + 1);
                }
                if (!nextFlag && i > 0) {
                    return (CommitteeSchedule)schedules.get(i - 1);
                }
                return null;
            }
        }
        return null;
    }

    public void setCommitteeMembershipService(CommitteeMembershipService committeeMembershipService) {
        this.committeeMembershipService = committeeMembershipService;
    }

    public CommitteeMembershipService getCommitteeMembershipService() {
        return this.committeeMembershipService;
    }

    public IrbPrintXmlUtilService getIrbPrintXmlUtilService() {
        return this.irbPrintXmlUtilService;
    }

    public void setIrbPrintXmlUtilService(IrbPrintXmlUtilService irbPrintXmlUtilService) {
        this.irbPrintXmlUtilService = irbPrintXmlUtilService;
    }
}

