/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.iacuc.actions;

import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.committee.impl.service.CommitteeServiceBase;
import org.kuali.coeus.common.questionnaire.framework.answer.AnswerHeader;
import org.kuali.kra.iacuc.IacucProtocol;
import org.kuali.kra.iacuc.actions.IacucActionHelper;
import org.kuali.kra.iacuc.actions.submit.IacucProtocolSubmission;
import org.kuali.kra.iacuc.committee.service.IacucCommitteeService;
import org.kuali.kra.iacuc.questionnaire.IacucSubmissionQuestionnaireHelper;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.protocol.actions.ProtocolActionBase;
import org.kuali.kra.protocol.questionnaire.ProtocolModuleQuestionnaireBeanBase;
import org.kuali.kra.protocol.questionnaire.ProtocolSubmissionQuestionnaireHelper;

public class IacucProtocolAction
extends ProtocolActionBase {
    private static final String COMMENT_SUBMITTED_TO_IACUC = "SubmittedToIACUC";
    private static final long serialVersionUID = -4895673225969021493L;
    private boolean createdSubmission;

    public IacucProtocolAction() {
    }

    public IacucProtocolAction(IacucProtocol protocol, IacucProtocolSubmission protocolSubmission, String protocolActionTypeCode) {
        super(protocol, protocolSubmission, protocolActionTypeCode);
    }

    public IacucProtocolAction(IacucProtocol protocol, String protocolActionTypeCode) {
        super(protocol, protocolActionTypeCode);
    }

    public void setQuestionnairePrintOptionFromHelper(IacucActionHelper actionHelper) {
        if (this.getSubmissionNumber() != null && !"101".equals(this.getProtocolActionTypeCode())) {
            if (this.getQuestionnaireHelper().getAnswerHeaders().isEmpty()) {
                this.setQuestionnairePrintOption(this.getQnPrintOptionForAction(this.getProtocolNumber(), this.getSubmissionNumber().toString(), "2"));
            }
        } else if ("101".equals(this.getProtocolActionTypeCode()) && COMMENT_SUBMITTED_TO_IACUC.equals(this.getComments())) {
            if (this.getProtocol().isAmendment() || this.getProtocol().isRenewal()) {
                this.setQuestionnairePrintOption(this.getQnPrintOptionForAction(this.getProtocolNumber(), this.getSequenceNumber().toString(), "1"));
            } else {
                this.setQuestionnairePrintOption(this.getQnPrintOptionForAction(this.getProtocolNumber(), this.getInitialSequence(this, ""), "0"));
            }
        } else if ("101".equals(this.getProtocolActionTypeCode()) && StringUtils.isNotBlank((CharSequence)this.getComments()) && (this.getComments().startsWith(COMMENT_PREFIX_AMMENDMENT) || this.getComments().startsWith(COMMENT_PREFIX_RENEWAL) || this.getComments().startsWith(COMMENT_PREFIX_FYI))) {
            String amendmentRenewalNumber = this.getAmendmentRenewalNumber(this.getComments());
            this.setQuestionnairePrintOption(this.getQnPrintOptionForAction(this.getProtocolNumber() + amendmentRenewalNumber, this.getInitialSequence(this, amendmentRenewalNumber), "1"));
        }
    }

    private String getInitialSequence(IacucProtocolAction protocolAction, String amendmentRenewalNumber) {
        HashMap<String, Object> fieldValues = new HashMap<String, Object>();
        fieldValues.put("protocolNumber", protocolAction.getProtocolNumber() + amendmentRenewalNumber);
        if (StringUtils.isBlank((CharSequence)amendmentRenewalNumber)) {
            fieldValues.put("actionId", protocolAction.getActionId().toString());
        } else {
            fieldValues.put("submissionNumber", protocolAction.getSubmissionNumber().toString());
        }
        fieldValues.put("protocolActionTypeCode", "101");
        return ((IacucProtocolAction)((List)this.getBusinessObjectService().findMatchingOrderBy(IacucProtocolAction.class, fieldValues, "protocolActionId", true)).get(0)).getProtocol().getSequenceNumber().toString();
    }

    @Override
    protected String getCoeusModule() {
        return "9";
    }

    public boolean isCreatedSubmission() {
        return this.createdSubmission;
    }

    public void setCreatedSubmission(boolean createdSubmission) {
        this.createdSubmission = createdSubmission;
    }

    @Override
    protected Class<? extends CommitteeServiceBase> getCommitteeServiceClassHook() {
        return IacucCommitteeService.class;
    }

    @Override
    protected ProtocolSubmissionQuestionnaireHelper getProtocolSubmissionQuestionnaireHelperHook(ProtocolBase protocol, String actionTypeCode, String submissionNumber) {
        return new IacucSubmissionQuestionnaireHelper(protocol, actionTypeCode, submissionNumber, true);
    }

    @Override
    public ProtocolSubmissionQuestionnaireHelper getQuestionnaireHelper() {
        IacucSubmissionQuestionnaireHelper questionnaireHelper = (IacucSubmissionQuestionnaireHelper)super.getQuestionnaireHelper();
        if (StringUtils.equals((CharSequence)this.getProtocolActionTypeCode(), (CharSequence)"101")) {
            ProtocolModuleQuestionnaireBeanBase protocolBaseQnBean = questionnaireHelper.getBaseProtocolModuleQuestionnaireBean(this.getSequenceNumber() == null ? null : this.getSequenceNumber().toString());
            List<AnswerHeader> protocolAnswerHeaders = questionnaireHelper.getQuestionnaireAnswerService().getQuestionnaireAnswer(protocolBaseQnBean);
            List<AnswerHeader> submissionAnswerHeaders = questionnaireHelper.getAnswerHeaders();
            submissionAnswerHeaders.addAll(protocolAnswerHeaders);
            questionnaireHelper.setAnswerHeaders(submissionAnswerHeaders);
            questionnaireHelper.resetHeaderLabels();
            this.setQuestionnaireHelper(questionnaireHelper);
        }
        return questionnaireHelper;
    }
}

