/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.negotiations.service;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kra.negotiations.bo.Negotiable;
import org.kuali.kra.negotiations.bo.Negotiation;
import org.kuali.kra.negotiations.bo.NegotiationPersonDTO;
import org.kuali.kra.negotiations.service.NegotiationService;
import org.kuali.rice.core.api.membership.MemberType;
import org.kuali.rice.kim.api.role.RoleMembership;
import org.kuali.rice.kns.kim.role.DerivedRoleTypeServiceBase;

public class NegotiationPersonDerivedRoleTypeServiceImpl
extends DerivedRoleTypeServiceBase {
    private NegotiationService negotiationService;

    public List<RoleMembership> getRoleMembersFromDerivedRole(String namespaceCode, String roleName, Map<String, String> qualification) {
        this.validateRequiredAttributesAgainstReceived(qualification);
        String negotiationId = qualification.get("negotiation");
        ArrayList<RoleMembership> members = new ArrayList<RoleMembership>();
        if (StringUtils.isNotBlank((CharSequence)negotiationId)) {
            Negotiation negotiation = (Negotiation)this.getBusinessObjectService().findBySinglePrimaryKey(Negotiation.class, (Object)negotiationId);
            Negotiable negotiableBo = this.getNegotiationService().getAssociatedObject(negotiation);
            if (negotiableBo != null) {
                List<NegotiationPersonDTO> persons = negotiableBo.getProjectPeople();
                this.filterListByRole(persons, roleName);
                for (NegotiationPersonDTO person : persons) {
                    if (!StringUtils.isNotBlank((CharSequence)person.getPerson().getPersonId())) continue;
                    members.add(RoleMembership.Builder.create(null, null, (String)person.getPerson().getPersonId(), (MemberType)MemberType.PRINCIPAL, null).build());
                }
            }
        }
        return members;
    }

    protected void filterListByRole(List<NegotiationPersonDTO> persons, String roleName) {
        if (StringUtils.equals((CharSequence)roleName, (CharSequence)"PI") || StringUtils.equals((CharSequence)roleName, (CharSequence)"COI") || StringUtils.equals((CharSequence)roleName, (CharSequence)"KP")) {
            Iterator<NegotiationPersonDTO> iter = persons.iterator();
            while (iter.hasNext()) {
                NegotiationPersonDTO person = iter.next();
                if (StringUtils.equals((CharSequence)person.getRoleCode(), (CharSequence)roleName)) continue;
                iter.remove();
            }
        }
    }

    public NegotiationService getNegotiationService() {
        return this.negotiationService;
    }

    public void setNegotiationService(NegotiationService negotiationService) {
        this.negotiationService = negotiationService;
    }

    protected List<String> getRequiredAttributes() {
        ArrayList<String> requiredAttributes = new ArrayList<String>();
        requiredAttributes.add("negotiation");
        return requiredAttributes;
    }

    public boolean dynamicRoleMembership(String namespaceCode, String roleName) {
        return true;
    }
}

