/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.protocol.actions.amendrenew;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.common.questionnaire.framework.answer.AnswerHeader;
import org.kuali.coeus.common.questionnaire.framework.answer.ModuleQuestionnaireBean;
import org.kuali.coeus.common.questionnaire.framework.answer.QuestionnaireAnswerService;
import org.kuali.kra.dao.KraLookupDao;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.protocol.ProtocolDocumentBase;
import org.kuali.kra.protocol.ProtocolFinderDao;
import org.kuali.kra.protocol.ProtocolSpecialVersion;
import org.kuali.kra.protocol.actions.ActionHelperBase;
import org.kuali.kra.protocol.actions.ProtocolActionBase;
import org.kuali.kra.protocol.actions.amendrenew.ProtocolAmendRenewModuleBase;
import org.kuali.kra.protocol.actions.amendrenew.ProtocolAmendRenewService;
import org.kuali.kra.protocol.actions.amendrenew.ProtocolAmendRenewalBase;
import org.kuali.kra.protocol.actions.amendrenew.ProtocolAmendmentBean;
import org.kuali.kra.protocol.actions.copy.ProtocolCopyService;
import org.kuali.kra.protocol.noteattachment.ProtocolAttachmentProtocolBase;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.krad.bo.DocumentHeader;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.service.DocumentService;
import org.kuali.rice.krad.util.GlobalVariables;

public abstract class ProtocolAmendRenewServiceImplBase
implements ProtocolAmendRenewService {
    private static Logger LOGGER = LogManager.getLogger(ProtocolAmendRenewServiceImplBase.class);
    protected static final int DIGIT_COUNT = 3;
    protected static final String AMEND_NEXT_VALUE = "nextAmendValue";
    protected static final String RENEW_NEXT_VALUE = "nextRenewValue";
    protected static final String FYI_NEXT_VALUE = "nextFyiValue";
    protected static final String CREATED = "Created";
    protected static final String PROTOCOL_NUMBER = "protocolNumber";
    protected static final String PROTOCOL_STATUS = "protocolStatus";
    protected static final String PROTOCOL_ID = "protocolId";
    protected DocumentService documentService;
    protected ProtocolCopyService<ProtocolDocumentBase> protocolCopyService;
    protected KraLookupDao kraLookupDao;
    protected ProtocolFinderDao protocolFinderDao;
    protected QuestionnaireAnswerService questionnaireAnswerService;
    protected BusinessObjectService businessObjectService;
    private LoadingCache<String, List<ProtocolBase>> amendmentAndRenewalsCache = CacheBuilder.newBuilder().expireAfterWrite(2L, TimeUnit.MINUTES).maximumSize(1000L).build((CacheLoader)new CacheLoader<String, List<ProtocolBase>>(){

        public List<ProtocolBase> load(String protocolNumber) throws Exception {
            return Collections.unmodifiableList(new ArrayList(ProtocolAmendRenewServiceImplBase.this.kraLookupDao.findCollectionUsingWildCardWithSorting(ProtocolAmendRenewServiceImplBase.this.getProtocolBOClassHook(), ProtocolAmendRenewServiceImplBase.PROTOCOL_NUMBER, protocolNumber + "_%", ProtocolAmendRenewServiceImplBase.PROTOCOL_ID, true, true)));
        }
    });

    @Override
    public void refreshCacheForProtocol(String protocolNumber) {
        this.amendmentAndRenewalsCache.refresh((Object)protocolNumber);
    }

    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }

    public void setProtocolCopyService(ProtocolCopyService<ProtocolDocumentBase> protocolCopyService) {
        this.protocolCopyService = protocolCopyService;
    }

    public void setKraLookupDao(KraLookupDao kraLookupDao) {
        this.kraLookupDao = kraLookupDao;
    }

    public void setProtocolFinderDao(ProtocolFinderDao protocolFinderDao) {
        this.protocolFinderDao = protocolFinderDao;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String createFYI(ProtocolDocumentBase protocolDocument, ActionHelperBase actionHelper, String fyiComments) throws Exception {
        ProtocolDocumentBase fyiProtocolDocument = null;
        ProtocolBase originalProtocol = protocolDocument.getProtocol();
        try {
            GlobalVariables.getUserSession().addObject("onAmendAndRenewAllowNewProtocolDocument", (Object)Boolean.TRUE);
            fyiProtocolDocument = this.protocolCopyService.copyProtocol(protocolDocument, this.generateProtocolFYINumber(protocolDocument), true);
        }
        finally {
            GlobalVariables.getUserSession().removeObject("onAmendAndRenewAllowNewProtocolDocument");
        }
        fyiProtocolDocument.getProtocol().setInitialSubmissionDate(originalProtocol.getInitialSubmissionDate());
        fyiProtocolDocument.getProtocol().setApprovalDate(originalProtocol.getApprovalDate());
        fyiProtocolDocument.getProtocol().setExpirationDate(originalProtocol.getExpirationDate());
        fyiProtocolDocument.getProtocol().setLastApprovalDate(originalProtocol.getLastApprovalDate());
        fyiProtocolDocument.getProtocol().setProtocolStatusCode(this.getFyiInProgressStatusHook());
        fyiProtocolDocument.getProtocol().refreshReferenceObject(PROTOCOL_STATUS);
        ArrayList<ProtocolAttachmentProtocolBase> fyiAttachments = new ArrayList<ProtocolAttachmentProtocolBase>();
        fyiProtocolDocument.getProtocol().setAttachmentProtocols(fyiAttachments);
        ProtocolActionBase protocolAction = this.createNotifyIrbAction(originalProtocol, fyiProtocolDocument.getProtocol().getProtocolNumber());
        protocolDocument.getProtocol().getProtocolActions().add(protocolAction);
        return this.createFYI(protocolDocument, fyiProtocolDocument, actionHelper, fyiComments);
    }

    protected String createFYI(ProtocolDocumentBase protocolDocument, ProtocolDocumentBase fyiProtocolDocument, ActionHelperBase actionHelper, String fyiComments) throws WorkflowException {
        ProtocolAmendRenewalBase protocolAmendRenewal = this.createAmendmentRenewal(protocolDocument, fyiProtocolDocument, fyiComments);
        fyiProtocolDocument.getProtocol().setProtocolAmendRenewal(protocolAmendRenewal);
        this.addModules(fyiProtocolDocument.getProtocol(), this.getFyiAttachmentsBean(actionHelper));
        this.documentService.saveDocument((Document)protocolDocument);
        this.documentService.saveDocument((Document)fyiProtocolDocument);
        return fyiProtocolDocument.getDocumentNumber();
    }

    protected abstract ProtocolAmendmentBean getFyiAttachmentsBean(ActionHelperBase var1);

    protected ProtocolActionBase createNotifyIrbAction(ProtocolBase protocol, String protocolNumber) {
        ProtocolActionBase protocolAction = this.getNewFyiProtocolActionInstanceHook(protocol);
        protocolAction.setComments(ProtocolSpecialVersion.FYI.getDescription() + "-" + protocolNumber.substring(11) + ": Created");
        return protocolAction;
    }

    protected String generateProtocolFYINumber(ProtocolDocumentBase protocolDocument) {
        return this.generateProtocolNumber(protocolDocument, ProtocolSpecialVersion.FYI.getCode(), FYI_NEXT_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String createAmendment(ProtocolDocumentBase protocolDocument, ProtocolAmendmentBean amendmentBean) throws Exception {
        ProtocolDocumentBase amendProtocolDocument = null;
        try {
            GlobalVariables.getUserSession().addObject("onAmendAndRenewAllowNewProtocolDocument", (Object)Boolean.TRUE);
            amendProtocolDocument = this.protocolCopyService.copyProtocol(protocolDocument, this.generateProtocolAmendmentNumber(protocolDocument), true);
        }
        finally {
            GlobalVariables.getUserSession().removeObject("onAmendAndRenewAllowNewProtocolDocument");
        }
        amendProtocolDocument.getProtocol().setInitialSubmissionDate(protocolDocument.getProtocol().getInitialSubmissionDate());
        amendProtocolDocument.getProtocol().setApprovalDate(protocolDocument.getProtocol().getApprovalDate());
        amendProtocolDocument.getProtocol().setExpirationDate(protocolDocument.getProtocol().getExpirationDate());
        amendProtocolDocument.getProtocol().setLastApprovalDate(protocolDocument.getProtocol().getLastApprovalDate());
        amendProtocolDocument.getProtocol().setProtocolStatusCode(this.getAmendmentInProgressStatusHook());
        amendProtocolDocument.getProtocol().refreshReferenceObject(PROTOCOL_STATUS);
        this.markProtocolAttachmentsAsFinalized(amendProtocolDocument.getProtocol().getAttachmentProtocols());
        ProtocolActionBase protocolAction = this.createCreateAmendmentProtocolAction(protocolDocument.getProtocol(), amendProtocolDocument.getProtocol().getProtocolNumber());
        protocolDocument.getProtocol().getProtocolActions().add(protocolAction);
        return this.createAmendment(protocolDocument, amendProtocolDocument, amendmentBean);
    }

    protected void markProtocolAttachmentsAsFinalized(List<ProtocolAttachmentProtocolBase> attachmentProtocols) {
        for (ProtocolAttachmentProtocolBase protocolAttachment : attachmentProtocols) {
            if (!"1".equals(protocolAttachment.getDocumentStatusCode())) continue;
            protocolAttachment.setDocumentStatusCode("2");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String createRenewal(ProtocolDocumentBase protocolDocument, String renewalSummary) throws Exception {
        ProtocolDocumentBase renewProtocolDocument = null;
        try {
            GlobalVariables.getUserSession().addObject("onAmendAndRenewAllowNewProtocolDocument", (Object)Boolean.TRUE);
            renewProtocolDocument = this.protocolCopyService.copyProtocol(protocolDocument, this.generateProtocolRenewalNumber(protocolDocument), true);
        }
        finally {
            GlobalVariables.getUserSession().removeObject("onAmendAndRenewAllowNewProtocolDocument");
        }
        renewProtocolDocument.getProtocol().setInitialSubmissionDate(protocolDocument.getProtocol().getInitialSubmissionDate());
        renewProtocolDocument.getProtocol().setApprovalDate(protocolDocument.getProtocol().getApprovalDate());
        renewProtocolDocument.getProtocol().setExpirationDate(protocolDocument.getProtocol().getExpirationDate());
        renewProtocolDocument.getProtocol().setLastApprovalDate(protocolDocument.getProtocol().getLastApprovalDate());
        renewProtocolDocument.getProtocol().setProtocolStatusCode(this.getRenewalInProgressStatusHook());
        renewProtocolDocument.getProtocol().refreshReferenceObject(PROTOCOL_STATUS);
        this.markProtocolAttachmentsAsFinalized(renewProtocolDocument.getProtocol().getAttachmentProtocols());
        ProtocolActionBase protocolAction = this.createCreateRenewalProtocolAction(protocolDocument.getProtocol(), renewProtocolDocument.getProtocol().getProtocolNumber());
        protocolDocument.getProtocol().getProtocolActions().add(protocolAction);
        ProtocolAmendRenewalBase protocolAmendRenewal = this.createAmendmentRenewal(protocolDocument, renewProtocolDocument, renewalSummary);
        renewProtocolDocument.getProtocol().setProtocolAmendRenewal(protocolAmendRenewal);
        this.documentService.saveDocument((Document)protocolDocument);
        this.documentService.saveDocument((Document)renewProtocolDocument);
        return renewProtocolDocument.getDocumentNumber();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String createRenewalWithAmendment(ProtocolDocumentBase protocolDocument, ProtocolAmendmentBean amendmentBean) throws Exception {
        ProtocolDocumentBase renewProtocolDocument = null;
        try {
            GlobalVariables.getUserSession().addObject("onAmendAndRenewAllowNewProtocolDocument", (Object)Boolean.TRUE);
            renewProtocolDocument = this.protocolCopyService.copyProtocol(protocolDocument, this.generateProtocolRenewalNumber(protocolDocument), true);
        }
        finally {
            GlobalVariables.getUserSession().removeObject("onAmendAndRenewAllowNewProtocolDocument");
        }
        renewProtocolDocument.getProtocol().setInitialSubmissionDate(protocolDocument.getProtocol().getInitialSubmissionDate());
        renewProtocolDocument.getProtocol().setApprovalDate(protocolDocument.getProtocol().getApprovalDate());
        renewProtocolDocument.getProtocol().setExpirationDate(protocolDocument.getProtocol().getExpirationDate());
        renewProtocolDocument.getProtocol().setLastApprovalDate(protocolDocument.getProtocol().getLastApprovalDate());
        renewProtocolDocument.getProtocol().setProtocolStatusCode(this.getRenewalInProgressStatusHook());
        renewProtocolDocument.getProtocol().refreshReferenceObject(PROTOCOL_STATUS);
        this.markProtocolAttachmentsAsFinalized(renewProtocolDocument.getProtocol().getAttachmentProtocols());
        ProtocolActionBase protocolAction = this.createCreateRenewalWithAmendmentProtocolAction(protocolDocument.getProtocol(), renewProtocolDocument.getProtocol().getProtocolNumber());
        protocolDocument.getProtocol().getProtocolActions().add(protocolAction);
        return this.createAmendment(protocolDocument, renewProtocolDocument, amendmentBean);
    }

    @Override
    public void updateAmendmentRenewal(ProtocolDocumentBase protocolDocument, ProtocolAmendmentBean amendmentBean) throws WorkflowException {
        protocolDocument.getProtocol().getProtocolAmendRenewal().setSummary(amendmentBean.getSummary());
        protocolDocument.getProtocol().getProtocolAmendRenewal().setModules(new ArrayList<ProtocolAmendRenewModuleBase>());
        this.addModules(protocolDocument.getProtocol(), amendmentBean);
    }

    protected String createAmendment(ProtocolDocumentBase protocolDocument, ProtocolDocumentBase amendProtocolDocument, ProtocolAmendmentBean amendmentBean) throws WorkflowException {
        ProtocolAmendRenewalBase protocolAmendRenewal = this.createAmendmentRenewal(protocolDocument, amendProtocolDocument, amendmentBean.getSummary());
        amendProtocolDocument.getProtocol().setProtocolAmendRenewal(protocolAmendRenewal);
        this.addModules(amendProtocolDocument.getProtocol(), amendmentBean);
        this.documentService.saveDocument((Document)protocolDocument);
        this.documentService.saveDocument((Document)amendProtocolDocument);
        return amendProtocolDocument.getDocumentNumber();
    }

    protected String generateProtocolAmendmentNumber(ProtocolDocumentBase protocolDocument) {
        return this.generateProtocolNumber(protocolDocument, ProtocolSpecialVersion.AMENDMENT.getCode(), AMEND_NEXT_VALUE);
    }

    protected String generateProtocolRenewalNumber(ProtocolDocumentBase protocolDocument) {
        return this.generateProtocolNumber(protocolDocument, ProtocolSpecialVersion.RENEWAL.getCode(), RENEW_NEXT_VALUE);
    }

    protected String generateProtocolNumber(ProtocolDocumentBase protocolDocument, String letter, String nextValueKey) {
        String protocolNumber = protocolDocument.getProtocol().getProtocolNumber();
        Integer nextValue = protocolDocument.getDocumentNextValue(nextValueKey);
        Object s = nextValue.toString();
        int length = ((String)s).length();
        for (int i = 0; i < 3 - length; ++i) {
            s = "0" + (String)s;
        }
        return protocolNumber + letter + (String)s;
    }

    protected ProtocolAmendRenewalBase createAmendmentRenewal(ProtocolDocumentBase protocolDocument, ProtocolDocumentBase amendProtocolDocument, String summary) {
        ProtocolAmendRenewalBase protocolAmendRenewal = this.getNewProtocolAmendRenewalInstanceHook();
        protocolAmendRenewal.setProtoAmendRenNumber(amendProtocolDocument.getProtocol().getProtocolNumber());
        protocolAmendRenewal.setDateCreated(new Date(System.currentTimeMillis()));
        protocolAmendRenewal.setSummary(summary);
        protocolAmendRenewal.setProtocolNumber(protocolDocument.getProtocol().getProtocolNumber());
        protocolAmendRenewal.setProtocolId(amendProtocolDocument.getProtocol().getProtocolId());
        protocolAmendRenewal.setProtocol(amendProtocolDocument.getProtocol());
        protocolAmendRenewal.setSequenceNumber(0);
        return protocolAmendRenewal;
    }

    protected void removeEditedQuestionaire(ProtocolBase protocol) {
        ModuleQuestionnaireBean moduleQuestionnaireBean = this.getNewProtocolModuleQuestionnaireBeanInstanceHook(protocol);
        moduleQuestionnaireBean.setModuleSubItemCode("0");
        List<Object> answerHeaders = new ArrayList();
        answerHeaders = this.questionnaireAnswerService.getQuestionnaireAnswer(moduleQuestionnaireBean);
        if (!answerHeaders.isEmpty() && ((AnswerHeader)answerHeaders.get(0)).getId() != null) {
            this.businessObjectService.delete(answerHeaders);
        }
    }

    protected ProtocolAmendRenewModuleBase createModule(ProtocolAmendRenewalBase amendmentEntry, String moduleTypeCode) {
        ProtocolAmendRenewModuleBase module = this.getNewProtocolAmendRenewModuleInstanceHook();
        module.setProtocolAmendRenewalNumber(amendmentEntry.getProtoAmendRenNumber());
        module.setProtocolAmendRenewal(amendmentEntry);
        module.setProtocolAmendRenewalId(amendmentEntry.getId());
        module.setProtocolNumber(amendmentEntry.getProtocolNumber());
        module.setProtocolModuleTypeCode(moduleTypeCode);
        return module;
    }

    protected ProtocolActionBase createCreateAmendmentProtocolAction(ProtocolBase protocol, String protocolNumber) {
        ProtocolActionBase protocolAction = this.getNewAmendmentProtocolActionInstanceHook(protocol);
        protocolAction.setComments(ProtocolSpecialVersion.AMENDMENT.getDescription() + "-" + protocolNumber.substring(11) + ": Created");
        return protocolAction;
    }

    protected ProtocolActionBase createCreateRenewalProtocolAction(ProtocolBase protocol, String protocolNumber) {
        ProtocolActionBase protocolAction = this.getNewRenewalProtocolActionInstanceHook(protocol);
        protocolAction.setComments(ProtocolSpecialVersion.RENEWAL.getDescription() + "-" + protocolNumber.substring(11) + ": Created");
        return protocolAction;
    }

    protected ProtocolActionBase createCreateRenewalWithAmendmentProtocolAction(ProtocolBase protocol, String protocolNumber) {
        ProtocolActionBase protocolAction = this.getNewRenewalWithAmendmentProtocolActionInstanceHook(protocol);
        protocolAction.setComments(ProtocolSpecialVersion.RENEWAL.getDescription() + "-" + protocolNumber.substring(11) + ": Created");
        return protocolAction;
    }

    @Override
    public List<ProtocolBase> getAmendmentAndRenewals(String protocolNumber) throws Exception {
        try {
            return new ArrayList<ProtocolBase>((Collection)this.amendmentAndRenewalsCache.get((Object)protocolNumber));
        }
        catch (ExecutionException e) {
            LOGGER.error("amendmentAndRenewalsCache for fetching amendment renewals did not execute properly. Trying to fetch it from database with DAO", (Throwable)e);
            return new ArrayList<ProtocolBase>(this.kraLookupDao.findCollectionUsingWildCardWithSorting(this.getProtocolBOClassHook(), PROTOCOL_NUMBER, protocolNumber + "_%", PROTOCOL_ID, true, true));
        }
    }

    @Override
    public Collection<ProtocolBase> getAmendments(String protocolNumber) throws Exception {
        return new ArrayList<ProtocolBase>(this.kraLookupDao.findCollectionUsingWildCard(this.getProtocolBOClassHook(), PROTOCOL_NUMBER, protocolNumber + ProtocolSpecialVersion.AMENDMENT.getCode() + "%", true));
    }

    @Override
    public Collection<ProtocolBase> getRenewals(String protocolNumber) throws Exception {
        return new ArrayList<ProtocolBase>(this.kraLookupDao.findCollectionUsingWildCard(this.getProtocolBOClassHook(), PROTOCOL_NUMBER, protocolNumber + ProtocolSpecialVersion.RENEWAL.getCode() + "%", true));
    }

    @Override
    public List<String> getAvailableModules(String protocolNumber) throws Exception {
        List<String> moduleTypeCodes = this.getAllModuleTypeCodes();
        List<ProtocolBase> protocols = this.getAmendmentAndRenewals(protocolNumber);
        for (ProtocolBase protocol : protocols) {
            ProtocolAmendRenewalBase amendRenewal;
            if (this.isAmendmentCompleted(protocol) || (amendRenewal = protocol.getProtocolAmendRenewal()) == null) continue;
            List<ProtocolAmendRenewModuleBase> modules = amendRenewal.getModules();
            for (ProtocolAmendRenewModuleBase module : modules) {
                moduleTypeCodes.remove(module.getProtocolModuleTypeCode());
            }
        }
        return moduleTypeCodes;
    }

    @Override
    public String getAmendedOrRenewalProtocolNumber(String protocolNumber) {
        if (protocolNumber.contains(ProtocolSpecialVersion.AMENDMENT.getCode())) {
            return StringUtils.substringBefore((String)protocolNumber, (String)ProtocolSpecialVersion.AMENDMENT.getCode());
        }
        if (protocolNumber.contains(ProtocolSpecialVersion.RENEWAL.getCode())) {
            return StringUtils.substringBefore((String)protocolNumber, (String)ProtocolSpecialVersion.RENEWAL.getCode());
        }
        return protocolNumber;
    }

    protected boolean isAmendmentCompleted(ProtocolBase protocol) {
        WorkflowDocument workflowDocument = this.getWorkflowDocument((Document)protocol.getProtocolDocument());
        if (workflowDocument != null) {
            return workflowDocument.isApproved() || workflowDocument.isFinal() || workflowDocument.isDisapproved() || workflowDocument.isCanceled() || workflowDocument.isException();
        }
        return false;
    }

    protected WorkflowDocument getWorkflowDocument(Document doc) {
        DocumentHeader header;
        WorkflowDocument workflowDocument = null;
        if (doc != null && (header = doc.getDocumentHeader()) != null) {
            try {
                workflowDocument = header.getWorkflowDocument();
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        return workflowDocument;
    }

    public void setQuestionnaireAnswerService(QuestionnaireAnswerService questionnaireAnswerService) {
        this.questionnaireAnswerService = questionnaireAnswerService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    protected abstract ProtocolActionBase getNewAmendmentProtocolActionInstanceHook(ProtocolBase var1);

    protected abstract ProtocolActionBase getNewRenewalProtocolActionInstanceHook(ProtocolBase var1);

    protected abstract ProtocolActionBase getNewRenewalWithAmendmentProtocolActionInstanceHook(ProtocolBase var1);

    protected abstract ProtocolActionBase getNewFyiProtocolActionInstanceHook(ProtocolBase var1);

    protected abstract ModuleQuestionnaireBean getNewProtocolModuleQuestionnaireBeanInstanceHook(ProtocolBase var1);

    protected abstract String getAmendmentInProgressStatusHook();

    protected abstract String getFyiInProgressStatusHook();

    protected abstract String getRenewalInProgressStatusHook();

    protected abstract List<String> getAllModuleTypeCodes();

    protected abstract void addModules(ProtocolBase var1, ProtocolAmendmentBean var2);

    protected abstract Class<? extends ProtocolBase> getProtocolBOClassHook();

    protected abstract ProtocolAmendRenewalBase getNewProtocolAmendRenewalInstanceHook();

    protected abstract ProtocolAmendRenewModuleBase getNewProtocolAmendRenewModuleInstanceHook();

    public ProtocolCopyService<ProtocolDocumentBase> getProtocolCopyService() {
        return this.protocolCopyService;
    }
}

