/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.protocol.noteattachment;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.apache.struts.upload.FormFile;
import org.kuali.coeus.common.framework.attachment.AttachmentFile;
import org.kuali.kra.SkipVersioning;
import org.kuali.kra.protocol.ProtocolAssociateBase;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.protocol.noteattachment.TypedAttachment;

public abstract class ProtocolAttachmentBase
extends ProtocolAssociateBase
implements TypedAttachment {
    private static final long serialVersionUID = -2519574730475246022L;
    private Long id;
    private Long fileId;
    private Integer documentId;
    private transient AttachmentFile file;
    private transient FormFile newFile;
    @SkipVersioning
    private transient String updateUserFullName;

    public ProtocolAttachmentBase() {
    }

    public ProtocolAttachmentBase(ProtocolBase protocol) {
        super(protocol);
    }

    public AttachmentFile getFile() {
        if (this.fileId != null && this.file == null) {
            this.refreshReferenceObject("file");
        }
        return this.file;
    }

    public void setFile(AttachmentFile file) {
        this.file = file;
    }

    public FormFile getNewFile() {
        return this.newFile;
    }

    public void setNewFile(FormFile newFile) {
        this.newFile = newFile;
    }

    public Long getFileId() {
        return this.fileId;
    }

    public void setFileId(Long fileId) {
        this.fileId = fileId;
    }

    public abstract String getAttachmentDescription();

    @Override
    public void resetPersistenceState() {
        this.setId(null);
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public static <T extends ProtocolAttachmentBase> void addAttachmentToCollection(T attachment, Collection<T> toCollection) {
        if (attachment == null) {
            throw new IllegalArgumentException("the attachment is null");
        }
        if (toCollection == null) {
            throw new IllegalArgumentException("the toList is null");
        }
        toCollection.add(attachment);
    }

    public static <T extends ProtocolAttachmentBase> void removeAttachmentFromCollection(T attachment, Collection<T> fromCollection) {
        if (attachment == null) {
            throw new IllegalArgumentException("the attachment is null");
        }
        if (fromCollection == null) {
            throw new IllegalArgumentException("the toList is null");
        }
        fromCollection.remove(attachment);
    }

    public boolean isNew() {
        return this.getId() == null;
    }

    public static <T extends ProtocolAttachmentBase> Collection<T> filterNewAttachments(Collection<T> attachments) {
        ArrayList<ProtocolAttachmentBase> newAttachments = new ArrayList<ProtocolAttachmentBase>();
        for (ProtocolAttachmentBase attachment : attachments) {
            if (!attachment.isNew()) continue;
            newAttachments.add(attachment);
        }
        return newAttachments;
    }

    public static <T extends ProtocolAttachmentBase> Collection<T> filterExistingAttachments(Collection<T> attachments) {
        ArrayList<T> existingAttachments = new ArrayList<T>(attachments);
        existingAttachments.removeAll(ProtocolAttachmentBase.filterNewAttachments(attachments));
        return existingAttachments;
    }

    public abstract boolean supportsVersioning();

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.file == null ? 0 : this.file.hashCode());
        result = 31 * result + (this.fileId == null ? 0 : this.fileId.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProtocolAttachmentBase other = (ProtocolAttachmentBase)obj;
        if (this.file == null ? other.file != null : !this.isSameFile(this.file, other.file)) {
            return false;
        }
        if (this.fileId == null ? other.fileId != null : !this.fileId.equals(other.fileId)) {
            return false;
        }
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    private boolean isSameFile(AttachmentFile obj, AttachmentFile other) {
        if (!Arrays.equals(obj.getData(), other.getData())) {
            return false;
        }
        if (obj.getId() != null && other.getId() != null && !obj.getId().equals(other.getId())) {
            return false;
        }
        if (obj.getId() != null && other.getId() == null || obj.getId() == null && other.getId() != null) {
            return false;
        }
        if (obj.getName() == null ? other.getName() != null : !obj.getName().equals(other.getName())) {
            return false;
        }
        return !(obj.getType() == null ? other.getType() != null : !obj.getType().equals(other.getType()));
    }

    @Override
    public Integer getDocumentId() {
        return this.documentId;
    }

    @Override
    public void setDocumentId(Integer documentId) {
        this.documentId = documentId;
    }

    public String getUpdateUserFullName() {
        return this.updateUserFullName;
    }

    public void setUpdateUserFullName(String updateUserFullName) {
        this.updateUserFullName = updateUserFullName;
    }

    public static enum PropertyName {
        FILE_ID("fileId"),
        ID("id");

        private final String name;

        private PropertyName(String name) {
            this.name = name;
        }

        public String getPropertyName() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }
    }
}

