/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award;

import java.util.List;
import org.kuali.coeus.common.framework.sponsor.term.SponsorTerm;
import org.kuali.coeus.sys.framework.rule.KcTransactionalDocumentRuleBase;
import org.kuali.kra.award.AwardSponsorTermRule;
import org.kuali.kra.award.AwardSponsorTermRuleEvent;
import org.kuali.kra.award.home.AwardSponsorTerm;

public class AwardSponsorTermRuleImpl
extends KcTransactionalDocumentRuleBase
implements AwardSponsorTermRule {
    private static final String NEW_AWARD_SPONSOR_TERM = "newAwardSponsorTerm[";
    private AwardSponsorTerm awardSponsorTerm;

    @Override
    public boolean processAddSponsorTermBusinessRules(AwardSponsorTermRuleEvent awardSponsorTermRuleEvent) {
        this.awardSponsorTerm = awardSponsorTermRuleEvent.getAwardSponsorTermForValidation();
        int typeCode = awardSponsorTermRuleEvent.getSponsorTermTypeCode();
        String sponsorTermCode = awardSponsorTermRuleEvent.getSponsorTermCode();
        boolean valid = true;
        if (!this.validateAwardSponsorTermNotEmpty(sponsorTermCode, typeCode)) {
            valid = false;
        } else if (!this.validateAwardSponsorTermValid(awardSponsorTermRuleEvent.getAwardSponsorTermForValidation().getSponsorTerm(), sponsorTermCode, typeCode)) {
            valid = false;
        } else if (!this.validateAwardSponsorTermNotDuplicate(this.awardSponsorTerm, awardSponsorTermRuleEvent.getAwardDocument().getAward().getAwardSponsorTerms())) {
            valid = false;
        }
        return valid;
    }

    private boolean validateAwardSponsorTermNotEmpty(String sponsorTermCode, int sponsorTermTypeCode) {
        boolean valid = true;
        if (sponsorTermCode == null) {
            this.reportError(NEW_AWARD_SPONSOR_TERM + sponsorTermTypeCode + "]", "error.awardSponsorTerm.no.term", new String[0]);
            valid = false;
        }
        return valid;
    }

    private boolean validateAwardSponsorTermValid(SponsorTerm sponsorTerm, String sponsorTermCode, int sponsorTermTypeCode) {
        boolean valid = true;
        if (sponsorTerm == null) {
            this.reportError(NEW_AWARD_SPONSOR_TERM + sponsorTermTypeCode + "]", "error.awardSponsorTerm.invalid.term", sponsorTermCode);
            valid = false;
        }
        return valid;
    }

    boolean validateAwardSponsorTermNotDuplicate(AwardSponsorTerm awardSponsorTerm, List<AwardSponsorTerm> awardSponsorTerms) {
        boolean valid = true;
        for (AwardSponsorTerm tempAwardSponsorTerm : awardSponsorTerms) {
            if (!awardSponsorTerm.getSponsorTermId().equals(tempAwardSponsorTerm.getSponsorTermId())) continue;
            valid = false;
            this.reportError(NEW_AWARD_SPONSOR_TERM + awardSponsorTerm.getSponsorTerm().getSponsorTermTypeCode() + "]", "error.awardSponsorTerm.duplicate.term", new String[0]);
        }
        return valid;
    }
}

