/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.budget;

import java.util.HashMap;
import java.util.List;
import org.kuali.coeus.common.budget.framework.version.AddBudgetVersionEvent;
import org.kuali.coeus.common.budget.framework.version.BudgetVersionRule;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.award.document.AwardDocument;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.timeandmoney.document.TimeAndMoneyDocument;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.service.DocumentService;
import org.kuali.rice.krad.util.GlobalVariables;

public class AwardBudgetVersionRule
extends BudgetVersionRule {
    public static final String ROOT_AWARD_NUMBER = "rootAwardNumber";
    BusinessObjectService businessObjectService;
    DocumentService documentService;
    ParameterService parameterService;

    @Override
    public boolean processAddBudgetVersion(AddBudgetVersionEvent event) throws WorkflowException {
        boolean success = true;
        Award award = (Award)event.getBudgetParent();
        if (!award.getObligatedDistributableTotal().isPositive()) {
            GlobalVariables.getMessageMap().putError(event.getErrorPath(), "error.award.invalidObligatedAmount", new String[]{"Name"});
            success &= false;
        }
        if (award.getRequestedStartDateInitial() == null) {
            GlobalVariables.getMessageMap().putError(event.getErrorPath(), "error.award.budgetVersion.startDate.required", new String[0]);
            success &= false;
        }
        if (award.getRequestedEndDateInitial() == null) {
            GlobalVariables.getMessageMap().putError(event.getErrorPath(), "error.award.budgetVersion.endDate.required", new String[0]);
            success &= false;
        }
        boolean anyAwardVersionFinal = false;
        AwardDocument awardDocument = (AwardDocument)this.getDocumentService().getByDocumentHeaderId(award.getAwardDocument().getDocumentHeader().getDocumentNumber());
        anyAwardVersionFinal = awardDocument.getDocumentHeader().hasWorkflowDocument() && awardDocument.getDocumentHeader().getWorkflowDocument().isFinal();
        HashMap<String, String> fieldValues1 = new HashMap<String, String>();
        fieldValues1.put(ROOT_AWARD_NUMBER, award.getAwardNumber());
        List timeAndMoneyDocuments = (List)this.getBusinessObjectService().findMatchingOrderBy(TimeAndMoneyDocument.class, fieldValues1, "documentNumber", true);
        boolean anyTimeAndMoneyDocumentsFinal = false;
        if (!timeAndMoneyDocuments.isEmpty()) {
            TimeAndMoneyDocument timeAndMoneyDocument = (TimeAndMoneyDocument)this.getDocumentService().getByDocumentHeaderId(((TimeAndMoneyDocument)timeAndMoneyDocuments.get(0)).getDocumentHeader().getDocumentNumber());
            boolean bl = anyTimeAndMoneyDocumentsFinal = timeAndMoneyDocument.getDocumentHeader().hasWorkflowDocument() && timeAndMoneyDocument.getDocumentHeader().getWorkflowDocument().isFinal();
        }
        if (!anyAwardVersionFinal && !anyTimeAndMoneyDocumentsFinal) {
            GlobalVariables.getMessageMap().putError(event.getErrorPath(), "error.budget.award.not.final", new String[0]);
            success &= false;
        }
        return success;
    }

    public BusinessObjectService getBusinessObjectService() {
        this.businessObjectService = KcServiceLocator.getService(BusinessObjectService.class);
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public DocumentService getDocumentService() {
        this.documentService = KcServiceLocator.getService(DocumentService.class);
        return this.documentService;
    }

    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }

    protected ParameterService getParameterService() {
        if (this.parameterService == null) {
            this.parameterService = KcServiceLocator.getService(ParameterService.class);
        }
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }
}

