/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.excon.project;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.kuali.coeus.common.framework.attachment.AttachmentFile;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.excon.project.ExconProject;
import org.kuali.kra.excon.project.ExconProjectAttachment;
import org.kuali.kra.excon.project.ExconProjectForm;
import org.kuali.kra.excon.rules.ExconProjectAttachmentAddRuleImpl;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.service.BusinessObjectService;

public class ExconProjectAttachmentsBean
implements Serializable {
    private static final long serialVersionUID = 234523457L;
    private final ExconProjectForm form;
    private ExconProjectAttachment newAttachment;
    private transient BusinessObjectService businessObjectService;

    public ExconProjectAttachmentsBean(ExconProjectForm form) {
        this.form = form;
    }

    public ExconProjectAttachment getNewAttachment() {
        if (this.newAttachment == null) {
            this.initAttachment();
        }
        return this.newAttachment;
    }

    private void initAttachment() {
        this.setNewAttachment(new ExconProjectAttachment(this.getExconProject()));
    }

    public void setNewAttachment(ExconProjectAttachment newAttachment) {
        this.newAttachment = newAttachment;
    }

    public ExconProjectForm getForm() {
        return this.form;
    }

    public ExconProject getExconProject() {
        if (this.form.getExconProjectDocument() == null) {
            throw new IllegalArgumentException("the document is null");
        }
        if (this.form.getExconProjectDocument().getExconProject() == null) {
            throw new IllegalArgumentException("the exconProject is null");
        }
        return this.form.getExconProjectDocument().getExconProject();
    }

    public void addExconProjectAttachment() {
        boolean success = new ExconProjectAttachmentAddRuleImpl().processAddExconProjectAttachmentBusinessRules(this.getExconProject(), this.getNewAttachment());
        if (success) {
            this.refreshAttachmentReferences(Collections.singletonList(this.getNewAttachment()));
            this.syncNewFiles(Collections.singletonList(this.getNewAttachment()));
            this.assignDocumentId(Collections.singletonList(this.getNewAttachment()), this.createTypeToMaxDocNumber(this.getExconProject().getExconProjectAttachments()));
            this.newAttachment.setExconProjectId(this.getExconProject().getProjectId());
            this.getExconProject().add(this.newAttachment);
            this.getBusinessObjectService().save((PersistableBusinessObject)this.newAttachment);
            this.initNewAttachment();
        }
    }

    public ExconProjectAttachment retrieveExistingAttachment(int attachmentNumber) {
        if (!ExconProjectAttachmentsBean.validIndexForList(attachmentNumber, this.getExconProject().getExconProjectAttachments())) {
            return null;
        }
        return this.getExconProject().getExconProjectAttachments().get(attachmentNumber);
    }

    private static boolean validIndexForList(int index, List<?> forList) {
        return forList != null && index >= 0 && index <= forList.size() - 1;
    }

    private void initNewAttachment() {
        this.setNewAttachment(new ExconProjectAttachment(this.getExconProject()));
    }

    private Map<String, Integer> createTypeToMaxDocNumber(List<ExconProjectAttachment> attachments) {
        HashMap<String, Integer> typeToDocNumber = new HashMap<String, Integer>();
        for (ExconProjectAttachment attachment : attachments) {
            Integer curMax = (Integer)typeToDocNumber.get(attachment.getTypeCode());
            if (curMax != null && curMax >= attachment.getDocumentId()) continue;
            typeToDocNumber.put(attachment.getTypeCode(), attachment.getDocumentId());
        }
        return typeToDocNumber;
    }

    private void assignDocumentId(List<ExconProjectAttachment> attachments, Map<String, Integer> typeToDocNumber) {
        for (ExconProjectAttachment attachment : attachments) {
            if (!attachment.isNew()) continue;
            Integer nextDocNumber = ExconProjectAttachmentsBean.createNextDocNumber(typeToDocNumber.get(attachment.getTypeCode()));
            attachment.setDocumentId(nextDocNumber);
        }
    }

    private static Integer createNextDocNumber(Integer docNumber) {
        return docNumber == null ? NumberUtils.INTEGER_ONE : Integer.valueOf(docNumber + 1);
    }

    private void refreshAttachmentReferences(List<ExconProjectAttachment> attachments) {
        assert (attachments != null) : "the attachments was null";
        for (ExconProjectAttachment attachment : attachments) {
            attachment.refreshReferenceObject("type");
        }
    }

    private void syncNewFiles(List<ExconProjectAttachment> attachments) {
        assert (attachments != null) : "the attachments was null";
        for (ExconProjectAttachment attachment : attachments) {
            if (!ExconProjectAttachmentsBean.doesNewFileExist(attachment)) continue;
            AttachmentFile newFile = AttachmentFile.createFromFormFile(attachment.getNewFile());
            if (attachment.getFile() != null) {
                newFile.setSequenceNumber(attachment.getFile().getSequenceNumber());
            }
            attachment.setFile(newFile);
        }
    }

    private static boolean doesNewFileExist(ExconProjectAttachment attachment) {
        return attachment.getNewFile() != null && StringUtils.isNotBlank((CharSequence)attachment.getNewFile().getFileName());
    }

    protected BusinessObjectService getBusinessObjectService() {
        if (this.businessObjectService == null) {
            this.businessObjectService = KcServiceLocator.getService(BusinessObjectService.class);
        }
        return this.businessObjectService;
    }

    void setBusinessObjectService(BusinessObjectService bos) {
        this.businessObjectService = bos;
    }
}

