/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.iacuc.actions.copy;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.iacuc.IacucProtocol;
import org.kuali.kra.iacuc.IacucProtocolDocument;
import org.kuali.kra.iacuc.actions.IacucProtocolAction;
import org.kuali.kra.iacuc.actions.copy.IacucProtocolCopyService;
import org.kuali.kra.iacuc.actions.submit.IacucProtocolSubmission;
import org.kuali.kra.iacuc.procedures.IacucProtocolProcedureService;
import org.kuali.kra.iacuc.protocol.IacucProtocolNumberService;
import org.kuali.kra.iacuc.species.IacucProtocolSpecies;
import org.kuali.kra.iacuc.species.IacucProtocolSpeciesService;
import org.kuali.kra.iacuc.species.exception.IacucProtocolException;
import org.kuali.kra.iacuc.species.exception.IacucProtocolExceptionService;
import org.kuali.kra.iacuc.threers.IacucAlternateSearch;
import org.kuali.kra.iacuc.threers.IacucPrinciples;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.protocol.actions.ProtocolActionBase;
import org.kuali.kra.protocol.actions.copy.ProtocolCopyServiceImplBase;
import org.kuali.kra.protocol.actions.submit.ProtocolSubmissionBase;

public class IacucProtocolCopyServiceImpl
extends ProtocolCopyServiceImplBase<IacucProtocolDocument>
implements IacucProtocolCopyService {
    private IacucProtocolSpeciesService iacucProtocolSpeciesService;
    private IacucProtocolExceptionService iacucProtocolExceptionService;
    private IacucProtocolProcedureService iacucProtocolProcedureService;

    @Override
    protected Class<? extends ProtocolActionBase> getProtocolActionBOClassHook() {
        return IacucProtocolAction.class;
    }

    @Override
    protected String getProtocolActionProtocolCreatedCodeHook() {
        return "100";
    }

    @Override
    protected String getSequenceNumberNameHook() {
        return "SEQ_IACUC_PROTOCOL_ID";
    }

    @Override
    protected void copyRequiredProperties(IacucProtocolDocument srcDoc, IacucProtocolDocument destDoc) {
        super.copyRequiredProperties(srcDoc, destDoc);
        destDoc.getIacucProtocol().setLayStatement1(srcDoc.getIacucProtocol().getLayStatement1());
        destDoc.getIacucProtocol().setLayStatement2(srcDoc.getIacucProtocol().getLayStatement2());
        destDoc.getIacucProtocol().setProtocolProjectTypeCode(srcDoc.getIacucProtocol().getProtocolProjectTypeCode());
        destDoc.getIacucProtocol().setOverviewTimeline(srcDoc.getIacucProtocol().getOverviewTimeline());
        destDoc.getIacucProtocol().setSpeciesStudyGroupIndicator(srcDoc.getIacucProtocol().getSpeciesStudyGroupIndicator());
        destDoc.getIacucProtocol().setAlternativeSearchIndicator(srcDoc.getIacucProtocol().getAlternativeSearchIndicator());
        destDoc.getIacucProtocol().setScientificJustifIndicator(srcDoc.getIacucProtocol().getScientificJustifIndicator());
    }

    @Override
    protected void copyProtocolLists(IacucProtocolDocument srcDoc, IacucProtocolDocument destDoc) {
        super.copyProtocolLists(srcDoc, destDoc);
        IacucProtocol srcProtocol = srcDoc.getIacucProtocol();
        IacucProtocol destProtocol = destDoc.getIacucProtocol();
        this.copyIacucProtocolLists(srcProtocol, destProtocol);
    }

    protected void copyIacucProtocolLists(IacucProtocol srcProtocol, IacucProtocol destProtocol) {
        this.addThreeRs(srcProtocol, destProtocol);
        this.addProtocolSpecies(srcProtocol, destProtocol);
        this.addProtocolExceptions(srcProtocol, destProtocol);
        this.addProtocolProcedures(srcProtocol, destProtocol);
        destProtocol.setIacucProtocolCustomDataList(this.deepCopy(srcProtocol.getIacucProtocolCustomDataList()));
    }

    protected void addThreeRs(IacucProtocol srcProtocol, IacucProtocol destProtocol) {
        IacucPrinciples newIacucPrinciple = this.deepCopy(srcProtocol.getIacucPrinciples().get(0));
        newIacucPrinciple.setIacucPrinciplesId(null);
        destProtocol.getIacucPrinciples().clear();
        destProtocol.getIacucPrinciples().add(newIacucPrinciple);
        List<IacucAlternateSearch> newIacucAlternateSearches = this.deepCopy(srcProtocol.getIacucAlternateSearches());
        for (IacucAlternateSearch iacucAlternateSearch : newIacucAlternateSearches) {
            iacucAlternateSearch.setIacucAltSearchId(null);
        }
        destProtocol.setIacucAlternateSearches(newIacucAlternateSearches);
    }

    @Override
    public void copyProtocolThreers(IacucProtocol srcProtocol, IacucProtocol destProtocol) {
        this.addThreeRs(srcProtocol, destProtocol);
    }

    @Override
    public void copyProtocolExceptions(IacucProtocol srcProtocol, IacucProtocol destProtocol) {
        this.addProtocolExceptions(srcProtocol, destProtocol);
    }

    protected void addProtocolSpecies(IacucProtocol srcProtocol, IacucProtocol destProtocol) {
        List<IacucProtocolSpecies> sourceProtocolSpecies = srcProtocol.getIacucProtocolSpeciesList();
        destProtocol.setIacucProtocolSpeciesList(new ArrayList<IacucProtocolSpecies>());
        for (IacucProtocolSpecies protocolSpecies : sourceProtocolSpecies) {
            destProtocol.getIacucProtocolSpeciesList().add(this.getNewProtocolSpecies(protocolSpecies, destProtocol));
        }
    }

    private IacucProtocolSpecies getNewProtocolSpecies(IacucProtocolSpecies srcProtocolSpecies, IacucProtocol destProtocol) {
        IacucProtocolSpecies newProtocolSpecies = this.deepCopy(srcProtocolSpecies);
        newProtocolSpecies = this.getIacucProtocolSpeciesService().getNewProtocolSpecies(destProtocol, newProtocolSpecies);
        newProtocolSpecies.setOldProtocolSpeciesId(srcProtocolSpecies.getIacucProtocolSpeciesId());
        return newProtocolSpecies;
    }

    protected void mergeProtocolSpecies(IacucProtocolSpecies srcProtocolSpecies, IacucProtocolSpecies dstProtocolSpecies) {
        dstProtocolSpecies.setUsdaCovered(srcProtocolSpecies.getUsdaCovered());
        dstProtocolSpecies.setStrain(srcProtocolSpecies.getStrain());
        dstProtocolSpecies.setSpeciesCount(srcProtocolSpecies.getSpeciesCount());
        dstProtocolSpecies.setPainCategoryCode(srcProtocolSpecies.getPainCategoryCode());
        dstProtocolSpecies.setSpeciesCountCode(srcProtocolSpecies.getSpeciesCountCode());
        dstProtocolSpecies.setExceptionsPresent(srcProtocolSpecies.getExceptionsPresent());
        dstProtocolSpecies.setProcedureSummary(srcProtocolSpecies.getProcedureSummary());
    }

    protected HashMap<Integer, Integer> getNewProtocolSpeciesMap(IacucProtocol protocol) {
        return this.getIacucProtocolSpeciesService().getNewProtocolSpeciesMap(protocol);
    }

    protected void addProtocolExceptions(IacucProtocol srcProtocol, IacucProtocol destProtocol) {
        destProtocol.setIacucProtocolExceptions(new ArrayList<IacucProtocolException>());
        List<IacucProtocolException> sourceProtocolExceptions = srcProtocol.getIacucProtocolExceptions();
        for (IacucProtocolException protocolException : sourceProtocolExceptions) {
            IacucProtocolException newProtocolException = this.deepCopy(protocolException);
            newProtocolException = this.getIacucProtocolExceptionService().getNewProtocolException(destProtocol, newProtocolException);
            destProtocol.getIacucProtocolExceptions().add(newProtocolException);
        }
    }

    protected void addProtocolProcedures(IacucProtocol srcProtocol, IacucProtocol destProtocol) {
        this.getIacucProtocolProcedureService().createNewProtocolStudyProcedures(srcProtocol, destProtocol);
    }

    @Override
    protected IacucProtocolNumberService getProtocolNumberServiceHook() {
        return (IacucProtocolNumberService)KcServiceLocator.getService("iacucProtocolNumberService");
    }

    @Override
    protected IacucProtocolAction getProtocolActionNewInstanceHook(ProtocolBase protocol, ProtocolSubmissionBase protocolSubmission, String protocolActionTypeCode) {
        return new IacucProtocolAction((IacucProtocol)protocol, (IacucProtocolSubmission)protocolSubmission, protocolActionTypeCode);
    }

    @Override
    protected String getProtocolAggregatorHook() {
        return "IACUC Protocol Aggregator";
    }

    @Override
    protected String getProtocolApproverHook() {
        return "IACUC ProtocolApprover";
    }

    @Override
    protected String getProtocolRoleTypeHook() {
        return "KC-IACUC";
    }

    public IacucProtocolSpeciesService getIacucProtocolSpeciesService() {
        return this.iacucProtocolSpeciesService;
    }

    public void setIacucProtocolSpeciesService(IacucProtocolSpeciesService iacucProtocolSpeciesService) {
        this.iacucProtocolSpeciesService = iacucProtocolSpeciesService;
    }

    public IacucProtocolExceptionService getIacucProtocolExceptionService() {
        return this.iacucProtocolExceptionService;
    }

    public void setIacucProtocolExceptionService(IacucProtocolExceptionService iacucProtocolExceptionService) {
        this.iacucProtocolExceptionService = iacucProtocolExceptionService;
    }

    public IacucProtocolProcedureService getIacucProtocolProcedureService() {
        return this.iacucProtocolProcedureService;
    }

    public void setIacucProtocolProcedureService(IacucProtocolProcedureService iacucProtocolProcedureService) {
        this.iacucProtocolProcedureService = iacucProtocolProcedureService;
    }
}

