/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.irb.actions.assignreviewers;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.committee.impl.bo.CommitteeMembershipBase;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.committee.bo.CommitteeMembership;
import org.kuali.kra.committee.service.CommitteeService;
import org.kuali.kra.irb.actions.ActionHelper;
import org.kuali.kra.irb.actions.ProtocolActionBean;
import org.kuali.kra.irb.actions.submit.ProtocolReviewerBean;
import org.kuali.kra.irb.actions.submit.ProtocolSubmission;
import org.kuali.kra.protocol.actions.submit.ProtocolReviewerBeanBase;
import org.kuali.kra.protocol.onlinereview.ProtocolOnlineReviewBase;

public class ProtocolAssignReviewersBean
extends ProtocolActionBean
implements org.kuali.kra.protocol.actions.assignreviewers.ProtocolAssignReviewersBean {
    private static final long serialVersionUID = -3769655019628462999L;
    private String currentCommitteeId = null;
    private String currentScheduleId = null;
    private List<ProtocolReviewerBean> reviewers = new ArrayList<ProtocolReviewerBean>();

    public ProtocolAssignReviewersBean(ActionHelper actionHelper) {
        super(actionHelper);
    }

    @Override
    public void prepareView() {
        ProtocolSubmission submission = this.getProtocol().getProtocolSubmission();
        if (submission != null) {
            String committeeId = submission.getCommitteeId();
            String scheduleId = submission.getScheduleId();
            this.reviewers.clear();
            if (!StringUtils.equals((CharSequence)committeeId, (CharSequence)this.currentCommitteeId) || !StringUtils.equals((CharSequence)scheduleId, (CharSequence)this.currentScheduleId)) {
                this.currentCommitteeId = committeeId;
                this.currentScheduleId = scheduleId;
                if (!(StringUtils.isBlank((CharSequence)committeeId) || StringUtils.isBlank((CharSequence)scheduleId) && !this.isExpeditedSubmission(submission))) {
                    this.populateReviewers(committeeId, scheduleId, submission);
                } else if (!StringUtils.isBlank((CharSequence)committeeId) && !this.isFullCommitteeReview(submission)) {
                    this.populateReviewers(committeeId, scheduleId, submission);
                }
            } else if (!(StringUtils.isBlank((CharSequence)committeeId) || this.isScheduleRequiredForReview(submission, scheduleId) && StringUtils.isBlank((CharSequence)scheduleId))) {
                this.populateReviewers(committeeId, scheduleId, submission);
            }
        }
    }

    private void populateReviewers(String committeeId, String scheduleId, ProtocolSubmission submission) {
        List<CommitteeMembershipBase> members = this.getProtocol().filterOutProtocolPersonnel(this.getCommitteeService().getAvailableMembers(committeeId, scheduleId));
        for (CommitteeMembershipBase member : members) {
            this.reviewers.add(new ProtocolReviewerBean((CommitteeMembership)member));
        }
        block1: for (ProtocolOnlineReviewBase review : submission.getProtocolOnlineReviews()) {
            if (!review.isActive()) continue;
            for (ProtocolReviewerBean reviewerBean : this.reviewers) {
                if (!reviewerBean.isProtocolReviewerBeanForReviewer(review.getProtocolReviewer())) continue;
                reviewerBean.setReviewerTypeCode(review.getProtocolReviewer().getReviewerTypeCode());
                continue block1;
            }
        }
    }

    private CommitteeService getCommitteeService() {
        return KcServiceLocator.getService(CommitteeService.class);
    }

    @Override
    public List<ProtocolReviewerBeanBase> getReviewers() {
        return this.reviewers;
    }

    @Override
    public ProtocolReviewerBean getReviewer(int i) {
        return this.reviewers.get(i);
    }

    @Override
    public List<ProtocolReviewerBeanBase> getLeftReviewers() {
        ArrayList<ProtocolReviewerBeanBase> leftReviewers = new ArrayList<ProtocolReviewerBeanBase>();
        for (int i = 0; i < (this.reviewers.size() + 1) / 2; ++i) {
            leftReviewers.add(this.reviewers.get(i));
        }
        return leftReviewers;
    }

    @Override
    public List<ProtocolReviewerBeanBase> getRightReviewers() {
        ArrayList<ProtocolReviewerBeanBase> rightReviewers = new ArrayList<ProtocolReviewerBeanBase>();
        for (int i = (this.reviewers.size() + 1) / 2; i < this.reviewers.size(); ++i) {
            rightReviewers.add(this.reviewers.get(i));
        }
        return rightReviewers;
    }

    private boolean isExpeditedSubmission(ProtocolSubmission submission) {
        return submission != null && "2".equals(submission.getProtocolReviewTypeCode());
    }

    private boolean isFullCommitteeReview(ProtocolSubmission submission) {
        return submission != null && "1".equals(submission.getProtocolReviewTypeCode());
    }

    private boolean isScheduleRequiredForReview(ProtocolSubmission submission, String scheduleId) {
        return this.isFullCommitteeReview(submission) && !StringUtils.isBlank((CharSequence)scheduleId);
    }
}

