/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.instprop.impl.api;

import java.beans.FeatureDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.api.document.service.CommonApiService;
import org.kuali.coeus.instprop.impl.api.dto.InstitutionalProposalDto;
import org.kuali.coeus.instprop.impl.api.dto.IpPersonDto;
import org.kuali.coeus.instprop.impl.api.service.InstitutionalProposalApiService;
import org.kuali.coeus.sys.framework.controller.rest.RestController;
import org.kuali.coeus.sys.framework.controller.rest.audit.RestAuditLogger;
import org.kuali.coeus.sys.framework.controller.rest.audit.RestAuditLoggerFactory;
import org.kuali.coeus.sys.framework.gv.GlobalVariableService;
import org.kuali.coeus.sys.framework.rest.NotImplementedException;
import org.kuali.coeus.sys.framework.rest.ResourceNotFoundException;
import org.kuali.coeus.sys.framework.rest.UnauthorizedAccessException;
import org.kuali.coeus.sys.framework.rest.UnprocessableEntityException;
import org.kuali.kra.institutionalproposal.contacts.InstitutionalProposalPerson;
import org.kuali.kra.institutionalproposal.dao.InstitutionalProposalDao;
import org.kuali.kra.institutionalproposal.document.InstitutionalProposalDocument;
import org.kuali.kra.institutionalproposal.home.InstitutionalProposal;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.exception.InvalidActionTakenException;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kew.routeheader.DocumentRouteHeaderValue;
import org.kuali.rice.kew.routeheader.service.RouteHeaderService;
import org.kuali.rice.kim.api.permission.PermissionService;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.service.DocumentService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@RequestMapping(value={"/api"})
@Controller(value="institutionalProposalDocumentController")
public class InstitutionalProposalDocumentController
extends RestController {
    @Autowired
    @Qualifier(value="institutionalProposalApiService")
    InstitutionalProposalApiService institutionalProposalApiService;
    @Autowired
    @Qualifier(value="documentService")
    private DocumentService documentService;
    @Autowired
    @Qualifier(value="routeHeaderService")
    private RouteHeaderService routeHeaderService;
    @Autowired
    @Qualifier(value="restAuditLoggerFactory")
    private RestAuditLoggerFactory restAuditLoggerFactory;
    @Autowired
    @Qualifier(value="commonApiService")
    private CommonApiService commonApiService;
    @Autowired
    @Qualifier(value="permissionService")
    private PermissionService permissionService;
    @Autowired
    @Qualifier(value="parameterService")
    private ParameterService parameterService;
    @Autowired
    @Qualifier(value="globalVariableService")
    private GlobalVariableService globalVariableService;
    @Autowired
    @Qualifier(value="institutionalProposalDao")
    private InstitutionalProposalDao institutionalProposalDao;
    private List<String> ipDtoProperties = this.getIpdtoProperties();
    private List<String> ipPersonDtoProperties = this.getIpPersonDtoProperties();

    protected List<String> getIpdtoProperties() throws IntrospectionException {
        return Arrays.asList(Introspector.getBeanInfo(InstitutionalProposalDto.class).getPropertyDescriptors()).stream().map(FeatureDescriptor::getName).filter(prop -> !"class".equals(prop)).collect(Collectors.toList());
    }

    protected List<String> getIpPersonDtoProperties() throws IntrospectionException {
        return Arrays.asList(Introspector.getBeanInfo(IpPersonDto.class).getPropertyDescriptors()).stream().map(FeatureDescriptor::getName).filter(prop -> !"class".equals(prop)).collect(Collectors.toList());
    }

    public String createInstitutionalProposal(InstitutionalProposalDto ipDto, @RequestParam(value="createProposalLog", required=false) boolean createProposalLog) throws WorkflowException, InvocationTargetException, IllegalAccessException {
        return this.createInstitutionalProposal(ipDto, createProposalLog, false);
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/v1/institutional-proposal-document"}, consumes={"application/json"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @ResponseBody
    public String createInstitutionalProposal(@RequestBody InstitutionalProposalDto ipDto, @RequestParam(value="createProposalLog", required=false) boolean createProposalLog, @RequestParam(value="route", required=false) boolean route) throws WorkflowException, InvocationTargetException, IllegalAccessException {
        this.assertUserHasWriteAccess();
        RestAuditLogger auditLogger = this.getRestAuditLoggerFactory().getNewAuditLogger(InstitutionalProposalDto.class, this.ipDtoProperties);
        this.getCommonApiService().clearErrors();
        InstitutionalProposal proposal = this.getCommonApiService().convertObject(ipDto, InstitutionalProposal.class);
        String proposalLogNumber = null;
        if (createProposalLog) {
            IpPersonDto ip = null;
            if (ipDto.getProjectPersons() != null) {
                ip = ipDto.getProjectPersons().stream().filter(ipPersonDto -> ipPersonDto.getRoleCode().equalsIgnoreCase("PI")).findFirst().orElse(null);
            }
            proposalLogNumber = this.getInstitutionalProposalApiService().createProposalLog(ipDto, ip);
        }
        proposal.setProjectPersons(new ArrayList<InstitutionalProposalPerson>());
        this.getInstitutionalProposalApiService().initializeData(proposal);
        InstitutionalProposalDocument ipDocument = this.getInstitutionalProposalApiService().saveInitialProposal(proposal, ipDto.getDocumentDescription());
        this.getInstitutionalProposalApiService().addPersons(ipDocument, ipDto.getProjectPersons());
        this.getInstitutionalProposalApiService().addCustomData(ipDocument.getInstitutionalProposal(), ipDto);
        this.getInstitutionalProposalApiService().addSpecialReviews(ipDocument, ipDto.getInstitutionalProposalSpecialReviewList());
        this.getInstitutionalProposalApiService().addCostShares(ipDocument, ipDto.getInstitutionalProposalCostShares());
        this.getInstitutionalProposalApiService().addComments(ipDocument, ipDto.getProposalComments());
        this.getInstitutionalProposalApiService().addFandAs(ipDocument, ipDto.getInstitutionalProposalFandAs());
        this.getInstitutionalProposalApiService().addUnrecoveredFandAs(ipDocument, ipDto.getInstitutionalProposalUnrecoveredFandAs());
        if (createProposalLog) {
            ipDocument.getInstitutionalProposal().setProposalNumber(proposalLogNumber);
            this.getInstitutionalProposalApiService().updateProposalLog(proposalLogNumber, ipDocument);
        }
        this.saveDocument(ipDocument);
        auditLogger.addNewItem(ipDto);
        auditLogger.saveAuditLog();
        if (route) {
            this.routeDocument(ipDocument);
        }
        return ipDocument.getDocumentNumber();
    }

    @RequestMapping(method={RequestMethod.DELETE}, value={"/v1/institutional-proposal-document/{documentNumber}"}, consumes={"application/json"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    void deleteInstitutionalProposal(@PathVariable Long documentNumber) throws WorkflowException {
        this.assertUserHasWriteAccess();
        InstitutionalProposalDocument proposalDocument = (InstitutionalProposalDocument)this.getCommonApiService().getDocumentFromDocId(documentNumber);
        DocumentRouteHeaderValue routeHeader = this.getRouteHeaderService().getRouteHeader(proposalDocument.getDocumentHeader().getWorkflowDocument().getDocumentId());
        if (!routeHeader.getDocRouteStatus().equalsIgnoreCase("X")) {
            try {
                this.getDocumentService().cancelDocument((Document)proposalDocument, "Cancelled");
            }
            catch (InvalidActionTakenException e) {
                throw new UnprocessableEntityException("Document " + documentNumber + " is not in a state to be cancelled.");
            }
        }
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/v1/institutional-proposal-document/{documentNumber}"}, consumes={"application/json"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    InstitutionalProposalDto getInstitutionalProposal(@PathVariable Long documentNumber) {
        this.assertUserHasReadAccess();
        InstitutionalProposalDocument proposalDocument = (InstitutionalProposalDocument)this.getCommonApiService().getDocumentFromDocId(documentNumber);
        InstitutionalProposal proposal = proposalDocument.getInstitutionalProposal();
        InstitutionalProposalDto proposalDto = this.getCommonApiService().convertObject(proposal, InstitutionalProposalDto.class);
        proposalDto.setDocNbr(proposalDocument.getDocumentNumber());
        proposalDto.setDocStatus(proposalDocument.getDocumentHeader().getWorkflowDocument().getStatus().getLabel());
        return proposalDto;
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/v1/institutional-proposal-document/{documentNumber}/proposal-persons"}, consumes={"application/json"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @ResponseBody
    public List<IpPersonDto> addProposalPersons(@RequestBody List<IpPersonDto> ipPersonDto, @PathVariable Long documentNumber) throws WorkflowException {
        this.assertUserHasWriteAccess();
        this.getCommonApiService().clearErrors();
        InstitutionalProposalDocument proposalDocument = (InstitutionalProposalDocument)this.getCommonApiService().getDocumentFromDocId(documentNumber);
        RestAuditLogger auditLogger = this.getRestAuditLoggerFactory().getNewAuditLogger(IpPersonDto.class, this.ipPersonDtoProperties);
        this.getInstitutionalProposalApiService().addPersons(proposalDocument, ipPersonDto);
        ipPersonDto.stream().forEach(item -> auditLogger.addNewItem(item));
        this.saveDocument(proposalDocument);
        auditLogger.saveAuditLog();
        return this.getAllProposalPersons(Long.parseLong(proposalDocument.getDocumentNumber()));
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/v1/institutional-proposal-document/{documentNumber}/proposal-persons"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    List<IpPersonDto> getAllProposalPersons(@PathVariable Long documentNumber) throws WorkflowException {
        this.assertUserHasReadAccess();
        InstitutionalProposalDocument proposalDocument = (InstitutionalProposalDocument)this.getCommonApiService().getDocumentFromDocId(documentNumber);
        InstitutionalProposalDto proposalDto = this.getCommonApiService().convertObject(proposalDocument.getInstitutionalProposal(), InstitutionalProposalDto.class);
        List<IpPersonDto> persons = proposalDto.getProjectPersons();
        return persons;
    }

    private InstitutionalProposalPerson getInstitutionalProposalPerson(Long id, InstitutionalProposalDocument proposalDocument) {
        InstitutionalProposalPerson person = proposalDocument.getInstitutionalProposal().getProjectPersons().stream().filter(institutionalProposalPerson -> id.intValue() == institutionalProposalPerson.getInstitutionalProposalContactId().intValue()).findFirst().orElse(null);
        if (person == null) {
            throw new ResourceNotFoundException("Person with id " + id + " not found.");
        }
        return person;
    }

    @RequestMapping(method={RequestMethod.DELETE}, value={"/v1/institutional-proposal-document/{documentNumber}/proposal-persons/{id}"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    void deleteProposalPerson(@PathVariable Long documentNumber, @PathVariable Long id) throws WorkflowException {
        this.assertUserHasWriteAccess();
        InstitutionalProposalDocument proposalDocument = (InstitutionalProposalDocument)this.getCommonApiService().getDocumentFromDocId(documentNumber);
        RestAuditLogger auditLogger = this.getRestAuditLoggerFactory().getNewAuditLogger(IpPersonDto.class, this.ipPersonDtoProperties);
        InstitutionalProposalPerson person = this.getInstitutionalProposalPerson(id, proposalDocument);
        IpPersonDto personDto = this.getCommonApiService().convertObject(person, IpPersonDto.class);
        proposalDocument.getInstitutionalProposal().getProjectPersons().remove(person);
        this.saveDocument(proposalDocument);
        auditLogger.addDeletedItem(personDto);
        auditLogger.saveAuditLog();
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/v1/institutional-proposal-document/{documentNumber}/proposal-persons/{id}"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    IpPersonDto getProposalPerson(@PathVariable Long documentNumber, @PathVariable Long id) throws WorkflowException {
        this.assertUserHasReadAccess();
        InstitutionalProposalDocument proposalDocument = (InstitutionalProposalDocument)this.getCommonApiService().getDocumentFromDocId(documentNumber);
        InstitutionalProposalPerson person = this.getInstitutionalProposalPerson(id, proposalDocument);
        IpPersonDto personDto = this.getCommonApiService().convertObject(person, IpPersonDto.class);
        return personDto;
    }

    @RequestMapping(method={RequestMethod.PUT}, value={"/v1/institutional-proposal-document/{documentNumber}"}, params={"route"}, consumes={"application/json"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    void routeDocument(@PathVariable Long documentNumber) throws WorkflowException {
        this.assertUserHasWriteAccess();
        this.getCommonApiService().clearErrors();
        InstitutionalProposalDocument proposalDocument = (InstitutionalProposalDocument)this.getDocumentService().getByDocumentHeaderId(documentNumber.toString());
        this.routeDocument(proposalDocument);
    }

    private void routeDocument(InstitutionalProposalDocument proposalDocument) {
        this.getCommonApiService().routeDocument((Document)proposalDocument);
    }

    protected void saveDocument(InstitutionalProposalDocument proposalDocument) throws WorkflowException {
        WorkflowDocument workflowDocument = proposalDocument.getDocumentHeader().getWorkflowDocument();
        if (!this.getCommonApiService().isDocInModifiableState(workflowDocument)) {
            throw new UnprocessableEntityException("Document " + proposalDocument.getDocumentNumber() + " with status " + workflowDocument.getStatus() + " is not in a state to be saved.");
        }
        this.getInstitutionalProposalApiService().initializeCollections(proposalDocument.getInstitutionalProposal());
        this.getCommonApiService().saveDocument((Document)proposalDocument);
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/v2/institutional-proposals"}, consumes={"application/json"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    List<InstitutionalProposalDto> getIpByCriteria(@RequestParam(value="ipNumber", required=false) String ipNumber, @RequestParam(value="activeVersionOnly", required=false) boolean activeVersionOnly) {
        this.assertUserHasReadAccess();
        this.getCommonApiService().clearErrors();
        List<InstitutionalProposalDto> ipDtos = new ArrayList<InstitutionalProposalDto>();
        if (StringUtils.isBlank((CharSequence)ipNumber)) {
            throw new NotImplementedException("GET all institutional proposals not yet implemented in.");
        }
        if (StringUtils.isNotBlank((CharSequence)ipNumber)) {
            List<InstitutionalProposal> institutionalProposals = this.getInstitutionalProposalDao().getIpByIpNumber(ipNumber, activeVersionOnly);
            ipDtos = institutionalProposals.stream().map(institutionalProposal -> {
                InstitutionalProposalDto ipDto = this.getCommonApiService().convertObject(institutionalProposal, InstitutionalProposalDto.class);
                ipDto.setDocNbr(institutionalProposal.getInstitutionalProposalDocument().getDocumentNumber());
                return ipDto;
            }).collect(Collectors.toList());
        }
        return ipDtos;
    }

    public InstitutionalProposalDao getInstitutionalProposalDao() {
        return this.institutionalProposalDao;
    }

    public void setInstitutionalProposalDao(InstitutionalProposalDao institutionalProposalDao) {
        this.institutionalProposalDao = institutionalProposalDao;
    }

    public boolean isApiAuthEnabled() {
        return this.parameterService.getParameterValueAsBoolean("KC-GEN", "Document", "RESKC-2456_Enable_Api_Authorization");
    }

    protected void assertUserHasReadAccess() {
        if (this.isApiAuthEnabled() && (this.getGlobalVariableService().getUserSession() == null || !this.getPermissionService().hasPermissionByTemplate(this.getGlobalVariableService().getUserSession().getPrincipalId(), "KC-SYS", "Read Class", Collections.singletonMap("className", InstitutionalProposal.class.getName())))) {
            throw new UnauthorizedAccessException();
        }
    }

    protected void assertUserHasWriteAccess() {
        if (this.isApiAuthEnabled() && (this.getGlobalVariableService().getUserSession() == null || !this.getPermissionService().hasPermissionByTemplate(this.getGlobalVariableService().getUserSession().getPrincipalId(), "KC-SYS", "Write Class", Collections.singletonMap("className", InstitutionalProposal.class.getName())))) {
            throw new UnauthorizedAccessException();
        }
    }

    public PermissionService getPermissionService() {
        return this.permissionService;
    }

    public GlobalVariableService getGlobalVariableService() {
        return this.globalVariableService;
    }

    public RouteHeaderService getRouteHeaderService() {
        return this.routeHeaderService;
    }

    public void setRouteHeaderService(RouteHeaderService routeHeaderService) {
        this.routeHeaderService = routeHeaderService;
    }

    public InstitutionalProposalApiService getInstitutionalProposalApiService() {
        return this.institutionalProposalApiService;
    }

    public void setInstitutionalProposalApiService(InstitutionalProposalApiService institutionalProposalApiService) {
        this.institutionalProposalApiService = institutionalProposalApiService;
    }

    public RestAuditLoggerFactory getRestAuditLoggerFactory() {
        return this.restAuditLoggerFactory;
    }

    public void setRestAuditLoggerFactory(RestAuditLoggerFactory restAuditLoggerFactory) {
        this.restAuditLoggerFactory = restAuditLoggerFactory;
    }

    public CommonApiService getCommonApiService() {
        return this.commonApiService;
    }

    public void setCommonApiService(CommonApiService commonApiService) {
        this.commonApiService = commonApiService;
    }

    public DocumentService getDocumentService() {
        return this.documentService;
    }

    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }
}

