/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.infrastructure;

import java.util.Arrays;

public enum DocumentType {
    AWARD_DOCUMENT("AwardDocument"),
    AWARD_BUDGET_DOCUMENT("AwardBudgetDocument"),
    INSTITUTIONAL_PROPOSAL_DOCUMENT("InstitutionalProposalDocument"),
    NEGOTIATION_DOCUMENT("NegotiationDocument"),
    PROPOSAL_DEVELOPMENT_DOCUMENT("ProposalDevelopmentDocument"),
    SUBAWARD_DOCUMENT("SubAwardDocument");

    private final String name;

    private DocumentType(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public static DocumentType fromName(String name) {
        return Arrays.stream(DocumentType.values()).filter(d -> d.getName().equals(name)).findFirst().orElseThrow(() -> {
            throw new IllegalArgumentException("Invalid Document Type name " + name);
        });
    }
}

