/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.subaward.templateAttachments;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.math.NumberUtils;
import org.kuali.coeus.common.framework.attachment.AttachmentDocumentStatus;
import org.kuali.coeus.common.framework.attachment.KcAttachmentService;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.subaward.SubAwardForm;
import org.kuali.kra.subaward.bo.SubAward;
import org.kuali.kra.subaward.bo.SubAwardAttachments;
import org.kuali.kra.subaward.bo.SubAwardReports;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.service.BusinessObjectService;

public class SubAwardAttachmentFormBean
implements Serializable {
    private final SubAwardForm form;
    private SubAwardAttachments newAttachment;
    private SubAwardReports newReport;
    private boolean disableAttachmentRemovalIndicator = false;

    public SubAwardReports getNewReport() {
        if (this.newReport == null) {
            this.initReport();
        }
        return this.newReport;
    }

    public void setNewReport(SubAwardReports newReport) {
        this.newReport = newReport;
    }

    public SubAwardAttachmentFormBean(SubAwardForm form) {
        this.form = form;
    }

    public SubAwardAttachments getNewAttachment() {
        if (this.newAttachment == null) {
            this.initAttachment();
        }
        return this.newAttachment;
    }

    private void initReport() {
        this.setNewReport(new SubAwardReports(this.getSubAward()));
    }

    private void initAttachment() {
        this.setNewAttachment(new SubAwardAttachments(this.getSubAward()));
    }

    public void setNewAttachment(SubAwardAttachments newAttachment) {
        this.newAttachment = newAttachment;
    }

    public boolean isDisableAttachmentRemovalIndicator() {
        return this.disableAttachmentRemovalIndicator;
    }

    public void setDisableAttachmentRemovalIndicator(boolean disableAttachmentRemovalIndicator) {
        this.disableAttachmentRemovalIndicator = disableAttachmentRemovalIndicator;
    }

    public SubAwardForm getForm() {
        return this.form;
    }

    public SubAward getSubAward() {
        if (this.form.getSubAwardDocument() == null) {
            throw new IllegalArgumentException("the document is null");
        }
        if (this.form.getSubAwardDocument().getSubAward() == null) {
            throw new IllegalArgumentException("the subaward is null");
        }
        return this.form.getSubAwardDocument().getSubAward();
    }

    private Map<Integer, Integer> createTypeToMaxDocNumber(List<SubAwardAttachments> attachments) {
        HashMap<Integer, Integer> typeToDocNumber = new HashMap<Integer, Integer>();
        for (SubAwardAttachments attachment : attachments) {
            Integer curMax = (Integer)typeToDocNumber.get(attachment.getSubAwardAttachmentTypeCode());
            if (curMax != null && curMax >= attachment.getDocumentId()) continue;
            typeToDocNumber.put(attachment.getSubAwardAttachmentTypeCode(), attachment.getDocumentId());
        }
        return typeToDocNumber;
    }

    public SubAwardAttachments retrieveExistingAttachment(int attachmentNumber) {
        if (!SubAwardAttachmentFormBean.validIndexForList(attachmentNumber, this.getSubAward().getSubAwardAttachments())) {
            return null;
        }
        return this.getSubAward().getSubAwardAttachments().get(attachmentNumber);
    }

    private void initNewAttachment() {
        this.setNewAttachment(new SubAwardAttachments(this.getSubAward()));
    }

    private void initNewReport() {
        this.setNewReport(new SubAwardReports(this.getSubAward()));
    }

    private static boolean validIndexForList(int index, List<?> forList) {
        return forList != null && index >= 0 && index <= forList.size() - 1;
    }

    private void refreshAttachmentReferences(List<SubAwardAttachments> attachments) {
        assert (attachments != null) : "the attachments was null";
        for (SubAwardAttachments attachment : attachments) {
            attachment.refreshReferenceObject("typeAttachment");
        }
    }

    private void refreshReportReferences(List<SubAwardReports> reports) {
        assert (reports != null) : "the report was null";
        for (SubAwardReports report : reports) {
            report.refreshReferenceObject("typeCode");
        }
    }

    private void assignDocumentId(List<SubAwardAttachments> attachments, Map<Integer, Integer> typeToDocNumber) {
        for (SubAwardAttachments attachment : attachments) {
            if (!attachment.isNew()) continue;
            Integer nextDocNumber = SubAwardAttachmentFormBean.createNextDocNumber(typeToDocNumber.get(attachment.getSubAwardAttachmentTypeCode()));
            attachment.setDocumentId(nextDocNumber);
        }
    }

    private static Integer createNextDocNumber(Integer docNumber) {
        return docNumber == null ? NumberUtils.INTEGER_ONE : Integer.valueOf(docNumber + 1);
    }

    public void addNewAwardAttachment() {
        this.refreshAttachmentReferences(Collections.singletonList(this.getNewAttachment()));
        this.assignDocumentId(Collections.singletonList(this.getNewAttachment()), this.createTypeToMaxDocNumber(this.getSubAward().getSubAwardAttachments()));
        this.newAttachment.setSubAward(this.getSubAward());
        this.newAttachment.setDocumentStatusCode(AttachmentDocumentStatus.ACTIVE.getCode());
        this.getSubAward().addAttachment(this.newAttachment);
        this.getBusinessObjectService().save((PersistableBusinessObject)this.newAttachment);
        this.initNewAttachment();
    }

    public void addNewReport() {
        this.refreshReportReferences(Collections.singletonList(this.getNewReport()));
        this.newReport.setSubAwardId(this.getSubAward().getSubAwardId());
        this.getSubAward().addReport(this.newReport);
        this.getBusinessObjectService().save((PersistableBusinessObject)this.newReport);
        this.initNewReport();
    }

    private BusinessObjectService getBusinessObjectService() {
        return KcServiceLocator.getService(BusinessObjectService.class);
    }

    private KcAttachmentService getKcAttachmentService() {
        return KcServiceLocator.getService(KcAttachmentService.class);
    }
}

