/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.subawardReporting.printing.print;

import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.kuali.coeus.sys.framework.util.PdfBoxUtils;
import org.kuali.kra.award.printing.schema.AwardType;
import org.kuali.kra.subaward.printing.schema.SubContractDataDocument;
import org.kuali.kra.subawardReporting.printing.print.SubawardFdp;

public class SubAwardFDPModification
extends SubawardFdp {
    private static final String NO = "N";

    @Override
    protected void setSubrecipientInfo(PDDocument document, SubContractDataDocument.SubContractData.SubcontractDetail subcontractDetail) {
        if (StringUtils.isNotBlank((CharSequence)subcontractDetail.getSubcontractorName())) {
            PdfBoxUtils.setFieldAppearance(document, SubawardFdp.ModificationPdf.Field.SUBRECIPIENT.getfName(), "/ArialMT 8 Tf 0 g");
            PdfBoxUtils.setField(document, SubawardFdp.ModificationPdf.Field.SUBRECIPIENT.getfName(), subcontractDetail.getSubcontractorName());
        }
        if (StringUtils.isNotBlank((CharSequence)subcontractDetail.getSiteInvestigatorEmail())) {
            PdfBoxUtils.setFieldAppearance(document, SubawardFdp.ModificationPdf.Field.SUBEMAIL.getfName(), "/ArialMT 8 Tf 0 g");
            PdfBoxUtils.setField(document, SubawardFdp.ModificationPdf.Field.SUBEMAIL.getfName(), subcontractDetail.getSiteInvestigatorEmail());
        }
        if (StringUtils.isNotBlank((CharSequence)subcontractDetail.getSiteInvestigator())) {
            PdfBoxUtils.setFieldAppearance(document, SubawardFdp.ModificationPdf.Field.SUBPI.getfName(), "/ArialMT 8 Tf 0 g");
            PdfBoxUtils.setField(document, SubawardFdp.ModificationPdf.Field.SUBPI.getfName(), subcontractDetail.getSiteInvestigator());
        }
    }

    @Override
    protected void setPteInfo(PDDocument document, SubContractDataDocument xmlObject) {
        SubContractDataDocument.SubContractData.PrimePrincipalInvestigator primePrincipalInvestigator;
        SubContractDataDocument.SubContractData.PrimeRecipientContacts primeRecipientContacts = xmlObject.getSubContractData().getPrimeRecipientContacts() != null ? xmlObject.getSubContractData().getPrimeRecipientContacts() : SubContractDataDocument.SubContractData.PrimeRecipientContacts.Factory.newInstance();
        SubContractDataDocument.SubContractData.PrimePrincipalInvestigator primePrincipalInvestigator2 = primePrincipalInvestigator = ArrayUtils.isNotEmpty((Object[])xmlObject.getSubContractData().getPrimePrincipalInvestigatorArray()) ? xmlObject.getSubContractData().getPrimePrincipalInvestigatorArray()[0] : SubContractDataDocument.SubContractData.PrimePrincipalInvestigator.Factory.newInstance();
        if (primeRecipientContacts.getRequisitionerOrgDetails() != null) {
            PdfBoxUtils.setFieldAppearance(document, SubawardFdp.ModificationPdf.Field.PTE_ENTITY_NAME.getfName(), "/ArialMT 8 Tf 0 g");
            PdfBoxUtils.setField(document, SubawardFdp.ModificationPdf.Field.PTE_ENTITY_NAME.getfName(), primeRecipientContacts.getRequisitionerOrgDetails().getOrganizationName());
        }
        if (primePrincipalInvestigator.getPersonDetailsType() != null) {
            if (StringUtils.isNotBlank((CharSequence)primePrincipalInvestigator.getPersonDetailsType().getFullName())) {
                PdfBoxUtils.setFieldAppearance(document, SubawardFdp.ModificationPdf.Field.PTEPI.getfName(), "/ArialMT 8 Tf 0 g");
                PdfBoxUtils.setField(document, SubawardFdp.ModificationPdf.Field.PTEPI.getfName(), primePrincipalInvestigator.getPersonDetailsType().getFullName());
            }
            if (StringUtils.isNotBlank((CharSequence)primePrincipalInvestigator.getPersonDetailsType().getFullName())) {
                PdfBoxUtils.setFieldAppearance(document, SubawardFdp.ModificationPdf.Field.PTE_EMAIL.getfName(), "/ArialMT 8 Tf 0 g");
                PdfBoxUtils.setField(document, SubawardFdp.ModificationPdf.Field.PTE_EMAIL.getfName(), primePrincipalInvestigator.getPersonDetailsType().getEmailAddress());
            }
        }
    }

    @Override
    protected void setAwardSubawardNumbers(PDDocument document, SubContractDataDocument.SubContractData.SubcontractDetail subcontractDetail, AwardType award) {
        PdfBoxUtils.setFieldAppearance(document, SubawardFdp.ModificationPdf.Field.PTE_FEDERAL_AWARD_NO.getfName(), "/ArialMT 8 Tf 0 g");
        PdfBoxUtils.setField(document, SubawardFdp.ModificationPdf.Field.PTE_FEDERAL_AWARD_NO.getfName(), award.getAwardDetails().getAwardHeader().getSponsorAwardNumber());
        if (award.getAwardDetails().getAwardHeader().getSponsorDescription() != null) {
            PdfBoxUtils.setFieldAppearance(document, SubawardFdp.ModificationPdf.Field.FEDERAL_AWARDING_AGENCY.getfName(), "/ArialMT 8 Tf 0 g");
            PdfBoxUtils.setField(document, SubawardFdp.ModificationPdf.Field.FEDERAL_AWARDING_AGENCY.getfName(), award.getAwardDetails().getAwardHeader().getSponsorDescription());
        } else {
            PdfBoxUtils.setField(document, SubawardFdp.ModificationPdf.Field.FEDERAL_AWARDING_AGENCY.getfName(), "");
        }
    }

    @Override
    protected void setTitle(PDDocument pdfDocument, AwardType award) {
        PdfBoxUtils.setFieldAppearance(pdfDocument, SubawardFdp.ModificationPdf.Field.PROJECT_TITLE.getfName(), "/ArialMT 8 Tf 0 g");
        PdfBoxUtils.setField(pdfDocument, SubawardFdp.ModificationPdf.Field.PROJECT_TITLE.getfName(), award.getAwardDetails().getAwardHeader().getTitle());
    }

    @Override
    protected void setDates(PDDocument document, SubContractDataDocument xmlObject) {
        SubContractDataDocument.SubContractData.SubcontractAmountInfo amountInfo;
        SubContractDataDocument.SubContractData.SubcontractDetail subcontractDetail = xmlObject.getSubContractData().getSubcontractDetail() != null ? xmlObject.getSubContractData().getSubcontractDetail() : SubContractDataDocument.SubContractData.SubcontractDetail.Factory.newInstance();
        SubContractDataDocument.SubContractData.SubcontractAmountInfo subcontractAmountInfo = amountInfo = ArrayUtils.isNotEmpty((Object[])xmlObject.getSubContractData().getSubcontractAmountInfoArray()) ? xmlObject.getSubContractData().getSubcontractAmountInfoArray()[0] : SubContractDataDocument.SubContractData.SubcontractAmountInfo.Factory.newInstance();
        if (subcontractDetail.getStartDate() != null) {
            PdfBoxUtils.setFieldAppearance(document, SubawardFdp.ModificationPdf.Field.START_DATE.getfName(), "/ArialMT 8 Tf 0 g");
            PdfBoxUtils.setField(document, SubawardFdp.ModificationPdf.Field.START_DATE.getfName(), this.formatDate(subcontractDetail.getStartDate().getTime()));
        }
        if (amountInfo.getPerformanceEndDate() != null) {
            PdfBoxUtils.setFieldAppearance(document, SubawardFdp.ModificationPdf.Field.END_DATE.getfName(), "/ArialMT 8 Tf 0 g");
            PdfBoxUtils.setField(document, SubawardFdp.ModificationPdf.Field.END_DATE.getfName(), this.formatDate(amountInfo.getPerformanceEndDate().getTime()));
        }
        if (amountInfo.getModificationEffectiveDate() != null) {
            PdfBoxUtils.setFieldAppearance(document, SubawardFdp.ModificationPdf.Field.EFFECTIVE_DATE.getfName(), "/ArialMT 8 Tf 0 g");
            PdfBoxUtils.setField(document, SubawardFdp.ModificationPdf.Field.EFFECTIVE_DATE.getfName(), this.formatDate(amountInfo.getModificationEffectiveDate().getTime()));
        }
        if (amountInfo.getModificationNumber() != null) {
            PdfBoxUtils.setFieldAppearance(document, SubawardFdp.ModificationPdf.Field.AMENDMENT_NUMBER.getfName(), "/ArialMT 8 Tf 0 g");
            PdfBoxUtils.setField(document, SubawardFdp.ModificationPdf.Field.AMENDMENT_NUMBER.getfName(), amountInfo.getModificationNumber());
        }
    }

    @Override
    protected void setAmounts(PDDocument document, SubContractDataDocument xmlObject) {
        SubContractDataDocument.SubContractData.SubcontractAmountInfo amountInfo;
        SubContractDataDocument.SubContractData.SubcontractAmountInfo subcontractAmountInfo = amountInfo = ArrayUtils.isNotEmpty((Object[])xmlObject.getSubContractData().getSubcontractAmountInfoArray()) ? xmlObject.getSubContractData().getSubcontractAmountInfoArray()[0] : SubContractDataDocument.SubContractData.SubcontractAmountInfo.Factory.newInstance();
        if (amountInfo.getObligatedChange() != null) {
            PdfBoxUtils.setFieldAppearance(document, SubawardFdp.ModificationPdf.Field.AMOUNT_FUNDED_THIS_ACTION.getfName(), "/ArialMT 8 Tf 0 g");
            PdfBoxUtils.setField(document, SubawardFdp.ModificationPdf.Field.AMOUNT_FUNDED_THIS_ACTION.getfName(), amountInfo.getObligatedChange().toPlainString());
        }
        if (amountInfo.getObligatedAmount() != null) {
            PdfBoxUtils.setFieldAppearance(document, SubawardFdp.ModificationPdf.Field.TOTAL_FEDERAL_FUNDS_OBLIGATED.getfName(), "/ArialMT 8 Tf 0 g");
            PdfBoxUtils.setField(document, SubawardFdp.ModificationPdf.Field.TOTAL_FEDERAL_FUNDS_OBLIGATED.getfName(), amountInfo.getObligatedAmount().toPlainString());
        }
    }

    @Override
    protected void setTermsAndConditions(PDDocument document, SubContractDataDocument xmlObject) {
        SubContractDataDocument.SubContractData.SubcontractDetail subcontractDetail;
        SubContractDataDocument.SubContractData.SubcontractDetail subcontractDetail2 = subcontractDetail = xmlObject.getSubContractData().getSubcontractDetail() != null ? xmlObject.getSubContractData().getSubcontractDetail() : SubContractDataDocument.SubContractData.SubcontractDetail.Factory.newInstance();
        if (subcontractDetail.getComments() != null) {
            PdfBoxUtils.setFieldAppearance(document, SubawardFdp.ModificationPdf.Field.ACTION.getfName(), "/ArialMT 8 Tf 0 g");
            PdfBoxUtils.setField(document, SubawardFdp.ModificationPdf.Field.ACTION.getfName(), subcontractDetail.getComments());
        }
    }

    @Override
    protected void setMiscellaneousItems(PDDocument document, SubContractDataDocument xmlObject) {
        SubContractDataDocument.SubContractData.SubcontractTemplateInfo templateInfo;
        SubContractDataDocument.SubContractData.SubcontractDetail subcontractDetail = xmlObject.getSubContractData().getSubcontractDetail() != null ? xmlObject.getSubContractData().getSubcontractDetail() : SubContractDataDocument.SubContractData.SubcontractDetail.Factory.newInstance();
        SubContractDataDocument.SubContractData.SubcontractTemplateInfo subcontractTemplateInfo = templateInfo = ArrayUtils.isNotEmpty((Object[])xmlObject.getSubContractData().getSubcontractTemplateInfoArray()) ? xmlObject.getSubContractData().getSubcontractTemplateInfoArray(0) : SubContractDataDocument.SubContractData.SubcontractTemplateInfo.Factory.newInstance();
        if (subcontractDetail.getFsrsSubawardNumber() != null) {
            PdfBoxUtils.setFieldAppearance(document, SubawardFdp.ModificationPdf.Field.SUBAWARD_NUMBER.getfName(), "/ArialMT 8 Tf 0 g");
            PdfBoxUtils.setField(document, SubawardFdp.ModificationPdf.Field.SUBAWARD_NUMBER.getfName(), subcontractDetail.getFsrsSubawardNumber());
        }
        PdfBoxUtils.setField(document, SubawardFdp.ModificationPdf.Field.SUBJECTO_FFATA.getfName(), subcontractDetail.getFFATA() == null || subcontractDetail.getFFATA().equalsIgnoreCase(NO) ? "No" : "Yes");
        PdfBoxUtils.setField(document, SubawardFdp.ModificationPdf.Field.CARRYOVER_RADIO_BUTTON.getfName(), templateInfo.getAutomaticCarryForward() == null || templateInfo.getAutomaticCarryForward().equalsIgnoreCase(NO) ? "CarryoverNo" : "CarryoverYes");
    }
}

