/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.committee.impl.lookup;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.committee.impl.bo.CommitteeBase;
import org.kuali.coeus.common.committee.impl.bo.CommitteeScheduleBase;
import org.kuali.coeus.common.committee.impl.document.authorization.CommitteeScheduleTaskBase;
import org.kuali.coeus.common.committee.impl.document.authorization.CommitteeTaskBase;
import org.kuali.coeus.common.framework.auth.task.Task;
import org.kuali.coeus.common.framework.auth.task.TaskAuthorizationService;
import org.kuali.rice.kns.lookup.HtmlData;
import org.kuali.rice.kns.lookup.KualiLookupableHelperServiceImpl;
import org.kuali.rice.kns.lookup.LookupUtils;
import org.kuali.rice.kns.web.ui.Field;
import org.kuali.rice.kns.web.ui.Row;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.lookup.CollectionIncomplete;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.UrlFactory;

public abstract class CommitteeScheduleLookupableHelperServiceImplBase<CS extends CommitteeScheduleBase<CS, CMT, ?, ?>, CMT extends CommitteeBase<CMT, ?, CS>, CMTTSK extends CommitteeTaskBase<CMT>, CSTSK extends CommitteeScheduleTaskBase<CMT, CS>>
extends KualiLookupableHelperServiceImpl {
    private static final String READ_ONLY = "readOnly";
    private static final String COMMITTEE_COMMITTEE_NAME = "committee.committeeName";
    private static final String COMMITTEE_COMMITTEE_TYPE_CODE = "committee.committeeTypeCode";
    private static final String COMMITTEE_ID = "committeeId";
    private static final String SEQUENCE_NUMBER = "sequenceNumber";
    private static final String SCHEDULE_PERSON_ID_LOOKUP = "committee.committeeMemberships.personId";
    private TaskAuthorizationService taskAuthorizationService;
    private List<Long> activeCommitteePKs = new ArrayList<Long>();
    private List<Long> inActiveCommitteePKs = new ArrayList<Long>();

    protected boolean isCurrentVersion(CMT committee) {
        boolean retValue = false;
        if (this.activeCommitteePKs.contains(((CommitteeBase)committee).getId())) {
            retValue = true;
        } else if (!this.inActiveCommitteePKs.contains(((CommitteeBase)committee).getId())) {
            HashMap<String, String> fieldValues = new HashMap<String, String>();
            fieldValues.put(COMMITTEE_ID, ((CommitteeBase)committee).getCommitteeId());
            List committees = (List)this.getBusinessObjectService().findMatchingOrderBy(this.getCommonCommitteeBOClassHook(), fieldValues, SEQUENCE_NUMBER, false);
            if (committees != null && !committees.isEmpty()) {
                if (((CommitteeBase)committees.get(0)).equals(committee)) {
                    retValue = true;
                }
                this.activeCommitteePKs.add(((CommitteeBase)committees.get(0)).getId());
                committees.remove(0);
                for (CommitteeBase cmt : committees) {
                    this.inActiveCommitteePKs.add(cmt.getId());
                }
            }
        }
        return retValue;
    }

    protected abstract Class<CMT> getCommonCommitteeBOClassHook();

    public List<? extends BusinessObject> getSearchResults(Map<String, String> fieldValues) {
        fieldValues.put(COMMITTEE_COMMITTEE_TYPE_CODE, this.getCommitteeTypeCodeHook());
        List rawCommitteeSchedules = super.getSearchResultsUnbounded(fieldValues);
        ArrayList<Object> finalCommitteeSchedules = new ArrayList<Object>();
        for (Object schedule2 : rawCommitteeSchedules) {
            if (((CommitteeScheduleBase)schedule2).getParentCommittee() == null || !this.isCurrentVersion(((CommitteeScheduleBase)schedule2).getParentCommittee())) continue;
            if (StringUtils.isNotBlank((CharSequence)fieldValues.get(SCHEDULE_PERSON_ID_LOOKUP))) {
                if ((!((CommitteeScheduleBase)schedule2).isActiveFor(fieldValues.get(SCHEDULE_PERSON_ID_LOOKUP)) || !((CommitteeScheduleBase)schedule2).isAvailableToReviewers()) && !this.canModifySchedule(schedule2)) continue;
                finalCommitteeSchedules.add(schedule2);
                continue;
            }
            finalCommitteeSchedules.add(schedule2);
        }
        Collections.sort(finalCommitteeSchedules);
        if (StringUtils.isNotBlank((CharSequence)fieldValues.get(SCHEDULE_PERSON_ID_LOOKUP))) {
            CommitteeScheduleBase schedule;
            Object schedule2;
            ArrayList<CommitteeScheduleBase> pastCommitteeSchedules = new ArrayList<CommitteeScheduleBase>();
            schedule2 = finalCommitteeSchedules.iterator();
            while (schedule2.hasNext() && (schedule = (CommitteeScheduleBase)schedule2.next()).isScheduleDateInPast()) {
                pastCommitteeSchedules.add(schedule);
            }
            finalCommitteeSchedules.removeAll(pastCommitteeSchedules);
            Collections.reverse(pastCommitteeSchedules);
            finalCommitteeSchedules.addAll(pastCommitteeSchedules);
        }
        Long matchingResultsCount = new Long(finalCommitteeSchedules.size());
        Integer searchResultsLimit = LookupUtils.getSearchResultsLimit(this.getCommitteeScheduleBOClassHook());
        if (matchingResultsCount == null || matchingResultsCount.intValue() <= searchResultsLimit) {
            return new CollectionIncomplete(finalCommitteeSchedules, new Long(0L));
        }
        return new CollectionIncomplete(this.trimResult(finalCommitteeSchedules, searchResultsLimit), matchingResultsCount);
    }

    protected abstract Class<CS> getCommitteeScheduleBOClassHook();

    protected abstract String getCommitteeTypeCodeHook();

    protected List<CS> trimResult(List<CS> result, Integer trimSize) {
        ArrayList<CommitteeScheduleBase> trimmedResult = new ArrayList<CommitteeScheduleBase>();
        for (CommitteeScheduleBase committeeSchedule : result) {
            if (trimmedResult.size() >= trimSize) continue;
            trimmedResult.add(committeeSchedule);
        }
        return trimmedResult;
    }

    public List<HtmlData> getCustomActionUrls(BusinessObject businessObject, List pkNames) {
        ArrayList<HtmlData> htmlDataList = new ArrayList<HtmlData>();
        boolean canModify = this.canModifySchedule((CommitteeScheduleBase)businessObject);
        boolean canView = this.canViewSchedule((CommitteeScheduleBase)businessObject);
        if (canModify) {
            htmlDataList.add((HtmlData)this.getLink((CommitteeScheduleBase)businessObject, true));
            htmlDataList.add((HtmlData)this.getLink((CommitteeScheduleBase)businessObject, false));
        } else if (canView) {
            htmlDataList.add((HtmlData)this.getLink((CommitteeScheduleBase)businessObject, false));
        }
        if (((CommitteeScheduleBase)businessObject).isScheduleDateInPast() && (canModify || canView)) {
            HtmlData.AnchorHtmlData htmlData = new HtmlData.AnchorHtmlData();
            htmlData.setDisplayText("(past)");
            htmlDataList.add((HtmlData)htmlData);
        }
        return htmlDataList;
    }

    protected String getUserIdentifier() {
        return GlobalVariables.getUserSession().getPrincipalId();
    }

    protected HtmlData.AnchorHtmlData getLink(CS committeeSchedule, boolean isEdit) {
        HtmlData.AnchorHtmlData htmlData = new HtmlData.AnchorHtmlData();
        Properties parameters = new Properties();
        parameters.put("methodToCall", "start");
        parameters.put("scheduleId", ((CommitteeScheduleBase)committeeSchedule).getId().toString());
        if (isEdit) {
            htmlData.setDisplayText("edit");
            parameters.put(READ_ONLY, "false");
        } else {
            htmlData.setDisplayText("view");
            parameters.put(READ_ONLY, "true");
        }
        String href = UrlFactory.parameterizeUrl((String)("../" + this.getMeetingManagementActionIdHook() + ".do"), (Properties)parameters);
        htmlData.setHref(href);
        return htmlData;
    }

    protected abstract String getMeetingManagementActionIdHook();

    public HtmlData getInquiryUrl(BusinessObject bo, String propertyName) {
        BusinessObject inqBo = bo;
        String inqPropertyName = propertyName;
        if (COMMITTEE_COMMITTEE_NAME.equals(propertyName)) {
            return new HtmlData.AnchorHtmlData();
        }
        return super.getInquiryUrl(inqBo, inqPropertyName);
    }

    protected boolean canModifySchedule(CS committeeSchedule) {
        CMTTSK task = this.getNewCommitteeTaskInstanceHook("modifySchedule", ((CommitteeScheduleBase)committeeSchedule).getParentCommittee());
        return this.taskAuthorizationService.isAuthorized(this.getUserIdentifier(), (Task)task);
    }

    protected abstract CMTTSK getNewCommitteeTaskInstanceHook(String var1, CMT var2);

    protected boolean canViewSchedule(CS committeeSchedule) {
        CSTSK task = this.getNewCommitteeScheduleTaskInstanceHook("viewSchedule", ((CommitteeScheduleBase)committeeSchedule).getParentCommittee(), committeeSchedule);
        boolean result = this.taskAuthorizationService.isAuthorized(this.getUserIdentifier(), (Task)task);
        return result;
    }

    protected abstract CSTSK getNewCommitteeScheduleTaskInstanceHook(String var1, CMT var2, CS var3);

    public void setTaskAuthorizationService(TaskAuthorizationService taskAuthorizationService) {
        this.taskAuthorizationService = taskAuthorizationService;
    }

    public List<Row> getRows() {
        List rows = super.getRows();
        for (Row row : rows) {
            for (Field field : row.getFields()) {
                if (!"committee.committeeId".equals(field.getPropertyName()) && !COMMITTEE_COMMITTEE_NAME.equals(field.getPropertyName())) continue;
                field.setQuickFinderClassNameImpl("");
            }
        }
        return rows;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }
}

