/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.impl.krms;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.kuali.coeus.common.impl.krms.FunctionParamComparator;
import org.kuali.coeus.common.impl.krms.FunctionTermResolver;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krms.api.engine.TermResolver;
import org.kuali.rice.krms.api.repository.function.FunctionDefinition;
import org.kuali.rice.krms.api.repository.function.FunctionParameterDefinition;
import org.kuali.rice.krms.api.repository.function.FunctionRepositoryService;
import org.kuali.rice.krms.api.repository.term.TermResolverDefinition;
import org.kuali.rice.krms.framework.type.TermResolverTypeService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public abstract class FunctionTermResolverTypeServiceBase
implements TermResolverTypeService {
    @Autowired
    @Qualifier(value="businessObjectService")
    private BusinessObjectService businessObjectService;
    @Autowired
    @Qualifier(value="functionRepositoryService")
    private FunctionRepositoryService functionRepositoryService;

    public abstract FunctionTermResolver createFunctionResolver(List<String> var1, Set<String> var2, String var3, FunctionDefinition var4);

    public TermResolver<?> loadTermResolver(TermResolverDefinition termResolverDefinition) {
        String functionId = termResolverDefinition.getOutput().getName();
        FunctionDefinition functionTerm = this.functionRepositoryService.getFunction(functionId);
        if (functionTerm == null) {
            throw new RuntimeException("Not able to find Term for function : " + functionId);
        }
        List<String> params = this.getFunctionParameters(functionTerm);
        Set paramNames = termResolverDefinition.getParameterNames();
        return this.createFunctionResolver(params, paramNames, functionId, functionTerm);
    }

    private List<String> getFunctionParameters(FunctionDefinition functionTerm) {
        List functionParams = functionTerm.getParameters();
        ArrayList modifiableParams = new ArrayList(functionParams);
        Collections.sort(modifiableParams, new FunctionParamComparator());
        ArrayList<String> params = new ArrayList<String>();
        for (FunctionParameterDefinition termResolverFunctionParamDefinition : modifiableParams) {
            params.add(termResolverFunctionParamDefinition.getName());
        }
        return params;
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public FunctionRepositoryService getFunctionRepositoryService() {
        return this.functionRepositoryService;
    }

    public void setFunctionRepositoryService(FunctionRepositoryService functionRepositoryService) {
        this.functionRepositoryService = functionRepositoryService;
    }
}

