/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.impl.unit;

import java.util.HashSet;
import java.util.Set;
import org.kuali.coeus.common.framework.auth.UnitAuthorizationService;
import org.kuali.coeus.common.framework.person.KcPersonService;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kns.document.MaintenanceDocumentBase;
import org.kuali.rice.kns.document.authorization.MaintenanceDocumentAuthorizerBase;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.exception.AuthorizationException;
import org.kuali.rice.krad.util.GlobalVariables;

public class UnitMaintenanceDocumentAuthorizer
extends MaintenanceDocumentAuthorizerBase {
    private static final String UNIT = "Unit";
    private KcPersonService kcPersonService;
    private UnitAuthorizationService unitAuthorizationService;

    public Set<String> getDocumentActions(Document document, Person user, Set<String> documentActions) {
        Set actions = this.getDocumentActions(document);
        actions = super.getDocumentActions(document, user, actions);
        return actions;
    }

    protected Set<String> getDocumentActions(Document document) {
        Set<Object> documentActions = new HashSet();
        String personId = this.getKcPersonService().getKcPersonByPersonId(GlobalVariables.getUserSession().getPerson().getPrincipalId()).getPersonId();
        boolean hasModifyPermission = this.getUnitAuthorizationService().hasPermission(personId, "KC-UNT", "Modify Unit");
        boolean hasAddPermission = this.getUnitAuthorizationService().hasPermission(personId, "KC-UNT", "Add Unit");
        documentActions = hasModifyPermission ? this.getDocumentActionsWithModifyPermission(document) : (hasAddPermission ? this.getDocumentActionsWithAddPermission(document) : this.getDocumentActionsWithViewPermission(document));
        return documentActions;
    }

    private Set<String> getDocumentActionsWithModifyPermission(Document document) {
        HashSet<String> documentActions = new HashSet<String>();
        if (document.getDocumentHeader().getWorkflowDocument().isInitiated() || document.getDocumentHeader().getWorkflowDocument().isSaved()) {
            documentActions.add("canEdit");
            documentActions.add("canEditDocumentOverview");
            documentActions.add("canSave");
            documentActions.add("canClose");
            documentActions.add("canCancel");
            documentActions.add("canBlanketApprove");
            documentActions.add("canRoute");
        } else {
            documentActions.add("canReload");
            documentActions.add("canClose");
        }
        return documentActions;
    }

    private Set<String> getDocumentActionsWithAddPermission(Document document) {
        HashSet<String> documentActions = new HashSet<String>();
        String maintenanceAction = ((MaintenanceDocumentBase)document).getNewMaintainableObject().getMaintenanceAction();
        if (document.getDocumentHeader().getWorkflowDocument().isInitiated()) {
            if (maintenanceAction.equals("Copy")) {
                throw new AuthorizationException(GlobalVariables.getUserSession().getPerson().getPrincipalName(), "Copy", UNIT);
            }
            documentActions.add("canEdit");
            documentActions.add("canEditDocumentOverview");
            documentActions.add("canSave");
            documentActions.add("canClose");
            documentActions.add("canCancel");
            documentActions.add("canBlanketApprove");
            documentActions.add("canRoute");
        } else {
            documentActions.add("canReload");
            documentActions.add("canClose");
        }
        return documentActions;
    }

    private Set<String> getDocumentActionsWithViewPermission(Document document) {
        HashSet<String> documentActions = new HashSet<String>();
        String maintenanceAction = ((MaintenanceDocumentBase)document).getNewMaintainableObject().getMaintenanceAction();
        if (document.getDocumentHeader().getWorkflowDocument().isInitiated()) {
            if (maintenanceAction.equals("Copy")) {
                throw new AuthorizationException(GlobalVariables.getUserSession().getPerson().getPrincipalName(), "Copy", UNIT);
            }
            if (maintenanceAction.equals("New")) {
                throw new AuthorizationException(GlobalVariables.getUserSession().getPerson().getPrincipalName(), "Create", UNIT);
            }
            documentActions.add("canReload");
            documentActions.add("canClose");
        } else {
            documentActions.add("canReload");
            documentActions.add("canClose");
        }
        return documentActions;
    }

    public KcPersonService getKcPersonService() {
        if (this.kcPersonService == null) {
            this.kcPersonService = KcServiceLocator.getService(KcPersonService.class);
        }
        return this.kcPersonService;
    }

    public void setKcPersonService(KcPersonService kcPersonService) {
        this.kcPersonService = kcPersonService;
    }

    public UnitAuthorizationService getUnitAuthorizationService() {
        if (this.unitAuthorizationService == null) {
            this.unitAuthorizationService = KcServiceLocator.getService(UnitAuthorizationService.class);
        }
        return this.unitAuthorizationService;
    }

    public void setUnitAuthorizationService(UnitAuthorizationService unitAuthorizationService) {
        this.unitAuthorizationService = unitAuthorizationService;
    }
}

