/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.iacuc.threers;

import java.util.Date;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.sys.framework.rule.KcBusinessRule;
import org.kuali.coeus.sys.framework.rule.KcTransactionalDocumentRuleBase;
import org.kuali.kra.iacuc.threers.AddAlternateSearchEvent;
import org.kuali.rice.krad.datadictionary.validation.result.DictionaryValidationResult;
import org.kuali.rice.krad.util.GlobalVariables;

public class AddAlternateSearchRule
extends KcTransactionalDocumentRuleBase
implements KcBusinessRule<AddAlternateSearchEvent> {
    private static final String ERROR_PATH_PREFIX = "iacucAlternateSearchHelper.newAlternateSearch.";
    private static final String DD_ENTRY_NAME = "IacucAlternateSearch";

    @Override
    public boolean processRules(AddAlternateSearchEvent event) {
        return this.validateRequiredFields(event);
    }

    private boolean validateRequiredFields(AddAlternateSearchEvent event) {
        boolean valid = true;
        valid &= this.validateSearchDate(event);
        valid &= this.validateDatabases(event);
        valid &= this.validateYears(event);
        return valid &= this.validateKeywords(event);
    }

    private boolean validateSearchDate(AddAlternateSearchEvent event) {
        java.sql.Date searchDate = event.getAlternateSearch().getSearchDate();
        if (searchDate != null) {
            DictionaryValidationResult result = this.getDictionaryValidationService().validate((Object)searchDate, DD_ENTRY_NAME, "searchDate", false);
            if (result.getNumberOfErrors() == 0) {
                Date currentDate = new Date();
                if (!searchDate.after(currentDate)) {
                    return true;
                }
                GlobalVariables.getMessageMap().putError("iacucAlternateSearchHelper.newAlternateSearch.searchDate", "error.iacuc.validation.searchdate.after.currentdate", new String[]{"Search Date"});
                return false;
            }
            GlobalVariables.getMessageMap().putError("iacucAlternateSearchHelper.newAlternateSearch.searchDate", "error.iacuc.validation.alternate.search", new String[]{"Search Date"});
            return false;
        }
        GlobalVariables.getMessageMap().putError("iacucAlternateSearchHelper.newAlternateSearch.searchDate", "error.iacuc.validation.alternate.search", new String[]{"Search Date"});
        return false;
    }

    private boolean validateDatabases(AddAlternateSearchEvent event) {
        List<String> newDatabases = event.getSelectedDatabases();
        if (CollectionUtils.isNotEmpty(newDatabases)) {
            return true;
        }
        GlobalVariables.getMessageMap().putError("iacucAlternateSearchHelper.newAlternateSearch.databases", "error.required", new String[]{"Databases"});
        return false;
    }

    private boolean validateYears(AddAlternateSearchEvent event) {
        String years = event.getAlternateSearch().getYearsSearched();
        if (StringUtils.isNotBlank((CharSequence)years)) {
            DictionaryValidationResult result = this.getDictionaryValidationService().validate((Object)years, DD_ENTRY_NAME, "yearsSearched", false);
            if (result.getNumberOfErrors() == 0) {
                return true;
            }
            GlobalVariables.getMessageMap().putError("iacucAlternateSearchHelper.newAlternateSearch.yearsSearched", "error.iacuc.validation.alternate.search", new String[]{"Years"});
            return false;
        }
        GlobalVariables.getMessageMap().putError(ERROR_PATH_PREFIX, "error.required", new String[]{"Years"});
        return false;
    }

    private boolean validateKeywords(AddAlternateSearchEvent event) {
        String keywords = event.getAlternateSearch().getKeywords();
        if (StringUtils.isNotBlank((CharSequence)keywords)) {
            DictionaryValidationResult result = this.getDictionaryValidationService().validate((Object)keywords, DD_ENTRY_NAME, "keywords", false);
            if (result.getNumberOfErrors() == 0) {
                return true;
            }
            GlobalVariables.getMessageMap().putError("iacucAlternateSearchHelper.newAlternateSearch.keywords", "error.iacuc.validation.alternate.search", new String[]{"Keywords"});
            return false;
        }
        GlobalVariables.getMessageMap().putError(ERROR_PATH_PREFIX, "error.required", new String[]{"Keywords"});
        return false;
    }
}

