/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.irb.personnel;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.irb.personnel.ProtocolPersonnelService;
import org.kuali.kra.protocol.personnel.ProtocolPersonRoleMappingBase;
import org.kuali.rice.core.api.util.ConcreteKeyValue;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.krad.uif.control.UifKeyValuesFinderBase;

public class ProtocolPersonRoleValuesFinder
extends UifKeyValuesFinderBase {
    private String sourceRoleId;
    private String sourceRoleReferenceObject = "sourceRole";
    private String targetRoleReferenceObject = "targetRole";

    public List<KeyValue> getKeyValues() {
        List<ProtocolPersonRoleMappingBase> validPersonRoles = this.getProtocolPersonnelService().getPersonRoleMapping(this.getSourceRoleId());
        ArrayList<ConcreteKeyValue> keyValues = new ArrayList<ConcreteKeyValue>();
        keyValues.add(new ConcreteKeyValue(this.getSourceRoleId(), this.getSourceRoleDescription()));
        for (ProtocolPersonRoleMappingBase protocolPersonRole : validPersonRoles) {
            keyValues.add(new ConcreteKeyValue(protocolPersonRole.getTargetRoleId(), this.getTargetRoleDescription(protocolPersonRole)));
        }
        Collections.sort(keyValues);
        ArrayList<KeyValue> returnKeyValues = new ArrayList<KeyValue>();
        returnKeyValues.addAll(keyValues);
        return returnKeyValues;
    }

    private String getSourceRoleDescription() {
        return this.getProtocolPersonnelService().getProtocolPersonRole(this.getSourceRoleId()).getDescription();
    }

    private String getTargetRoleDescription(ProtocolPersonRoleMappingBase protocolPersonRole) {
        protocolPersonRole.refreshReferenceObject(this.targetRoleReferenceObject);
        return protocolPersonRole.getTargetRole().getDescription();
    }

    private ProtocolPersonnelService getProtocolPersonnelService() {
        return KcServiceLocator.getService(ProtocolPersonnelService.class);
    }

    public String getSourceRoleId() {
        return this.sourceRoleId;
    }

    public void setSourceRoleId(String sourceRoleId) {
        this.sourceRoleId = sourceRoleId;
    }
}

