/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.personmasschange.service.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.kuali.coeus.common.api.rolodex.RolodexContract;
import org.kuali.coeus.common.framework.person.KcPerson;
import org.kuali.coeus.common.framework.person.editable.PersonEditableService;
import org.kuali.kra.irb.Protocol;
import org.kuali.kra.irb.actions.submit.ProtocolReviewer;
import org.kuali.kra.irb.onlinereview.ProtocolOnlineReview;
import org.kuali.kra.irb.personnel.ProtocolPersonTrainingService;
import org.kuali.kra.personmasschange.bo.PersonMassChange;
import org.kuali.kra.personmasschange.service.ProtocolPersonMassChangeService;
import org.kuali.kra.personmasschange.service.impl.MassPersonChangeServiceBase;
import org.kuali.kra.protocol.onlinereview.ProtocolOnlineReviewBase;
import org.kuali.kra.protocol.personnel.ProtocolPersonBase;
import org.kuali.kra.protocol.personnel.ProtocolUnitBase;
import org.kuali.rice.krad.bo.PersistableBusinessObject;

public class ProtocolPersonMassChangeServiceImpl
extends MassPersonChangeServiceBase
implements ProtocolPersonMassChangeService {
    private static final String PROTOCOL_NUMBER = "protocolNumber";
    private static final String SEQUENCE_NUMBER = "sequenceNumber";
    private static final String PROTOCOL = "protocol";
    private static final String IRB_WARNINGS = "irbWarnings";
    private PersonEditableService personEditableService;
    private ProtocolPersonTrainingService protocolPersonTrainingService;

    @Override
    public List<Protocol> getProtocolChangeCandidates(PersonMassChange personMassChange) {
        ArrayList<Protocol> protocolChangeCandidates = new ArrayList<Protocol>();
        ArrayList<Protocol> protocols = new ArrayList<Protocol>();
        if (personMassChange.getProtocolPersonMassChange().requiresChange()) {
            protocols.addAll(this.getProtocols(personMassChange));
        }
        for (Protocol protocol : protocols) {
            if (!this.isProtocolChangeCandidate(personMassChange, protocol)) continue;
            protocolChangeCandidates.add(protocol);
        }
        for (Protocol protocolChangeCandidate : protocolChangeCandidates) {
            if (protocolChangeCandidate.getProtocolDocument().getPessimisticLocks().isEmpty()) continue;
            this.reportSoftError(protocolChangeCandidate);
        }
        return protocolChangeCandidates;
    }

    private List<Protocol> getProtocols(PersonMassChange personMassChange) {
        ArrayList<Protocol> protocols = new ArrayList<Protocol>();
        Collection allProtocols = this.getBusinessObjectService().findAll(Protocol.class);
        if (personMassChange.isChangeAllSequences()) {
            protocols.addAll(allProtocols);
        } else {
            protocols.addAll(this.getLatestProtocols(allProtocols));
        }
        return protocols;
    }

    private List<Protocol> getLatestProtocols(Collection<Protocol> protocols) {
        ArrayList<Protocol> latestProtocols = new ArrayList<Protocol>();
        for (String uniqueProtocolNumber : this.getUniqueProtocolNumbers(protocols)) {
            HashMap<String, String> fieldValues = new HashMap<String, String>();
            fieldValues.put(PROTOCOL_NUMBER, uniqueProtocolNumber);
            Collection uniqueProtocols = this.getBusinessObjectService().findMatchingOrderBy(Protocol.class, fieldValues, SEQUENCE_NUMBER, false);
            if (uniqueProtocols.isEmpty()) continue;
            latestProtocols.add((Protocol)CollectionUtils.get((Iterable)uniqueProtocols, (int)0));
        }
        return latestProtocols;
    }

    private Set<String> getUniqueProtocolNumbers(Collection<Protocol> protocols) {
        HashSet<String> uniqueProtocolIds = new HashSet<String>();
        for (Protocol protocol : protocols) {
            uniqueProtocolIds.add(protocol.getProtocolNumber());
        }
        return uniqueProtocolIds;
    }

    private boolean isProtocolChangeCandidate(PersonMassChange personMassChange, Protocol protocol) {
        boolean isProtocolChangeCandidate = false;
        boolean hasErrors = false;
        List<ProtocolPersonBase> persons = protocol.getProtocolPersons();
        List<ProtocolOnlineReviewBase> onlineReviews = protocol.getProtocolOnlineReviews();
        String[] investigatorRoles = new String[]{"PI", "COI"};
        String[] keyStudyPersonRoles = new String[]{"SP"};
        String[] correspondentsRoles = new String[]{"CRC", "CA"};
        if (personMassChange.getProtocolPersonMassChange().isInvestigator()) {
            isProtocolChangeCandidate |= this.isPersonChangeCandidate(personMassChange, persons, investigatorRoles);
        }
        if (personMassChange.getProtocolPersonMassChange().isKeyStudyPerson()) {
            isProtocolChangeCandidate |= this.isPersonChangeCandidate(personMassChange, persons, keyStudyPersonRoles);
        }
        if (personMassChange.getProtocolPersonMassChange().isCorrespondents()) {
            isProtocolChangeCandidate |= this.isPersonChangeCandidate(personMassChange, persons, correspondentsRoles);
        }
        if (isProtocolChangeCandidate) {
            hasErrors |= !this.isReplacerValidPersonChangeCandidate(personMassChange, persons);
        }
        if (personMassChange.getProtocolPersonMassChange().isReviewer()) {
            isProtocolChangeCandidate |= this.isReviewerChangeCandidate(personMassChange, onlineReviews);
        }
        return isProtocolChangeCandidate && !hasErrors;
    }

    private boolean isReviewerChangeCandidate(PersonMassChange personMassChange, List<ProtocolOnlineReview> onlineReviews) {
        boolean isReviewerChangeCandidate = false;
        for (ProtocolOnlineReview onlineReview : onlineReviews) {
            ProtocolReviewer reviewer = (ProtocolReviewer)onlineReview.getProtocolReviewer();
            if (!this.isPersonIdMassChange(personMassChange, reviewer.getPersonId()) && !this.isRolodexIdMassChange(personMassChange, reviewer.getRolodexId())) continue;
            isReviewerChangeCandidate = true;
            break;
        }
        return isReviewerChangeCandidate;
    }

    @Override
    public void performPersonMassChange(PersonMassChange personMassChange, List<Protocol> protocolChangeCandidates) {
        for (Protocol protocolChangeCandidate : protocolChangeCandidates) {
            if (!protocolChangeCandidate.getProtocolDocument().getPessimisticLocks().isEmpty()) continue;
            this.performInvestigatorPersonMassChange(personMassChange, protocolChangeCandidate);
            this.performKeyStudyPersonPersonMassChange(personMassChange, protocolChangeCandidate);
            this.performCorrespondentsPersonMassChange(personMassChange, protocolChangeCandidate);
            this.performReviewerPersonMassChange(personMassChange, protocolChangeCandidate);
        }
    }

    private void performInvestigatorPersonMassChange(PersonMassChange personMassChange, Protocol protocol) {
        if (personMassChange.getProtocolPersonMassChange().isInvestigator()) {
            String[] personRoles = new String[]{"PI", "COI"};
            this.performPersonPersonMassChange(personMassChange, protocol, personRoles);
        }
    }

    private void performKeyStudyPersonPersonMassChange(PersonMassChange personMassChange, Protocol protocol) {
        if (personMassChange.getProtocolPersonMassChange().isKeyStudyPerson()) {
            String[] personRoles = new String[]{"SP"};
            this.performPersonPersonMassChange(personMassChange, protocol, personRoles);
        }
    }

    private void performCorrespondentsPersonMassChange(PersonMassChange personMassChange, Protocol protocol) {
        if (personMassChange.getProtocolPersonMassChange().isCorrespondents()) {
            String[] personRoles = new String[]{"CRC", "CA"};
            this.performPersonPersonMassChange(personMassChange, protocol, personRoles);
        }
    }

    private void performPersonPersonMassChange(PersonMassChange personMassChange, Protocol protocol, String ... personRoles) {
        for (ProtocolPersonBase person : protocol.getProtocolPersons()) {
            if (!this.isPersonInRole(person, personRoles) || !this.isPersonIdMassChange(personMassChange, person.getPersonId()) && !this.isRolodexIdMassChange(personMassChange, person.getRolodexId())) continue;
            if (personMassChange.getReplacerPersonId() != null) {
                KcPerson kcPerson = this.getKcPersonService().getKcPersonByPersonId(personMassChange.getReplacerPersonId());
                person.setPersonId(personMassChange.getReplacerPersonId());
                person.setRolodexId(null);
                person.setPersonName(kcPerson.getFullName());
                this.getPersonEditableService().populateContactFieldsFromPersonId(person);
                this.getProtocolPersonTrainingService().setTrainedFlag(person);
                for (ProtocolUnitBase unit : person.getProtocolUnits()) {
                    unit.setPersonId(personMassChange.getReplacerPersonId());
                }
            } else if (personMassChange.getReplacerRolodexId() != null) {
                RolodexContract rolodex = this.getRolodexService().getRolodex(personMassChange.getReplacerRolodexId());
                person.setPersonId(null);
                person.setRolodexId(rolodex.getRolodexId());
                person.setPersonName(rolodex.getFullName());
                this.getPersonEditableService().populateContactFieldsFromRolodexId(person);
                this.getProtocolPersonTrainingService().setTrainedFlag(person);
                for (ProtocolUnitBase unit : person.getProtocolUnits()) {
                    unit.setPersonId(null);
                }
            }
            this.getBusinessObjectService().save((PersistableBusinessObject)person);
        }
    }

    private void performReviewerPersonMassChange(PersonMassChange personMassChange, Protocol protocol) {
        if (personMassChange.getProtocolPersonMassChange().isReviewer()) {
            for (ProtocolOnlineReviewBase onlineReview : protocol.getProtocolOnlineReviews()) {
                ProtocolReviewer reviewer = (ProtocolReviewer)onlineReview.getProtocolReviewer();
                if (!this.isPersonIdMassChange(personMassChange, reviewer.getPersonId()) && !this.isRolodexIdMassChange(personMassChange, reviewer.getRolodexId())) continue;
                if (personMassChange.getReplacerPersonId() != null) {
                    KcPerson kcPerson = this.getKcPersonService().getKcPersonByPersonId(personMassChange.getReplacerPersonId());
                    reviewer.setPersonId(kcPerson.getPersonId());
                    reviewer.setRolodexId(null);
                    reviewer.setNonEmployeeFlag(false);
                } else if (personMassChange.getReplacerRolodexId() != null) {
                    RolodexContract rolodex = this.getRolodexService().getRolodex(personMassChange.getReplacerRolodexId());
                    reviewer.setRolodexId(rolodex.getRolodexId());
                    reviewer.setPersonId(null);
                    reviewer.setNonEmployeeFlag(true);
                }
                this.getBusinessObjectService().save((PersistableBusinessObject)reviewer);
            }
        }
    }

    private void reportSoftError(Protocol protocol) {
        String protocolNumber = protocol.getProtocolNumber();
        this.errorReporter.reportSoftError("personMassChangeDocumentLocked", "error.personMassChange.document.locked", PROTOCOL, protocolNumber);
    }

    public PersonEditableService getPersonEditableService() {
        return this.personEditableService;
    }

    public void setPersonEditableService(PersonEditableService personEditableService) {
        this.personEditableService = personEditableService;
    }

    public ProtocolPersonTrainingService getProtocolPersonTrainingService() {
        return this.protocolPersonTrainingService;
    }

    public void setProtocolPersonTrainingService(ProtocolPersonTrainingService protocolPersonTrainingService) {
        this.protocolPersonTrainingService = protocolPersonTrainingService;
    }

    @Override
    protected String getDocumentId(PersistableBusinessObject parent) {
        return ((Protocol)parent).getProtocolNumber();
    }

    @Override
    protected String getDocumentName() {
        return PROTOCOL;
    }

    @Override
    protected String getWarningKey() {
        return IRB_WARNINGS;
    }
}

