/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.excon.project;

import java.io.Serializable;
import java.util.List;
import org.kuali.kra.excon.document.ExconProjectDocument;
import org.kuali.kra.excon.project.ExconProject;
import org.kuali.kra.excon.project.ExconProjectComment;
import org.kuali.kra.excon.project.ExconProjectForm;
import org.kuali.kra.excon.rules.ExconProjectCommentAddRuleImpl;

public class ExconProjectCommentsBean
implements Serializable {
    private static final long serialVersionUID = 234678678457L;
    protected ExconProjectComment newComment;
    protected ExconProjectForm exconProjectForm;

    public ExconProjectCommentsBean(ExconProjectForm exconProjectForm) {
        this.exconProjectForm = exconProjectForm;
        this.init();
    }

    public void addExconProjectComment() {
        boolean success = new ExconProjectCommentAddRuleImpl().processAddExconProjectCommentBusinessRules(this.getExconProject(), this.getExconProjectComment());
        if (success) {
            this.getExconProject().add(this.getExconProjectComment());
            this.init();
        }
    }

    public void deleteExconProjectComment(int lineToDelete) {
        this.deleteExconProjectComment(this.getExconProjectComments(), lineToDelete);
    }

    public ExconProjectComment getNewComment() {
        return this.newComment;
    }

    public ExconProjectComment getExconProjectComment() {
        return this.newComment;
    }

    public List<ExconProjectComment> getExconProjectComments() {
        return ((ExconProjectDocument)this.exconProjectForm.getDocument()).getExconProject().getExconProjectComments();
    }

    public int getExconProjectCommentsCount() {
        return this.getExconProjectComments().size();
    }

    protected void deleteExconProjectComment(List<ExconProjectComment> comments, int lineToDelete) {
        if (comments.size() > lineToDelete) {
            ExconProjectComment foundComment = comments.get(lineToDelete);
            this.getExconProject().getExconProjectComments().remove(foundComment);
        }
    }

    protected void init() {
        this.newComment = new ExconProjectComment();
    }

    protected ExconProject getExconProject() {
        return this.getDocument().getExconProject();
    }

    protected ExconProjectDocument getDocument() {
        return this.exconProjectForm.getExconProjectDocument();
    }
}

