/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.budget.framework.core;

import java.sql.Date;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.MappedSuperclass;
import javax.persistence.Transient;
import org.kuali.coeus.common.budget.framework.rate.RateClass;
import org.kuali.coeus.sys.api.model.ScaleTwoDecimal;
import org.kuali.coeus.sys.framework.model.KcPersistableBusinessObjectBase;
import org.kuali.coeus.sys.framework.persistence.ScaleTwoDecimalConverter;
import org.kuali.rice.krad.data.jpa.PortableSequenceGenerator;
import org.kuali.rice.krad.data.jpa.converters.BooleanYNConverter;

@MappedSuperclass
public abstract class AbstractBudget
extends KcPersistableBusinessObjectBase
implements Comparable<AbstractBudget> {
    private static final long serialVersionUID = -4997453399414404715L;
    @Column(name="VERSION_NUMBER")
    private Integer budgetVersionNumber;
    @PortableSequenceGenerator(name="SEQ_BUDGET_ID")
    @GeneratedValue(generator="SEQ_BUDGET_ID")
    @Id
    @Column(name="BUDGET_ID")
    private Long budgetId;
    @Column(name="DOCUMENT_NUMBER")
    private String documentNumber;
    @Column(name="COST_SHARING_AMOUNT")
    @Convert(converter=ScaleTwoDecimalConverter.class)
    private ScaleTwoDecimal costSharingAmount;
    @Column(name="END_DATE")
    private Date endDate;
    @Column(name="START_DATE")
    private Date startDate;
    @Column(name="OH_RATE_TYPE_CODE")
    private String ohRateTypeCode;
    @Column(name="OH_RATE_CLASS_CODE")
    private String ohRateClassCode;
    @Column(name="RESIDUAL_FUNDS")
    @Convert(converter=ScaleTwoDecimalConverter.class)
    private ScaleTwoDecimal residualFunds;
    @Column(name="TOTAL_COST")
    @Convert(converter=ScaleTwoDecimalConverter.class)
    private ScaleTwoDecimal totalCost;
    @Column(name="TOTAL_DIRECT_COST")
    @Convert(converter=ScaleTwoDecimalConverter.class)
    private ScaleTwoDecimal totalDirectCost;
    @Column(name="TOTAL_INDIRECT_COST")
    @Convert(converter=ScaleTwoDecimalConverter.class)
    private ScaleTwoDecimal totalIndirectCost;
    @Column(name="TOTAL_COST_LIMIT")
    @Convert(converter=ScaleTwoDecimalConverter.class)
    private ScaleTwoDecimal totalCostLimit;
    @Column(name="TOTAL_DIRECT_COST_LIMIT")
    @Convert(converter=ScaleTwoDecimalConverter.class)
    private ScaleTwoDecimal totalDirectCostLimit;
    @Column(name="UNDERRECOVERY_AMOUNT")
    @Convert(converter=ScaleTwoDecimalConverter.class)
    private ScaleTwoDecimal underrecoveryAmount;
    @Column(name="COMMENTS")
    @Lob
    private String comments;
    @Column(name="MODULAR_BUDGET_FLAG")
    @Convert(converter=BooleanYNConverter.class)
    private Boolean modularBudgetFlag = Boolean.FALSE;
    @Column(name="EXCLUDE_SUBCONFA_FROM_DC_SYNC")
    @Convert(converter=BooleanYNConverter.class)
    private Boolean excludeSubconFAFromDirectCostSync = Boolean.FALSE;
    @Column(name="UR_RATE_CLASS_CODE")
    private String urRateClassCode;
    @Column(name="ON_OFF_CAMPUS_FLAG")
    private String onOffCampusFlag;
    @Column(name="SUBMIT_COST_SHARING")
    @Convert(converter=BooleanYNConverter.class)
    private Boolean submitCostSharingFlag = Boolean.TRUE;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.REFRESH})
    @JoinColumn(name="UR_RATE_CLASS_CODE", referencedColumnName="RATE_CLASS_CODE", insertable=false, updatable=false)
    private RateClass urRateClass;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.REFRESH})
    @JoinColumn(name="OH_RATE_CLASS_CODE", referencedColumnName="RATE_CLASS_CODE", insertable=false, updatable=false)
    private RateClass rateClass;
    @Transient
    private boolean nameUpdatable;
    @Column(name="BUDGET_NAME")
    private String name;
    @Transient
    private String printBudgetCommentFlag;

    public Integer getBudgetVersionNumber() {
        return this.budgetVersionNumber;
    }

    public void setBudgetVersionNumber(Integer budgetVersionNumber) {
        this.budgetVersionNumber = budgetVersionNumber;
    }

    public ScaleTwoDecimal getCostSharingAmount() {
        return this.costSharingAmount == null ? ScaleTwoDecimal.ZERO : this.costSharingAmount;
    }

    public void setCostSharingAmount(ScaleTwoDecimal costSharingAmount) {
        this.costSharingAmount = costSharingAmount;
    }

    public String getOhRateTypeCode() {
        return this.ohRateTypeCode;
    }

    public void setOhRateTypeCode(String ohRateTypeCode) {
        this.ohRateTypeCode = ohRateTypeCode;
    }

    public String getOhRateClassCode() {
        return this.ohRateClassCode;
    }

    public void setOhRateClassCode(String ohRateClassCode) {
        this.ohRateClassCode = ohRateClassCode;
    }

    public RateClass getRateClass() {
        return this.rateClass;
    }

    public void setRateClass(RateClass rateClass) {
        this.rateClass = rateClass;
    }

    public String getDocumentNumber() {
        return this.documentNumber;
    }

    public void setDocumentNumber(String documentNumber) {
        this.documentNumber = documentNumber;
    }

    public ScaleTwoDecimal getResidualFunds() {
        return this.residualFunds;
    }

    public void setResidualFunds(ScaleTwoDecimal residualFunds) {
        this.residualFunds = residualFunds;
    }

    public ScaleTwoDecimal getTotalCost() {
        return this.totalCost == null ? ScaleTwoDecimal.ZERO : this.totalCost;
    }

    public void setTotalCost(ScaleTwoDecimal totalCost) {
        this.totalCost = totalCost;
    }

    public void setTotalDirectCost(ScaleTwoDecimal totalDirectCost) {
        this.totalDirectCost = totalDirectCost;
    }

    public void setTotalIndirectCost(ScaleTwoDecimal totalIndirectCost) {
        this.totalIndirectCost = totalIndirectCost;
    }

    public void setUnderrecoveryAmount(ScaleTwoDecimal underrecoveryAmount) {
        this.underrecoveryAmount = underrecoveryAmount;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public ScaleTwoDecimal getTotalCostLimit() {
        return this.totalCostLimit == null ? ScaleTwoDecimal.ZERO : this.totalCostLimit;
    }

    public void setTotalCostLimit(ScaleTwoDecimal totalCostLimit) {
        this.totalCostLimit = totalCostLimit;
    }

    public ScaleTwoDecimal getTotalDirectCost() {
        return this.totalDirectCost == null ? ScaleTwoDecimal.ZERO : this.totalDirectCost;
    }

    public ScaleTwoDecimal getTotalIndirectCost() {
        return this.totalIndirectCost == null ? ScaleTwoDecimal.ZERO : this.totalIndirectCost;
    }

    public ScaleTwoDecimal getUnderrecoveryAmount() {
        return this.underrecoveryAmount == null ? ScaleTwoDecimal.ZERO : this.underrecoveryAmount;
    }

    public String getComments() {
        return this.comments;
    }

    public void setComments(String comments) {
        this.comments = comments;
    }

    @Override
    public int compareTo(AbstractBudget otherVersion) {
        return this.budgetVersionNumber.compareTo(otherVersion.getBudgetVersionNumber());
    }

    public Long getBudgetId() {
        return this.budgetId;
    }

    public void setBudgetId(Long budgetId) {
        this.budgetId = budgetId;
    }

    public Boolean getModularBudgetFlag() {
        return this.modularBudgetFlag;
    }

    public void setModularBudgetFlag(Boolean modularBudgetFlag) {
        this.modularBudgetFlag = modularBudgetFlag;
    }

    public Boolean getExcludeSubconFAFromDirectCostSync() {
        return this.excludeSubconFAFromDirectCostSync;
    }

    public void setExcludeSubconFAFromDirectCostSync(Boolean excludeSubconFAFromDirectCostSync) {
        this.excludeSubconFAFromDirectCostSync = excludeSubconFAFromDirectCostSync;
    }

    public String getUrRateClassCode() {
        return this.urRateClassCode;
    }

    public void setUrRateClassCode(String urRateClassCode) {
        this.urRateClassCode = urRateClassCode;
    }

    public String getOnOffCampusFlag() {
        return this.onOffCampusFlag;
    }

    public void setOnOffCampusFlag(String onOffCampusFlag) {
        this.onOffCampusFlag = onOffCampusFlag;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.budgetId == null ? 0 : this.budgetId.hashCode());
        result = 31 * result + (this.budgetVersionNumber == null ? 0 : this.budgetVersionNumber.hashCode());
        result = 31 * result + (this.comments == null ? 0 : this.comments.hashCode());
        result = 31 * result + (this.costSharingAmount == null ? 0 : this.costSharingAmount.hashCode());
        result = 31 * result + (this.documentNumber == null ? 0 : this.documentNumber.hashCode());
        result = 31 * result + (this.endDate == null ? 0 : this.endDate.hashCode());
        result = 31 * result + (this.modularBudgetFlag == null ? 0 : this.modularBudgetFlag.hashCode());
        result = 31 * result + (this.excludeSubconFAFromDirectCostSync == null ? 0 : this.excludeSubconFAFromDirectCostSync.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.ohRateClassCode == null ? 0 : this.ohRateClassCode.hashCode());
        result = 31 * result + (this.ohRateTypeCode == null ? 0 : this.ohRateTypeCode.hashCode());
        result = 31 * result + (this.onOffCampusFlag == null ? 0 : this.onOffCampusFlag.hashCode());
        result = 31 * result + (this.rateClass == null ? 0 : this.rateClass.hashCode());
        result = 31 * result + (this.residualFunds == null ? 0 : this.residualFunds.hashCode());
        result = 31 * result + (this.startDate == null ? 0 : this.startDate.hashCode());
        result = 31 * result + (this.totalCost == null ? 0 : this.totalCost.hashCode());
        result = 31 * result + (this.totalCostLimit == null ? 0 : this.totalCostLimit.hashCode());
        result = 31 * result + (this.totalDirectCost == null ? 0 : this.totalDirectCost.hashCode());
        result = 31 * result + (this.totalIndirectCost == null ? 0 : this.totalIndirectCost.hashCode());
        result = 31 * result + (this.underrecoveryAmount == null ? 0 : this.underrecoveryAmount.hashCode());
        result = 31 * result + (this.urRateClassCode == null ? 0 : this.urRateClassCode.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractBudget other = (AbstractBudget)obj;
        if (this.budgetId == null ? other.budgetId != null : !this.budgetId.equals(other.budgetId)) {
            return false;
        }
        if (this.budgetVersionNumber == null ? other.budgetVersionNumber != null : !this.budgetVersionNumber.equals(other.budgetVersionNumber)) {
            return false;
        }
        if (this.comments == null ? other.comments != null : !this.comments.equals(other.comments)) {
            return false;
        }
        if (this.costSharingAmount == null ? other.costSharingAmount != null : !this.costSharingAmount.equals((Object)other.costSharingAmount)) {
            return false;
        }
        if (this.documentNumber == null ? other.documentNumber != null : !this.documentNumber.equals(other.documentNumber)) {
            return false;
        }
        if (this.endDate == null ? other.endDate != null : !this.endDate.equals(other.endDate)) {
            return false;
        }
        if (this.modularBudgetFlag == null ? other.modularBudgetFlag != null : !this.modularBudgetFlag.equals(other.modularBudgetFlag)) {
            return false;
        }
        if (this.excludeSubconFAFromDirectCostSync == null ? other.excludeSubconFAFromDirectCostSync != null : !this.excludeSubconFAFromDirectCostSync.equals(other.excludeSubconFAFromDirectCostSync)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.ohRateClassCode == null ? other.ohRateClassCode != null : !this.ohRateClassCode.equals(other.ohRateClassCode)) {
            return false;
        }
        if (this.ohRateTypeCode == null ? other.ohRateTypeCode != null : !this.ohRateTypeCode.equals(other.ohRateTypeCode)) {
            return false;
        }
        if (this.onOffCampusFlag == null ? other.onOffCampusFlag != null : !this.onOffCampusFlag.equals(other.onOffCampusFlag)) {
            return false;
        }
        if (this.rateClass == null ? other.rateClass != null : !this.rateClass.equals(other.rateClass)) {
            return false;
        }
        if (this.residualFunds == null ? other.residualFunds != null : !this.residualFunds.equals((Object)other.residualFunds)) {
            return false;
        }
        if (this.startDate == null ? other.startDate != null : !this.startDate.equals(other.startDate)) {
            return false;
        }
        if (this.totalCost == null ? other.totalCost != null : !this.totalCost.equals((Object)other.totalCost)) {
            return false;
        }
        if (this.totalCostLimit == null ? other.totalCostLimit != null : !this.totalCostLimit.equals((Object)other.totalCostLimit)) {
            return false;
        }
        if (this.totalDirectCost == null ? other.totalDirectCost != null : !this.totalDirectCost.equals((Object)other.totalDirectCost)) {
            return false;
        }
        if (this.totalIndirectCost == null ? other.totalIndirectCost != null : !this.totalIndirectCost.equals((Object)other.totalIndirectCost)) {
            return false;
        }
        if (this.underrecoveryAmount == null ? other.underrecoveryAmount != null : !this.underrecoveryAmount.equals((Object)other.underrecoveryAmount)) {
            return false;
        }
        return !(this.urRateClassCode == null ? other.urRateClassCode != null : !this.urRateClassCode.equals(other.urRateClassCode));
    }

    public ScaleTwoDecimal getTotalDirectCostLimit() {
        return this.totalDirectCostLimit == null ? ScaleTwoDecimal.ZERO : this.totalDirectCostLimit;
    }

    public void setTotalDirectCostLimit(ScaleTwoDecimal totalDirectCostLimit) {
        this.totalDirectCostLimit = totalDirectCostLimit;
    }

    public void setPrintBudgetCommentFlag(String printBudgetCommentFlag) {
        this.printBudgetCommentFlag = printBudgetCommentFlag;
    }

    public String getPrintBudgetCommentFlag() {
        return this.printBudgetCommentFlag;
    }

    public Boolean getSubmitCostSharingFlag() {
        return this.submitCostSharingFlag;
    }

    public void setSubmitCostSharingFlag(Boolean submitCostSharingFlag) {
        this.submitCostSharingFlag = submitCostSharingFlag;
    }

    public RateClass getUrRateClass() {
        return this.urRateClass;
    }

    public void setUrRateClass(RateClass urRateClass) {
        this.urRateClass = urRateClass;
    }

    public boolean isNameUpdatable() {
        return this.nameUpdatable;
    }

    public void setNameUpdatable(boolean nameUpdatable) {
        this.nameUpdatable = nameUpdatable;
    }
}

