/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.budget.impl.struts;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.coeus.common.budget.framework.calculator.BudgetCalculationService;
import org.kuali.coeus.common.budget.framework.core.Budget;
import org.kuali.coeus.common.budget.framework.core.BudgetForm;
import org.kuali.coeus.common.budget.framework.core.BudgetParent;
import org.kuali.coeus.common.budget.framework.core.BudgetService;
import org.kuali.coeus.common.budget.framework.core.category.BudgetCategoryTypeValuesFinder;
import org.kuali.coeus.common.budget.framework.distribution.BudgetDistributionService;
import org.kuali.coeus.common.budget.framework.lock.BudgetLockService;
import org.kuali.coeus.common.budget.framework.nonpersonnel.BudgetLineItem;
import org.kuali.coeus.common.budget.framework.nonpersonnel.BudgetLineItemCalculatedAmount;
import org.kuali.coeus.common.budget.framework.period.BudgetPeriod;
import org.kuali.coeus.common.budget.framework.personnel.BudgetPerson;
import org.kuali.coeus.common.budget.framework.personnel.BudgetPersonService;
import org.kuali.coeus.common.budget.framework.personnel.BudgetPersonnelCalculatedAmount;
import org.kuali.coeus.common.budget.framework.personnel.BudgetPersonnelDetails;
import org.kuali.coeus.common.budget.framework.print.BudgetPrintService;
import org.kuali.coeus.common.budget.framework.rate.BudgetRatesService;
import org.kuali.coeus.common.budget.framework.summary.BudgetSummaryService;
import org.kuali.coeus.common.budget.impl.struts.BudgetActionBase;
import org.kuali.coeus.common.framework.print.AttachmentDataSource;
import org.kuali.coeus.common.framework.rolodex.PersonRolodex;
import org.kuali.coeus.common.framework.version.VersionStatus;
import org.kuali.coeus.common.framework.version.history.VersionHistory;
import org.kuali.coeus.common.framework.version.history.VersionHistoryService;
import org.kuali.coeus.propdev.impl.budget.modular.BudgetModularService;
import org.kuali.coeus.propdev.impl.budget.subaward.PropDevBudgetSubAwardService;
import org.kuali.coeus.propdev.impl.core.ProposalDevelopmentDocument;
import org.kuali.coeus.sys.framework.controller.StrutsConfirmation;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.coeus.sys.framework.workflow.KcDocumentRejectionService;
import org.kuali.kra.award.budget.AwardBudgetExt;
import org.kuali.kra.award.budget.calculator.AwardBudgetCalculationService;
import org.kuali.kra.award.budget.document.AwardBudgetDocument;
import org.kuali.kra.award.document.AwardDocument;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.award.home.ContactRole;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kns.datadictionary.HeaderNavigation;
import org.kuali.rice.kns.datadictionary.KNSDocumentEntry;
import org.kuali.rice.kns.service.DataDictionaryService;
import org.kuali.rice.kns.util.KNSGlobalVariables;
import org.kuali.rice.kns.util.WebUtils;
import org.kuali.rice.kns.web.struts.form.KualiDocumentFormBase;
import org.kuali.rice.kns.web.struts.form.KualiForm;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.rules.rule.event.DocumentAuditEvent;
import org.kuali.rice.krad.rules.rule.event.DocumentEvent;
import org.kuali.rice.krad.service.DocumentService;
import org.kuali.rice.krad.service.KualiRuleService;
import org.kuali.rice.krad.service.PessimisticLockService;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.ObjectUtils;

public class BudgetAction
extends BudgetActionBase {
    private static final Logger LOG = LogManager.getLogger(BudgetAction.class);
    private static final String DOCUMENT_REJECT_QUESTION = "DocReject";
    protected static final String CONFIRM_SYNCH_BUDGET_RATE = "confirmSynchBudgetRate";
    protected static final String NO_SYNCH_BUDGET_RATE = "noSynchBudgetRate";
    protected static final String CONFIRM_SYNCH_AWARD_RATES = "confirmSynchAwardRates";
    protected static final String NO_SYNCH_AWARD_RATES = "noSynchAwardRates";
    public static final String BUDGET_SUMMARY_TOTALS_ACTION = "BudgetSummaryTotalsAction";
    public static final String BUDGET_PERSON = "budgetPerson";
    public static final String SAVE = "save";
    public static final String BUDGET_ACTIONS = "budgetActions";
    public static final String RATE_CLASS = "rateClass";
    public static final String BUDGET_PERIODS = "budgetPeriods";
    public static final String TRUE = "TRUE";
    public static final String PROPOSAL_HIERARCHY_SUB_PROJECT_INDIRECT_COST_ELEMENT = "proposalHierarchySubProjectIndirectCostElement";
    public static final String SUMMARY_TOTALS = "summaryTotals";
    public static final String ROUTE = "route";
    public static final String SYNC_QUESTION_ASKED = "syncQuestionAsked";

    @Override
    public ActionForward docHandler(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = super.docHandler(mapping, form, request, response);
        BudgetForm budgetForm = (BudgetForm)form;
        if ("initiate".equals(budgetForm.getCommand())) {
            budgetForm.getBudgetDocument().initialize();
        } else {
            budgetForm.initialize();
        }
        AwardBudgetDocument awardBudgetDocument = budgetForm.getBudgetDocument();
        AwardBudgetExt budget = awardBudgetDocument.getBudget();
        this.copyLineItemToPersonnelDetails(awardBudgetDocument);
        if (budget.getActivityTypeCode().equals("x")) {
            budget.setActivityTypeCode(KcServiceLocator.getService(BudgetService.class).getActivityTypeForBudget(budget));
        }
        if (budget.getOhRateClassCode() != null && KNSGlobalVariables.getKualiForm() != null) {
            ((BudgetForm)KNSGlobalVariables.getKualiForm()).setOhRateClassCodePrevValue(budget.getOhRateClassCode());
        }
        if (budget.getUrRateClassCode() != null && KNSGlobalVariables.getKualiForm() != null) {
            ((BudgetForm)KNSGlobalVariables.getKualiForm()).setUrRateClassCodePrevValue(budget.getUrRateClassCode());
        }
        budget.setStartDate(((Budget)budget).getBudgetParent().getRequestedStartDateInitial());
        budget.setEndDate(((Budget)budget).getBudgetParent().getRequestedEndDateInitial());
        if (this.isAwardBudget(budget) && StringUtils.isNotBlank((CharSequence)budgetForm.getSyncBudgetRate()) && budgetForm.getSyncBudgetRate().equals("Y")) {
            this.getBudgetRatesService().syncParentDocumentRates(budget);
            this.getBudgetCommonService(((Budget)budget).getBudgetParent()).recalculateBudget(budget);
        }
        if ("Personnel".equals(budgetForm.getActivePanelName())) {
            forward = this.personnel(mapping, (ActionForm)budgetForm, request, response);
        }
        return forward;
    }

    protected StrutsConfirmation syncAwardBudgetRateConfirmationQuestion(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response, String message) throws Exception {
        return this.buildParameterizedConfirmationQuestion(mapping, form, request, response, CONFIRM_SYNCH_AWARD_RATES, message, "");
    }

    public ActionForward confirmSynchAwardRates(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.synchAwardBudgetRate(form, true);
    }

    public ActionForward noSynchAwardRates(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.synchAwardBudgetRate(form, false);
    }

    private ActionForward synchAwardBudgetRate(ActionForm form, boolean confirm) throws Exception {
        BudgetForm budgetForm = (BudgetForm)form;
        AwardBudgetDocument budgetDoc = budgetForm.getBudgetDocument();
        String routeHeaderId = budgetDoc.getDocumentHeader().getWorkflowDocument().getDocumentId();
        String forward = this.buildForwardUrl(routeHeaderId);
        forward = confirm ? forward.replace("awardBudgetVersions.do?", "awardBudgetParameters.do?syncBudgetRate=Y&") : forward.replace("awardBudgetVersions.do?", "awardBudgetVersions.do?syncQuestionAsked=Y&");
        return new ActionForward(forward, true);
    }

    protected boolean isAwardBudget(Budget budget) {
        return budget instanceof AwardBudgetExt;
    }

    private BudgetRatesService getBudgetRatesService() {
        return KcServiceLocator.getService(BudgetRatesService.class);
    }

    public List<HeaderNavigation> getBudgetHeaderNavigatorList() {
        DataDictionaryService dataDictionaryService = (DataDictionaryService)KcServiceLocator.getService("dataDictionaryService");
        KNSDocumentEntry docEntry = (KNSDocumentEntry)dataDictionaryService.getDataDictionary().getDocumentEntry(Budget.class.getName());
        return docEntry.getHeaderNavigationList();
    }

    @Override
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward actionForward = null;
        BudgetForm budgetForm = (BudgetForm)form;
        if (budgetForm != null) {
            if (budgetForm.getMethodToCall().equals("close")) {
                this.setupDocumentExit();
            }
            if ((actionForward = super.execute(mapping, (ActionForm)budgetForm, request, response)) != null && SUMMARY_TOTALS.equals(actionForward.getName())) {
                budgetForm.suppressButtonsForTotalPage();
            }
            if (budgetForm.isAuditActivated() && !ROUTE.equals(((KualiForm)form).getMethodToCall())) {
                KcServiceLocator.getService(KualiRuleService.class).applyRules((DocumentEvent)new DocumentAuditEvent((Document)budgetForm.getBudgetDocument()));
            }
        } else {
            this.setupDocumentExit();
        }
        return actionForward;
    }

    @Override
    public ActionForward save(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BudgetForm budgetForm = (BudgetForm)form;
        AwardBudgetDocument budgetDoc = budgetForm.getBudgetDocument();
        budgetForm.getDocument().prepareForSave();
        AwardBudgetExt budget = budgetDoc.getBudget();
        if (budgetForm.getActionName().equals(BUDGET_SUMMARY_TOTALS_ACTION)) {
            this.getBudgetCommonService(((Budget)budget).getBudgetParent()).calculateBudgetOnSave(budget);
        } else {
            this.getBudgetCalculationService().calculateBudget(budget);
        }
        ActionForward forward = super.save(mapping, form, request, response);
        if (budgetForm.getMethodToCall().equals(SAVE) && budgetForm.isAuditActivated()) {
            forward = mapping.findForward(BUDGET_ACTIONS);
        }
        return forward;
    }

    public BudgetCalculationService getBudgetCalculationService() {
        return KcServiceLocator.getService(AwardBudgetCalculationService.class);
    }

    protected BudgetSummaryService getBudgetSummaryService() {
        return KcServiceLocator.getService(BudgetSummaryService.class);
    }

    @Override
    public ActionForward reload(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = super.reload(mapping, form, request, response);
        this.updateBudgetAttributes(form, request);
        return forward;
    }

    @Override
    public ActionForward reloadWithoutWarning(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = super.reloadWithoutWarning(mapping, form, request, response);
        this.updateBudgetAttributes(form, request);
        return forward;
    }

    protected void updateBudgetAttributes(ActionForm form, HttpServletRequest request) {
        BudgetForm budgetForm = (BudgetForm)form;
        AwardBudgetDocument awardBudgetDocument = budgetForm.getBudgetDocument();
        this.populateBudgetPrintForms(awardBudgetDocument.getBudget());
    }

    public ActionForward versions(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        return mapping.findForward("versions");
    }

    public ActionForward parameters(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        AwardBudgetDocument awardBudgetDocument = ((BudgetForm)form).getBudgetDocument();
        this.getBudgetSummaryService().setupOldStartEndDate(awardBudgetDocument.getBudget(), false);
        return mapping.findForward("parameters");
    }

    public ActionForward personnel(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        BudgetForm budgetForm = (BudgetForm)form;
        Budget budget = budgetForm.getBudget();
        this.populatePersonnelCategoryTypeCodes(budgetForm);
        if (budgetForm.getBudgetDocument().getBudget().getBudgetPersons().isEmpty()) {
            KcServiceLocator.getService(BudgetPersonService.class).synchBudgetPersonsToProposal(budgetForm.getBudgetDocument().getBudget());
        }
        this.reconcilePersonnelRoles(budget);
        for (BudgetPeriod period : budget.getBudgetPeriods()) {
            for (BudgetLineItem lineItem : period.getBudgetLineItems()) {
                for (BudgetPersonnelDetails budgetPersonnelDetails : lineItem.getBudgetPersonnelDetailsList()) {
                    budgetPersonnelDetails.refreshReferenceObject(BUDGET_PERSON);
                    ObjectUtils.materializeObjects(budgetPersonnelDetails.getBudgetPersonnelCalculatedAmounts());
                    for (BudgetPersonnelCalculatedAmount budgetPersonnelCalculatedAmount : budgetPersonnelDetails.getBudgetPersonnelCalculatedAmounts()) {
                        if (budgetPersonnelCalculatedAmount.getRateClass() != null) continue;
                        budgetPersonnelCalculatedAmount.refreshReferenceObject(RATE_CLASS);
                    }
                }
                for (BudgetLineItemCalculatedAmount lineItemCalculatedAmount : lineItem.getBudgetLineItemCalculatedAmounts()) {
                    if (lineItemCalculatedAmount.getRateClass() != null) continue;
                    lineItemCalculatedAmount.refreshReferenceObject(RATE_CLASS);
                }
            }
        }
        ParameterService parameterService = KcServiceLocator.getService(ParameterService.class);
        String enableBudgetSalaryByPeriod = parameterService.getParameterValueAsString(ProposalDevelopmentDocument.class, "enableBudgetCalculatedSalary");
        budgetForm.setEnableBudgetSalaryByPeriod(enableBudgetSalaryByPeriod);
        return mapping.findForward("personnel");
    }

    private String getPersonnelBudgetCategoryTypeCode() {
        return this.getParameterService().getParameterValueAsString(Budget.class, "budgetCategoryType.personnel");
    }

    protected void populatePersonnelCategoryTypeCodes(BudgetForm budgetForm) {
        Budget budget = budgetForm.getBudget();
        BudgetCategoryTypeValuesFinder budgetCategoryTypeValuesFinder = new BudgetCategoryTypeValuesFinder();
        ArrayList<KeyValue> budgetCategoryTypes = new ArrayList<KeyValue>();
        String personnelBudgetCategoryTypeCode = this.getPersonnelBudgetCategoryTypeCode();
        for (KeyValue budgetCategoryType : budgetCategoryTypeValuesFinder.getKeyValues()) {
            String budgetCategoryTypeCode = budgetCategoryType.getKey();
            if (!StringUtils.isNotBlank((CharSequence)budgetCategoryTypeCode) || !StringUtils.equalsIgnoreCase((CharSequence)budgetCategoryTypeCode, (CharSequence)personnelBudgetCategoryTypeCode)) continue;
            budgetCategoryTypes.add(budgetCategoryType);
            BudgetLineItem newBudgetLineItem = budget.getNewBudgetLineItem();
            if (budgetForm.getNewBudgetLineItems() == null) {
                budgetForm.setNewBudgetLineItems(new ArrayList<BudgetLineItem>());
            }
            budgetForm.getNewBudgetLineItems().add(newBudgetLineItem);
        }
        budget.setBudgetCategoryTypeCodes(budgetCategoryTypes);
    }

    protected void populateNonPersonnelCategoryTypeCodes(BudgetForm budgetForm) {
        Budget budget = budgetForm.getBudget();
        BudgetCategoryTypeValuesFinder budgetCategoryTypeValuesFinder = new BudgetCategoryTypeValuesFinder();
        ArrayList<KeyValue> budgetCategoryTypes = new ArrayList<KeyValue>();
        String personnelBudgetCategoryTypeCode = this.getPersonnelBudgetCategoryTypeCode();
        for (KeyValue budgetCategoryType : budgetCategoryTypeValuesFinder.getKeyValues()) {
            String budgetCategoryTypeCode = budgetCategoryType.getKey();
            if (!StringUtils.isNotBlank((CharSequence)budgetCategoryTypeCode) || StringUtils.equalsIgnoreCase((CharSequence)budgetCategoryTypeCode, (CharSequence)personnelBudgetCategoryTypeCode)) continue;
            budgetCategoryTypes.add(budgetCategoryType);
            BudgetLineItem newBudgetLineItem = budget.getNewBudgetLineItem();
            budgetForm.getNewBudgetLineItems().add(newBudgetLineItem);
        }
        budget.setBudgetCategoryTypeCodes(budgetCategoryTypes);
    }

    public ActionForward expenses(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        BudgetForm budgetForm = (BudgetForm)form;
        this.populateNonPersonnelCategoryTypeCodes(budgetForm);
        Budget budget = budgetForm.getBudget();
        budget.refreshReferenceObject(BUDGET_PERIODS);
        return mapping.findForward("expenses");
    }

    public ActionForward rates(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        return mapping.findForward("rates");
    }

    public ActionForward distributionAndIncome(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        BudgetDistributionService budgetDistributionService = KcServiceLocator.getService(BudgetDistributionService.class);
        budgetDistributionService.initializeCollectionDefaults(((BudgetForm)form).getBudgetDocument().getBudget());
        return mapping.findForward("distributionAndIncome");
    }

    public ActionForward modularBudget(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        BudgetForm budgetForm = (BudgetForm)form;
        BudgetModularService budgetModularService = KcServiceLocator.getService(BudgetModularService.class);
        budgetForm.setBudgetModularSummary(budgetModularService.processModularSummary(budgetForm.getBudgetDocument().getBudget(), false));
        return mapping.findForward("modularBudget");
    }

    protected void populatePersonnelRoles(Budget budget) {
        BudgetParent budgetParent = budget.getBudgetParent().getDocument().getBudgetParent();
        List<BudgetPerson> budgetPersons = budget.getBudgetPersons();
        for (BudgetPerson budgetPerson : budgetPersons) {
            ContactRole role;
            PersonRolodex person;
            String roleDesc = "";
            if (budgetPerson.getRolodexId() != null) {
                person = budgetParent.getProposalNonEmployee(budgetPerson.getRolodexId());
                if (person != null && (role = budgetParent.getProposalNonEmployeeRole(budgetPerson.getRolodexId())) != null) {
                    roleDesc = person.getInvestigatorRoleDescription();
                    if (StringUtils.equals((CharSequence)"KP", (CharSequence)role.getRoleCode()) && StringUtils.isNotEmpty((CharSequence)person.getProjectRole())) {
                        roleDesc = person.getProjectRole();
                    }
                }
            } else if (budgetPerson.getPersonId() != null && (person = budgetParent.getProposalEmployee(budgetPerson.getPersonId())) != null && (role = budgetParent.getProposalEmployeeRole(budgetPerson.getPersonId())) != null) {
                roleDesc = person.getInvestigatorRoleDescription();
                if (StringUtils.equals((CharSequence)"KP", (CharSequence)role.getRoleCode()) && StringUtils.isNotEmpty((CharSequence)person.getProjectRole())) {
                    roleDesc = person.getProjectRole();
                }
            }
            budgetPerson.setRole(roleDesc);
        }
    }

    public ActionForward summaryTotals(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        BudgetForm budgetForm = (BudgetForm)form;
        Budget budget = budgetForm.getBudget();
        this.populatePersonnelRoles(budget);
        for (BudgetPeriod period : budget.getBudgetPeriods()) {
            for (BudgetLineItem lineItem : period.getBudgetLineItems()) {
                for (BudgetPersonnelDetails budgetPersonnelDetails : lineItem.getBudgetPersonnelDetailsList()) {
                    budgetPersonnelDetails.refreshReferenceObject(BUDGET_PERSON);
                }
            }
        }
        budget.getBudgetTotals();
        budgetForm.setProposalHierarchyIndirectObjectCode(this.getParameterService().getParameterValueAsString(AwardBudgetDocument.class, PROPOSAL_HIERARCHY_SUB_PROJECT_INDIRECT_COST_ELEMENT));
        return mapping.findForward(SUMMARY_TOTALS);
    }

    public ActionForward budgetActions(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        BudgetForm budgetForm = (BudgetForm)form;
        Budget budget = budgetForm.getBudget();
        this.populateBudgetPrintForms(budget);
        KcServiceLocator.getService(PropDevBudgetSubAwardService.class).prepareBudgetSubAwards(budget);
        return mapping.findForward(BUDGET_ACTIONS);
    }

    private void populateBudgetPrintForms(Budget budget) {
        if (budget.getBudgetPrintForms().isEmpty()) {
            BudgetPrintService budgetPrintService = KcServiceLocator.getService(BudgetPrintService.class);
            budgetPrintService.populateBudgetPrintForms(budget);
        }
    }

    public ActionForward returnToProposal(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BudgetForm budgetForm = (BudgetForm)form;
        ActionForward forward = null;
        if (!StringUtils.equalsIgnoreCase((CharSequence)((String)budgetForm.getEditingMode().get("viewOnly")), (CharSequence)TRUE)) {
            forward = this.save(mapping, form, request, response);
        }
        this.setupDocumentExit();
        if (forward == null || !forward.getPath().contains("questionPrompt.do")) {
            return this.getReturnToProposalForward(budgetForm);
        }
        return forward;
    }

    public ActionForward returnToAward(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BudgetForm budgetForm = (BudgetForm)form;
        ActionForward forward = null;
        if (!"true".equals(budgetForm.getEditingMode().get("viewOnly"))) {
            forward = this.save(mapping, form, request, response);
        }
        this.setupDocumentExit();
        if (forward == null || !forward.getPath().contains("questionPrompt.do")) {
            return this.getReturnToAwardForward(budgetForm);
        }
        return forward;
    }

    private ActionForward getReturnToAwardForward(BudgetForm budgetForm) throws Exception {
        assert (budgetForm != null) : "the form is null";
        DocumentService docService = KcServiceLocator.getService(DocumentService.class);
        Award award = budgetForm.getBudgetDocument().getBudget().getBudgetParent();
        String docNumber = award.getAwardDocument().getDocumentNumber();
        List<VersionHistory> versions = KcServiceLocator.getService(VersionHistoryService.class).loadVersionHistory(Award.class, award.getAwardNumber());
        for (VersionHistory version : versions) {
            if (version.getSequenceOwnerSequenceNumber() <= award.getSequenceNumber() || version.getStatus() == VersionStatus.CANCELED) continue;
            docNumber = ((Award)version.getSequenceOwner()).getAwardDocument().getDocumentNumber();
        }
        AwardDocument awardDocument = (AwardDocument)docService.getByDocumentHeaderId(docNumber);
        String forwardUrl = this.buildForwardUrl(awardDocument.getDocumentHeader().getWorkflowDocument().getDocumentId());
        if (budgetForm.isAuditActivated()) {
            forwardUrl = StringUtils.replace((String)forwardUrl, (String)"Award.do?", (String)"Actions.do?");
        }
        forwardUrl = StringUtils.replace((String)forwardUrl, (String)".do?", (String)(".do?showAllBudgetVersions=" + budgetForm.isShowAllBudgetVersions() + "&"));
        return new ActionForward(forwardUrl, true);
    }

    private ActionForward getReturnToProposalForward(BudgetForm form) throws WorkflowException {
        assert (form != null) : "the form is null";
        DocumentService docService = KcServiceLocator.getService(DocumentService.class);
        String docNumber = form.getBudgetDocument().getBudget().getBudgetParent().getDocument().getDocumentNumber();
        ProposalDevelopmentDocument pdDoc = (ProposalDevelopmentDocument)docService.getByDocumentHeaderId(docNumber);
        Object forwardUrl = this.buildForwardUrl(pdDoc.getDocumentHeader().getWorkflowDocument().getDocumentId());
        if (form.isAuditActivated()) {
            forwardUrl = StringUtils.replace((String)forwardUrl, (String)"Proposal.do?", (String)"Actions.do?auditActivated=true&");
        }
        forwardUrl = (String)forwardUrl + "&methodToCallAttribute=methodToCall.reload";
        return new ActionForward((String)forwardUrl, true);
    }

    public void reconcilePersonnelRoles(Budget budget) {
        BudgetParent budgetParent = budget.getBudgetParent();
        List<BudgetPerson> budgetPersons = budget.getBudgetPersons();
        for (BudgetPerson budgetPerson : budgetPersons) {
            PersonRolodex person;
            if (budgetPerson.getRolodexId() != null) {
                person = budgetParent.getProposalNonEmployee(budgetPerson.getRolodexId());
                if (person == null) continue;
                budgetPerson.setRole(person.getInvestigatorRoleDescription());
                continue;
            }
            if (budgetPerson.getPersonId() == null || (person = budgetParent.getProposalEmployee(budgetPerson.getPersonId())) == null) continue;
            budgetPerson.setRole(person.getInvestigatorRoleDescription());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void streamToResponse(AttachmentDataSource attachmentDataSource, HttpServletResponse response) throws Exception {
        byte[] xbts = attachmentDataSource.getData();
        ByteArrayOutputStream baos = null;
        if (xbts != null) {
            try {
                baos = new ByteArrayOutputStream(xbts.length);
                baos.write(xbts);
                WebUtils.saveMimeOutputStreamAsFile((HttpServletResponse)response, (String)attachmentDataSource.getType(), (ByteArrayOutputStream)baos, (String)attachmentDataSource.getName());
            }
            finally {
                try {
                    if (baos != null) {
                        baos.close();
                        baos = null;
                    }
                }
                catch (IOException ioEx) {
                    LOG.warn(ioEx.getMessage(), (Throwable)ioEx);
                }
            }
        }
    }

    private void copyLineItemToPersonnelDetails(AwardBudgetDocument awardBudgetDocument) {
        for (BudgetPeriod budgetPeriod : awardBudgetDocument.getBudget().getBudgetPeriods()) {
            if (budgetPeriod.getBudgetLineItems() == null || budgetPeriod.getBudgetLineItems().isEmpty()) continue;
            for (BudgetLineItem budgetLineItem : budgetPeriod.getBudgetLineItems()) {
                if (budgetLineItem.getBudgetPersonnelDetailsList() == null || budgetLineItem.getBudgetPersonnelDetailsList().isEmpty()) continue;
                for (BudgetPersonnelDetails budgetPersonnelDetails : budgetLineItem.getBudgetPersonnelDetailsList()) {
                    budgetPersonnelDetails.setBudgetId(budgetLineItem.getBudgetId());
                    budgetPersonnelDetails.setBudgetPeriod(budgetLineItem.getBudgetPeriod());
                    budgetPersonnelDetails.setLineItemNumber(budgetLineItem.getLineItemNumber());
                    budgetPersonnelDetails.setCostElement(budgetLineItem.getCostElement());
                    budgetPersonnelDetails.setCostElementBO(budgetLineItem.getCostElementBO());
                }
            }
        }
    }

    @Override
    protected PessimisticLockService getPessimisticLockService() {
        return KcServiceLocator.getService(BudgetLockService.class);
    }

    public ActionForward reject(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward;
        KualiDocumentFormBase kualiDocumentFormBase = (KualiDocumentFormBase)form;
        String question = request.getParameter("questionIndex");
        String buttonClicked = request.getParameter("buttonClicked");
        String reason = request.getParameter("reason");
        String methodToCall = ((KualiForm)form).getMethodToCall();
        String questionText = "Are you sure you want to return this document?";
        if (question == null) {
            forward = this.performQuestionWithInput(mapping, form, request, response, DOCUMENT_REJECT_QUESTION, "Are you sure you want to return this document?", "confirmationQuestion", methodToCall, "");
        } else if (DOCUMENT_REJECT_QUESTION.equals(question) && "1".equals(buttonClicked)) {
            forward = mapping.findForward("basic");
        } else if (StringUtils.isEmpty((CharSequence)reason)) {
            String context = "";
            String errorKey = "error.budget.reject.noReason";
            String errorPropertyName = DOCUMENT_REJECT_QUESTION;
            String errorParameter = "";
            reason = reason == null ? "" : reason;
            forward = this.performQuestionWithInputAgainBecauseOfErrors(mapping, form, request, response, DOCUMENT_REJECT_QUESTION, "Are you sure you want to return this document?", "confirmationQuestion", methodToCall, context, reason, errorKey, errorPropertyName, errorParameter);
        } else {
            AwardBudgetDocument document = ((BudgetForm)form).getBudgetDocument();
            document.documentHasBeenRejected(reason);
            KcServiceLocator.getService(KcDocumentRejectionService.class).reject(document.getDocumentHeader().getWorkflowDocument(), reason, GlobalVariables.getUserSession().getPrincipalId(), null);
            forward = super.returnToSender(request, mapping, kualiDocumentFormBase);
        }
        return forward;
    }

    protected BudgetCalculationService getCalculationService() {
        return KcServiceLocator.getService(BudgetCalculationService.class);
    }
}

