/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.impl.country;

import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.api.country.CountryContract;
import org.kuali.coeus.common.api.country.KcCountryService;
import org.kuali.coeus.common.impl.country.CountryDto;
import org.kuali.rice.location.api.country.Country;
import org.kuali.rice.location.api.country.CountryService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service(value="kcCountryService")
public class KcCountryServiceImpl
implements KcCountryService {
    @Autowired
    @Qualifier(value="countryService")
    private CountryService countryService;

    public CountryContract getCountry(String code) {
        if (StringUtils.isBlank((CharSequence)code)) {
            throw new IllegalArgumentException("code is blank");
        }
        return this.toDto(this.countryService.getCountry(code));
    }

    public CountryContract getCountryByAlternateCode(String alternateCode) {
        if (StringUtils.isBlank((CharSequence)alternateCode)) {
            throw new IllegalArgumentException("alternateCode is blank");
        }
        return this.toDto(this.countryService.getCountryByAlternateCode(alternateCode));
    }

    protected CountryDto toDto(Country country) {
        if (country != null) {
            CountryDto dto = new CountryDto();
            dto.setName(country.getName());
            dto.setNameV3(country.getNameV3());
            dto.setCode(country.getCode());
            dto.setAlternateCode(country.getAlternateCode());
            return dto;
        }
        return null;
    }

    public CountryService getCountryService() {
        return this.countryService;
    }

    public void setCountryService(CountryService countryService) {
        this.countryService = countryService;
    }
}

