/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.budget.framework.core;

import java.util.ArrayList;
import java.util.List;
import org.kuali.coeus.common.budget.framework.core.BudgetConstants;
import org.kuali.coeus.sys.framework.gv.GlobalVariableService;
import org.kuali.rice.krad.util.AuditCluster;
import org.kuali.rice.krad.util.AuditError;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public abstract class BudgetAuditRuleBase {
    @Autowired
    @Qualifier(value="globalVariableService")
    private GlobalVariableService globalVariableService;

    protected List<AuditError> getAuditErrors(BudgetConstants.BudgetAuditRules auditRule, boolean auditError) {
        return this.getAuditCluster(auditRule, auditError).getAuditErrorList();
    }

    protected List<AuditError> getAuditErrors(BudgetConstants.BudgetAuditRules auditRule, String appendLabel, boolean auditError) {
        AuditCluster auditCluster = this.getAuditCluster(auditRule, false);
        auditCluster.setLabel(auditCluster.getLabel().concat(appendLabel));
        return auditCluster.getAuditErrorList();
    }

    protected AuditCluster getAuditCluster(BudgetConstants.BudgetAuditRules auditRule, boolean auditError) {
        AuditCluster auditCluster;
        String auditKey = auditRule.getWarningKey();
        String auditCategory = "Warnings";
        if (auditError) {
            auditKey = auditRule.getErrorKey();
            auditCategory = "Error";
        }
        if ((auditCluster = this.getGlobalVariableService().getAuditErrorMap().get(auditKey)) == null) {
            ArrayList auditErrors = new ArrayList();
            auditCluster = new AuditCluster(auditRule.getLabel(), auditErrors, auditCategory);
            this.getGlobalVariableService().getAuditErrorMap().put(auditKey, auditCluster);
        }
        return auditCluster;
    }

    protected GlobalVariableService getGlobalVariableService() {
        return this.globalVariableService;
    }

    public void setGlobalVariableService(GlobalVariableService globalVariableService) {
        this.globalVariableService = globalVariableService;
    }
}

